/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.extendedtable;

import com.swimap.iview.templates.basictable.filter.DefaultFilterElement;
import com.swimap.iview.templates.basictable.filter.FilterElement;
import com.swimap.iview.templates.basictable.filter.Filterable;
import com.swimap.iview.templates.basictable.filter.Operators;
import com.swimap.iview.templates.extendedtable.ExtendedTable;
import com.swimap.iview.templates.extendedtable.HashCell;
import com.swimap.iview.templates.extendedtable.TableFilterAdapter;
import com.swimap.iview.templates.extendedtable.TableSorter;
import com.swimap.iview.util.log.IviewLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;

public class SortableTableModel
extends DefaultTableModel
implements Filterable {
    private static IviewLogger logger = IviewLogger.getLogger(SortableTableModel.class, "IVIEW");
    private boolean tableUnsort = false;
    private int[] indexes = null;
    private int[] unsortIndexes = null;
    private TableSorter sorter = null;
    private StringBuffer buf = new StringBuffer("");
    private int needDelRow = -1;
    private ConcurrentHashMap m_oEditableCells = new ConcurrentHashMap(10);
    private Hashtable m_oNotSavedCells = new Hashtable(10);
    private HashCell hashCell = null;
    private HashCell editCell = new HashCell();
    private boolean[] m_isbColumnSortable = null;
    private boolean[] m_isbColumnVisible = null;
    private String[] columnsName = null;
    private int sortColumnIndex = -1;
    private boolean isDescend = false;
    private int unSortRows = 0;
    private final int ARRAYLIST_CAPACITY = 8;
    private Map<Integer, Boolean> columnFilterEnable = new HashMap<Integer, Boolean>(8);
    private Map<Integer, Boolean> multiValSelection = new HashMap<Integer, Boolean>(8);
    private int lastUnSortRows = 0;
    private boolean[] columnsConfigable = null;
    private boolean isInitialized = true;
    private FilterElement filter = null;
    private TableFilterAdapter tableFilterAdapter = null;
    private Map<Integer, List<Object>> addedColValuesMap = null;
    private TableModelListener m_tableModalListner = null;

    public SortableTableModel() {
        this.init();
    }

    public SortableTableModel(Object[] objectArray, int n) {
        super(objectArray, n);
        this.init();
    }

    public SortableTableModel(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
        this.init();
    }

    public void setDataVector(Vector vector, Vector vector2) {
        super.setDataVector(vector, vector2);
        this.init();
    }

    void setFilteredDataVector(Vector<Vector<Object>> vector) {
        this.dataVector = vector;
        this.fireTableDataChanged();
        this.sortAgain();
    }

    private void init() {
        if (this.isInitialized) {
            for (int i = this.getColumnCount() - 1; i >= 0; --i) {
                if (this.isThisColumnSortable(i)) {
                    this.setColumnSortable(i);
                }
                this.setColumnVisible(i, true);
                for (int j = this.getRowCount() - 1; j >= 0; --j) {
                    if (!this.isThisCellEditable(j, i)) continue;
                    this.setCellEditable(j, i);
                }
            }
        }
    }

    @Override
    public Object getValueAt(int n, int n2) {
        this.getIndexes();
        if (n >= this.indexes.length) {
            this.buf.delete(0, this.buf.toString().length());
            this.buf.append("The row's vlaue is ");
            this.buf.append(n);
            this.buf.append(" ,the length of the indexes is ");
            this.buf.append(this.indexes.length);
            logger.trace(this.buf.toString());
            return "";
        }
        return this.getTheValueAt(this.indexes[n], n2);
    }

    public Object getTheValueAt(int n, int n2) {
        return super.getValueAt(n, n2);
    }

    public Class getColumnClass(int n) {
        int n2 = this.getRowCount();
        for (int i = n2 - 1; i >= 0; --i) {
            if (this.getValueAt(i, n) == null) continue;
            return this.getValueAt(i, n).getClass();
        }
        return Object.class;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.getIndexes();
        Object object2 = this.getValueAt(n, n2);
        if (object == null) {
            if (object2 != null) {
                this.hashCell = new HashCell(this.indexes[n], n2);
                this.m_oNotSavedCells.put(this.hashCell, this.hashCell);
                this.hashCell = null;
            }
        } else if (!object.equals(object2)) {
            this.hashCell = new HashCell(this.indexes[n], n2);
            this.m_oNotSavedCells.put(this.hashCell, this.hashCell);
            this.hashCell = null;
        }
        this.setTheValueAt(object, this.indexes[n], n2);
    }

    public void setTheValueAt(Object object, int n, int n2) {
        super.setValueAt(object, n, n2);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        this.getIndexes();
        if (this.indexes.length > n) {
            this.editCell.setRow(this.indexes[n]);
        }
        this.editCell.setColumn(n2);
        Object v = this.m_oEditableCells.get(this.editCell);
        return v != null && this.editCell.equals(v);
    }

    public boolean isCellNotSaved(int n, int n2) {
        this.getIndexes();
        if (this.indexes.length > n) {
            this.editCell.setRow(this.indexes[n]);
        }
        this.editCell.setColumn(n2);
        Object v = this.m_oNotSavedCells.get(this.editCell);
        return v != null && this.editCell.equals(v);
    }

    public void clearNotSavedCells() {
        this.m_oNotSavedCells.clear();
    }

    final boolean isColumnSortable(int n) {
        if (this.m_isbColumnSortable == null || n >= this.m_isbColumnSortable.length) {
            return false;
        }
        return this.m_isbColumnSortable[n];
    }

    public boolean isThisCellEditable(int n, int n2) {
        return false;
    }

    public boolean isThisCellValided(int n, int n2) {
        return false;
    }

    public boolean isThisColumnSortable(int n) {
        return false;
    }

    public void setCellEditable(int n, int n2, boolean bl) {
        this.getIndexes();
        if (n == -1) {
            int n3 = this.getRowCount();
            if (n2 == -1) {
                int n4 = this.getColumnCount();
                if (bl) {
                    for (int i = n3 - 1; i >= 0; --i) {
                        for (int j = n4 - 1; j >= 0; --j) {
                            this.hashCell = new HashCell(this.indexes[i], j);
                            this.m_oEditableCells.put(this.hashCell, this.hashCell);
                            this.hashCell = null;
                        }
                    }
                } else {
                    for (int i = n3 - 1; i >= 0; --i) {
                        for (int j = n4 - 1; j >= 0; --j) {
                            this.editCell.setRow(this.indexes[i]);
                            this.editCell.setColumn(j);
                            this.m_oEditableCells.remove(this.editCell);
                        }
                    }
                }
            } else if (bl) {
                for (int i = n3 - 1; i >= 0; --i) {
                    this.hashCell = new HashCell(this.indexes[i], n2);
                    this.m_oEditableCells.put(this.hashCell, this.hashCell);
                    this.hashCell = null;
                }
            } else {
                this.editCell.setColumn(n2);
                for (int i = n3 - 1; i >= 0; --i) {
                    this.editCell.setRow(this.indexes[i]);
                    this.m_oEditableCells.remove(this.editCell);
                }
            }
        } else if (n2 == -1) {
            int n5 = this.getColumnCount();
            if (bl) {
                for (int i = n5 - 1; i >= 0; --i) {
                    this.hashCell = new HashCell(this.indexes[n], i);
                    this.m_oEditableCells.put(this.hashCell, this.hashCell);
                    this.hashCell = null;
                }
            } else {
                this.editCell.setRow(n);
                for (int i = n5 - 1; i >= 0; --i) {
                    this.editCell.setColumn(i);
                    this.m_oEditableCells.remove(this.editCell);
                }
            }
        } else if (bl) {
            this.hashCell = new HashCell(this.indexes[n], n2);
            this.m_oEditableCells.put(this.hashCell, this.hashCell);
            this.hashCell = null;
        } else {
            this.editCell.setRow(this.indexes[n]);
            this.editCell.setColumn(n2);
            this.m_oEditableCells.remove(this.editCell);
        }
    }

    public void setCellEditable(int n, int n2) {
        this.setCellEditable(n, n2, true);
    }

    public boolean[] getColumnsVisible() {
        return this.m_isbColumnVisible;
    }

    public void setColumnsVisible(boolean[] blArray) {
        if (blArray.length == this.getColumnCount()) {
            this.m_isbColumnVisible = blArray;
        }
    }

    public String[] getColumnsName() {
        this.columnsName = new String[this.getColumnCount()];
        for (int i = 0; i < this.columnsName.length; ++i) {
            this.columnsName[i] = this.getColumnName(i);
        }
        return this.columnsName;
    }

    public void setColumnVisible(int n, boolean bl) {
        this.AssertColumnVisible();
        int n2 = this.getColumnCount();
        if (n >= n2) {
            return;
        }
        this.m_isbColumnVisible[n] = bl;
    }

    public void AssertColumnVisible() {
        if (this.m_isbColumnVisible == null) {
            this.m_isbColumnVisible = new boolean[this.getColumnCount()];
            for (int i = this.m_isbColumnVisible.length - 1; i >= 0; --i) {
                this.m_isbColumnVisible[i] = true;
            }
        } else if (this.m_isbColumnVisible.length != this.getColumnCount()) {
            int n = this.getColumnCount();
            boolean[] blArray = new boolean[n];
            int n2 = this.m_isbColumnVisible.length < n ? this.m_isbColumnVisible.length : n;
            System.arraycopy(this.m_isbColumnVisible, 0, blArray, 0, n2);
            this.m_isbColumnVisible = blArray;
        }
    }

    public void setColumnSortable(int[] nArray, boolean bl) {
        int n = this.getColumnCount();
        this.assertColumnSortable();
        for (int i = nArray.length - 1; i >= 0; --i) {
            if (nArray[i] >= n) {
                return;
            }
            this.m_isbColumnSortable[nArray[i]] = bl;
        }
    }

    public void setColumnSortable(int[] nArray) {
        this.setColumnSortable(nArray, true);
    }

    public void setColumnSortable(int n, boolean bl) {
        this.assertColumnSortable();
        int n2 = this.getColumnCount();
        if (n >= n2) {
            return;
        }
        this.m_isbColumnSortable[n] = bl;
    }

    public void setColumnSortable(int n) {
        this.setColumnSortable(n, true);
    }

    private void assertColumnSortable() {
        if (this.m_isbColumnSortable == null) {
            this.m_isbColumnSortable = new boolean[this.getColumnCount()];
            for (int i = this.m_isbColumnSortable.length - 1; i >= 0; --i) {
                this.m_isbColumnSortable[i] = false;
            }
        } else if (this.m_isbColumnSortable.length != this.getColumnCount()) {
            int n = this.getColumnCount();
            boolean[] blArray = new boolean[n];
            int n2 = this.m_isbColumnSortable.length < n ? this.m_isbColumnSortable.length : n;
            System.arraycopy(this.m_isbColumnSortable, 0, blArray, 0, n2);
            this.m_isbColumnSortable = blArray;
        }
    }

    @Override
    public void removeRow(int n) {
        this.needDelRow = n;
        this.getIndexes();
        int n2 = this.indexes[n];
        super.removeRow(n2);
        this.remove_m_oNotSavedCells(n2);
        this.getIndexes();
        this.needDelRow = -1;
        this.fireTableRowsDeleted(n, n);
    }

    public void removeSelectedRows(int[] nArray) {
        int n;
        int[] nArray2 = new int[nArray.length];
        Vector<Vector> vector = this.getDataVector();
        for (n = 0; n < nArray.length; ++n) {
            nArray2[n] = this.convertRowIndexToModel(nArray[n]);
        }
        Arrays.sort(nArray2);
        for (n = nArray2.length - 1; n >= 0; --n) {
            this.remove_m_oNotSavedCells(nArray2[n]);
        }
        this.dataVector = this.filterTableData(vector, nArray2);
        this.indexes = this.getIndexAfterRemove(this.indexes, nArray2);
        this.fireTableDataChanged();
    }

    private Vector filterTableData(Vector vector, int[] nArray) {
        Vector vector2 = new Vector(vector.size() - nArray.length);
        int n = vector.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (n2 < nArray.length && i == nArray[n2]) {
                ++n2;
                continue;
            }
            vector2.add(vector.get(i));
        }
        return vector2;
    }

    private int[] getIndexAfterRemove(int[] nArray, int[] nArray2) {
        int n;
        int n2;
        int n3 = nArray.length;
        int n4 = nArray.length - nArray2.length;
        int[] nArray3 = new int[n4];
        int[] nArray4 = new int[n3];
        int[] nArray5 = new int[n4];
        int[] nArray6 = new int[n3];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray4[nArray[n2]] = n2;
        }
        n2 = 0;
        for (n = 0; n < nArray4.length && n2 < nArray2.length; ++n) {
            if (n != nArray2[n2]) continue;
            nArray4[n] = -1;
            ++n2;
        }
        n2 = 0;
        for (n = 0; n < nArray4.length; ++n) {
            if (nArray4[n] == -1) continue;
            nArray5[n2] = nArray4[n];
            ++n2;
        }
        for (n = 0; n < nArray6.length; ++n) {
            nArray6[n] = -1;
        }
        for (n = 0; n < nArray5.length; ++n) {
            nArray6[nArray5[n]] = n;
        }
        n2 = 0;
        for (n = 0; n < nArray6.length; ++n) {
            if (nArray6[n] == -1) continue;
            nArray3[n2] = nArray6[n];
            ++n2;
        }
        return nArray3;
    }

    public void removeModelRow(int n) {
        this.needDelRow = this.convertRowIndexToTable(n);
        this.getIndexes();
        super.removeRow(n);
        this.remove_m_oNotSavedCells(n);
        this.getIndexes();
        this.needDelRow = -1;
        this.fireTableDataChanged();
    }

    public void removeModelRows(int[] nArray) {
        this.getIndexes();
        Vector<Vector> vector = this.getDataVector();
        Arrays.sort(nArray);
        for (int i = nArray.length - 1; i >= 0; --i) {
            this.remove_m_oNotSavedCells(nArray[i]);
        }
        this.dataVector = this.filterTableData(vector, nArray);
        this.indexes = this.getIndexAfterRemove(this.indexes, nArray);
        this.fireTableDataChanged();
    }

    public void addRows(Vector vector) {
        this.getDataVector().addAll(vector);
        this.fireTableDataChanged();
        if (null == this.getFilter()) {
            return;
        }
        this.tableFilterAdapter.applyFilterOnDataVector(this.getFilter());
    }

    public void addRows(Object[][] objectArray) {
        this.addRows(SortableTableModel.convertToVector(objectArray));
    }

    public void insertActualRow(int n, Object[] objectArray, boolean bl) {
        int n2;
        if (n >= this.getActualRowCount() || n < 0) {
            throw new ArrayIndexOutOfBoundsException("Row index = " + n + " is out of range");
        }
        Vector<Object> vector = new Vector<Object>();
        for (Object object : objectArray) {
            vector.add(object);
        }
        for (n2 = objectArray.length; n2 < this.getColumnCount(); ++n2) {
            vector.add(null);
        }
        if (n < this.dataVector.size()) {
            this.dataVector.add(n, vector);
        } else {
            n2 = n - this.dataVector.size();
            this.tableFilterAdapter.getBackupDataVector().add(n2, vector);
        }
        if (bl) {
            this.applyFilterAndSort();
        }
    }

    private int[] getRowsSelected() {
        TableModelListener[] tableModelListenerArray;
        int[] nArray = new int[]{};
        for (TableModelListener tableModelListener : tableModelListenerArray = this.getTableModelListeners()) {
            if (!(tableModelListener instanceof JTable)) continue;
            this.m_tableModalListner = tableModelListener;
            nArray = ((JTable)this.m_tableModalListner).getSelectedRows();
            break;
        }
        return nArray;
    }

    private void setRowSelection(int[] nArray) {
        if (0 == nArray.length) {
            return;
        }
        ((JTable)this.m_tableModalListner).setRowSelectionInterval(nArray[0], nArray[nArray.length - 1]);
        for (int i = nArray[0]; i < nArray[nArray.length - 1]; ++i) {
            if (-1 < Arrays.binarySearch(nArray, i)) continue;
            ((JTable)this.m_tableModalListner).removeRowSelectionInterval(i, i);
        }
    }

    @Override
    public void setRowCount(int n) {
        if (null != this.tableFilterAdapter && n == 0) {
            this.tableFilterAdapter.getBackupDataVector().clear();
        }
        super.setRowCount(n);
    }

    public void applyFilterAndSort() {
        int[] nArray = this.getRowsSelected();
        if (null != this.getFilter()) {
            this.tableFilterAdapter.applyFilterOnDataVector(this.getFilter());
        }
        this.fireTableDataChanged();
        if (0 != nArray.length && !this.dataVector.isEmpty()) {
            this.setRowSelection(nArray);
        }
    }

    public void setActualRow(int n, Object[] objectArray, boolean bl) {
        int n2;
        if (n >= this.getActualRowCount() || n < 0) {
            throw new ArrayIndexOutOfBoundsException("Row index = " + n + " is out of range");
        }
        Vector<Object> vector = new Vector<Object>();
        for (Object object : objectArray) {
            vector.add(object);
        }
        for (n2 = objectArray.length; n2 < this.getColumnCount(); ++n2) {
            vector.add(null);
        }
        if (n < this.dataVector.size()) {
            if (null == this.getFilter()) {
                this.dataVector.set(this.getIndexes()[n], vector);
            } else {
                this.dataVector.set(n, vector);
            }
        } else {
            n2 = n - this.dataVector.size();
            this.tableFilterAdapter.getBackupDataVector().set(n2, vector);
        }
        if (bl) {
            this.applyFilterAndSort();
        }
    }

    public void remove_m_oNotSavedCells(int n) {
        LinkedList<HashCell> linkedList = new LinkedList<HashCell>();
        HashCell hashCell = null;
        Set set = this.m_oNotSavedCells.keySet();
        Iterator iterator = set.iterator();
        boolean bl = iterator.hasNext();
        while (bl) {
            hashCell = (HashCell)iterator.next();
            if (hashCell.getRow() == n) {
                linkedList.add(hashCell);
            }
            bl = iterator.hasNext();
        }
        try {
            Iterator iterator2 = linkedList.iterator();
            boolean bl2 = iterator2.hasNext();
            while (bl2) {
                this.m_oNotSavedCells.remove((HashCell)iterator2.next());
                bl2 = iterator2.hasNext();
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    public void sortByColumn(int n, boolean bl) {
        TableModelListener[] tableModelListenerArray;
        this.sortColumnIndex = n;
        this.isDescend = bl;
        if (n == -1) {
            return;
        }
        for (TableModelListener tableModelListener : tableModelListenerArray = this.getTableModelListeners()) {
            if (!(tableModelListener instanceof ExtendedTable)) continue;
            ((ExtendedTable)tableModelListener).setColumnInformation();
        }
        if (null == this.sorter) {
            this.sorter = new TableSorter(this);
        }
        this.sorter.sort(this.sortColumnIndex, this.isDescend);
    }

    public void sortColumn(int n, boolean bl) {
        this.sortColumnIndex = n;
        this.isDescend = bl;
        if (n == -1) {
            return;
        }
        if (null == this.sorter) {
            this.sorter = new TableSorter(this);
        }
        this.sorter.sort(this.sortColumnIndex, this.isDescend);
    }

    public void sortAgain() {
        this.sortByColumn(this.sortColumnIndex, this.isDescend);
    }

    public int[] getIndexes() {
        int n = this.getRowCount();
        if (this.indexes != null) {
            if (this.indexes.length == n) {
                return this.indexes;
            }
            if (this.tableUnsort) {
                this.unsortIndexes = this.resetArray();
                if (this.indexes.length > n) {
                    if (this.needDelRow != -1) {
                        this.unsortIndexes = this.creatUnsortIndexes(this.indexes, this.needDelRow);
                        this.indexes = this.unsortIndexes;
                        return this.unsortIndexes;
                    }
                } else {
                    System.arraycopy(this.indexes, 0, this.unsortIndexes, 0, this.indexes.length);
                    this.indexes = this.unsortIndexes;
                    return this.unsortIndexes;
                }
            }
        }
        this.indexes = new int[n];
        for (int i = 0; i < n; ++i) {
            this.indexes[i] = i;
        }
        return this.indexes;
    }

    public int[] getTheIndexes() {
        return this.indexes;
    }

    public int[] creatUnsortIndexes(int[] nArray, int n) {
        int[] nArray2 = new int[this.getRowCount()];
        int n2 = n;
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        System.arraycopy(nArray, n2 + 1, nArray2, n2, nArray.length - n2 - 1);
        nArray2 = this.resetUnsortIndexes(nArray2);
        return nArray2;
    }

    protected int[] resetUnsortIndexes(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= this.indexes[this.needDelRow]) continue;
            int n = i;
            nArray[n] = nArray[n] - 1;
        }
        return nArray;
    }

    public void resetIndexes() {
        int n = this.getRowCount();
        this.indexes = new int[n];
        for (int i = 0; i < n; ++i) {
            this.indexes[i] = i;
        }
    }

    public int convertRowIndexToModel(int n) {
        this.getIndexes();
        return this.indexes[n];
    }

    public int convertRowIndexToTable(int n) {
        this.getIndexes();
        for (int i = 0; i < this.indexes.length; ++i) {
            if (this.indexes[i] != n) continue;
            return i;
        }
        return -1;
    }

    public void clear() {
        this.m_oEditableCells.clear();
        this.clearNotSavedCells();
    }

    public int getSortedColumn() {
        return this.sortColumnIndex;
    }

    public boolean sortStateIsDescend() {
        return this.isDescend;
    }

    public void initColumnsConfigable() {
        if (this.columnsConfigable == null) {
            this.columnsConfigable = new boolean[this.getColumnCount()];
            for (int i = 0; i < this.columnsConfigable.length; ++i) {
                this.columnsConfigable[i] = true;
            }
        }
    }

    public void checkColumns() {
        if (this.columnsConfigable.length != this.getColumnCount()) {
            int n = this.getColumnCount();
            boolean[] blArray = new boolean[n];
            int n2 = this.columnsConfigable.length < n ? this.columnsConfigable.length : n;
            System.arraycopy(this.columnsConfigable, 0, blArray, 0, n2);
            this.columnsConfigable = blArray;
        }
    }

    public boolean[] getColumnsConfigable() {
        if (this.columnsConfigable == null) {
            this.initColumnsConfigable();
        } else {
            this.checkColumns();
        }
        return this.columnsConfigable;
    }

    public boolean isTableUnsort() {
        return this.tableUnsort;
    }

    public void setColConfigable(int n, boolean bl) {
        int n2 = this.getColumnCount();
        if (n >= n2 || n <= -1) {
            return;
        }
        if (this.columnsConfigable == null) {
            this.initColumnsConfigable();
        } else {
            this.checkColumns();
        }
        this.columnsConfigable[n] = bl;
    }

    public void setColsConfigable(boolean[] blArray) {
        if (blArray.length == this.getColumnCount()) {
            this.columnsConfigable = blArray;
        }
    }

    public void setTableUnsort(boolean bl) {
        this.tableUnsort = bl;
    }

    public int[] resetArray() {
        int n = this.getRowCount();
        int[] nArray = new int[n];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    public void setUnSortRows(int n) {
        this.unSortRows = n;
        if (this.sorter == null) {
            this.sorter = new TableSorter(this);
        }
        this.sorter.setUnSortRows(n);
    }

    public int getUnSortRows() {
        return this.unSortRows;
    }

    public void cancelUnSortRows() {
        this.setUnSortRows(0);
    }

    public int getLastUnSortRows() {
        return this.lastUnSortRows;
    }

    public void setLastUnSortRows(int n) {
        this.lastUnSortRows = n;
        this.resetIndexes();
        if (this.sorter == null) {
            this.sorter = new TableSorter(this);
        }
        this.sorter.setLastUnSortRows(n);
        this.sortAgain();
        this.fireTableDataChanged();
    }

    @Override
    public final FilterElement getFilter() {
        return this.filter == null ? null : (FilterElement)((DefaultFilterElement)this.filter).clone();
    }

    @Override
    public final List<Object> getAddedColumnValueList(int n) {
        if (null == this.addedColValuesMap) {
            this.addedColValuesMap = new HashMap<Integer, List<Object>>(8);
        }
        if (!this.addedColValuesMap.containsKey(n)) {
            this.addedColValuesMap.put(n, new ArrayList(8));
        }
        return this.addedColValuesMap.get(n);
    }

    @Override
    public Collection<Object> getFilterColumnValues(int n) {
        if (null == this.tableFilterAdapter) {
            this.tableFilterAdapter = new TableFilterAdapter(this);
        }
        return this.tableFilterAdapter.getFilterColumnValues(n);
    }

    @Override
    public List<Operators.Operator> getFilterOperatorList(int n) {
        return Arrays.asList(Operators.Operator.values());
    }

    @Override
    public final boolean isColumnFilterable(int n) {
        boolean bl = true;
        if (this.columnFilterEnable.containsKey(n)) {
            bl = this.columnFilterEnable.get(n);
        } else {
            this.columnFilterEnable.put(n, true);
        }
        return bl;
    }

    @Override
    public final boolean isColumnFiltered(int n) {
        if (null != this.filter) {
            return ((DefaultFilterElement)this.filter).isColumnExist(n);
        }
        return false;
    }

    @Override
    public final void setFilter(FilterElement filterElement) {
        this.filter = filterElement;
        if (null == this.tableFilterAdapter) {
            this.tableFilterAdapter = new TableFilterAdapter(this);
        }
        this.tableFilterAdapter.filterDataVector(filterElement);
    }

    public final void setColumnFilterable(int n, boolean bl) {
        this.columnFilterEnable.put(n, bl);
    }

    @Override
    public final boolean isMultiValueSelectionEnabled(int n) {
        boolean bl = false;
        if (this.multiValSelection.containsKey(n)) {
            bl = this.multiValSelection.get(n);
        } else {
            this.multiValSelection.put(n, false);
        }
        return bl;
    }

    public final void setMultiValueSelectionEnabled(int[] nArray, boolean bl) {
        for (int n : nArray) {
            this.multiValSelection.put(n, bl);
        }
    }

    public int getActualRowCount() {
        int n = this.dataVector.size();
        if (null == this.getFilter()) {
            return n;
        }
        int n2 = this.tableFilterAdapter.getBackupDataVector().size();
        return n2 + n;
    }

    public Object getActualValueAt(int n, int n2) {
        Object object = null;
        if (null == this.getFilter()) {
            object = this.getValueAt(n, n2);
        } else {
            Vector<Object> vector = null;
            if (this.dataVector.size() > n) {
                vector = (Vector<Object>)this.dataVector.elementAt(n);
                object = vector.elementAt(n2);
            } else {
                int n3 = n - this.dataVector.size();
                Vector<Vector<Object>> vector2 = this.tableFilterAdapter.getBackupDataVector();
                if (vector2.size() > n3) {
                    vector = vector2.elementAt(n3);
                    object = vector.elementAt(n2);
                }
            }
        }
        return object;
    }

    public void setActualValueAt(Object object, int n, int n2) {
        if (null == this.getFilter()) {
            this.setValueAt(object, n, n2);
            return;
        }
        Vector<Object> vector = null;
        if (this.dataVector.size() > n) {
            vector = (Vector<Object>)this.dataVector.elementAt(n);
            vector.setElementAt(object, n2);
        } else {
            int n3 = n - this.dataVector.size();
            Vector<Vector<Object>> vector2 = this.tableFilterAdapter.getBackupDataVector();
            if (vector2.size() > n3) {
                vector = vector2.elementAt(n3);
                vector.setElementAt(object, n2);
            }
        }
        int[] nArray = this.getRowsSelected();
        this.tableFilterAdapter.applyFilterOnDataVector(this.getFilter());
        this.fireTableCellUpdated(n, n2);
        if (0 != nArray.length) {
            this.setRowSelection(nArray);
        }
    }

    public Vector getActualDataVector() {
        if (null == this.getFilter()) {
            return this.getDataVector();
        }
        Vector<Vector<Object>> vector = new Vector<Vector<Object>>(1);
        vector.addAll(this.dataVector);
        Vector<Vector<Object>> vector2 = this.tableFilterAdapter.getBackupDataVector();
        vector.addAll(vector2);
        return vector;
    }

    public void removeActualRow(int n) {
        if (null == this.getFilter()) {
            this.removeRow(n);
            return;
        }
        if (this.dataVector.size() > n) {
            this.dataVector.remove(n);
            this.fireTableRowsDeleted(n, n);
        } else {
            int n2 = n - this.dataVector.size();
            Vector<Vector<Object>> vector = this.tableFilterAdapter.getBackupDataVector();
            vector.remove(n2);
        }
    }

    public void addRow(Vector vector) {
        this.insertRow(this.getRowCount(), vector);
        if (null == this.getFilter()) {
            return;
        }
        this.tableFilterAdapter.applyFilterOnDataVector(this.getFilter());
    }
}

