/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.extendedtable;

import com.swimap.iview.templates.basictable.filter.FilterConstants;
import com.swimap.iview.templates.beans.TableProperties;
import com.swimap.iview.templates.extendedtable.SortableTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class SortButtonRenderer
extends JButton
implements TableCellRenderer {
    private ImageIcon sortableIcon = this.createImageIcon("sortable.gif");
    private ImageIcon upSortedIcon = this.createImageIcon("upsorted.gif");
    private ImageIcon downSortedIcon = this.createImageIcon("downsorted.gif");
    private JLabel iconLabel = new JLabel();
    public static final int NONE = 0;
    public static final int DOWN = 1;
    public static final int UP = 2;
    private int pushedColumn = -1;
    private Hashtable state;
    private JPanel topPanel = new JPanel(new BorderLayout()){

        @Override
        public void setForeground(Color color) {
            int n = this.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component = this.getComponent(i);
                component.setForeground(color);
            }
            super.setForeground(color);
        }
    };
    private JLabel filterIconLbl = new JLabel(FilterConstants.EMPTY_FILTER_ICON);

    public SortButtonRenderer() {
        this.state = new Hashtable(20);
        this.iconLabel.setHorizontalAlignment(0);
        this.iconLabel.setVerticalAlignment(0);
        this.iconLabel.setHorizontalTextPosition(2);
        this.filterIconLbl.setBorder(FilterConstants.FILTER_ICON_BORDER);
        this.filterIconLbl.setName("SortableTableHeaderRenderer_FilterIconLabel");
        Dimension dimension = new Dimension(15, 10);
        this.filterIconLbl.setMinimumSize(dimension);
        this.filterIconLbl.setPreferredSize(dimension);
        LookAndFeel.installBorder(this.topPanel, "TableHeader.cellBorder");
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Object object2;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        if (jTable instanceof TableProperties) {
            TableProperties tableProperties = (TableProperties)((Object)jTable);
            bl3 = tableProperties.getSortable();
            bl5 = tableProperties.isDataFilterEnabled();
            bl6 = tableProperties.isColumnFiltarable(n2);
        }
        int n3 = jTable.convertColumnIndexToModel(n2);
        TableModel tableModel = jTable.getModel();
        if (tableModel instanceof SortableTableModel) {
            bl4 = ((SortableTableModel)tableModel).isColumnSortable(n3);
        }
        this.topPanel.removeAll();
        if (!(!bl3 && jTable instanceof TableProperties || !bl4 && tableModel instanceof SortableTableModel)) {
            object2 = this.state.get(n3);
            if (object2 != null) {
                if ((Integer)object2 == 1) {
                    this.iconLabel.setIcon(this.downSortedIcon);
                } else {
                    this.iconLabel.setIcon(this.upSortedIcon);
                }
            } else {
                this.iconLabel.setIcon(this.sortableIcon);
            }
        } else {
            this.iconLabel.setIcon(null);
        }
        this.iconLabel.setText(object == null ? "" : object.toString());
        this.topPanel.add((Component)this.iconLabel, "Center");
        if (bl5 && bl6) {
            boolean bl7 = ((TableProperties)((Object)jTable)).isColumnFiltered(n2);
            this.filterIconLbl.setIcon(bl7 ? FilterConstants.NON_EMPTY_FILTER_ICON : FilterConstants.EMPTY_FILTER_ICON);
            this.topPanel.add((Component)this.filterIconLbl, "East");
        }
        object2 = this.topPanel.getInsets();
        ((Insets)object2).top = 1;
        ((Insets)object2).bottom = 0;
        return this.topPanel;
    }

    public void setPressedColumn(int n) {
        this.pushedColumn = n;
    }

    public void setSelectedColumn(int n) {
        if (n < 0) {
            return;
        }
        Integer n2 = null;
        Object v = this.state.get(n);
        n2 = v == null ? Integer.valueOf(1) : ((Integer)v == 1 ? Integer.valueOf(2) : Integer.valueOf(1));
        this.state.clear();
        this.state.put(n, n2);
    }

    public int getState(int n) {
        int n2 = 2;
        Object v = this.state.get(n);
        if (v == null) {
            n2 = 0;
        } else if ((Integer)v == 1) {
            n2 = 1;
        }
        return n2;
    }

    public void clearSortFlag() {
        this.setPressedColumn(-1);
        this.state.clear();
    }

    private ImageIcon createImageIcon(String string) {
        URL uRL = this.getClass().getResource(string);
        if (uRL == null) {
            uRL = SortButtonRenderer.class.getResource(string);
        }
        if (null != uRL) {
            return new ImageIcon(uRL);
        }
        return null;
    }
}

