/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.extendedtable;

import com.swimap.iview.templates.extendedtable.ExtendedTable;
import com.swimap.iview.templates.extendedtable.SortableTableModel;
import com.swimap.iview.templates.filtertree.FilterTreeCell;
import com.swimap.iview.templates.filtertree.FilterTreeTemplate;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class ShowColumnSetDialog
extends JDialog {
    private static IviewLogger logger = IviewLogger.getLogger(ShowColumnSetDialog.class, "IVIEW");
    private ExtendedTable table = null;
    private SortableTableModel model = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private boolean haveDisable = false;
    private int[] index = null;
    private boolean[] show = null;
    private FilterTreeTemplate columnTree = new FilterTreeTemplate();
    private DefaultMutableTreeNode columnTreeRootNode = null;
    private JPanel buttonPanel = new JPanel();
    private static final int PER_WIDTH = 380;
    private static final int PER_HEIGHT = 380;
    private static final int TOGGLE_CLICK_NUM = 100;
    private static final Color SHADOW_COLOR = new Color(134, 134, 134);

    public ShowColumnSetDialog(ExtendedTable extendedTable, JFrame jFrame) {
        super(OptionPane.getFrameForComponent(extendedTable), true);
        this.table = extendedTable;
        this.setDefaultCloseOperation(2);
        this.columnTreeRootNode = new DefaultMutableTreeNode(new FilterTreeCell(ExtendedTable.res.getString("Select_Column_Name")));
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        this.setSize(380, 380);
    }

    public boolean isModified() {
        return true;
    }

    private void jbInit() throws Exception {
        this.columnTree.setShowsRootHandles(false);
        this.columnTree.setToggleClickCount(100);
        this.setTitle(ExtendedTable.res.getString("ShowColumnSetDialog_Title"));
        this.okButton = new JButton(ExtendedTable.res.getString("okButton"));
        this.cancelButton = new JButton(ExtendedTable.res.getString("cancelButton"));
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.columnTree);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel2.add((Component)jPanel, "South");
        jPanel2.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(new EtchedBorder(0, Color.white, SHADOW_COLOR), null), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.model = this.table.getSortableTableModel();
        this.setListdata(this.model.getColumnsName(), this.model.getColumnsVisible(), this.model.getColumnsConfigable());
        this.buttonPanel.setLayout(new FlowLayout(1, 30, 5));
        Dimension dimension = new Dimension(80, 21);
        this.okButton.setMaximumSize(dimension);
        this.okButton.setMinimumSize(dimension);
        this.okButton.setPreferredSize(dimension);
        this.cancelButton.setMaximumSize(dimension);
        this.cancelButton.setMinimumSize(dimension);
        this.cancelButton.setPreferredSize(dimension);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShowColumnSetDialog.this.okButton_mouseClicked(actionEvent);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShowColumnSetDialog.this.canelButton_mouseClicked(actionEvent);
            }
        });
        ScreenToolKit.setDefaultButtons(this.okButton, this.cancelButton);
        this.buttonPanel.add((Component)this.okButton, null);
        this.buttonPanel.add((Component)this.cancelButton, null);
        this.getContentPane().add((Component)jPanel2, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                ShowColumnSetDialog.this.okButton.requestFocus();
            }
        });
    }

    public void setListdata(String[] stringArray, boolean[] blArray, boolean[] blArray2) {
        this.columnTreeRootNode.removeAllChildren();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        FilterTreeCell filterTreeCell = null;
        String string = null;
        boolean bl = true;
        this.show = new boolean[blArray2.length];
        this.index = new int[blArray2.length];
        int n = 0;
        int n2 = 0;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        for (int i = 0; i < stringArray.length && i < blArray.length; ++i) {
            if (!blArray2[i]) {
                this.haveDisable = true;
                this.show[i] = blArray[i];
                continue;
            }
            string = stringArray[i];
            bl = blArray[i];
            n2 = 0;
            if (bl) {
                n2 = 1;
                this.show[i] = true;
                this.index[n] = i;
                ++n;
            } else {
                n2 = 0;
                this.show[i] = false;
                this.index[n] = i;
                ++n;
            }
            filterTreeCell = new FilterTreeCell(string, n2);
            defaultMutableTreeNode = new DefaultMutableTreeNode(filterTreeCell);
            this.columnTreeRootNode.add(defaultMutableTreeNode);
            if (!bl) continue;
            FilterTreeTemplate.refreshUp(defaultMutableTreeNode);
        }
        ((DefaultTreeModel)this.columnTree.getModel()).setRoot(this.columnTreeRootNode);
    }

    private void okButton_mouseClicked(ActionEvent actionEvent) {
        if (((FilterTreeCell)this.columnTreeRootNode.getUserObject()).getState() == 0 && !this.haveDisable) {
            OptionPane.showMessageDialog(this, ExtendedTable.res.getString("ShowColumnSetDialog_noselect"));
            return;
        }
        int n = this.columnTreeRootNode.getChildCount();
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        FilterTreeCell filterTreeCell = null;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)this.columnTreeRootNode.getChildAt(i);
            filterTreeCell = (FilterTreeCell)defaultMutableTreeNode.getUserObject();
            bl = false;
            bl = filterTreeCell.getState() != 0;
            this.show[this.index[i]] = bl;
        }
        this.table.setColumnShowingEnable(this.show);
        this.model.setColumnsVisible(this.show);
        this.dispose();
    }

    private void canelButton_mouseClicked(ActionEvent actionEvent) {
        this.dispose();
    }
}

