/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.extendedtable;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.templates.extendedtable.ExtendedTable;
import com.swimap.iview.templates.print.PrintSupportor;
import com.swimap.iview.templates.print.SaveAndPrintParameters;
import com.swimap.iview.templates.print.SavePrintable;
import com.swimap.iview.templates.print.tools.TablePrintable;
import com.swimap.iview.templates.progressdialog.IStop;
import com.swimap.iview.templates.progressdialog.ProgressDialogTemplate;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class SaveAndPrintFile {
    private static IviewLogger logger = IviewLogger.getLogger(SaveAndPrintFile.class, "IVIEW");
    private Component parent = null;
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/extendedtable/Res");
    private ExtendedTable m_oTable = null;
    private String fileName = "";
    private String fileType = "";
    private String userName = "";
    private String summary = "";
    private String m_szTitle = "";
    private int[] _rows = null;
    private JFrame mainFrame = null;
    private boolean running = false;
    private IStop cancelListener = null;
    private TablePrintable printable = null;
    private ProgressDialogTemplate blockDialog = null;
    private static final int SHOW_DIALOG_THRESHOLD = 5000;
    private boolean isSuccess = true;
    private SaveAndPrintParameters _saveAndPrintParameters = null;
    private PropertyChangeListener[] printablePropChangeListeners = null;
    private static final int MAX_REC_COUNT_PERFILE = 65536;
    private int maxRecordsCountPerFile = 65536;

    public SaveAndPrintFile(ExtendedTable extendedTable) {
        this.m_oTable = extendedTable;
    }

    public SaveAndPrintFile(ExtendedTable extendedTable, Component component, int[] nArray, String string, String string2, String string3, String string4, String string5) {
        this.m_oTable = extendedTable;
        this.parent = component;
        this._rows = nArray;
        this.m_szTitle = string == null ? "" : string2;
        this.userName = string2 == null ? "" : string2;
        this.summary = string3 == null ? "" : string3;
        this.fileName = string4;
        this.fileType = string5;
    }

    public void setMaxRecordsCountPerFile(int n) {
        this.maxRecordsCountPerFile = n;
    }

    private void createBlockDialog(String string) {
        this.blockDialog = new ProgressDialogTemplate(this.getMainFrame(), string, "", null);
        this.cancelListener = new IStop(){

            @Override
            public void stop() {
                SaveAndPrintFile.this.running = false;
                SaveAndPrintFile.this.isSuccess = false;
                SaveAndPrintFile.this.printable.setDataOver(true);
                SaveAndPrintFile.this.printable.setSaveCanceled(true);
                SaveAndPrintFile.this.blockDialog.dispose();
            }
        };
        this.blockDialog.setStop(this.cancelListener);
    }

    boolean saveFile() {
        if (!this.checkPreSaveorPrint()) {
            return false;
        }
        int n = this._rows.length;
        if (n <= 5000) {
            String[] stringArray = this.getColumnNames();
            Vector vector = this.getTablePartData(this._rows, 0, this._rows.length);
            SaveAndPrintParameters saveAndPrintParameters = this.getSaveAndPrintParameters();
            this.printable = saveAndPrintParameters.createTablePrintable(stringArray, vector, n, true);
            this.printable.setMaxRecordsCountPerFile(this.maxRecordsCountPerFile);
            this.printable.setHtmlPerColWidth(saveAndPrintParameters.getHtmlPerColWidth());
            return PrintSupportor.saveToFileNoCheck(this.getMainFrame(), this.fileName, this.printable, this.fileType, saveAndPrintParameters.getUserEncoding());
        }
        this.createBlockDialog(res.getString("Saving"));
        SaveAndPrintTask saveAndPrintTask = new SaveAndPrintTask(this._rows, true, this.maxRecordsCountPerFile);
        saveAndPrintTask.start();
        ScreenToolKit.centerLocateToScreen(this.blockDialog);
        this.blockDialog.show();
        return this.isSuccess;
    }

    boolean printFile() {
        if (!this.checkPreSaveorPrint()) {
            return false;
        }
        int n = this._rows.length;
        String[] stringArray = this.getColumnNames();
        Vector vector = null;
        if (n <= 5000) {
            vector = this.getTablePartData(this._rows, 0, this._rows.length);
            this.printable = this.getSaveAndPrintParameters().createTablePrintable(stringArray, vector, n, false);
            return PrintSupportor.print(this.getMainFrame(), this.printable, this.printable.getPageCount());
        }
        this.printable = new TablePrintable(this.m_szTitle, this.userName, this.summary, stringArray, vector, n, false);
        boolean bl = PrintSupportor.print(this.getMainFrame(), this.printable, this.printable.getPageCount());
        if (bl) {
            this.createBlockDialog(res.getString("Printing"));
            SaveAndPrintTask saveAndPrintTask = new SaveAndPrintTask(this._rows, false);
            saveAndPrintTask.start();
            ScreenToolKit.centerLocateToScreen(this.blockDialog);
            this.blockDialog.show();
            return this.isSuccess;
        }
        return false;
    }

    public String[] getColumnNames() {
        String[] stringArray = new String[this.m_oTable.getColumnCount()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.m_oTable.getColumnName(i);
        }
        return stringArray;
    }

    private Vector getTablePartData(int[] nArray, int n, int n2) {
        Vector vector = new Vector(80);
        int n3 = n + n2;
        Object object = null;
        int n4 = this.m_oTable.getColumnModel().getColumnCount();
        Vector<String> vector2 = null;
        for (int i = n; i < n3; ++i) {
            vector2 = new Vector<String>(20);
            for (int j = 0; j < n4; ++j) {
                object = this.m_oTable.getValueAt(nArray[i], j);
                vector2.add(object == null ? "  " : object.toString());
            }
            vector.add(vector2);
        }
        return vector;
    }

    public void setTitle(String string) {
        if (string != null) {
            this.m_szTitle = string;
        }
    }

    public JFrame getMainFrame() {
        Window window;
        if (this.mainFrame == null && (window = SwingUtilities.windowForComponent(this.m_oTable)) instanceof Frame) {
            this.mainFrame = (JFrame)window;
        }
        return this.mainFrame;
    }

    private boolean checkPreSaveorPrint() {
        return this._rows != null && this._rows.length != 0;
    }

    public void setMainFrame(JFrame jFrame) {
        this.mainFrame = jFrame;
    }

    public void setSaveAndPrintParameters(SaveAndPrintParameters saveAndPrintParameters) {
        this._saveAndPrintParameters = saveAndPrintParameters;
    }

    public SaveAndPrintParameters getSaveAndPrintParameters() {
        if (this._saveAndPrintParameters == null) {
            return new SaveAndPrintParameters(this.m_oTable, this.parent, this._rows, this.m_szTitle, this.userName, this.summary, this.fileName);
        }
        return this._saveAndPrintParameters;
    }

    public void setPrintablePropChangeListeners(PropertyChangeListener[] propertyChangeListenerArray) {
        this.printablePropChangeListeners = propertyChangeListenerArray;
    }

    public String getFileType() {
        return this.fileType;
    }

    private final class SaveAndPrintTask
    extends Thread {
        private static final int ONCE_SAVE_SIZE = 2000;
        private int[] rows;
        private boolean flag = true;
        private int maxRecordsCountPerFile = -1;

        public SaveAndPrintTask(int[] nArray, boolean bl) {
            this.rows = nArray;
            this.flag = bl;
        }

        public SaveAndPrintTask(int[] nArray, boolean bl, int n) {
            this.rows = nArray;
            this.flag = bl;
            this.maxRecordsCountPerFile = n;
        }

        @Override
        public void run() {
            Vector vector = new Vector(80);
            String[] stringArray = SaveAndPrintFile.this.getColumnNames();
            boolean bl = false;
            int n = this.rows.length;
            if (this.flag) {
                SaveAndPrintParameters saveAndPrintParameters = SaveAndPrintFile.this.getSaveAndPrintParameters();
                SaveAndPrintFile.this.printable = saveAndPrintParameters.createTablePrintable(stringArray, vector, n, this.flag);
                if (this.maxRecordsCountPerFile != -1) {
                    SaveAndPrintFile.this.printable.setMaxRecordsCountPerFile(this.maxRecordsCountPerFile);
                }
                SaveAndPrintFile.this.printable.setHtmlPerColWidth(saveAndPrintParameters.getHtmlPerColWidth());
                bl = PrintSupportor.saveToFileNoCheck(SaveAndPrintFile.this.getMainFrame(), SaveAndPrintFile.this.fileName, SaveAndPrintFile.this.printable, SaveAndPrintFile.this.fileType, saveAndPrintParameters.getUserEncoding());
            } else {
                bl = true;
            }
            if (!bl) {
                SaveAndPrintFile.this.isSuccess = false;
            } else {
                if (SaveAndPrintFile.this.blockDialog != null) {
                    SaveAndPrintFile.this.blockDialog.getProgressBar().setStringPainted(true);
                    SaveAndPrintFile.this.blockDialog.getProgressBar().setMinimum(0);
                    SaveAndPrintFile.this.blockDialog.getProgressBar().setMaximum(n);
                    SaveAndPrintFile.this.blockDialog.setCurrentValue(0);
                }
                SaveAndPrintFile.this.running = true;
                SaveAndPrintFile.this.isSuccess = true;
                int n2 = 0;
                boolean bl2 = false;
                int n3 = 0;
                try {
                    for (int i = 0; SaveAndPrintFile.this.running && i < this.rows.length && !SaveAndPrintFile.this.printable.isOver(); i += 2000) {
                        n2 = this.rows.length - i < 2000 ? this.rows.length - i : 2000;
                        vector = SaveAndPrintFile.this.getTablePartData(this.rows, i, n2);
                        SaveAndPrintFile.this.printable.append(vector, true);
                        if (SaveAndPrintFile.this.blockDialog != null && bl2) {
                            SaveAndPrintFile.this.blockDialog.incrementValue(n3);
                        }
                        n3 = vector.size();
                        bl2 = true;
                    }
                    SavePrintable savePrintable = SaveAndPrintFile.this.printable.getImplRef();
                    if (null != savePrintable) {
                        while (!savePrintable.isOver()) {
                            Thread.sleep(1000L);
                        }
                    }
                    SaveAndPrintFile.this.blockDialog.incrementValue(n3);
                }
                catch (Exception exception) {
                    logger.trace(exception.getMessage(), exception);
                    SaveAndPrintFile.this.running = false;
                    SaveAndPrintFile.this.isSuccess = false;
                    SaveAndPrintFile.this.printable.setDataOver(true);
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SaveAndPrintFile.this.blockDialog != null) {
                        SaveAndPrintFile.this.blockDialog.setCurrentValue(0);
                        SaveAndPrintFile.this.blockDialog.removeAll();
                        SaveAndPrintFile.this.blockDialog.dispose();
                        SaveAndPrintFile.this.blockDialog = null;
                    }
                }
            });
            SaveAndPrintFile.this.printable = null;
        }
    }
}

