/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.extendedtable;

import com.swimap.iview.templates.textfield.ipaddress.IPAddressTextField;
import java.awt.Component;
import java.util.StringTokenizer;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class IPTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final String DEFAULT_IP = "0.0.0.0";
    private static final int IP_ELEMENT_MAX = 255;
    private static final int IP_LENGTH_MAX = 15;
    private static final int IP_LENGTH_MIN = 7;
    private IPAddressTextField ipTextField = new IPAddressTextField();

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.ipTextField.setText(object.toString());
        return this.ipTextField;
    }

    @Override
    public Object getCellEditorValue() {
        String string = this.ipTextField.getText().trim();
        if (!IPTableCellEditor.isValidIP(string)) {
            return DEFAULT_IP;
        }
        return this.delSpace(string);
    }

    private static boolean isValidIP(String string) {
        String string2;
        String string3 = string2 = string == null ? "" : string.trim();
        if (string2.length() < 7 || string2.length() > 15) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
        int n = stringTokenizer.countTokens();
        if (n == 4) {
            int n2 = 1;
            while (stringTokenizer.hasMoreTokens()) {
                if (!IPTableCellEditor.isValidNumber(stringTokenizer.nextToken(), n2, 255)) {
                    return false;
                }
                n2 = 0;
            }
        } else {
            return false;
        }
        return true;
    }

    private static boolean isValidNumber(String string, int n, int n2) {
        try {
            int n3 = Integer.parseInt(string.trim());
            if (n3 < n || n3 > n2) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    private final String delSpace(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = -1;
        int n3 = 0;
        while (n3 < n && (n3 = string.indexOf(32, n3)) != -1) {
            stringBuffer.append(string.substring(n2 + 1, n3));
            n2 = n3++;
        }
        return stringBuffer.append(string.substring(n2 + 1, n)).toString();
    }
}

