/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.extendedtable;

import com.swimap.iview.templates.extendedtable.ColumnResizer;
import com.swimap.iview.templates.extendedtable.ExtendedTable;
import com.swimap.iview.templates.extendedtable.SortButtonRenderer;
import com.swimap.iview.templates.extendedtable.SortableTableModel;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class HeaderListener
extends MouseAdapter {
    private JTableHeader header = null;
    private SortButtonRenderer renderer = null;
    private int clickCount = 1;

    public HeaderListener(JTableHeader jTableHeader, SortButtonRenderer sortButtonRenderer, int n) {
        this.header = jTableHeader;
        this.renderer = sortButtonRenderer;
        this.clickCount = n;
    }

    public HeaderListener(JTableHeader jTableHeader, SortButtonRenderer sortButtonRenderer) {
        this.header = jTableHeader;
        this.renderer = sortButtonRenderer;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        JTable jTable = this.header.getTable();
        TableColumn tableColumn = ColumnResizer.getResizingColumn(jTable, mouseEvent);
        if (tableColumn != null) {
            return;
        }
        this.sortTableAction(mouseEvent);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        JTable jTable = this.header.getTable();
        if (jTable.isEditing()) {
            jTable.getCellEditor().stopCellEditing();
        }
    }

    public int getClickCount() {
        return this.clickCount;
    }

    public void setClickCount(int n) {
        this.clickCount = n;
    }

    private void sortTableAction(MouseEvent mouseEvent) {
        int n;
        JTable jTable = this.header.getTable();
        int n2 = this.header.columnAtPoint(mouseEvent.getPoint());
        if (n2 < 0) {
            return;
        }
        boolean bl = SwingUtilities.isLeftMouseButton(mouseEvent);
        boolean bl2 = jTable instanceof ExtendedTable;
        if (bl && bl2 && (n = ((ExtendedTable)jTable).handleHeaderMouseClick(mouseEvent)) != 0) {
            return;
        }
        if (mouseEvent.getClickCount() == this.clickCount && bl) {
            SortableTableModel sortableTableModel;
            if (bl2 && !((ExtendedTable)jTable).getSortable()) {
                return;
            }
            if (jTable.getModel() instanceof SortableTableModel && (sortableTableModel = (SortableTableModel)jTable.getModel()).isColumnSortable(jTable.convertColumnIndexToModel(n2))) {
                int n3 = jTable.convertColumnIndexToModel(n2);
                this.renderer.setPressedColumn(n3);
                if (0 == this.renderer.getState(n3)) {
                    this.renderer.setSelectedColumn(n3);
                }
                this.renderer.setSelectedColumn(n3);
                this.header.repaint();
                boolean bl3 = false;
                if (1 == this.renderer.getState(n3)) {
                    bl3 = true;
                }
                int[] nArray = jTable.getSelectedRows();
                int[] nArray2 = new int[nArray.length];
                int[] nArray3 = sortableTableModel.getIndexes();
                for (int i = nArray2.length - 1; i >= 0; --i) {
                    nArray2[i] = nArray3[nArray[i]];
                }
                RootPaneContainer rootPaneContainer = (RootPaneContainer)((Object)jTable.getTopLevelAncestor());
                rootPaneContainer.getGlassPane().setVisible(true);
                rootPaneContainer.getGlassPane().setCursor(new Cursor(3));
                sortableTableModel.sortByColumn(n3, bl3);
                rootPaneContainer.getGlassPane().setVisible(false);
                rootPaneContainer.getGlassPane().setCursor(new Cursor(0));
                rootPaneContainer.getGlassPane().setCursor(new Cursor(0));
                this.renderer.setPressedColumn(-1);
                jTable.invalidate();
                jTable.repaint();
                jTable.getSelectionModel().setValueIsAdjusting(true);
                if (jTable.getRowCount() > 0) {
                    jTable.clearSelection();
                }
                nArray3 = sortableTableModel.getIndexes();
                int n4 = nArray3.length;
                block1: for (int i = nArray2.length - 1; i >= 0; --i) {
                    for (int j = 0; j < n4; ++j) {
                        if (nArray3[j] != nArray2[i]) continue;
                        jTable.addRowSelectionInterval(j, j);
                        continue block1;
                    }
                }
                jTable.getSelectionModel().setValueIsAdjusting(false);
            }
            jTable.firePropertyChange("sortEnded", false, true);
            n = jTable.getSelectedRow();
            if (-1 != n) {
                jTable.scrollRectToVisible(jTable.getCellRect(n, n2, true));
            }
        }
    }
}

