/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.extendedtable;

import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.templates.basictable.BasicTable;
import com.swimap.iview.templates.basictable.ColumnInformation;
import com.swimap.iview.templates.extendedtable.DiscontinueSelectionModel;
import com.swimap.iview.templates.extendedtable.EditableRenderer;
import com.swimap.iview.templates.extendedtable.HeaderListener;
import com.swimap.iview.templates.extendedtable.SaveAndPrintFile;
import com.swimap.iview.templates.extendedtable.SimpleTableEditorActionListener;
import com.swimap.iview.templates.extendedtable.SortButtonRenderer;
import com.swimap.iview.templates.extendedtable.SortableTableModel;
import com.swimap.iview.templates.extendedtable.TablePopupMenu;
import com.swimap.iview.templates.print.SaveAndPrintParameters;
import com.swimap.iview.templates.utils.MultiRowToolTip;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.ListSelectionModel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ExtendedTable
extends BasicTable {
    private static IviewLogger logger = IviewLogger.getLogger(ExtendedTable.class, "IVIEW");
    protected static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/extendedtable/Res");
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private SaveAndPrintFile saveAndPrintFile = null;
    private SortButtonRenderer renderer = new SortButtonRenderer();
    private int[] fromSelRows = null;
    private int[] fromSelCols = null;
    private JPopupMenu m_oPopMenu = null;
    private JPopupMenu userPopMenu = null;
    private boolean isEnableCellInfo = false;
    private boolean enableToolTip = false;
    private transient MouseListener popupListener = null;
    private JPopupMenu m_oHeaderPopMenu = null;
    private MouseListener headerPopupListener = null;
    private static String COLUMN_SORTED = "columnSorted";
    private static String IS_DESCENDING = "isDescending";
    private Color editableForeground = new Color(0, 0, 0);
    private Color editableBackground = UIManager.getColor("Table.background");
    private Color uneditableForeground = new Color(174, 174, 174);
    private Color uneditableBackground = UIManager.getColor("Table.background");
    private Color invalidedForeground = new Color(102, 102, 102);
    private Color invalidedBackground = UIManager.getColor("Table.background");
    private Color notSaveForeground = Color.red;
    private Color notSaveBackground = null;
    private SimpleTableEditorActionListener simpleTableEditorActionListener = null;
    private HashMap hideColsHashMap = new HashMap(10);
    private boolean isCellSelection = false;
    private JFrame mainFrame = null;
    private DiscontinueSelectionModel discontinueSelectionModel = new DiscontinueSelectionModel();
    private static final int ROW_HEIGHT = 21;
    private int sortableClickCount = 2;
    private HeaderListener headerListener = null;
    private boolean isScrolls = true;
    private boolean isSortAgain = true;
    private boolean isUpDateSelectedRow = false;
    protected boolean autoSelect = true;
    private boolean changeSelect = false;
    private boolean sortable = true;
    private int[] printColumnWidths = null;
    private boolean useActualWidthsForPrint = false;
    private int htmlPerColWidth = 0;
    public static final int MAX_REC_COUNT_PERFILE = 65536;
    public static final int MAX_XLSX_REC_COUNT_PERFILE = 500000;
    private int maxRecordsCountPerFile = -1;

    public void setUpDateSelectedRow(boolean bl) {
        this.isUpDateSelectedRow = bl;
    }

    public ExtendedTable(SortableTableModel sortableTableModel) {
        super(sortableTableModel);
        this.init();
    }

    public ExtendedTable(SortableTableModel sortableTableModel, int n) {
        super(sortableTableModel);
        this.setSortableClickCount(n);
        this.init();
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.isEnableToolTip()) {
            String string = null;
            int n = this.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
            int n2 = this.columnAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
            if (this.simpleTableEditorActionListener != null) {
                string = this.simpleTableEditorActionListener.getToolTip(this, n, n2);
            }
            return string;
        }
        return super.getToolTipText(mouseEvent);
    }

    public SortableTableModel getSortableTableModel() {
        return (SortableTableModel)this.getModel();
    }

    public void setShowConfig(boolean bl) {
        this.setCustomizable(bl);
    }

    public boolean isShowConfig() {
        return this.isCustomizable();
    }

    public void removeSelectRow(int n) {
        if (n < 0) {
            return;
        }
        this.stopCellEdit();
        this.getSortableTableModel().removeRow(n);
    }

    @Override
    public JToolTip createToolTip() {
        MultiRowToolTip multiRowToolTip = new MultiRowToolTip();
        multiRowToolTip.setComponent(this);
        return multiRowToolTip;
    }

    public void removeSelectRows(int[] nArray) {
        this.stopCellEdit();
        this.getSelectionModel().clearSelection();
        this.getSortableTableModel().removeSelectedRows(nArray);
    }

    private void init() {
        this.setSortableHeaderRenderer(this.renderer);
        this.setCustomizable(false);
        this.setRowHeight(21);
        this.setRenderer();
        this.addPopupActionListener();
        this.saveAndPrintFile = new SaveAndPrintFile(this);
        this.enableCellInfo(this.isEnableCellInfo());
    }

    public void setSortableHeaderRenderer(SortButtonRenderer sortButtonRenderer) {
        if (null == sortButtonRenderer) {
            return;
        }
        this.renderer = sortButtonRenderer;
        this.getTableHeader().setDefaultRenderer(this.renderer);
        this.setSortableRenderer();
        if (null != this.headerListener) {
            this.removeSortActionListener();
        }
        this.addSortActionListener();
    }

    private void setRenderer() {
        this.setDefaultRenderer(Object.class, new EditableRenderer());
        this.setDefaultRenderer(Number.class, new NumberRenderer());
        this.setDefaultRenderer(Float.class, new DoubleRenderer());
        this.setDefaultRenderer(Double.class, new DoubleRenderer());
        this.setDefaultRenderer(Date.class, new DateRenderer());
        this.setDefaultRenderer(Icon.class, new IconRenderer());
        this.setDefaultRenderer(ImageIcon.class, new IconRenderer());
        this.setDefaultRenderer(Boolean.class, new BooleanRenderer());
    }

    private void setSortableRenderer() {
        Hashtable hashtable = this.getColumns();
        Vector vector = this.getKeys();
        TableColumn tableColumn = null;
        for (Object e : vector) {
            tableColumn = (TableColumn)hashtable.get(e);
            tableColumn.setHeaderRenderer(this.renderer);
        }
    }

    private void addPopupActionListener() {
        this.popupListener = new PopupListener();
        this.addMouseListener(this.popupListener);
    }

    public void stopCellEdit() {
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
    }

    public void setFileTitle(String string) {
        this.saveAndPrintFile.setTitle(string);
    }

    public void setMaxRecordsCountPerFile(int n) {
        this.maxRecordsCountPerFile = n;
    }

    public boolean saveAs() {
        return this.saveAs("", "", "");
    }

    public boolean saveAs(String string) {
        return this.saveAs(string, "");
    }

    public boolean saveAs(String string, String string2) {
        return this.saveMultiRows(string, string2, "", "", 0, this.getRowCount() - 1);
    }

    public boolean saveAs(String string, String string2, String string3) {
        return this.saveMultiRows(null, string, string2, string3, 0, this.getRowCount() - 1);
    }

    public boolean saveSelectRows(String string, String string2, String string3, String string4) {
        int[] nArray = this.getSelectedRows();
        if (nArray != null && nArray.length > 0) {
            return this.saveMultiRows(string, string2, string3, string4, nArray);
        }
        return false;
    }

    public boolean saveMultiRows(String string, String string2, String string3, String string4, int n, int n2) {
        if (n >= 0 && n2 >= n && n2 < this.getRowCount()) {
            int[] nArray = new int[n2 - n + 1];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = n++;
            }
            return this.saveMultiRows(string, string2, string3, string4, nArray);
        }
        return false;
    }

    private boolean saveMultiRows(String string, String string2, String string3, String string4, int[] nArray) {
        JFrame jFrame = this.mainFrame != null ? this.mainFrame : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this);
        SaveAndPrintParameters saveAndPrintParameters = new SaveAndPrintParameters(this, jFrame, nArray, string2, string3, string4, string);
        return this.saveMultiRows(saveAndPrintParameters);
    }

    public boolean saveMultiRows(SaveAndPrintParameters saveAndPrintParameters) {
        SaveAndPrintFile saveAndPrintFile;
        if (0 == this.getColumnCount()) {
            logger.trace("Column count is zero");
            return false;
        }
        this.stopCellEdit();
        if (saveAndPrintParameters.getHtmlPerColWidth() == 0) {
            saveAndPrintParameters.setHtmlPerColWidth(this.htmlPerColWidth);
        }
        if ((saveAndPrintFile = saveAndPrintParameters.initExtSaveTask()) == null) {
            return false;
        }
        this.setMaxRowCount(saveAndPrintFile);
        saveAndPrintFile.setMaxRecordsCountPerFile(this.maxRecordsCountPerFile);
        if (this.mainFrame != null) {
            saveAndPrintFile.setMainFrame(this.mainFrame);
        }
        this.saveAndPrintFile = saveAndPrintFile;
        return saveAndPrintFile.saveFile();
    }

    private void setMaxRowCount(SaveAndPrintFile saveAndPrintFile) {
        if (-1 == this.maxRecordsCountPerFile) {
            this.maxRecordsCountPerFile = null != saveAndPrintFile.getFileType() && saveAndPrintFile.getFileType().equals("xlsx") ? 500000 : 65536;
        }
    }

    public boolean printTable() {
        return this.printTable("", "", "");
    }

    public boolean printTable(String string, String string2, String string3) {
        return this.printMultiRows(string, string2, string3, 0, this.getRowCount() - 1);
    }

    public boolean printSelectRows(String string, String string2, String string3) {
        int[] nArray = this.getSelectedRows();
        if (nArray != null && nArray.length > 0) {
            return this.printMultiRows(string, string2, string3, nArray);
        }
        return false;
    }

    public boolean printMultiRows(String string, String string2, String string3, int n, int n2) {
        if (n >= 0 && n2 >= n && n2 < this.getRowCount()) {
            int[] nArray = new int[n2 - n + 1];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = n++;
            }
            return this.printMultiRows(string, string2, string3, nArray);
        }
        return false;
    }

    private boolean printMultiRows(String string, String string2, String string3, int[] nArray) {
        JFrame jFrame = this.mainFrame != null ? this.mainFrame : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this);
        SaveAndPrintParameters saveAndPrintParameters = new SaveAndPrintParameters(this, jFrame, nArray, string, string2, string3, "");
        return this.printMultiRows(saveAndPrintParameters);
    }

    public boolean printMultiRows(SaveAndPrintParameters saveAndPrintParameters) {
        this.stopCellEdit();
        SaveAndPrintFile saveAndPrintFile = saveAndPrintParameters.initExtPrintTask();
        if (saveAndPrintFile == null) {
            return false;
        }
        if (this.mainFrame != null) {
            saveAndPrintFile.setMainFrame(this.mainFrame);
        }
        this.saveAndPrintFile = saveAndPrintFile;
        return saveAndPrintFile.printFile();
    }

    public void clearNotSavedCells() {
        this.getSortableTableModel().clearNotSavedCells();
    }

    public void addPopupMenu(JPopupMenu jPopupMenu) {
        if (null == jPopupMenu) {
            logger.trace("popMenu is null");
            return;
        }
        this.userPopMenu = jPopupMenu;
        this.userPopMenu.setName("ExtendedTable_userPopMenu");
        this.enableCellInfo(this.isEnableCellInfo());
    }

    public void enableCellInfo(boolean bl) {
        this.isEnableCellInfo = bl;
        this.m_oPopMenu = bl ? new TablePopupMenu(this.userPopMenu) : this.userPopMenu;
        if (this.m_oPopMenu != null) {
            this.m_oPopMenu.setName("ExtendedTable_m_oPopMenu");
        }
    }

    public boolean isEnableCellInfo() {
        return this.isEnableCellInfo;
    }

    public void addHeaderPopupMenu(JPopupMenu jPopupMenu) {
        this.m_oHeaderPopMenu = jPopupMenu;
    }

    public void setChangeSelect(boolean bl) {
        this.changeSelect = bl;
    }

    private void refreshSelect(MouseEvent mouseEvent) {
        if (3 == mouseEvent.getButton()) {
            int n = this.columnAtPoint(mouseEvent.getPoint());
            int n2 = this.rowAtPoint(mouseEvent.getPoint());
            if (this.getRowSelectionAllowed() && !this.getColumnSelectionAllowed()) {
                int[] nArray = this.getSelectedRows();
                boolean bl = false;
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] != n2) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    this.setRowSelectionInterval(n2, n2);
                }
            } else if (!this.getRowSelectionAllowed() && this.getColumnSelectionAllowed()) {
                int[] nArray = this.getSelectedColumns();
                boolean bl = false;
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] != n) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    this.setColumnSelectionInterval(n, n);
                }
            } else if (this.getRowSelectionAllowed() && this.getColumnSelectionAllowed()) {
                boolean bl = false;
                boolean bl2 = false;
                int[] nArray = this.getSelectedColumns();
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] != n) continue;
                    bl2 = true;
                    break;
                }
                int[] nArray2 = this.getSelectedRows();
                for (int i = 0; i < nArray2.length; ++i) {
                    if (nArray2[i] != n2) continue;
                    bl = true;
                    break;
                }
                if (!bl || !bl2) {
                    this.setColumnSelectionInterval(n, n);
                    this.setRowSelectionInterval(n2, n2);
                }
            } else {
                logger.trace("Tabel is at unselected model!");
            }
        }
    }

    public void setCellEditable(int n, int n2, boolean bl) {
        this.getSortableTableModel().setCellEditable(n, this.convertColumnIndexToModel(n2), bl);
    }

    public void setSelectedCellsEditable(boolean bl) {
        int[] nArray = this.getSelectedRows();
        int[] nArray2 = this.getSelectedColumns();
        int n = this.getSelectedRow();
        int n2 = this.getSelectedRowCount();
        int n3 = this.getSelectedColumnCount();
        if (n != -1) {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    this.setCellEditable(nArray[i], nArray2[j], bl);
                }
            }
        }
    }

    public void setColumnSortable(int[] nArray, boolean bl) {
        if (nArray == null) {
            return;
        }
        this.columnModel = this.getColumnModel();
        int n = this.getColumnCount();
        for (int i = nArray.length - 1; i >= 0; --i) {
            if (nArray[i] >= n) {
                return;
            }
            this.getSortableTableModel().setColumnSortable(this.convertColumnIndexToModel(nArray[i]), bl);
        }
        this.getTableHeader().repaint();
    }

    public void setColumnSortable(int n, boolean bl) {
        this.setColumnSortable(new int[]{n}, bl);
    }

    public void setColumnSortable(Object object, boolean bl) {
        TableColumn tableColumn = this.getColumn(object);
        if (tableColumn != null) {
            this.getSortableTableModel().setColumnSortable(tableColumn.getModelIndex(), bl);
            this.getTableHeader().repaint();
        }
    }

    public void setColumnSortable(Object[] objectArray, boolean bl) {
        if (objectArray == null) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            this.setColumnSortable(objectArray[i], bl);
        }
    }

    public void setSortable(boolean bl) {
        if (this.sortable == bl) {
            return;
        }
        this.sortable = bl;
        this.getTableHeader().repaint();
    }

    @Override
    public boolean getSortable() {
        return this.sortable;
    }

    public void setSelectedColumnSortable(boolean bl) {
        int[] nArray = this.getSelectedColumns();
        this.setColumnSortable(nArray, bl);
    }

    private void addSortActionListener() {
        JTableHeader jTableHeader = this.getTableHeader();
        this.headerListener = new HeaderListener(jTableHeader, this.renderer, this.getSortableClickCount());
        jTableHeader.addMouseListener(this.headerListener);
    }

    private void removeSortActionListener() {
        JTableHeader jTableHeader = this.getTableHeader();
        jTableHeader.removeMouseListener(this.headerListener);
    }

    @Override
    protected void updateTable(ColumnInformation[] columnInformationArray) {
        super.updateTable(columnInformationArray);
        Vector vector = this.getKeys();
        Hashtable hashtable = this.getColInfos();
        ColumnInformation columnInformation = null;
        boolean[] blArray = new boolean[vector.size()];
        boolean bl = true;
        JTableHeader jTableHeader = this.getTableHeader();
        JTable jTable = jTableHeader.getTable();
        boolean bl2 = jTable instanceof ExtendedTable && jTable.getModel() instanceof SortableTableModel;
        SortableTableModel sortableTableModel = this.getSortableTableModel();
        for (int i = 0; i < blArray.length; ++i) {
            int n;
            columnInformation = (ColumnInformation)hashtable.get(vector.get(i));
            blArray[i] = columnInformation.getState() != 3 && columnInformation.getState() != 1;
            if (null == columnInformation.getIdentifier() || !columnInformation.isColumnSorted()) continue;
            bl = columnInformation.isDescending();
            int n2 = columnInformation.getIndex();
            if (!bl2) continue;
            int n3 = -1;
            int n4 = this.getColumnModel().getColumnCount();
            if (n2 < n4) {
                n = jTable.convertColumnIndexToModel(n2);
                String string = sortableTableModel.getColumnName(n);
                if (columnInformation.getIdentifier().equals(string)) {
                    n3 = n;
                }
            }
            if (-1 == n3) {
                n = sortableTableModel.getColumnCount();
                for (int j = 0; j < n; ++j) {
                    if (!columnInformation.getIdentifier().equals(sortableTableModel.getColumnName(j))) continue;
                    n3 = j;
                    break;
                }
            }
            if (-1 == n3) continue;
            this.renderer.setPressedColumn(n3);
            this.renderer.setSelectedColumn(n3);
            RootPaneContainer rootPaneContainer = (RootPaneContainer)((Object)jTable.getTopLevelAncestor());
            if (null != rootPaneContainer) {
                rootPaneContainer.getGlassPane().setVisible(true);
                rootPaneContainer.getGlassPane().setCursor(new Cursor(3));
                sortableTableModel.sortColumn(n3, bl);
                rootPaneContainer.getGlassPane().setVisible(false);
                rootPaneContainer.getGlassPane().setCursor(new Cursor(0));
            } else {
                sortableTableModel.sortColumn(n3, bl);
            }
            this.renderer.clearSortFlag();
            this.refurbishTable();
        }
        this.getSortableTableModel().setColumnsVisible(blArray);
    }

    @Override
    public void setColumnVisible(Object object, int n) {
        super.setColumnVisible(object, n);
        Vector vector = this.getKeys();
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            if (!vector.get(i).equals(object)) continue;
            if (n == 3 || n == 1) {
                this.getSortableTableModel().setColumnVisible(i, false);
                break;
            }
            this.getSortableTableModel().setColumnVisible(i, true);
            break;
        }
    }

    public void setColumnShowingEnable(boolean[] blArray) {
        int n;
        Serializable serializable;
        if (blArray == null || blArray.length == 0) {
            return;
        }
        TableColumnModel tableColumnModel = this.getColumnModel();
        while (0 != tableColumnModel.getColumnCount()) {
            serializable = tableColumnModel.getColumn(0);
            tableColumnModel.removeColumn((TableColumn)serializable);
        }
        serializable = this.getColInfos();
        Vector vector = this.getKeys();
        Hashtable hashtable = this.getColumns();
        int n2 = ((Hashtable)serializable).size();
        int n3 = Math.min(blArray.length, n2);
        for (n = 0; n < n3; ++n) {
            if (blArray[n]) {
                ((ColumnInformation)((Hashtable)serializable).get(vector.get(n))).setState(0);
                tableColumnModel.addColumn((TableColumn)hashtable.get(vector.get(n)));
                continue;
            }
            ((ColumnInformation)((Hashtable)serializable).get(vector.get(n))).setState(1);
        }
        for (n = blArray.length; n < n2; ++n) {
            ((ColumnInformation)((Hashtable)serializable).get(vector.get(n))).setState(1);
        }
    }

    public void clearSortFlag() {
        if (this.renderer != null) {
            this.renderer.clearSortFlag();
        }
        this.getSortableTableModel().sortByColumn(-1, false);
        this.getTableHeader().repaint();
    }

    public void copy() {
        this.fromSelRows = this.getSelectedRows();
        this.fromSelCols = this.getSelectedColumns();
    }

    public void paste() {
        int[] nArray = this.getSelectedRows();
        int[] nArray2 = this.getSelectedColumns();
        int n = this.getSelectedRow();
        int n2 = this.getSelectedRowCount();
        int n3 = this.getSelectedColumnCount();
        int n4 = 0;
        int n5 = 0;
        if (this.fromSelRows == null || this.fromSelCols == null) {
            return;
        }
        n4 = Math.min(this.fromSelRows.length, n2);
        n5 = Math.min(this.fromSelCols.length, n3);
        if (n != -1) {
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n5; ++j) {
                    if (!this.getModel().isCellEditable(nArray[i], nArray2[j]) || this.getModel().getColumnClass(this.fromSelCols[j]) != this.getModel().getColumnClass(nArray2[j])) continue;
                    this.setValueAt(this.getValueAt(this.fromSelRows[i], this.fromSelCols[j]), nArray[i], nArray2[j]);
                }
            }
        }
        this.repaint();
    }

    public void copyDown() {
        int[] nArray = this.getSelectedRows();
        int[] nArray2 = this.getSelectedColumns();
        int n = this.getSelectedRow();
        int n2 = this.getSelectedRowCount();
        int n3 = this.getSelectedColumnCount();
        if (n != -1) {
            for (int i = 1; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    if (nArray[i] >= this.getRowCount() || !this.getModel().isCellEditable(nArray[i], nArray2[j])) continue;
                    this.setValueAt(this.getValueAt(n, nArray2[j]), nArray[i], nArray2[j]);
                }
            }
        }
        this.repaint();
    }

    public void copyToClipboard() {
        int n;
        int n2;
        this.fromSelRows = this.getSelectedRows();
        this.fromSelCols = this.getSelectedColumns();
        if (this.fromSelCols.length == 0) {
            n2 = this.getColumnCount();
            this.fromSelCols = new int[n2];
            for (n = 0; n < n2; ++n) {
                this.fromSelCols[n] = n;
            }
        }
        if (this.fromSelRows.length == 0) {
            n2 = this.getRowCount();
            this.fromSelRows = new int[n2];
            for (n = 0; n < n2; ++n) {
                this.fromSelRows[n] = n;
            }
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        n = this.fromSelRows.length;
        int n3 = this.fromSelCols.length;
        String string = null;
        Object object = null;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n3; ++j) {
                object = this.getValueAt(this.fromSelRows[i], this.fromSelCols[j]);
                string = object == null ? "  " : object.toString();
                stringBuffer.append(string);
                stringBuffer.append("\t");
            }
            stringBuffer.append(LINE_SEPARATOR);
        }
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, null);
    }

    public void hideColumn() {
        int n;
        int[] nArray = this.getSelectedColumns();
        ArrayList<String> arrayList = new ArrayList<String>(10);
        int n2 = nArray.length;
        for (n = 0; n < n2; ++n) {
            arrayList.add(this.getColumnName(nArray[n]));
        }
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            this.hideColumn((String)arrayList.get(n));
        }
        arrayList.clear();
    }

    public void hideColumn(int n) {
        if (n >= this.getColumnCount()) {
            return;
        }
        this.hideColumn(this.getColumnName(n));
    }

    public void hideColumn(String string) {
        this.hideColsHashMap.put(string, this.getColumn(string));
        this.setColumnVisible(string, 3);
    }

    public void showColumn(String string) {
        this.setColumnVisible(string, 0);
        this.hideColsHashMap.remove(string);
    }

    public void showHidedColumns() {
        Hashtable hashtable = this.getColInfos();
        Vector vector = this.getKeys();
        ColumnInformation columnInformation = null;
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            columnInformation = (ColumnInformation)hashtable.get(vector.get(i));
            if (columnInformation == null || columnInformation.getState() != 3) continue;
            this.setColumnVisible(columnInformation.getIdentifier(), 0);
        }
        this.hideColsHashMap.clear();
    }

    public HashMap getHideColsHashMap() {
        return this.hideColsHashMap;
    }

    public void reverseSort() {
        this.getSortableTableModel().resetIndexes();
        this.repaint();
        this.clearSortFlag();
    }

    public void setColumnEditor(int n, TableCellEditor tableCellEditor) {
        this.getColumn(this.getColumnName(n)).setCellEditor(tableCellEditor);
    }

    public void setColumnEditor(String string, TableCellEditor tableCellEditor) {
        this.getColumn(string).setCellEditor(tableCellEditor);
    }

    public void setColumnRenderer(int n, TableCellRenderer tableCellRenderer) {
        this.getColumn(this.getColumnName(n)).setCellRenderer(tableCellRenderer);
    }

    public void setColumnRenderer(String string, TableCellRenderer tableCellRenderer) {
        this.getColumn(string).setCellRenderer(tableCellRenderer);
    }

    public void clear() {
        this.removeMouseListener(this.popupListener);
        this.getTableHeader().removeMouseListener(this.headerPopupListener);
        this.clearNotSavedCells();
        this.hideColsHashMap.clear();
        if (this.getModel() instanceof SortableTableModel) {
            SortableTableModel sortableTableModel = (SortableTableModel)this.getModel();
            sortableTableModel.clear();
        }
    }

    public Color getEditableForeground() {
        return this.editableForeground;
    }

    public void setEditableForeground(Color color) {
        this.editableForeground = color;
    }

    public Color getEditableBackground() {
        return this.editableBackground;
    }

    public void setEditableBackground(Color color) {
        this.editableBackground = color;
    }

    public Color getUneditableForeground() {
        return this.uneditableForeground;
    }

    public void setUneditableForeground(Color color) {
        this.uneditableForeground = color;
    }

    public Color getUneditableBackground() {
        return this.uneditableBackground;
    }

    public void setUneditableBackground(Color color) {
        this.uneditableBackground = color;
    }

    public Color getNotSaveForeground() {
        return this.notSaveForeground;
    }

    public void setNotSaveForeground(Color color) {
        this.notSaveForeground = color;
    }

    public Color getNotSaveBackground() {
        return this.notSaveBackground;
    }

    public void setNotSaveBackground(Color color) {
        this.notSaveBackground = color;
    }

    @Override
    public boolean isCellSelected(int n, int n2) {
        if (!this.getRowSelectionAllowed() && !this.getColumnSelectionAllowed()) {
            return false;
        }
        return (!this.getRowSelectionAllowed() || this.isRowSelected(n)) && (!this.getColumnSelectionAllowed() || this.isColumnSelected(n2)) || this.discontinueSelectionModel.containsSelection(n, n2);
    }

    @Override
    public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
        if (!this.getIsCellSelection()) {
            super.changeSelection(n, n2, bl, bl2);
        } else {
            ListSelectionModel listSelectionModel = this.getSelectionModel();
            ListSelectionModel listSelectionModel2 = this.getColumnModel().getSelectionModel();
            boolean bl3 = this.isCellSelected(n, n2);
            if (bl && this.getSelectionModel().getSelectionMode() == 2) {
                this.discontinueSelectionModel.changeSelection(n, n2, bl3);
                listSelectionModel2.clearSelection();
                listSelectionModel.clearSelection();
                listSelectionModel2.setAnchorSelectionIndex(n2);
                listSelectionModel.setAnchorSelectionIndex(n);
            } else {
                this.discontinueSelectionModel.clear();
                this.discontinueSelectionModel.changeSelection(n, n2, bl3);
                this.changeListSelectionModel(listSelectionModel2, n2, bl, bl2, bl3);
                this.changeListSelectionModel(listSelectionModel, n, bl, bl2, bl3);
            }
            if (this.getAutoscrolls()) {
                Rectangle rectangle = this.getCellRect(n, n2, false);
                if (rectangle != null) {
                    this.scrollRectToVisible(rectangle);
                }
                this.repaint();
            }
        }
    }

    private void changeListSelectionModel(ListSelectionModel listSelectionModel, int n, boolean bl, boolean bl2, boolean bl3) {
        if (bl2) {
            if (bl) {
                listSelectionModel.setAnchorSelectionIndex(n);
            } else {
                listSelectionModel.setLeadSelectionIndex(n);
            }
        } else if (bl) {
            if (bl3) {
                listSelectionModel.removeSelectionInterval(n, n);
            } else {
                listSelectionModel.addSelectionInterval(n, n);
            }
        } else {
            listSelectionModel.setSelectionInterval(n, n);
        }
    }

    public DiscontinueSelectionModel getDiscontinueSelectionModel() {
        return this.discontinueSelectionModel;
    }

    public void setDiscontinueSelectionModel(DiscontinueSelectionModel discontinueSelectionModel) {
        this.discontinueSelectionModel = discontinueSelectionModel;
    }

    public Color getInvalidedBackground() {
        return this.invalidedBackground;
    }

    public void setInvalidedBackground(Color color) {
        this.invalidedBackground = color;
    }

    public void setInvalidedForeground(Color color) {
        this.invalidedForeground = color;
    }

    public Color getInvalidedForeground() {
        return this.invalidedForeground;
    }

    @Override
    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        JComponent jComponent;
        boolean bl;
        Object object;
        Component component;
        if (this.simpleTableEditorActionListener != null) {
            this.simpleTableEditorActionListener.preEdit(this, n, n2, tableCellEditor);
        }
        if ((component = tableCellEditor.getTableCellEditorComponent(this, object = this.getValueAt(n, n2), bl = this.isCellSelected(n, n2), n, n2)) instanceof JComponent && (jComponent = (JComponent)component).getNextFocusableComponent() == null) {
            jComponent.setNextFocusableComponent(this);
        }
        return component;
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        TableCellEditor tableCellEditor = this.getCellEditor();
        int n = this.editingRow;
        int n2 = this.editingColumn;
        if (tableCellEditor != null) {
            Object object = tableCellEditor.getCellEditorValue();
            this.setValueAt(object, this.editingRow, this.editingColumn);
            this.removeEditor();
        }
        if (this.simpleTableEditorActionListener != null) {
            this.simpleTableEditorActionListener.postEdit(this, n, n2, tableCellEditor);
        }
    }

    public SimpleTableEditorActionListener getSimpleTableEditorActionListener() {
        return this.simpleTableEditorActionListener;
    }

    public void setSimpleTableEditorActionListener(SimpleTableEditorActionListener simpleTableEditorActionListener) {
        this.simpleTableEditorActionListener = simpleTableEditorActionListener;
    }

    public boolean isEnableToolTip() {
        return this.enableToolTip;
    }

    public void setEnableToolTip(boolean bl) {
        this.enableToolTip = bl;
    }

    public void setIsCellSelection(boolean bl) {
        this.isCellSelection = bl;
    }

    public boolean getIsCellSelection() {
        return this.isCellSelection;
    }

    public SaveAndPrintFile getSaveAsFile() {
        return this.saveAndPrintFile;
    }

    public int getSortableClickCount() {
        if (this.headerListener != null) {
            return this.headerListener.getClickCount();
        }
        return this.sortableClickCount;
    }

    public void setSortableClickCount(int n) {
        this.sortableClickCount = n;
        if (this.headerListener != null) {
            this.headerListener.setClickCount(n);
        }
    }

    public void setMainFrame(JFrame jFrame) {
        this.mainFrame = jFrame;
        this.saveAndPrintFile.setMainFrame(jFrame);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        SortableTableModel sortableTableModel = this.getSortableTableModel();
        int n = tableModelEvent.getType();
        if (this.isSortAgain && sortableTableModel != null && !sortableTableModel.isTableUnsort() && this.typeNeedSort(n)) {
            int[] nArray = this.getSelModelRows(tableModelEvent, sortableTableModel);
            super.tableChanged(tableModelEvent);
            sortableTableModel.sortAgain();
            if (n == 1) {
                this.insertSelAct(tableModelEvent, nArray);
            } else if (n == -1) {
                this.deleteSelAct(tableModelEvent, nArray);
            } else if (n == 0) {
                this.updateSelAct(tableModelEvent, nArray);
            }
            this.revalidate();
            this.repaint();
        } else {
            super.tableChanged(tableModelEvent);
        }
    }

    private int[] getSelModelRows(TableModelEvent tableModelEvent, SortableTableModel sortableTableModel) {
        int[] nArray = null;
        if (this.getSelectedRows().length == 0) {
            return nArray;
        }
        if (this.isUpDateSelectedRow && this.getSelectedRows().length != 0) {
            int[] nArray2 = sortableTableModel.getTheIndexes() == null ? sortableTableModel.getIndexes() : sortableTableModel.getTheIndexes();
            nArray = this.getSelModelRows(nArray2);
            if (tableModelEvent.getType() == -1) {
                nArray = this.filtDelSelRows(nArray, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
            }
            if (tableModelEvent.getType() == 1) {
                nArray = this.filtInsertSelRows(nArray, tableModelEvent.getFirstRow() - 1);
            }
        }
        return nArray;
    }

    private int[] filtInsertSelRows(int[] nArray, int n) {
        return this.adjustIndexes(nArray, n, 1);
    }

    private int[] filtDelSelRows(int[] nArray, int n, int n2) {
        int[] nArray2 = nArray;
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2) + 1;
        for (int i = n3; i < n4; ++i) {
            nArray2 = this.filtDelSelRows(nArray2, i);
        }
        return nArray2;
    }

    private int[] filtDelSelRows(int[] nArray, int n) {
        int n2 = -1;
        int[] nArray2 = nArray;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            n2 = i;
            break;
        }
        if (n2 == -1) {
            return this.adjustIndexes(nArray2, n, -1);
        }
        nArray2 = new int[nArray.length - 1];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        System.arraycopy(nArray, n2 + 1, nArray2, n2, nArray.length - n2 - 1);
        return this.adjustIndexes(nArray2, n, -1);
    }

    private int[] adjustIndexes(int[] nArray, int n, int n2) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= n) continue;
            nArray[i] = nArray[i] + n2;
        }
        return nArray;
    }

    private void updateSelAct(TableModelEvent tableModelEvent, int[] nArray) {
        if (this.isScrolls) {
            int n = this.getVisibleRect().x;
            int n2 = this.getSortableTableModel().convertRowIndexToTable(tableModelEvent.getFirstRow());
            Rectangle rectangle = this.getCellRect(n2, 0, true);
            rectangle = new Rectangle(n, rectangle.y, rectangle.width, rectangle.height);
            this.scrollRectToVisible(rectangle);
        }
        if (this.isUpDateSelectedRow && nArray != null) {
            this.addRowSel(nArray, this);
        }
    }

    private void deleteSelAct(TableModelEvent tableModelEvent, int[] nArray) {
        if (nArray != null) {
            this.addRowSel(nArray, this);
        }
    }

    private void insertSelAct(TableModelEvent tableModelEvent, int[] nArray) {
        if (this.isScrolls) {
            if (!this.autoSelect && this.isUpDateSelectedRow && nArray != null) {
                this.addRowSel(nArray, this);
            }
            int n = this.getVisibleRect().x;
            int n2 = this.getSortableTableModel().convertRowIndexToTable(tableModelEvent.getFirstRow());
            Rectangle rectangle = this.getCellRect(n2, 0, true);
            rectangle = new Rectangle(n, rectangle.y, rectangle.width, rectangle.height);
            this.scrollRectToVisible(rectangle);
            if (this.autoSelect) {
                this.setRowSelectionInterval(n2, n2);
            }
        } else if (this.isUpDateSelectedRow && nArray != null) {
            this.addRowSel(nArray, this);
        }
    }

    private int[] getSelModelRows(int[] nArray) {
        int[] nArray2 = this.getSelectedRows();
        int[] nArray3 = null;
        nArray3 = new int[nArray2.length];
        for (int i = nArray3.length - 1; i >= 0; --i) {
            if (nArray2[i] >= nArray.length) continue;
            nArray3[i] = nArray[nArray2[i]];
        }
        return nArray3;
    }

    private void addRowSel(int[] nArray, ExtendedTable extendedTable) {
        SortableTableModel sortableTableModel = extendedTable.getSortableTableModel();
        this.getSelectionModel().setValueIsAdjusting(true);
        this.clearSelection();
        int[] nArray2 = sortableTableModel.getIndexes();
        int n = nArray2.length;
        block0: for (int i = nArray.length - 1; i >= 0; --i) {
            for (int j = 0; j < n; ++j) {
                if (nArray2[j] != nArray[i]) continue;
                this.addRowSelectionInterval(j, j);
                continue block0;
            }
        }
        this.getSelectionModel().setValueIsAdjusting(false);
    }

    private boolean typeNeedSort(int n) {
        return n == 1 || n == -1 || n == 0;
    }

    public void setScrolls(boolean bl) {
        this.isScrolls = bl;
    }

    public boolean isScrolls() {
        return this.isScrolls;
    }

    public void setSortAgain(boolean bl) {
        this.isSortAgain = bl;
    }

    public boolean isSortAgain() {
        return this.isSortAgain;
    }

    public void setAutoSelect(boolean bl) {
        this.autoSelect = bl;
    }

    public void refurbishTable() {
        SortableTableModel sortableTableModel = this.getSortableTableModel();
        if (sortableTableModel.getSortedColumn() != -1) {
            int n = sortableTableModel.sortStateIsDescend() ? 1 : 2;
            int n2 = this.renderer.getState(sortableTableModel.getSortedColumn());
            int n3 = Math.abs(n - n2);
            for (int i = 0; i < n3; ++i) {
                this.renderer.setSelectedColumn(sortableTableModel.getSortedColumn());
            }
        }
        this.revalidate();
        this.getTableHeader().repaint();
        this.repaint();
    }

    public void setMultiValues(int n, int n2, int[] nArray, Object object, boolean bl) {
        Object[] objectArray = new Object[nArray.length];
        Arrays.fill(objectArray, object);
        this.setMultiValues(n, n2, nArray, objectArray, bl);
    }

    public void setMultiValues(int n, int n2, int[] nArray, Object[] objectArray, boolean bl) {
        int n3;
        if (nArray.length != objectArray.length) {
            return;
        }
        SortableTableModel sortableTableModel = (SortableTableModel)this.getModel();
        int[] nArray2 = new int[nArray.length];
        int[] nArray3 = sortableTableModel.getIndexes();
        for (n3 = nArray2.length - 1; n3 >= 0; --n3) {
            nArray2[n3] = nArray3[nArray[n3]];
        }
        if (this.isSortAgain) {
            this.setSortAgain(false);
            for (n3 = 0; n3 < nArray.length; ++n3) {
                this.setValueAt(objectArray[n3], nArray[n3], n);
            }
            this.setSortAgain(true);
        } else {
            for (n3 = 0; n3 < nArray.length; ++n3) {
                this.setValueAt(objectArray[n3], nArray[n3], n);
            }
        }
        sortableTableModel.sortByColumn(n2, bl);
        this.invalidate();
        this.repaint();
        if (this.getRowCount() > 0) {
            this.clearSelection();
        }
        nArray3 = sortableTableModel.getIndexes();
        n3 = nArray3.length;
        block3: for (int i = nArray2.length - 1; i >= 0; --i) {
            for (int j = 0; j < n3; ++j) {
                if (nArray3[j] != nArray2[i]) continue;
                this.addRowSelectionInterval(j, j);
                continue block3;
            }
        }
    }

    public void setRowSelectionChange(boolean bl) {
        this.setScrolls(bl);
    }

    public boolean getRowSelectionChange() {
        return this.isScrolls();
    }

    public void setSaveStateChangeListeners(PropertyChangeListener[] propertyChangeListenerArray) {
        if (this.saveAndPrintFile != null) {
            this.saveAndPrintFile.setPrintablePropChangeListeners(propertyChangeListenerArray);
        }
    }

    public void setPrintPreviewColumnWidths(int[] nArray) {
        this.printColumnWidths = nArray;
    }

    public int[] getPrintPreviewColumnWidths() {
        if (this.useActualWidthsForPrint) {
            this.initColWidthFromTable();
        }
        return this.printColumnWidths;
    }

    public void setUseActualWidthsForPrint(boolean bl) {
        this.printColumnWidths = null;
        this.useActualWidthsForPrint = bl;
    }

    public void initColWidthFromTable() {
        int n = this.getColumnCount();
        TableColumnModel tableColumnModel = this.getColumnModel();
        this.printColumnWidths = new int[n];
        TableColumn tableColumn = null;
        for (int i = 0; i < n; ++i) {
            tableColumn = tableColumnModel.getColumn(i);
            this.printColumnWidths[i] = tableColumn.getWidth();
        }
    }

    public void setHtmlPerColWidth(int n) {
        this.htmlPerColWidth = n;
    }

    public static void cleanupWhileOSGIExit() {
        res = null;
    }

    public void setColumnFilterable(Object object, boolean bl) {
        TableColumn tableColumn = this.getColumn(object);
        if (tableColumn != null) {
            this.getSortableTableModel().setColumnFilterable(tableColumn.getModelIndex(), bl);
            this.getTableHeader().repaint();
        }
    }

    public void setMultiValueSelectionEnabled(Object[] objectArray, boolean bl) {
        int[] nArray = new int[objectArray.length];
        TableColumn tableColumn = null;
        Object object = null;
        for (int i = 0; i < objectArray.length; ++i) {
            object = objectArray[i];
            tableColumn = this.getColumn(object);
            nArray[i] = tableColumn != null ? tableColumn.getModelIndex() : -1;
        }
        this.getSortableTableModel().setMultiValueSelectionEnabled(nArray, bl);
    }

    public int getActualRowCount() {
        return this.getSortableTableModel().getActualRowCount();
    }

    public Object getActualValueAt(int n, int n2) {
        return this.getSortableTableModel().getActualValueAt(n, n2);
    }

    public void setActualValueAt(Object object, int n, int n2) {
        this.getSortableTableModel().setActualValueAt(object, n, n2);
    }

    @Override
    protected void constructColInfoDescContainer(DescContainer descContainer, ColumnInformation columnInformation) {
        super.constructColInfoDescContainer(descContainer, columnInformation);
        boolean bl = columnInformation.isColumnSorted();
        boolean bl2 = columnInformation.isDescending();
        descContainer.setParasItem(COLUMN_SORTED, Boolean.toString(bl), true);
        descContainer.setParasItem(IS_DESCENDING, Boolean.toString(bl2), true);
    }

    @Override
    protected ColumnInformation constructColumnInformation(Object object, String string, int n, int n2, int n3, DescContainer descContainer) {
        String string2 = "false";
        String string3 = "false";
        if (null != descContainer) {
            string2 = descContainer.getParasItemValue(COLUMN_SORTED);
            string3 = descContainer.getParasItemValue(IS_DESCENDING);
        }
        return new ColumnInformation(object, string, n, n2, n3, Boolean.parseBoolean(string2), Boolean.parseBoolean(string3));
    }

    void setColumnInformation() {
        Hashtable hashtable = this.getColInfos();
        Collection collection = hashtable.values();
        Iterator iterator = collection.iterator();
        SortableTableModel sortableTableModel = (SortableTableModel)this.getModel();
        int n = sortableTableModel.getSortedColumn();
        if (-1 == (n = this.convertColumnIndexToView(n))) {
            return;
        }
        TableColumn tableColumn = this.getColumnModel().getColumn(n);
        Object object = tableColumn.getIdentifier();
        ColumnInformation columnInformation = (ColumnInformation)hashtable.get(object);
        ColumnInformation columnInformation2 = null;
        boolean bl = iterator.hasNext();
        while (bl) {
            columnInformation2 = (ColumnInformation)iterator.next();
            columnInformation2.setColumnSorted(false);
            bl = iterator.hasNext();
        }
        columnInformation.setColumnSorted(true);
        columnInformation.setDescending(sortableTableModel.sortStateIsDescend());
    }

    @Override
    protected Hashtable getColInfos() {
        return super.getColInfos();
    }

    private static final class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public BooleanRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
            } else if (jTable instanceof ExtendedTable) {
                ExtendedTable extendedTable = (ExtendedTable)jTable;
                if (extendedTable.getModel().isCellEditable(n, jTable.convertColumnIndexToModel(n2))) {
                    this.setBackground(extendedTable.getEditableBackground() != null ? extendedTable.getEditableBackground() : Color.green);
                } else {
                    this.setBackground(extendedTable.getUneditableBackground() != null ? extendedTable.getUneditableBackground() : Color.lightGray);
                }
                if (!extendedTable.getSortableTableModel().isThisCellValided(n, jTable.convertColumnIndexToModel(n2))) {
                    this.setBackground(extendedTable.getInvalidedBackground() != null ? extendedTable.getInvalidedBackground() : jTable.getBackground());
                }
                if (extendedTable.getSortableTableModel().isCellNotSaved(n, jTable.convertColumnIndexToModel(n2))) {
                    this.setBackground(extendedTable.getNotSaveBackground() != null ? extendedTable.getNotSaveBackground() : Color.red);
                }
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            this.setSelected(object != null && (Boolean)object != false);
            return this;
        }
    }

    private static final class IconRenderer
    extends EditableRenderer {
        public IconRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public void setValue(Object object) {
            super.setIcon(object instanceof Icon ? (Icon)object : null);
        }
    }

    private static final class DateRenderer
    extends EditableRenderer {
        private DateFormat formater = null;

        public void setFormatter(DateFormat dateFormat) {
            this.formater = dateFormat;
        }

        public DateFormat getForMatter() {
            return this.formater;
        }

        @Override
        public void setValue(Object object) {
            if (this.formater == null) {
                this.formater = DateFormat.getDateInstance();
            }
            this.setText(object == null ? "" : this.formater.format(object));
        }
    }

    private static final class DoubleRenderer
    extends NumberRenderer {
        private NumberFormat formatter = null;

        @Override
        public void setValue(Object object) {
            if (this.formatter == null) {
                this.formatter = NumberFormat.getInstance();
            }
            this.setText(object == null ? "" : this.formatter.format(object));
        }
    }

    private static class NumberRenderer
    extends EditableRenderer {
        public NumberRenderer() {
            this.setHorizontalAlignment(4);
        }
    }

    private final class PopupListener
    extends MouseAdapter {
        private PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (ExtendedTable.this.changeSelect) {
                ExtendedTable.this.refreshSelect(mouseEvent);
            }
            this.showPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        private void showPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() && ExtendedTable.this.m_oPopMenu != null) {
                ExtendedTable.this.m_oPopMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

