/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.extendedtable;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

class ColumnResizer {
    private static final int MIN_WIDTH = 15;

    ColumnResizer() {
    }

    public static void adjustColumnPreferredWidths(JTable jTable, int n, int n2) {
        if (jTable == null || n < 0 || n > jTable.getColumnCount()) {
            throw new IllegalArgumentException("argument is null or argument is overrun");
        }
        TableColumn tableColumn = jTable.getColumnModel().getColumn(n);
        int n3 = 0;
        switch (n2) {
            case 0: {
                n3 = ColumnResizer.getPreferredWidthForHeader(jTable, n);
                tableColumn.setPreferredWidth(n3 + 15);
                break;
            }
            case 1: {
                n3 = ColumnResizer.getPreferredWidthForContent(jTable, n);
                tableColumn.setPreferredWidth(n3 + 15);
                break;
            }
            case 2: {
                n3 = ColumnResizer.getPreferredWidthForHeaderAndContent(jTable, n);
                tableColumn.setPreferredWidth(n3 + 15);
                break;
            }
            default: {
                return;
            }
        }
    }

    private static int getPreferredWidthForHeader(JTable jTable, int n) {
        TableColumn tableColumn = jTable.getColumnModel().getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
        }
        Object object = tableColumn.getHeaderValue();
        Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, false, false, 0, n);
        return component.getPreferredSize().width;
    }

    private static int getPreferredWidthForContent(JTable jTable, int n) {
        int n2 = 0;
        for (int i = 0; i < jTable.getRowCount(); ++i) {
            TableCellRenderer tableCellRenderer = jTable.getCellRenderer(i, n);
            Object object = jTable.getValueAt(i, n);
            Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, false, false, i, n);
            n2 = Math.max(component.getPreferredSize().width, n2);
        }
        return n2;
    }

    private static int getPreferredWidthForHeaderAndContent(JTable jTable, int n) {
        int n2 = Math.max(ColumnResizer.getPreferredWidthForHeader(jTable, n), ColumnResizer.getPreferredWidthForContent(jTable, n));
        return n2;
    }

    public static TableColumn getResizingColumn(JTable jTable, MouseEvent mouseEvent) {
        if (jTable == null || mouseEvent == null) {
            throw new IllegalArgumentException("argument is null");
        }
        Point point = mouseEvent.getPoint();
        int n = jTable.getTableHeader().columnAtPoint(point);
        if (n == -1) {
            return null;
        }
        JTableHeader jTableHeader = jTable.getTableHeader();
        Rectangle rectangle = jTableHeader.getHeaderRect(n);
        rectangle.grow(-3, 0);
        if (rectangle.contains(point)) {
            return null;
        }
        int n2 = rectangle.x + rectangle.width / 2;
        int n3 = 0;
        if (jTableHeader.getComponentOrientation().isLeftToRight()) {
            n3 = point.x < n2 ? n - 1 : n;
        } else {
            int n4 = n3 = point.x < n2 ? n : n - 1;
        }
        if (n3 == -1) {
            return null;
        }
        return jTableHeader.getColumnModel().getColumn(n3);
    }

    public static boolean canResize(JTable jTable, TableColumn tableColumn) {
        JTableHeader jTableHeader = jTable.getTableHeader();
        return tableColumn != null && jTableHeader.getResizingAllowed() && tableColumn.getResizable();
    }

    public static void updateMouseCursor(JTable jTable, MouseEvent mouseEvent) {
        if (jTable == null || mouseEvent == null) {
            throw new IllegalArgumentException("argument is null");
        }
        JTableHeader jTableHeader = jTable.getTableHeader();
        MouseMotionListener[] mouseMotionListenerArray = jTableHeader.getMouseMotionListeners();
        if (mouseMotionListenerArray != null) {
            int n = mouseMotionListenerArray.length;
            for (int i = 0; i < n; ++i) {
                mouseMotionListenerArray[i].mouseMoved(mouseEvent);
            }
        }
    }
}

