/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.extendedtable;

import com.swimap.iview.templates.extendedtable.ColorTableCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;

public class ColorTableCellEditor
extends ColorTableCellRenderer
implements TableCellEditor {
    protected int clickCountToStart = 2;
    private JColorChooser colorChooser = null;
    private JDialog colorDialog = null;
    private EventListenerList listenerList = new EventListenerList();
    private ChangeEvent event = new ChangeEvent(this);
    private Color defaultColor = Color.white;

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        if (null == this.colorChooser) {
            this.init();
        }
        this.colorChooser.setColor((Color)object);
        this.defaultColor = (Color)object;
        return this.getTableCellRendererComponent(jTable, object, bl, true, n, n2);
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        if (null == this.colorDialog) {
            this.init();
        }
        this.colorDialog.setVisible(true);
        return true;
    }

    @Override
    public void cancelCellEditing() {
        if (null == this.colorDialog) {
            return;
        }
        this.colorDialog.setVisible(false);
    }

    @Override
    public boolean stopCellEditing() {
        if (null == this.colorDialog) {
            return true;
        }
        this.colorDialog.setVisible(false);
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        if (null == this.colorChooser) {
            return this.defaultColor;
        }
        return this.colorChooser.getColor();
    }

    @Override
    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.add(CellEditorListener.class, cellEditorListener);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.remove(CellEditorListener.class, cellEditorListener);
    }

    protected void fireEditingStopped() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            ((CellEditorListener)objectArray[i + 1]).editingStopped(this.event);
        }
    }

    protected void fireEditingCanceled() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            ((CellEditorListener)objectArray[i + 1]).editingCanceled(this.event);
        }
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            return ((MouseEvent)eventObject).getClickCount() >= this.clickCountToStart;
        }
        return true;
    }

    public void setClickCountToStart(int n) {
        this.clickCountToStart = n;
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    private void init() {
        this.colorChooser = new JColorChooser();
        this.colorDialog = JColorChooser.createDialog(null, "Planet Color", false, this.colorChooser, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColorTableCellEditor.this.fireEditingStopped();
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColorTableCellEditor.this.fireEditingCanceled();
            }
        });
    }
}

