/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.extendedtable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.UIManager;

public class BevelArrowIcon
implements Icon {
    public static final int NONE = 0;
    public static final int DOWN = 1;
    public static final int UP = 2;
    private static final int DEFAULT_SIZE = 11;
    private Color edge1Color = null;
    private Color edge2Color = null;
    private Color fillColor = null;
    private int size = 0;
    private int direction = 0;

    public BevelArrowIcon(int n, boolean bl, boolean bl2) {
        Color color = null;
        Color color2 = null;
        if (bl) {
            if (bl2) {
                color = UIManager.getColor("controlLtHighlight");
                color2 = UIManager.getColor("controlDkShadow");
            } else {
                color = UIManager.getColor("controlHighlight");
                color2 = UIManager.getColor("controlShadow");
            }
        } else if (bl2) {
            color = UIManager.getColor("controlDkShadow");
            color2 = UIManager.getColor("controlLtHighlight");
        } else {
            color = UIManager.getColor("controlShadow");
            color2 = UIManager.getColor("controlHighlight");
        }
        this.init(color, color2, Color.cyan, 11, n);
    }

    public BevelArrowIcon(Color color, Color color2, Color color3, int n, int n2) {
        this.init(color, color2, color3, n, n2);
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        switch (this.direction) {
            case 0: {
                this.drawNoneArrow(graphics, n, n2);
                break;
            }
            case 1: {
                this.drawDownArrow(graphics, n, n2);
                break;
            }
            case 2: {
                this.drawUpArrow(graphics, n, n2);
                break;
            }
        }
    }

    @Override
    public int getIconWidth() {
        return this.size;
    }

    @Override
    public int getIconHeight() {
        return this.size;
    }

    private void init(Color color, Color color2, Color color3, int n, int n2) {
        this.edge1Color = color;
        this.edge2Color = color2;
        this.fillColor = color3;
        this.size = n;
        this.direction = n2;
    }

    private void drawUpArrow(Graphics graphics, int n, int n2) {
        graphics.setColor(this.edge1Color);
        int n3 = n + this.size / 2;
        graphics.drawLine(n3, n2, n3, n2);
        --n3;
        int n4 = n2 + 1;
        int n5 = 0;
        while (n4 + 3 < n2 + this.size) {
            graphics.setColor(this.edge1Color);
            graphics.drawLine(n3, n4, n3 + 1, n4);
            graphics.drawLine(n3, n4 + 1, n3 + 1, n4 + 1);
            if (0 < n5) {
                graphics.setColor(this.fillColor);
                graphics.drawLine(n3 + 2, n4, n3 + 1 + n5, n4);
                graphics.drawLine(n3 + 2, n4 + 1, n3 + 1 + n5, n4 + 1);
            }
            graphics.setColor(this.edge2Color);
            graphics.drawLine(n3 + n5 + 2, n4, n3 + n5 + 3, n4);
            graphics.drawLine(n3 + n5 + 2, n4 + 1, n3 + n5 + 3, n4 + 1);
            --n3;
            n4 += 2;
            n5 += 2;
        }
        graphics.setColor(this.edge1Color);
        graphics.drawLine(n, n2 + this.size - 3, n + 1, n2 + this.size - 3);
        graphics.setColor(this.edge2Color);
        graphics.drawLine(n + 2, n2 + this.size - 2, n + this.size - 1, n2 + this.size - 2);
        graphics.drawLine(n, n2 + this.size - 1, n + this.size, n2 + this.size - 1);
    }

    private void drawNoneArrow(Graphics graphics, int n, int n2) {
        graphics.setColor(Color.white);
        int[] nArray = new int[]{n + this.size / 2, n, n + this.size};
        int[] nArray2 = new int[]{n2, n2 + this.size, n2 + this.size};
        graphics.fillPolygon(nArray, nArray2, 3);
    }

    private void drawDownArrow(Graphics graphics, int n, int n2) {
        graphics.setColor(this.edge1Color);
        graphics.drawLine(n, n2, n + this.size - 1, n2);
        graphics.drawLine(n, n2 + 1, n + this.size - 3, n2 + 1);
        graphics.setColor(this.edge2Color);
        graphics.drawLine(n + this.size - 2, n2 + 1, n + this.size - 1, n2 + 1);
        int n3 = n + 1;
        int n4 = n2 + 2;
        int n5 = this.size - 6;
        while (n4 + 1 < n2 + this.size) {
            graphics.setColor(this.edge1Color);
            graphics.drawLine(n3, n4, n3 + 1, n4);
            graphics.drawLine(n3, n4 + 1, n3 + 1, n4 + 1);
            if (0 < n5) {
                graphics.setColor(this.fillColor);
                graphics.drawLine(n3 + 2, n4, n3 + 1 + n5, n4);
                graphics.drawLine(n3 + 2, n4 + 1, n3 + 1 + n5, n4 + 1);
            }
            graphics.setColor(this.edge2Color);
            graphics.drawLine(n3 + n5 + 2, n4, n3 + n5 + 3, n4);
            graphics.drawLine(n3 + n5 + 2, n4 + 1, n3 + n5 + 3, n4 + 1);
            ++n3;
            n4 += 2;
            n5 -= 2;
        }
        graphics.setColor(this.edge1Color);
        graphics.drawLine(n + this.size / 2, n2 + this.size - 1, n + this.size / 2, n2 + this.size - 1);
    }
}

