/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.devicepanel.view;

import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.resource.i18n.UnicodeInputStream;
import com.swimap.iview.templates.devicepanel.model.ConfigureUtilities;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.log.IviewLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;

public class ResPropertiesBundle {
    private static IviewLogger logger = IviewLogger.getLogger(ResPropertiesBundle.class, "IVIEW");
    private Properties resProperties = null;
    private static String fileEncoding = "";
    private static String productDirResFile = null;
    private static ResPropertiesBundle m_instance = null;
    private static String resPropertiesFile = null;
    private static String productResFile = null;

    private ResPropertiesBundle() {
        this.init();
    }

    public static synchronized ResPropertiesBundle getInstance() {
        if (m_instance == null) {
            m_instance = new ResPropertiesBundle();
        }
        return m_instance;
    }

    private void init() {
        this.resProperties = this.getProperties(resPropertiesFile);
        Properties properties = this.getProperties(productDirResFile);
        Properties properties2 = this.getProperties(productResFile);
        if (properties != null) {
            if (this.resProperties == null) {
                this.resProperties = new Properties();
            }
            this.propertiesMerge(this.resProperties, properties);
        }
        if (properties2 != null) {
            if (this.resProperties == null) {
                this.resProperties = new Properties();
            }
            this.propertiesMerge(this.resProperties, properties2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getProperties(String string) {
        Properties properties = new Properties();
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        if (string == null) {
            logger.warn(" Res Properties file path is null.");
            return null;
        }
        try {
            Object object;
            if (!new File(string).exists()) {
                logger.warn(" Res Properties file" + string + " is not exists and load it from the jar file.");
                object = CommStyleManager.getURLFromJar(string);
                if (null == object) {
                    Properties properties2 = null;
                    return properties2;
                }
                inputStream = ((URL)object).openStream();
            } else {
                inputStream = new FileInputStream(CommonUtil.getAbsolutePath(string));
            }
            object = new UnicodeInputStream(inputStream, null);
            String string2 = ((UnicodeInputStream)object).getEncoding();
            if (null == string2) {
                fileEncoding = ConfigureUtilities.CLIENT_ENCODING;
                inputStreamReader = new InputStreamReader((InputStream)object, fileEncoding);
            } else {
                inputStreamReader = new InputStreamReader((InputStream)object, string2);
            }
            properties.load(inputStreamReader);
        }
        catch (IOException iOException) {
            logger.warn("IOException occurs when load Properties File " + string + ". The detail exception is: ");
            logger.trace(iOException.getMessage(), iOException);
        }
        catch (Exception exception) {
            logger.warn("Exception occurs when load Properties File " + string + ".The detail exception is: ");
            logger.trace(exception.getMessage(), exception);
        }
        finally {
            if (null != inputStreamReader) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException iOException) {
                    logger.warn("IOException occurs when close reader " + iOException);
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    logger.warn("IOException occurs when close Properties File, .The detail exception is: ");
                    logger.trace(iOException.getMessage(), iOException);
                }
                catch (Exception exception) {
                    logger.warn("Exception occurs when close Properties File, .The detail exception is: ");
                    logger.trace(exception.getMessage(), exception);
                }
            }
        }
        return properties;
    }

    private void propertiesMerge(Properties properties, Properties properties2) {
        if (properties == null || properties2 == null) {
            return;
        }
        Enumeration<?> enumeration = properties2.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            properties.setProperty(string, properties2.getProperty(string));
        }
    }

    public static void setProductResFile(String string) {
        productResFile = string;
    }

    public static String getProductResFile() {
        return productResFile;
    }

    public static void setProductDirResFile(String string) {
        productDirResFile = string;
    }

    public static String getProductDirResFile() {
        return productDirResFile;
    }

    public static void setResPropertiesFile(String string) {
        resPropertiesFile = string;
    }

    public String getResPropertiesFile() {
        return resPropertiesFile;
    }

    public String getString(String string) {
        if (this.resProperties != null && this.resProperties.containsKey(string)) {
            try {
                if (fileEncoding.equals("")) {
                    fileEncoding = ConfigureUtilities.CLIENT_ENCODING;
                }
                return new String(this.resProperties.getProperty(string).getBytes(fileEncoding));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                logger.warn("UnsupportedEncodingException occurs when get the " + string + "'s value. The detail exception is: ");
                logger.trace(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
                return this.resProperties.getProperty(string);
            }
            catch (Exception exception) {
                logger.warn("Exception occurs when get the " + string + "'s value. The detail exception is: ");
                logger.trace(exception.getMessage(), exception);
                return this.resProperties.getProperty(string);
            }
        }
        logger.warn("Can't find the" + string);
        return string;
    }
}

