/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.devicepanel.view;

import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.templates.devicepanel.model.DevicePanelTreeModel;
import com.swimap.iview.templates.devicepanel.model.ModelChangeListener;
import com.swimap.iview.templates.devicepanel.model.PopupMenuResponseObjectPair;
import com.swimap.iview.templates.devicepanel.model.component.BuckledCard;
import com.swimap.iview.templates.devicepanel.model.component.Card;
import com.swimap.iview.templates.devicepanel.model.component.DevicePanelComponent;
import com.swimap.iview.templates.devicepanel.model.component.DevicePanelItem;
import com.swimap.iview.templates.devicepanel.model.component.EmptyComponent;
import com.swimap.iview.templates.devicepanel.model.component.EnvironmentItem;
import com.swimap.iview.templates.devicepanel.model.component.FansEnvironmentItem;
import com.swimap.iview.templates.devicepanel.model.component.Shelf;
import com.swimap.iview.templates.devicepanel.model.component.TemperatureEnvironmentItem;
import com.swimap.iview.templates.devicepanel.view.ClickableEx;
import com.swimap.iview.templates.devicepanel.view.DevicePanel;
import com.swimap.iview.templates.devicepanel.view.DrawingPanel;
import com.swimap.iview.templates.devicepanel.view.EmulationalDevicePanel;
import com.swimap.iview.templates.devicepanel.view.EmulationalShelfDialog;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

class LmtEmulationalDrawingPanel
extends DrawingPanel {
    private static IviewLogger logger = IviewLogger.getLogger(LmtEmulationalDrawingPanel.class, "IVIEW");
    Shelf shelf = null;
    DevicePanelTreeModel emuModel = null;
    private ModelChangeHandler modelChangeHandler = new ModelChangeHandler();

    void setEmuModel(DevicePanelTreeModel devicePanelTreeModel) {
        this.emuModel = devicePanelTreeModel;
        if (devicePanelTreeModel != null) {
            devicePanelTreeModel.addModelChangeListener(this.modelChangeHandler);
        }
    }

    LmtEmulationalDrawingPanel(Shelf shelf, final DevicePanel devicePanel) {
        super(shelf, devicePanel);
        this.shelf = shelf;
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27 && devicePanel != null) {
                    devicePanel.getEmulationalDialog().dispose();
                }
            }
        });
    }

    @Override
    protected void keepOneSelected() {
        if (this.devicePanel.getEmulationalDevicePanel().getFacilityDrawingPanel().selectedComponent != null) {
            Graphics2D graphics2D = this.devicePanel.getEmulationalDevicePanel().getFacilityDrawingPanel().getDrawingGraphics();
            this.devicePanel.getEmulationalDevicePanel().getFacilityDrawingPanel().selectedComponent.draw(graphics2D);
            this.devicePanel.getEmulationalDevicePanel().getFacilityDrawingPanel().selectedComponent = null;
            this.devicePanel.getEmulationalDevicePanel().getFacilityDrawingPanel().repaint();
            graphics2D.dispose();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        if (this.devicePanel.getEmulationalDialog().isVisible()) {
            this.keepOneSelected();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.currentComponent = this.container.matchCurrentComponent(n, n2);
        if (this.currentComponent == null) {
            return;
        }
        if (!this.currentComponent.isSelectable()) {
            return;
        }
        Graphics2D graphics2D = this.getDrawingGraphics();
        if (this.selectedComponent != null && this.selectedComponent != this.currentComponent && this.selectedComponent.isInCurrentPage()) {
            this.selectedComponent.draw(graphics2D);
        }
        if (this.currentComponent instanceof FansEnvironmentItem) {
            FansEnvironmentItem fansEnvironmentItem = (FansEnvironmentItem)this.currentComponent;
            if (fansEnvironmentItem.isInArea(mouseEvent.getX(), mouseEvent.getY())) {
                this.progressSelectedComponent(graphics2D);
            } else {
                DevicePanelComponent devicePanelComponent;
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)fansEnvironmentItem.getRelatedTreeNode().getParent();
                this.selectedComponent = devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
                this.selectedComponent.setIsSelected(true);
                this.selectedComponent.selectedShapedDraw(graphics2D);
            }
        } else {
            this.progressSelectedComponent(graphics2D);
        }
        graphics2D.dispose();
        if (this.devicePanel.getEmulationalDialog().isVisible()) {
            this.keepOneSelected();
        }
        this.repaint();
        if (this.devicePanel.getClickable() != null && this.selectedComponent != null && mouseEvent.getClickCount() == 1 && this.devicePanel.getClickable() != null) {
            try {
                this.devicePanel.getClickable().click(this.selectedComponent);
                if (this.devicePanel.getClickable() instanceof ClickableEx) {
                    ((ClickableEx)this.devicePanel.getClickable()).click(this.currentComponent, mouseEvent);
                }
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
        }
        if (SwingUtilities.isRightMouseButton(mouseEvent) && mouseEvent.getClickCount() == 1 && this.currentComponent != null && this.currentComponent.isPopupMenuAllowed(mouseEvent.getX(), mouseEvent.getY())) {
            this.showPopupMenu(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    protected void showPopupMenu(int n, int n2) {
        if (this.getEmuModel() == null) {
            return;
        }
        PopupMenuResponseObjectPair popupMenuResponseObjectPair = this.getEmuModel().getConfigureUtilities().getPopupMenuResponseObjectPair(this.selectedComponent.getPopupMenuReferrenceName());
        if (popupMenuResponseObjectPair != null) {
            if (this.devicePanel.getPopupMenuAuthorization() != null) {
                this.currentPopupMenu = this.devicePanel.getPopupMenuAuthorization().authorizePopupMenu(popupMenuResponseObjectPair.getPopupMenu(this.currentComponent), popupMenuResponseObjectPair.getActionListener(), this.selectedComponent);
            }
            if (this.devicePanel.getPopupMenuAuthorization() == null) {
                this.currentPopupMenu = popupMenuResponseObjectPair.getPopupMenu(this.currentComponent);
            }
        } else if (this.devicePanel.getPopupMenuAuthorization() != null) {
            this.currentPopupMenu = this.devicePanel.getPopupMenuAuthorization().authorizePopupMenu(null, null, this.selectedComponent);
        }
        if (this.currentPopupMenu != null) {
            this.currentPopupMenu.show(this, n, n2);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        super.mouseClicked(mouseEvent);
        this.currentComponent = this.container.matchCurrentComponent(mouseEvent.getX(), mouseEvent.getY());
        if (mouseEvent.getModifiers() == 16 && this.currentComponent != null && mouseEvent.getClickCount() % 2 == 0 && this.currentComponent instanceof Shelf) {
            this.switchFrontBack();
        }
    }

    private synchronized void switchFrontBack() {
        if (this.shelf.getRelatedTreeNode().getChildCount() > this.shelf.getFrontChildCount()) {
            this.shelf.setBehindEnabled(!this.shelf.getBehindEnabled());
            logger.debug("the shelf is behind panel ? " + this.shelf.getBehindEnabled());
            Graphics2D graphics2D = this.getDrawingGraphics();
            this.shelf.draw(graphics2D);
            this.shelf.setIsSelected(true);
            this.shelf.selectedShapedDraw(graphics2D);
            graphics2D.dispose();
            this.repaint();
            this.devicePanel.updateEmulationalDialogTitle();
        }
    }

    @Override
    void endTask() {
        super.endTask();
        this.clear();
        this.modelChangeHandler = null;
    }

    void clear() {
        if (this.emuModel != null) {
            this.emuModel.removeModelChangeListener(this.modelChangeHandler);
            this.emuModel = null;
        }
        this.shelf = null;
        this.container = null;
    }

    Shelf getShelf() {
        return this.shelf;
    }

    DevicePanelTreeModel getEmuModel() {
        return this.emuModel;
    }

    public Shelf getOwnerShelf(DevicePanelComponent devicePanelComponent) {
        DefaultMutableTreeNode defaultMutableTreeNode = devicePanelComponent.getRelatedTreeNode();
        TreeNode[] treeNodeArray = this.getEmuModel().getPathToRoot(defaultMutableTreeNode);
        if (treeNodeArray == null || treeNodeArray.length <= 2) {
            for (int i = 0; treeNodeArray != null && i < treeNodeArray.length; ++i) {
                logger.debug("don't get shelf in path" + treeNodeArray[i]);
            }
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treeNodeArray[2];
        if (defaultMutableTreeNode2.getUserObject() instanceof Shelf) {
            return (Shelf)defaultMutableTreeNode2.getUserObject();
        }
        for (int i = 0; i < treeNodeArray.length; ++i) {
            logger.debug("don't get shelf in path:" + treeNodeArray[i]);
        }
        return null;
    }

    private synchronized DrawingPanel processComponentAddedRemovedEvent(DevicePanelComponent devicePanelComponent) {
        Graphics2D graphics2D = this.getDrawingGraphics();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)devicePanelComponent.getRelatedTreeNode().getParent();
        DevicePanelComponent devicePanelComponent2 = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
        if (this.getOwnerShelf(devicePanelComponent) != this.shelf) {
            graphics2D.dispose();
            return this;
        }
        if (!this.shelf.getBehindEnabled()) {
            if (devicePanelComponent2 instanceof BuckledCard && devicePanelComponent2.getParent().getIndexInNotCompose() < this.shelf.getFrontChildCount()) {
                devicePanelComponent2.draw(graphics2D);
            } else if ((devicePanelComponent instanceof Card || devicePanelComponent instanceof EnvironmentItem) && devicePanelComponent.getIndexInNotCompose() < this.shelf.getFrontChildCount()) {
                devicePanelComponent2.draw(graphics2D);
            } else if (devicePanelComponent instanceof EmptyComponent && devicePanelComponent.getIndexInNotCompose() < this.shelf.getFrontChildCount()) {
                devicePanelComponent2.draw(graphics2D);
            } else if (devicePanelComponent2 instanceof Card && devicePanelComponent2.getIndexInNotCompose() < this.shelf.getFrontChildCount()) {
                devicePanelComponent2.draw(graphics2D);
            }
        } else if (this.shelf.getBehindEnabled()) {
            if (devicePanelComponent2 instanceof BuckledCard && devicePanelComponent2.getParent().getIndexInNotCompose() >= this.shelf.getFrontChildCount()) {
                devicePanelComponent2.draw(graphics2D);
            } else if ((devicePanelComponent instanceof Card || devicePanelComponent instanceof EnvironmentItem) && devicePanelComponent.getIndexInNotCompose() >= this.shelf.getFrontChildCount()) {
                devicePanelComponent2.draw(graphics2D);
            } else if (devicePanelComponent instanceof EmptyComponent && devicePanelComponent.getIndexInNotCompose() >= this.shelf.getFrontChildCount()) {
                devicePanelComponent2.draw(graphics2D);
            } else if (devicePanelComponent2 instanceof Card && devicePanelComponent2.getIndexInNotCompose() >= this.shelf.getFrontChildCount()) {
                devicePanelComponent2.draw(graphics2D);
            }
        }
        graphics2D.dispose();
        return this;
    }

    private void processStateTemperatureChangedEvent(DevicePanelItem[] devicePanelItemArray) {
        for (int i = 0; i < devicePanelItemArray.length; ++i) {
            if (this.shelf == null) {
                return;
            }
            if (devicePanelItemArray[i] instanceof TemperatureEnvironmentItem) {
                ((TemperatureEnvironmentItem)devicePanelItemArray[i]).setTemperatureModel(this.devicePanel.getTemperatureModel());
            }
            Graphics2D graphics2D = this.getDrawingGraphics();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)devicePanelItemArray[i].getRelatedTreeNode().getParent();
            DevicePanelComponent devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
            if (!(devicePanelComponent instanceof Shelf) || !ResourceUtil.areEquals(devicePanelComponent.getID(), this.shelf.getID()) || this.shelf.getBehindEnabled() != devicePanelItemArray[i].getBehindEnabled() || !(devicePanelItemArray[i] instanceof TemperatureEnvironmentItem)) continue;
            devicePanelItemArray[i].draw(graphics2D);
            graphics2D.dispose();
        }
        this.repaint();
    }

    private synchronized void processStateAlarmChangedEvent(DevicePanelItem[] devicePanelItemArray) {
        if (this.devicePanel.getEmulationalDevicePanel() == null || this.devicePanel.getEmulationalDevicePanel().getDrawingPanel() == null) {
            logger.debug("getEmulationalShelfDialog is null");
            return;
        }
        Graphics2D graphics2D = this.devicePanel.getEmulationalDevicePanel().getDrawingPanel().getDrawingGraphics();
        for (int i = 0; i < devicePanelItemArray.length; ++i) {
            if (this.shelf == null) {
                graphics2D.dispose();
                return;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)devicePanelItemArray[i].getRelatedTreeNode().getParent();
            DevicePanelComponent devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
            if (this.getOwnerShelf(devicePanelItemArray[i]) != this.shelf) {
                graphics2D.dispose();
                continue;
            }
            if (!this.shelf.getBehindEnabled()) {
                if (devicePanelComponent instanceof BuckledCard && devicePanelComponent.getParent().getIndexInNotCompose() < this.shelf.getFrontChildCount()) {
                    devicePanelItemArray[i].draw(graphics2D);
                } else if ((devicePanelItemArray[i] instanceof Card || devicePanelItemArray[i] instanceof EnvironmentItem) && devicePanelItemArray[i].getIndexInNotCompose() < this.shelf.getFrontChildCount()) {
                    devicePanelItemArray[i].draw(graphics2D);
                } else if (devicePanelItemArray[i] instanceof EmptyComponent && devicePanelItemArray[i].getIndexInNotCompose() < this.shelf.getFrontChildCount()) {
                    devicePanelItemArray[i].draw(graphics2D);
                } else if (devicePanelComponent instanceof Card && devicePanelComponent.getIndexInNotCompose() < this.shelf.getFrontChildCount()) {
                    devicePanelItemArray[i].draw(graphics2D);
                }
            } else if (this.shelf.getBehindEnabled()) {
                if (devicePanelComponent instanceof BuckledCard && devicePanelComponent.getParent().getIndexInNotCompose() >= this.shelf.getFrontChildCount()) {
                    devicePanelItemArray[i].draw(graphics2D);
                } else if ((devicePanelItemArray[i] instanceof Card || devicePanelItemArray[i] instanceof EnvironmentItem) && devicePanelItemArray[i].getIndexInNotCompose() >= this.shelf.getFrontChildCount()) {
                    devicePanelItemArray[i].draw(graphics2D);
                } else if (devicePanelItemArray[i] instanceof EmptyComponent && devicePanelItemArray[i].getIndexInNotCompose() >= this.shelf.getFrontChildCount()) {
                    devicePanelItemArray[i].draw(graphics2D);
                } else if (devicePanelComponent instanceof Card && devicePanelComponent.getIndexInNotCompose() >= this.shelf.getFrontChildCount()) {
                    devicePanelItemArray[i].draw(graphics2D);
                }
            }
            if (this.selectedComponent == null || this.selectedComponent instanceof Shelf) continue;
            this.selectedComponent.setIsSelected(true);
            this.selectedComponent.selectedShapedDraw(graphics2D);
        }
        this.repaint();
        graphics2D.dispose();
    }

    private void processUserIconUpdated(DevicePanelItem[] devicePanelItemArray) {
        EmulationalDevicePanel emulationalDevicePanel = this.devicePanel.getEmulationalDevicePanel();
        if (null == emulationalDevicePanel || null == emulationalDevicePanel.getDrawingPanel()) {
            logger.trace("getEmulationalShelfDialog is null");
            return;
        }
        Graphics2D graphics2D = emulationalDevicePanel.getDrawingPanel().getDrawingGraphics();
        if (null == graphics2D) {
            return;
        }
        for (int i = 0; i < devicePanelItemArray.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)devicePanelItemArray[i].getRelatedTreeNode().getParent();
            DevicePanelComponent devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
            if (!(devicePanelItemArray[i] instanceof Card)) continue;
            devicePanelComponent.draw(graphics2D);
        }
        this.repaint();
        graphics2D.dispose();
    }

    class ModelChangeHandler
    implements ModelChangeListener {
        ModelChangeHandler() {
        }

        @Override
        public void stateChanged(DevicePanelItem[] devicePanelItemArray) {
            LmtEmulationalDrawingPanel.this.processStateAlarmChangedEvent(devicePanelItemArray);
        }

        @Override
        public void alarmChanged(DevicePanelItem[] devicePanelItemArray) {
            LmtEmulationalDrawingPanel.this.processStateAlarmChangedEvent(devicePanelItemArray);
        }

        @Override
        public void alarmColorChanged() {
            LmtEmulationalDrawingPanel.this.getContainer().draw(LmtEmulationalDrawingPanel.this.getDrawingGraphics());
            LmtEmulationalDrawingPanel.this.repaint();
        }

        @Override
        public void stateColorChanged(int[] nArray) {
            for (int i = 0; i < nArray.length; ++i) {
                LmtEmulationalDrawingPanel.this.getContainer().updateUtilities(nArray[i]);
            }
            LmtEmulationalDrawingPanel.this.getContainer().draw(LmtEmulationalDrawingPanel.this.getDrawingGraphics());
            LmtEmulationalDrawingPanel.this.repaint();
        }

        @Override
        public void modelChanged() {
            LmtEmulationalDrawingPanel.this.getContainer().draw(LmtEmulationalDrawingPanel.this.getDrawingGraphics());
            LmtEmulationalDrawingPanel.this.repaint();
        }

        @Override
        public void progressChanged(DevicePanelItem[] devicePanelItemArray) {
        }

        @Override
        public void temperatureChanged(DevicePanelItem[] devicePanelItemArray) {
            LmtEmulationalDrawingPanel.this.processStateTemperatureChangedEvent(devicePanelItemArray);
        }

        @Override
        public void userIconsAdded(DevicePanelItem[] devicePanelItemArray) {
            LmtEmulationalDrawingPanel.this.processUserIconUpdated(devicePanelItemArray);
            LmtEmulationalDrawingPanel.this.repaint();
        }

        @Override
        public void userIconsRemoved(DevicePanelItem[] devicePanelItemArray) {
            LmtEmulationalDrawingPanel.this.processUserIconUpdated(devicePanelItemArray);
            LmtEmulationalDrawingPanel.this.repaint();
        }

        @Override
        public void componentVisibiltyChanged(DevicePanelComponent devicePanelComponent) {
        }

        @Override
        public void componentAdded(DevicePanelComponent devicePanelComponent, EmptyComponent emptyComponent) {
            DrawingPanel drawingPanel = LmtEmulationalDrawingPanel.this.processComponentAddedRemovedEvent(devicePanelComponent);
            if (drawingPanel != null) {
                DevicePanelComponent devicePanelComponent2;
                Graphics2D graphics2D;
                if (drawingPanel.getSelectedComponent() == emptyComponent) {
                    graphics2D = drawingPanel.getDrawingGraphics();
                    if (devicePanelComponent.isSelectable()) {
                        drawingPanel.setSelectedComponent(devicePanelComponent);
                        devicePanelComponent.setIsSelected(true);
                        devicePanelComponent.selectedShapedDraw(graphics2D);
                    } else {
                        devicePanelComponent2 = devicePanelComponent.getSelectableParentComponent();
                        if (devicePanelComponent2 == devicePanelComponent) {
                            drawingPanel.setSelectedComponent(null);
                        } else {
                            drawingPanel.setSelectedComponent(devicePanelComponent2);
                            devicePanelComponent2.setIsSelected(true);
                            devicePanelComponent2.selectedShapedDraw(graphics2D);
                        }
                    }
                    graphics2D.dispose();
                }
                if (drawingPanel.selectedComponent instanceof EmptyComponent) {
                    graphics2D = drawingPanel.getDrawingGraphics();
                    drawingPanel.currentComponent = drawingPanel.selectedComponent.getNextComponent();
                    if (drawingPanel.currentComponent != null && drawingPanel.currentComponent instanceof Card && ((Card)(devicePanelComponent2 = (Card)drawingPanel.currentComponent)).getOccupiedTwoSlots()) {
                        drawingPanel.selectedComponent.draw(graphics2D);
                        drawingPanel.selectedComponent = devicePanelComponent2;
                        drawingPanel.selectedComponent.selectedShapedDraw(graphics2D);
                    }
                    graphics2D.dispose();
                }
                LmtEmulationalDrawingPanel.this.repaint();
                if (LmtEmulationalDrawingPanel.this.devicePanel.isParentActivated()) {
                    drawingPanel.grabFocus();
                }
            }
        }

        @Override
        public void componentRemoved(DevicePanelComponent devicePanelComponent, EmptyComponent emptyComponent) {
            Object object;
            DrawingPanel drawingPanel = LmtEmulationalDrawingPanel.this.processComponentAddedRemovedEvent(emptyComponent);
            if (ResourceUtil.areEquals(LmtEmulationalDrawingPanel.this.shelf.getID(), devicePanelComponent.getID()) && ((Window)(object = LmtEmulationalDrawingPanel.this.devicePanel.getEmulationalDialog())).isShowing()) {
                ((EmulationalShelfDialog)object).dispose();
            }
            if (drawingPanel != null) {
                if (drawingPanel.getSelectedComponent() == devicePanelComponent) {
                    object = drawingPanel.getDrawingGraphics();
                    if (emptyComponent.isSelectable() && emptyComponent.isVisibleAllowed()) {
                        drawingPanel.setSelectedComponent(emptyComponent);
                        emptyComponent.setIsSelected(true);
                        emptyComponent.selectedShapedDraw((Graphics2D)object);
                    } else {
                        DevicePanelComponent devicePanelComponent2 = emptyComponent.getSelectableParentComponent();
                        if (devicePanelComponent2 == emptyComponent) {
                            drawingPanel.setSelectedComponent(null);
                        } else {
                            drawingPanel.setSelectedComponent(devicePanelComponent2);
                            devicePanelComponent2.setIsSelected(true);
                            devicePanelComponent2.selectedShapedDraw((Graphics2D)object);
                        }
                    }
                    ((Graphics)object).dispose();
                }
                if (drawingPanel.getSelectedComponent() != null) {
                    object = drawingPanel.getSelectedComponent().getRelatedTreeNode();
                    if (object == null) {
                        drawingPanel.setSelectedComponent(null);
                    } else {
                        emptyComponent.setIsSelected(true);
                        emptyComponent.selectedShapedDraw(drawingPanel.getDrawingGraphics());
                    }
                }
                drawingPanel.repaint();
                if (LmtEmulationalDrawingPanel.this.devicePanel.isParentActivated()) {
                    drawingPanel.grabFocus();
                }
            }
        }
    }
}

