/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.devicepanel.view;

import com.swimap.iview.templates.devicepanel.DevicePanelUtil;
import com.swimap.iview.templates.devicepanel.model.AlarmObject;
import com.swimap.iview.templates.devicepanel.model.StateObject;
import com.swimap.iview.templates.devicepanel.view.CellEditionNotEnabledTableModel;
import com.swimap.iview.templates.devicepanel.view.DevicePanel;
import com.swimap.iview.templates.devicepanel.view.LegendCellRenderer;
import com.swimap.iview.templates.devicepanel.view.ResPropertiesBundle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;

public class LegendPanel
extends JPanel {
    private static final int VALUE_PREFER_WIDTH = 130;
    private static final int NAME_PREFER_WIDTH = 70;
    private static final int LEGEND_TABLE_ROW_HEIGHT = 30;
    private static final int LEGEND_MAX_SIZE = 2000;
    private static final int FONT_SIZE = 12;
    private ResPropertiesBundle res = ResPropertiesBundle.getInstance();
    protected static final int LEGEND_WIDTH = 200;
    private JTable legendTable = new JTable();
    private JTabbedPane legendTabbedPane = new JTabbedPane();
    static boolean isVisibleAllowed = true;
    private DevicePanel devicePanel = null;

    public LegendPanel(DevicePanel devicePanel) {
        this.devicePanel = devicePanel;
        this.init(this.devicePanel);
    }

    private void init(DevicePanel devicePanel) {
        this.refreshLegendPanel();
        this.legendTabbedPane.setFont(new Font("Dialog", 0, 12));
        this.legendTabbedPane.setName("LegendPanel_legendTabbedPane");
        JScrollPane jScrollPane = new JScrollPane(this.legendTable, 20, 30);
        jScrollPane.setName("LegendPanel_legendScrollPane");
        this.legendTable.setName("LegendPanel_legendTable");
        this.legendTabbedPane.addTab(this.res.getString("Legend"), jScrollPane);
        this.setLayout(new BorderLayout());
        this.add((Component)this.legendTabbedPane, "Center");
        Dimension dimension = devicePanel.getModel().getConfigureUtilities().getPanelSize();
        Dimension dimension2 = new Dimension(200, dimension.height);
        this.setPreferredSize(dimension2);
        this.setMaximumSize(new Dimension(dimension2.width, 2000));
        this.setMinimumSize(new Dimension(dimension2.width, 0));
    }

    public void refreshLegendPanel() {
        int n;
        Object[] objectArray = new Object[]{"value", "name"};
        StateObject[] stateObjectArray = this.devicePanel.getModel().getConfigureUtilities().getAllStateObject();
        AlarmObject[] alarmObjectArray = this.devicePanel.getModel().getConfigureUtilities().getAllAlarmObject();
        Object[][] objectArray2 = null;
        if (stateObjectArray == null) {
            stateObjectArray = new StateObject[]{};
        }
        if (alarmObjectArray == null) {
            alarmObjectArray = new AlarmObject[]{};
        }
        int n2 = alarmObjectArray.length;
        if (!this.devicePanel.getModel().getConfigureUtilities().isAllowedVisiableAlarmLegend() || !isVisibleAllowed) {
            n2 = 0;
        }
        int n3 = 0;
        for (n = 0; n < stateObjectArray.length; ++n) {
            if (!stateObjectArray[n].isAllowedDisplayLegend()) continue;
            ++n3;
        }
        objectArray2 = new Object[n3 + n2][2];
        for (n = 0; n < n2; ++n) {
            ImageIcon imageIcon = alarmObjectArray[n].getImageIcon();
            Color color = alarmObjectArray[n].getColor();
            if (color != null && imageIcon != null) {
                ImageIcon imageIcon2 = alarmObjectArray[n].getCustormIcon(color);
                if (imageIcon2 == null) {
                    imageIcon2 = DevicePanelUtil.getAlarmIconWithColar(imageIcon, color);
                    alarmObjectArray[n].setCustormIcon(color, imageIcon2);
                }
                imageIcon = imageIcon2;
            }
            objectArray2[n][0] = imageIcon;
            objectArray2[n][1] = alarmObjectArray[n].getName();
        }
        int n4 = 0;
        for (n = 0; n < stateObjectArray.length; ++n) {
            if (!stateObjectArray[n].isAllowedDisplayLegend()) continue;
            objectArray2[n4 + n2][0] = stateObjectArray[n].getColor();
            objectArray2[n4 + n2][1] = stateObjectArray[n].getName();
            ++n4;
        }
        CellEditionNotEnabledTableModel cellEditionNotEnabledTableModel = new CellEditionNotEnabledTableModel(objectArray2, objectArray);
        this.legendTable.setModel(cellEditionNotEnabledTableModel);
        this.legendTable.setRowHeight(30);
        this.legendTable.getTableHeader().setPreferredSize(new Dimension(0, 0));
        this.legendTable.getColumnModel().getColumn(0).setCellRenderer(new LegendCellRenderer());
        this.legendTable.setCellSelectionEnabled(true);
        this.legendTable.setSelectionMode(0);
        TableColumnModel tableColumnModel = this.legendTable.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(70);
        tableColumnModel.getColumn(1).setPreferredWidth(130);
        this.legendTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = LegendPanel.this.legendTable.rowAtPoint(point);
                int n2 = LegendPanel.this.legendTable.columnAtPoint(point);
                if (n2 != 0) {
                    LegendPanel.this.legendTable.setToolTipText((String)LegendPanel.this.legendTable.getValueAt(n, n2));
                } else {
                    LegendPanel.this.legendTable.setToolTipText(null);
                }
            }
        });
    }

    JTabbedPane getLegendTabbedPane() {
        return this.legendTabbedPane;
    }

    void equipFocusListener(FocusListener focusListener) {
        this.legendTable.addFocusListener(focusListener);
        this.legendTabbedPane.addFocusListener(focusListener);
    }

    void unequipFocusListener(FocusListener focusListener) {
        this.legendTable.removeFocusListener(focusListener);
        this.legendTabbedPane.removeFocusListener(focusListener);
        for (int i = 0; i < this.legendTabbedPane.getComponentCount(); ++i) {
            this.legendTabbedPane.getComponentAt(i).removeFocusListener(focusListener);
        }
    }

    public void clear() {
        this.legendTable = null;
        this.legendTabbedPane = null;
        this.devicePanel = null;
    }
}

