/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.devicepanel.view;

import com.swimap.iview.templates.devicepanel.view.DevicePanel;
import com.swimap.iview.templates.devicepanel.view.ResPropertiesBundle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import javax.swing.border.BevelBorder;

class LegendDividerPanel
extends JPanel {
    private static final int MAX_SIZE = 1000;
    private ResPropertiesBundle res = ResPropertiesBundle.getInstance();
    private static ImageIcon dividerImageIcon = new ImageIcon(LegendDividerPanel.class.getResource("divider.gif"));
    private DevicePanel devicePanel = null;
    private transient MouseListener mouseListener = new MouseHandler();
    private transient MouseMotionListener mouseMotionListener = new MouseMotionHandler();
    private static final int upX = 3;
    private static final int upY = 20;
    private static final int leftX = 3;
    private static final int leftY = 32;
    private static final int rightX = 8;
    private static final int rightY = 26;
    private int xSub = 5;

    LegendDividerPanel(DevicePanel devicePanel) {
        this.devicePanel = devicePanel;
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseMotionListener);
        this.setLayout(new BorderLayout());
        this.setBorder(new BevelBorder(0));
        Dimension dimension = devicePanel.getModel().getConfigureUtilities().getPanelSize();
        Dimension dimension2 = new Dimension(dividerImageIcon.getIconWidth() + 2, dimension.height);
        this.setPreferredSize(dimension2);
        this.setMaximumSize(new Dimension(dimension2.width, 1000));
        this.setMinimumSize(dimension2);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    void endTask() {
        this.removeMouseListener(this.mouseListener);
        this.removeMouseMotionListener(this.mouseMotionListener);
        this.mouseListener = null;
        this.mouseMotionListener = null;
        this.devicePanel = null;
        ToolTipManager.sharedInstance().unregisterComponent(this);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        for (int i = 1; i < this.getWidth(); i += dividerImageIcon.getIconWidth()) {
            for (int j = 1; j < this.getHeight(); j += dividerImageIcon.getIconHeight()) {
                dividerImageIcon.paintIcon(this, graphics, i, j);
            }
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setPaint(this.getBackground());
        graphics2D.drawLine(0, 0, 0, this.getHeight() - 1);
        graphics2D.drawLine(1, 0, 1, this.getHeight() - 1);
        GeneralPath generalPath = new GeneralPath();
        if (this.devicePanel == null || this.devicePanel.legendPanel == null || this.devicePanel.legendPanel.isVisible()) {
            generalPath.append(new Line2D.Double(3.0, 20.0, 8.0, 26.0), true);
            generalPath.append(new Line2D.Double(8.0, 26.0, 3.0, 32.0), true);
            generalPath.append(new Line2D.Double(3.0, 32.0, 3.0, 20.0), true);
        } else {
            generalPath.append(new Line2D.Double(3 + this.xSub, 20.0, 8 - this.xSub, 26.0), true);
            generalPath.append(new Line2D.Double(8 - this.xSub, 26.0, 3 + this.xSub, 32.0), true);
            generalPath.append(new Line2D.Double(3 + this.xSub, 32.0, 3 + this.xSub, 20.0), true);
        }
        graphics2D.setPaint(Color.black);
        graphics2D.fill(generalPath);
    }

    boolean isInArea(int n, int n2) {
        return n >= 3 && n <= 8 && n2 >= 20 && n2 <= 32;
    }

    class MouseMotionHandler
    extends MouseMotionAdapter {
        MouseMotionHandler() {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (LegendDividerPanel.this.isInArea(mouseEvent.getX(), mouseEvent.getY())) {
                if (!((LegendDividerPanel)LegendDividerPanel.this).devicePanel.legendPanel.isVisible()) {
                    String string = LegendDividerPanel.this.devicePanel.getLegendToolTipOpenApMsg();
                    if (string != null) {
                        LegendDividerPanel.this.setToolTipText(LegendDividerPanel.this.res.getString("OpenLegend") + string);
                    } else {
                        LegendDividerPanel.this.setToolTipText(LegendDividerPanel.this.res.getString("OpenLegend"));
                    }
                } else {
                    String string = LegendDividerPanel.this.devicePanel.getLegendToolTipCloseApMsg();
                    if (string != null) {
                        LegendDividerPanel.this.setToolTipText(LegendDividerPanel.this.res.getString("CloseLegend") + string);
                    } else {
                        LegendDividerPanel.this.setToolTipText(LegendDividerPanel.this.res.getString("CloseLegend"));
                    }
                }
            } else {
                LegendDividerPanel.this.setToolTipText(null);
            }
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (LegendDividerPanel.this.isInArea(mouseEvent.getX(), mouseEvent.getY())) {
                if (!((LegendDividerPanel)LegendDividerPanel.this).devicePanel.legendPanel.isVisible()) {
                    LegendDividerPanel.this.devicePanel.fireLegendExpandingEvent();
                } else {
                    LegendDividerPanel.this.devicePanel.fireLegendClosingEvent();
                }
                LegendDividerPanel.this.repaint();
            }
        }
    }
}

