/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.devicepanel.view;

import com.swimap.iview.templates.devicepanel.model.XMLFileNotValidException;
import com.swimap.iview.templates.devicepanel.view.xml.AltDown;
import com.swimap.iview.templates.devicepanel.view.xml.CtrlDown;
import com.swimap.iview.templates.devicepanel.view.xml.DevicePanel;
import com.swimap.iview.templates.devicepanel.view.xml.DevicePanelKey;
import com.swimap.iview.templates.devicepanel.view.xml.KeyStroke;
import com.swimap.iview.templates.devicepanel.view.xml.ShiftDown;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.log.IviewLogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public class KeyConfigure {
    private static final IviewLogger logger = IviewLogger.getLogger(KeyConfigure.class, "IVIEW");
    private String xmlFileName = null;
    private static HashMap instanceHashMap = new HashMap();
    private HashMap keyStrokeHashMap = new HashMap(10);
    private HashMap keyNameToAction = new HashMap(10);

    public static KeyConfigure getInstance(String string) throws XMLFileNotValidException {
        KeyConfigure keyConfigure = (KeyConfigure)instanceHashMap.get(string);
        if (keyConfigure == null) {
            keyConfigure = new KeyConfigure(string);
            instanceHashMap.put(string, keyConfigure);
        }
        return keyConfigure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyConfigure(String string) throws XMLFileNotValidException {
        Object object;
        this.xmlFileName = string;
        File file = CommonUtil.getAbsoluteFile(this.xmlFileName);
        DevicePanel devicePanel = DevicePanel.unmarshal(file);
        if (null == devicePanel) {
            object = KeyConfigure.class.getClassLoader();
            InputStream inputStream = null;
            try {
                inputStream = ((ClassLoader)object).getResourceAsStream(string);
                devicePanel = DevicePanel.unmarshal(inputStream);
            }
            catch (Exception exception) {
                logger.info(exception.getMessage(), exception);
            }
            finally {
                if (null != inputStream) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        logger.info(iOException.getMessage(), iOException);
                    }
                }
            }
        }
        if (devicePanel == null || !devicePanel.isValid()) {
            object = new StringBuffer("The file '");
            ((StringBuffer)object).append(string);
            ((StringBuffer)object).append("' is not valid");
            throw new XMLFileNotValidException(((StringBuffer)object).toString());
        }
        this.readKeyConfigure(devicePanel.getDevicePanelKey());
    }

    private void readKeyConfigure(DevicePanelKey devicePanelKey) {
        int n = devicePanelKey.getKeyStroke().length;
        for (int i = 0; i < n; ++i) {
            KeyStroke keyStroke = devicePanelKey.getKeyStroke(i);
            this.initKeyStroke(keyStroke);
        }
    }

    public HashMap getKeyStrokeHashMap() {
        return this.keyStrokeHashMap;
    }

    private void initKeyStroke(KeyStroke keyStroke) {
        ShiftDown shiftDown;
        CtrlDown ctrlDown;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        string4 = keyStroke.getKeyNameText();
        int n = javax.swing.KeyStroke.getKeyStroke(string4).getKeyCode();
        if (string4 == null) {
            return;
        }
        String string5 = keyStroke.getActionValueText();
        this.keyNameToAction.put(string5, string4.toLowerCase());
        AltDown altDown = keyStroke.getAltDown();
        if (altDown != null) {
            string = altDown.getKeyPressedText();
        }
        if ((ctrlDown = keyStroke.getCtrlDown()) != null) {
            string2 = ctrlDown.getKeyPressedText();
        }
        if ((shiftDown = keyStroke.getShiftDown()) != null) {
            string3 = shiftDown.getKeyPressedText();
        }
        int n2 = 0;
        if (string != null && "true".equalsIgnoreCase(string)) {
            n2 |= 8;
        }
        if (string2 != null && "true".equalsIgnoreCase(string2)) {
            n2 |= 2;
        }
        if (string3 != null && "true".equalsIgnoreCase(string3)) {
            n2 |= 1;
        }
        javax.swing.KeyStroke keyStroke2 = javax.swing.KeyStroke.getKeyStroke(n, n2, false);
        javax.swing.KeyStroke keyStroke3 = javax.swing.KeyStroke.getKeyStroke(n, n2, true);
        this.keyStrokeHashMap.put(string5, keyStroke2);
        string5 = String.valueOf(Integer.parseInt(string5) + 5);
        this.keyStrokeHashMap.put(string5, keyStroke3);
    }

    public HashMap getKeyName() {
        return this.keyNameToAction;
    }

    public void endTask() {
        instanceHashMap.remove(this.xmlFileName);
    }
}

