/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.devicepanel.view;

import com.swimap.iview.templates.devicepanel.model.component.DevicePanelComponent;
import com.swimap.iview.templates.devicepanel.model.component.Frame;
import com.swimap.iview.templates.devicepanel.model.component.Shelf;
import com.swimap.iview.templates.devicepanel.view.BehindDrawingPanel;
import com.swimap.iview.templates.devicepanel.view.DevicePanel;
import com.swimap.iview.templates.devicepanel.view.DrawingPanel;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

class FrontDrawingPanel
extends DrawingPanel {
    private transient KeyListener keyListener = new KeyHandler();

    FrontDrawingPanel(DevicePanelComponent devicePanelComponent, DevicePanel devicePanel) {
        super(devicePanelComponent, devicePanel);
        this.addKeyListener(this.keyListener);
    }

    @Override
    void endTask() {
        super.endTask();
        this.removeKeyListener(this.keyListener);
        this.keyListener = null;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Shelf shelf;
        super.mouseClicked(mouseEvent);
        if (this.selectedComponent != null && this.selectedComponent instanceof Shelf && (shelf = (Shelf)this.selectedComponent).isBehindChildrenDisplayingAllowed(mouseEvent.getX(), mouseEvent.getY()) && shelf.isInArea(mouseEvent.getX(), mouseEvent.getY())) {
            if (this.devicePanel.getBehidListeners().getListenerCount() > 0) {
                this.fireBehidActionListener(mouseEvent, shelf);
                return;
            }
            BehindDrawingPanel behindDrawingPanel = null;
            if (this.devicePanel.getBehindShelfDialog().getDrawingPanel() instanceof BehindDrawingPanel) {
                behindDrawingPanel = (BehindDrawingPanel)this.devicePanel.getBehindShelfDialog().getDrawingPanel();
            }
            if (behindDrawingPanel != null && behindDrawingPanel.getShelf() == shelf) {
                behindDrawingPanel.repaint();
                if (this.devicePanel.getBehindShelfDialog().isModal()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            FrontDrawingPanel.this.devicePanel.getBehindShelfDialog().setVisible(true);
                        }
                    });
                } else {
                    this.devicePanel.getBehindShelfDialog().setVisible(true);
                }
            } else {
                BehindDrawingPanel behindDrawingPanel2 = new BehindDrawingPanel(shelf, this.devicePanel);
                behindDrawingPanel2.setIsComposeFrame(this.getIsComposeFrame());
                this.devicePanel.getBehindShelfDialog().setFrontDrawingPanel(this);
                this.devicePanel.getBehindShelfDialog().setDrawingPanel(behindDrawingPanel2);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        super.mouseMoved(mouseEvent);
        if (this.currentComponent != null && this.currentComponent instanceof Shelf) {
            Shelf shelf = (Shelf)this.currentComponent;
            if (shelf.isBehindChildrenDisplayingAllowed(mouseEvent.getX(), mouseEvent.getY()) && shelf.isInArea(mouseEvent.getX(), mouseEvent.getY())) {
                if (shelf.getBehindEnabled()) {
                    this.setToolTipText(this.res.getString("OpenFrontShelf"));
                } else {
                    this.setToolTipText(this.res.getString("OpenBehindShelf"));
                }
            } else {
                this.setToolTipText(this.currentComponent.getToolTipText());
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
        if (this.devicePanel != null && this.devicePanel.getBehindShelfDialog() != null && this.devicePanel.getBehindShelfDialog().getDrawingPanel() != null) {
            this.keepOneSelected();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        this.keepOneSelected();
    }

    @Override
    protected void keepOneSelected() {
        if (this.devicePanel == null) {
            return;
        }
        if (this.devicePanel.getBehindShelfDialog() == null) {
            return;
        }
        if (this.devicePanel.getBehindShelfDialog().getDrawingPanel() == null) {
            return;
        }
        if (this.devicePanel.getBehindShelfDialog().getDrawingPanel().selectedComponent != null) {
            Graphics2D graphics2D = this.devicePanel.getBehindShelfDialog().getDrawingPanel().getDrawingGraphics();
            BehindDrawingPanel behindDrawingPanel = (BehindDrawingPanel)this.devicePanel.getBehindShelfDialog().getDrawingPanel();
            behindDrawingPanel.getShelf().setBehindEnabled(true);
            behindDrawingPanel.selectedComponent.draw(graphics2D);
            behindDrawingPanel.getShelf().setBehindEnabled(false);
            behindDrawingPanel.selectedComponent = null;
            behindDrawingPanel.repaint();
            graphics2D.dispose();
        }
    }

    public Dimension getDimension() {
        if (this.container instanceof Frame) {
            return new Dimension(this.container.getWidth(), this.container.getHeight() + ((Frame)this.container).getAreaHeight());
        }
        return new Dimension(this.container.getWidth(), this.container.getHeight());
    }

    private void fireBehidActionListener(MouseEvent mouseEvent, Shelf shelf) {
        Object[] objectArray = this.devicePanel.getBehidListeners().getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ActionListener.class) continue;
            ActionEvent actionEvent = new ActionEvent(shelf, mouseEvent.getID(), "", mouseEvent.getModifiers());
            ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent);
        }
    }

    private class KeyHandler
    extends KeyAdapter {
        private KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (FrontDrawingPanel.this.container == null) {
                return;
            }
            boolean bl = false;
            Frame frame = (Frame)FrontDrawingPanel.this.container;
            if (keyEvent.getKeyCode() == 34) {
                bl = frame.downPage();
            } else if (keyEvent.getKeyCode() == 33) {
                bl = frame.upPage();
            }
            if (bl) {
                FrontDrawingPanel.this.repaintAgain();
            }
        }
    }
}

