/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.devicepanel.view;

import com.swimap.iview.templates.devicepanel.model.DevicePanelTreeModel;
import com.swimap.iview.templates.devicepanel.model.EmulationalListener;
import com.swimap.iview.templates.devicepanel.model.component.DevicePanelComponent;
import com.swimap.iview.templates.devicepanel.model.component.Frame;
import com.swimap.iview.templates.devicepanel.model.component.Shelf;
import com.swimap.iview.templates.devicepanel.view.DevicePanel;
import com.swimap.iview.templates.devicepanel.view.DrawingPanel;
import com.swimap.iview.templates.devicepanel.view.EmulationalDevicePanel;
import com.swimap.iview.templates.devicepanel.view.LmtEmulationalDrawingPanel;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import javax.swing.tree.DefaultMutableTreeNode;

class FacilityDrawingPanel
extends DrawingPanel {
    private static IviewLogger logger = IviewLogger.getLogger(FacilityDrawingPanel.class, "IVIEW");
    private LmtEmulationalDrawingPanel drawingPanel = null;
    private DevicePanelTreeModel emulationalModel = null;
    private Shelf facilityShelf = null;
    private EmulationalListener emulationalListener = null;
    Shelf emulationalShelf = null;

    private DevicePanelTreeModel createEmulationalModel(Shelf shelf) {
        DevicePanelTreeModel devicePanelTreeModel = null;
        this.emulationalListener = this.devicePanel.getEmulationalListener();
        if (this.emulationalListener == null) {
            return null;
        }
        this.checkAndFixFlag();
        if (!DevicePanelComponent.isOpenEmulational) {
            DevicePanelComponent.isOpenEmulational = true;
            devicePanelTreeModel = this.emulationalListener.openEmulationalPanel(shelf);
            if (devicePanelTreeModel == null) {
                DevicePanelComponent.isOpenEmulational = false;
            }
        } else {
            devicePanelTreeModel = this.facilityShelf != null && this.emulationalModel != null && this.facilityShelf == shelf ? this.emulationalModel : this.emulationalListener.switchEmulationalPanel(shelf);
        }
        return devicePanelTreeModel;
    }

    FacilityDrawingPanel(DevicePanelComponent devicePanelComponent, DevicePanel devicePanel) {
        super(devicePanelComponent, devicePanel);
    }

    @Override
    void endTask() {
        super.endTask();
        this.drawingPanel = null;
        this.emulationalModel = null;
        this.emulationalListener = null;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
        if (this.devicePanel.getEmulationalDevicePanel().isVisible()) {
            this.keepOneSelected();
        }
    }

    @Override
    protected void keepOneSelected() {
        if (this.devicePanel.getEmulationalDevicePanel().getDrawingPanel() == null) {
            return;
        }
        if (this.devicePanel.getEmulationalDevicePanel().getDrawingPanel().selectedComponent != null) {
            Graphics2D graphics2D = this.devicePanel.getEmulationalDevicePanel().getDrawingPanel().getDrawingGraphics();
            this.devicePanel.getEmulationalDevicePanel().getDrawingPanel().container.draw(graphics2D);
            this.devicePanel.getEmulationalDevicePanel().getDrawingPanel().selectedComponent = null;
            this.devicePanel.getEmulationalDevicePanel().getDrawingPanel().repaint();
            graphics2D.dispose();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        if (this.devicePanel.getEmulationalDialog().isVisible()) {
            this.keepOneSelected();
        }
    }

    private void firstOpenEmulational(Shelf shelf, MouseEvent mouseEvent) {
        this.facilityShelf = shelf;
        if (!this.facilityShelf.isInArea(mouseEvent.getX(), mouseEvent.getY())) {
            if (this.facilityShelf.getRelatedTreeNode().getChildCount() <= this.facilityShelf.getFrontChildCount() && this.facilityShelf.getBehindEnabled()) {
                return;
            }
            this.openEmulationShelf(this.facilityShelf);
        } else {
            if (this.facilityShelf.getRelatedTreeNode().getChildCount() <= this.facilityShelf.getFrontChildCount() && !this.facilityShelf.getBehindEnabled()) {
                this.openEmulationShelf(this.facilityShelf);
                return;
            }
            boolean bl = this.facilityShelf.getBehindEnabled();
            this.emulationalShelf = this.getEmulationalShelf(this.facilityShelf);
            if (this.emulationalShelf == null) {
                this.traceMessage("firstOpenEmulational", "emulationShelf is null, will be returned. ");
                this.facilityShelf = null;
                return;
            }
            this.emulationalShelf.setBehindEnabled(!bl);
            this.drawingPanel = new LmtEmulationalDrawingPanel(this.emulationalShelf, this.devicePanel);
            if (this.emulationalModel == null) {
                this.traceMessage("firstOpenEmulational", "emulationalModel is null, will be returned. ");
                return;
            }
            this.drawingPanel.setEmuModel(this.emulationalModel);
            this.devicePanel.getEmulationalDevicePanel().setFacilityDrawingPanel(this);
            this.devicePanel.getEmulationalDevicePanel().setDrawingPanel(this.drawingPanel);
            this.drawingPanel.repaint();
        }
    }

    private void switchInDifferentShelf(Shelf shelf, MouseEvent mouseEvent) {
        Shelf shelf2 = this.facilityShelf;
        Shelf shelf3 = this.emulationalShelf;
        if (!shelf.isInArea(mouseEvent.getX(), mouseEvent.getY())) {
            if (shelf.getRelatedTreeNode().getChildCount() <= shelf.getFrontChildCount() && shelf.getBehindEnabled()) {
                this.traceMessage("switchInDifferentShelf", " emulationShelf " + shelf.getID() + " haven't  back shelf to show when" + " behind shelfs are visible");
                return;
            }
            boolean bl = this.facilityShelf.getBehindEnabled();
            this.emulationalShelf = this.getEmulationalShelf(shelf);
            if (this.emulationalShelf == null) {
                this.traceMessage("switchInDifferentShelf", " emulationShelf " + shelf.getID() + " is null, will be returned when" + " behind shelfs are visible");
                this.facilityShelf = shelf2;
                this.emulationalShelf = shelf3;
                shelf2 = null;
                shelf3 = null;
                return;
            }
            this.facilityShelf = shelf;
            this.drawingPanel.clear();
            this.drawingPanel.endTask();
            this.drawingPanel = new LmtEmulationalDrawingPanel(this.emulationalShelf, this.devicePanel);
            this.drawingPanel.setEmuModel(this.emulationalModel);
            this.drawingPanel.shelf.setBehindEnabled(bl);
            this.devicePanel.getEmulationalDevicePanel().setFacilityDrawingPanel(this);
            this.devicePanel.getEmulationalDevicePanel().setDrawingPanel(this.drawingPanel, false);
        } else {
            if (shelf.getRelatedTreeNode().getChildCount() <= shelf.getFrontChildCount() && !shelf.getBehindEnabled()) {
                this.traceMessage("switchInDifferentShelf", " emulationShelf " + shelf.getID() + " haven't back shelf to show when" + " front shelfs are visible");
                return;
            }
            boolean bl = this.facilityShelf.getBehindEnabled();
            this.emulationalShelf = this.getEmulationalShelf(shelf);
            if (this.emulationalShelf == null) {
                this.traceMessage("switchInDifferentShelf", " emulationShelf " + shelf.getID() + " is null, will be returned when " + " behind shelfs are visible");
                this.facilityShelf = shelf2;
                this.emulationalShelf = shelf3;
                shelf2 = null;
                shelf3 = null;
                return;
            }
            this.facilityShelf = shelf;
            this.drawingPanel.clear();
            this.drawingPanel.endTask();
            this.drawingPanel = new LmtEmulationalDrawingPanel(this.emulationalShelf, this.devicePanel);
            this.drawingPanel.setEmuModel(this.emulationalModel);
            this.drawingPanel.shelf.setBehindEnabled(!bl);
            this.devicePanel.getEmulationalDevicePanel().setFacilityDrawingPanel(this);
            this.devicePanel.getEmulationalDevicePanel().setDrawingPanel(this.drawingPanel, false);
        }
        this.drawEmulationalShelf();
    }

    private Shelf getEmulationalShelf(Shelf shelf) {
        this.emulationalModel = this.createEmulationalModel(shelf);
        if (this.emulationalModel == null) {
            this.traceMessage("getEmulationalShelf", "the emulationalModel created by use is null.EmulationalShelf will not be refresh");
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = this.emulationalModel.findTreeNode(shelf.getID());
        if (defaultMutableTreeNode == null) {
            this.traceMessage("getEmulationalShelf", "Can't find the facilityShelf " + shelf.getID() + "from the emulationalModel created by " + "use.EmulationalShelf will not be refresh");
            return null;
        }
        Shelf shelf2 = (Shelf)defaultMutableTreeNode.getUserObject();
        return shelf2;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        super.mouseClicked(mouseEvent);
        this.currentComponent = this.container.matchCurrentComponent(mouseEvent.getX(), mouseEvent.getY());
        if (this.currentComponent == null) {
            return;
        }
        if (!this.currentComponent.isSelectable()) {
            return;
        }
        if (mouseEvent.getModifiers() == 16 && this.selectedComponent != null) {
            this.selectedComponent = this.currentComponent;
            if (mouseEvent.getClickCount() % 2 == 0 && this.selectedComponent instanceof Shelf) {
                if (this.facilityShelf == null || this.drawingPanel == null || this.emulationalShelf == null || !DevicePanelComponent.isOpenEmulational) {
                    this.firstOpenEmulational((Shelf)this.selectedComponent, mouseEvent);
                } else if (this.facilityShelf == this.selectedComponent) {
                    this.switchInSameShelf((Shelf)this.selectedComponent, mouseEvent);
                } else {
                    this.switchInDifferentShelf((Shelf)this.selectedComponent, mouseEvent);
                }
            }
        }
    }

    private void switchInSameShelf(Shelf shelf, MouseEvent mouseEvent) {
        this.facilityShelf = shelf;
        if (this.facilityShelf == null) {
            logger.debug("facilityShelf is null");
            return;
        }
        if (this.emulationalShelf == null) {
            logger.debug("emulationalShelf is null");
            return;
        }
        if (this.facilityShelf.isInArea(mouseEvent.getX(), mouseEvent.getY()) && this.facilityShelf.getBehindEnabled() == this.emulationalShelf.getBehindEnabled()) {
            if (this.facilityShelf.getRelatedTreeNode().getChildCount() <= this.facilityShelf.getFrontChildCount() && !this.facilityShelf.getBehindEnabled()) {
                return;
            }
            this.emulationalShelf.setBehindEnabled(!this.emulationalShelf.getBehindEnabled());
            this.drawEmulationalShelf();
        } else if (!this.facilityShelf.isInArea(mouseEvent.getX(), mouseEvent.getY())) {
            if (this.facilityShelf.getRelatedTreeNode().getChildCount() <= this.facilityShelf.getFrontChildCount() && !this.emulationalShelf.getBehindEnabled()) {
                return;
            }
            this.emulationalShelf.setBehindEnabled(!this.emulationalShelf.getBehindEnabled());
            this.drawEmulationalShelf();
        }
        this.devicePanel.getEmulationalDialog().setVisible(true);
    }

    private void drawEmulationalShelf() {
        Graphics2D graphics2D = this.devicePanel.getEmulationalDevicePanel().getDrawingPanel().getDrawingGraphics();
        this.emulationalShelf.draw(graphics2D);
        graphics2D.dispose();
        this.devicePanel.getEmulationalDevicePanel().getDrawingPanel().repaint();
        this.devicePanel.updateEmulationalDialogTitle();
        this.devicePanel.getEmulationalDialog().setVisible(true);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        super.mouseMoved(mouseEvent);
        this.currentComponent = this.container.matchCurrentComponent(mouseEvent.getX(), mouseEvent.getY());
        if (this.currentComponent != null && this.currentComponent instanceof Shelf) {
            Shelf shelf = (Shelf)this.currentComponent;
            if (shelf.isBehindChildrenDisplayingAllowed(mouseEvent.getX(), mouseEvent.getY()) && shelf.isInArea(mouseEvent.getX(), mouseEvent.getY()) && shelf.getIsShowOpenEmulationalToolTip()) {
                if (shelf.getBehindEnabled()) {
                    this.setToolTipText(this.res.getString("OpenFront"));
                } else {
                    this.setToolTipText(this.res.getString("OpenBehind"));
                }
            } else {
                this.setToolTipText(this.currentComponent.getToolTipText());
            }
        }
    }

    public Dimension getDimension() {
        if (this.container instanceof Frame) {
            return new Dimension(this.container.getWidth(), this.container.getHeight() + ((Frame)this.container).getAreaHeight());
        }
        return new Dimension(this.container.getWidth(), this.container.getHeight());
    }

    void openEmulationShelf(DevicePanelComponent devicePanelComponent) {
        Shelf shelf = null;
        if (!(devicePanelComponent instanceof Shelf)) {
            this.traceMessage("openEmulationShelf", "component " + devicePanelComponent.getID() + "is not a shelf, will be returned. ");
            return;
        }
        shelf = (Shelf)devicePanelComponent;
        this.emulationalShelf = this.getEmulationalShelf(shelf);
        if (this.emulationalShelf == null) {
            this.traceMessage("openEmulationShelf", "shelf " + devicePanelComponent.getID() + "'s emulationShelf is null, will be returned. ");
            this.facilityShelf = null;
            return;
        }
        this.facilityShelf = shelf;
        this.emulationalShelf.setBehindEnabled(shelf.getBehindEnabled());
        this.drawingPanel = new LmtEmulationalDrawingPanel(this.emulationalShelf, this.devicePanel);
        this.drawingPanel.setEmuModel(this.emulationalModel);
        EmulationalDevicePanel emulationalDevicePanel = this.devicePanel.getEmulationalDevicePanel();
        emulationalDevicePanel.setFacilityDrawingPanel(this);
        emulationalDevicePanel.setDrawingPanel(this.drawingPanel);
        this.drawingPanel.repaint();
    }

    public void clear() {
        this.emulationalModel = null;
        this.emulationalShelf = null;
        this.facilityShelf = null;
    }

    private void checkAndFixFlag() {
        boolean bl;
        if (this.devicePanel == null) {
            this.traceMessage("checkAndFixFlag", "DevicePanel is null, will be return true.");
            return;
        }
        boolean bl2 = this.devicePanel.getEmulationalDialog().isShowing();
        if (bl2 != (bl = DevicePanelComponent.isOpenEmulational)) {
            String string = new StringBuffer("Flag is not matched. DlgFlag = ").append(bl2).append(", staticFlag = ").append(bl).append(", will fix staticFlag to dlgFlag").toString();
            DevicePanelComponent.isOpenEmulational = bl2;
            this.traceMessage("checkandFixFlag", string);
        }
    }

    private void traceMessage(String string, String string2) {
        logger.debug(string2);
    }
}

