/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.devicepanel.view;

import com.swimap.iview.templates.devicepanel.model.component.DevicePanelComponent;
import com.swimap.iview.templates.devicepanel.view.EmulationalDevicePanel;
import com.swimap.iview.templates.devicepanel.view.ResPropertiesBundle;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.JDialog;
import javax.swing.JFrame;

class EmulationalShelfDialog
extends JDialog {
    private static IviewLogger logger = IviewLogger.getLogger(EmulationalShelfDialog.class, "IVIEW");
    private EmulationalDevicePanel emuDevicePanel = null;
    private static EmulationalShelfDialog instance = null;

    private EmulationalShelfDialog(JFrame jFrame) {
        super((Frame)jFrame, ResPropertiesBundle.getInstance().getString("EmulationalPanel"));
        EmulationalShelfDialog.traceMessage("EmulationalShelfDialog()", "Start Building emulatinal shelf dialog. Just build once...");
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.setDefaultCloseOperation(2);
    }

    static synchronized EmulationalShelfDialog getInstance(JFrame jFrame) {
        if (instance == null) {
            instance = new EmulationalShelfDialog(jFrame);
        }
        EmulationalShelfDialog.traceMessage("getInstance()", "instance=" + instance);
        return instance;
    }

    void updateTitle() {
        this.setTitle(this.emuDevicePanel.getTitleFromTooltip());
    }

    void setEmulationalDevicePanel(EmulationalDevicePanel emulationalDevicePanel) {
        EmulationalShelfDialog.traceMessage("setEmulationalDevicePanel()", "panel=" + emulationalDevicePanel);
        if (emulationalDevicePanel == null) {
            return;
        }
        if (this.emuDevicePanel != null) {
            this.getContentPane().remove(this.emuDevicePanel);
        }
        this.emuDevicePanel = emulationalDevicePanel;
        this.getContentPane().add((Component)this.emuDevicePanel, "Center");
    }

    EmulationalDevicePanel getEmulationalDevicePanel() {
        return this.emuDevicePanel;
    }

    @Override
    public void dispose() {
        DevicePanelComponent.isOpenEmulational = false;
        if (this.emuDevicePanel != null) {
            this.emuDevicePanel.notifyEmulationalPanelClose();
        }
        if (this.emuDevicePanel != null && this.emuDevicePanel.getFacilityDrawingPanel() != null && this.emuDevicePanel.getFacilityDrawingPanel().emulationalShelf != null) {
            this.emuDevicePanel.getFacilityDrawingPanel().emulationalShelf = null;
        }
        try {
            super.dispose();
        }
        catch (Exception exception) {
            this.setVisible(false);
            EmulationalShelfDialog.traceMessage("dispose()", "an exception occured. set dialog invisible");
            logger.trace(exception.getMessage(), exception);
        }
    }

    private static void traceMessage(String string, String string2) {
        logger.debug(string2);
    }
}

