/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.devicepanel.view;

import com.swimap.iview.templates.devicepanel.datasource.ComponentData;
import com.swimap.iview.templates.devicepanel.model.EmulationalListener;
import com.swimap.iview.templates.devicepanel.model.component.DevicePanelComponent;
import com.swimap.iview.templates.devicepanel.model.component.Shelf;
import com.swimap.iview.templates.devicepanel.view.DevicePanel;
import com.swimap.iview.templates.devicepanel.view.EmulationalShelfDialog;
import com.swimap.iview.templates.devicepanel.view.FacilityDrawingPanel;
import com.swimap.iview.templates.devicepanel.view.LmtEmulationalDrawingPanel;
import com.swimap.iview.templates.devicepanel.view.ResPropertiesBundle;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JPanel;

class EmulationalDevicePanel
extends JPanel {
    private static IviewLogger logger = IviewLogger.getLogger(EmulationalDevicePanel.class, "IVIEW");
    private static final int EMULATE_EXTEND_HEIGHT = 33;
    private static final int EMULATE_EXTEND_WIDTH = 8;
    private ResPropertiesBundle res = ResPropertiesBundle.getInstance();
    private DevicePanel devicePanel = null;
    private LmtEmulationalDrawingPanel drawingPanel;
    private FacilityDrawingPanel facilityDrawingPanel = null;
    private Dimension dimension = new Dimension();

    EmulationalDevicePanel(DevicePanel devicePanel) {
        EmulationalDevicePanel.traceMessage("EmulationalDevicePanel()", "building...");
        this.setLayout(new BorderLayout());
        this.devicePanel = devicePanel;
        this.drawingPanel = new LmtEmulationalDrawingPanel(new Shelf(new ComponentData("", "", "", null), new Rectangle(0, 0, 10, 10)), devicePanel);
    }

    final void endTask() {
        EmulationalDevicePanel.traceMessage("endTask()", "");
        if (this.drawingPanel != null) {
            this.drawingPanel.endTask();
        }
        DevicePanelComponent.isOpenEmulational = false;
        if (this.facilityDrawingPanel != null) {
            this.facilityDrawingPanel.clear();
        }
        this.drawingPanel = null;
        this.facilityDrawingPanel = null;
    }

    final void notifyEmulationalPanelClose() {
        EmulationalListener emulationalListener;
        EmulationalDevicePanel.traceMessage("notifyEmulationalPanelClose()", "drawingPanel=" + this.drawingPanel + ", devicePanel=" + this.devicePanel);
        if (this.devicePanel != null && this.drawingPanel != null && (emulationalListener = this.devicePanel.getEmulationalListener()) != null) {
            emulationalListener.closeEmulationalPanel(this.drawingPanel.getShelf());
        }
    }

    final FacilityDrawingPanel getFacilityDrawingPanel() {
        return this.facilityDrawingPanel;
    }

    final void setFacilityDrawingPanel(FacilityDrawingPanel facilityDrawingPanel) {
        EmulationalDevicePanel.traceMessage("setFacilityDrawingPanel()", "fdp=" + facilityDrawingPanel);
        this.facilityDrawingPanel = facilityDrawingPanel;
    }

    final void setDrawingPanel(LmtEmulationalDrawingPanel lmtEmulationalDrawingPanel) {
        this.setDrawingPanel(lmtEmulationalDrawingPanel, true);
    }

    final void setDrawingPanel(LmtEmulationalDrawingPanel lmtEmulationalDrawingPanel, boolean bl) {
        EmulationalDevicePanel.traceMessage("setDrawingPanel()", "panel=" + lmtEmulationalDrawingPanel);
        this.removeAll();
        this.drawingPanel = lmtEmulationalDrawingPanel;
        Shelf shelf = (Shelf)this.drawingPanel.getContainer();
        Graphics2D graphics2D = this.drawingPanel.getDrawingGraphics();
        shelf.draw(graphics2D);
        graphics2D.dispose();
        this.add((Component)this.drawingPanel, "Center");
        EmulationalShelfDialog emulationalShelfDialog = this.devicePanel.getEmulationalDialog();
        this.dimension = new Dimension(shelf.getWidth() + 8, shelf.getHeight() + 33);
        emulationalShelfDialog.setSize(this.dimension);
        Point point = emulationalShelfDialog.getLocation();
        if (bl) {
            ScreenToolKit.centerLocateToScreen(emulationalShelfDialog);
        } else {
            if (point.x + this.dimension.width < 0) {
                point.x = 0;
            }
            if (point.y < 0) {
                point.y = 0;
            }
            emulationalShelfDialog.setLocation(point);
        }
        emulationalShelfDialog.setTitle(this.getTitleFromTooltip());
        emulationalShelfDialog.setEmulationalDevicePanel(this);
        emulationalShelfDialog.validate();
        emulationalShelfDialog.setVisible(true);
    }

    final LmtEmulationalDrawingPanel getDrawingPanel() {
        return this.drawingPanel;
    }

    final String getTitleFromTooltip() {
        if (this.drawingPanel == null) {
            EmulationalDevicePanel.traceMessage("getTitleFromTooltip()", "drawingPanel is null.");
            return null;
        }
        Shelf shelf = (Shelf)this.drawingPanel.getContainer();
        if (shelf == null) {
            EmulationalDevicePanel.traceMessage("getTitleFromTooltip()", "shelf is null.");
            return null;
        }
        String string = shelf.getToolTipText();
        if (string == null) {
            EmulationalDevicePanel.traceMessage("getTitleFromTooltip()", "tooltip is null.");
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(this.res.getString("EmulationalPanel"));
        stringBuffer.append(" - ").append(string.substring(0, string.indexOf(32, string.lastIndexOf(58)) + 1));
        if (shelf.getRelatedTreeNode().getChildCount() > shelf.getFrontChildCount()) {
            stringBuffer.append(' ').append(this.res.getString(shelf.getBehindEnabled() ? "BehindTitle" : "FrontTitle"));
        }
        return stringBuffer.toString();
    }

    public Dimension getParentDimension() {
        return this.dimension;
    }

    private static void traceMessage(String string, String string2) {
        logger.debug(string2);
    }
}

