/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.devicepanel.view;

import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.templates.devicepanel.model.ComposeFrameModel;
import com.swimap.iview.templates.devicepanel.model.EmulationalListener;
import com.swimap.iview.templates.devicepanel.model.PopupMenuAuthorization;
import com.swimap.iview.templates.devicepanel.model.PopupMenuResponseObjectPair;
import com.swimap.iview.templates.devicepanel.model.component.Card;
import com.swimap.iview.templates.devicepanel.model.component.ComposeEnvironmentItem;
import com.swimap.iview.templates.devicepanel.model.component.DevicePanelComponent;
import com.swimap.iview.templates.devicepanel.model.component.DoubleCard;
import com.swimap.iview.templates.devicepanel.model.component.EmptyComponent;
import com.swimap.iview.templates.devicepanel.model.component.EmptyShelf;
import com.swimap.iview.templates.devicepanel.model.component.EnvironmentItem;
import com.swimap.iview.templates.devicepanel.model.component.FansEnvironmentItem;
import com.swimap.iview.templates.devicepanel.model.component.Frame;
import com.swimap.iview.templates.devicepanel.model.component.PowerShelf;
import com.swimap.iview.templates.devicepanel.model.component.Shelf;
import com.swimap.iview.templates.devicepanel.model.component.TemperatureEnvironmentItem;
import com.swimap.iview.templates.devicepanel.view.ClickableEx;
import com.swimap.iview.templates.devicepanel.view.DevicePanel;
import com.swimap.iview.templates.devicepanel.view.KeyConfigure;
import com.swimap.iview.templates.devicepanel.view.ResPropertiesBundle;
import com.swimap.iview.templates.utils.MultiRowToolTip;
import com.swimap.iview.templates.utils.timer.IviewTimerTask;
import com.swimap.iview.templates.utils.timer.IviewUtilTimer;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;

public class DrawingPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
Scrollable {
    private static IviewLogger logger = IviewLogger.getLogger(DrawingPanel.class, "IVIEW");
    protected ResPropertiesBundle res = ResPropertiesBundle.getInstance();
    private BufferedImage drawingImage = null;
    protected DevicePanelComponent container = null;
    protected DevicePanel devicePanel = null;
    protected DevicePanelComponent currentComponent = null;
    protected DevicePanelComponent selectedComponent = null;
    protected JPopupMenu currentPopupMenu = null;
    protected EmulationalListener emulationalListener = null;
    protected ActionMap actionMap = null;
    protected InputMap inputMap = null;
    private boolean isComposeFrame = false;
    protected KeyConfigure keyConfigure = null;
    private boolean isEndTaskCalled = false;
    private ExtentFirstToLastAction extentFirstToLastAction = new ExtentFirstToLastAction();
    private ReleasedAction releasedAction = new ReleasedAction();
    private ExtentLastToFirstAction extentLastToFirstAction = new ExtentLastToFirstAction();
    private DepthHightToLower depthHightToLower = new DepthHightToLower();
    private DepthLowerToHight depthLowerToHight = new DepthLowerToHight();
    private CallPopupMenu callPopupMenu = new CallPopupMenu();
    private HashMap valueToActionMap = new HashMap(11);
    private boolean isDoubleClick = false;
    private MouseEvent lastReleaseMouseEvent = null;
    private JPopupMenu devicePanelPopupMenu = null;
    private boolean isMouseDragged = false;
    private IviewUtilTimer timer = null;
    private final int SCROLBAR_INCREMENT = 25;

    DrawingPanel(DevicePanelComponent devicePanelComponent, DevicePanel devicePanel) {
        PopupMenuResponseObjectPair popupMenuResponseObjectPair;
        this.container = devicePanelComponent;
        this.devicePanel = devicePanel;
        int n = devicePanelComponent.getWidth();
        int n2 = devicePanelComponent.getHeight();
        if (devicePanelComponent instanceof Frame) {
            n2 = devicePanelComponent.getHeight() + ((Frame)devicePanelComponent).getAreaHeight();
        }
        logger.debug("creat a new DrawingPanel:w=[" + n + "] h=[" + n2 + ']');
        this.drawingImage = new BufferedImage(n + 5, n2 + 10, 2);
        this.actionMap = this.getActionMap();
        this.inputMap = this.getInputMap(0);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        ToolTipManager.sharedInstance().registerComponent(this);
        if (devicePanel.getModel().getConfigureUtilities().getKeyConfigure() == null) {
            this.initKeyEvent();
        } else {
            this.keyConfigure = devicePanel.getModel().getConfigureUtilities().getKeyConfigure();
            this.initConfigureKeyEvent(this.keyConfigure);
        }
        String string = devicePanel.getModel().getConfigureUtilities().getDevicePanelPopName();
        if (string != null && null != (popupMenuResponseObjectPair = devicePanel.getModel().getConfigureUtilities().getPopupMenuResponseObjectPair(string))) {
            this.devicePanelPopupMenu = popupMenuResponseObjectPair.getPopupMenu(devicePanel);
        }
    }

    protected void reinit(DevicePanelComponent devicePanelComponent, DevicePanel devicePanel) {
        this.container = null;
        this.container = devicePanelComponent;
        this.selectedComponent = null;
        this.currentComponent = null;
        this.lastReleaseMouseEvent = null;
        if (this.devicePanel != devicePanel) {
            this.devicePanel = null;
            this.devicePanel = devicePanel;
        }
        this.isEndTaskCalled = false;
    }

    private void initActionMap() {
        this.valueToActionMap.put("0", this.extentFirstToLastAction);
        this.valueToActionMap.put("1", this.extentLastToFirstAction);
        this.valueToActionMap.put("2", this.depthHightToLower);
        this.valueToActionMap.put("3", this.depthLowerToHight);
        this.valueToActionMap.put("4", this.callPopupMenu);
        this.valueToActionMap.put("5", this.releasedAction);
    }

    private void initConfigureKeyEvent(KeyConfigure keyConfigure) {
        if (keyConfigure == null) {
            this.initKeyEvent();
        } else {
            this.initActionMap();
            HashMap hashMap = keyConfigure.getKeyStrokeHashMap();
            HashMap hashMap2 = keyConfigure.getKeyName();
            int n = 0;
            int n2 = 5;
            while (n < 5) {
                KeyStroke keyStroke = (KeyStroke)hashMap.get(String.valueOf(n));
                KeyStroke keyStroke2 = (KeyStroke)hashMap.get(String.valueOf(n2));
                String string = hashMap2.get(String.valueOf(n)) + "keyReleased";
                String string2 = hashMap2.get(String.valueOf(n)) + "keyPressed";
                this.inputMap.put(keyStroke, string2);
                this.inputMap.put(keyStroke2, string);
                this.actionMap.put(string, (AbstractAction)this.valueToActionMap.get(String.valueOf(5)));
                this.actionMap.put(string2, (AbstractAction)this.valueToActionMap.get(String.valueOf(n)));
                ++n;
                ++n2;
            }
        }
    }

    public Graphics2D getDrawingGraphics() {
        return this.drawingImage.createGraphics();
    }

    private void initKeyEvent() {
        this.inputMap.put(KeyStroke.getKeyStroke(39, 0, false), "rightPressed");
        this.inputMap.put(KeyStroke.getKeyStroke(39, 0, true), "rightReleased");
        this.actionMap.put("rightPressed", this.extentFirstToLastAction);
        this.inputMap.put(KeyStroke.getKeyStroke(37, 0, false), "lefttPressed");
        this.inputMap.put(KeyStroke.getKeyStroke(37, 0, true), "leftReleased");
        this.actionMap.put("lefttPressed", this.extentLastToFirstAction);
        this.inputMap.put(KeyStroke.getKeyStroke(40, 0, false), "downPressed");
        this.inputMap.put(KeyStroke.getKeyStroke(40, 0, true), "downReleased");
        this.actionMap.put("downPressed", this.depthHightToLower);
        this.actionMap.put("downReleased", this.releasedAction);
        this.inputMap.put(KeyStroke.getKeyStroke(38, 0, false), "upPressed");
        this.inputMap.put(KeyStroke.getKeyStroke(38, 0, true), "upReleased");
        this.actionMap.put("upPressed", this.depthLowerToHight);
        this.actionMap.put("upReleased", this.releasedAction);
        this.inputMap.put(KeyStroke.getKeyStroke(10, 0, false), "enterPressed");
        this.inputMap.put(KeyStroke.getKeyStroke(10, 0, true), "enterReleased");
        this.actionMap.put("enterPressed", this.callPopupMenu);
        this.actionMap.put("enterReleased", this.releasedAction);
    }

    DevicePanelComponent getContainer() {
        return this.container;
    }

    DevicePanelComponent getSelectedComponent() {
        return this.selectedComponent;
    }

    void setSelectedComponent(DevicePanelComponent devicePanelComponent) {
        this.selectedComponent = devicePanelComponent;
    }

    void repaintAgain() {
        Graphics2D graphics2D = this.getDrawingGraphics();
        this.container.draw(graphics2D);
        if (this.selectedComponent != null && this.selectedComponent.isInCurrentPage()) {
            this.selectedComponent.setIsSelected(true);
            this.selectedComponent.selectedShapedDraw(graphics2D);
        }
        if (this.currentPopupMenu != null) {
            CommonUtil.hidePopupMenu(this.currentPopupMenu);
            this.currentPopupMenu = null;
        }
        graphics2D.dispose();
        this.repaint();
    }

    void endTask() {
        this.isEndTaskCalled = true;
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        if (this.actionMap != null) {
            this.actionMap.clear();
        }
        if (this.inputMap != null) {
            this.inputMap.clear();
        }
        this.actionMap = null;
        this.inputMap = null;
        if (this.valueToActionMap != null) {
            this.valueToActionMap.clear();
        }
        this.valueToActionMap = null;
        this.keyConfigure = null;
        this.devicePanel = null;
        this.container = null;
        this.currentComponent = null;
        this.selectedComponent = null;
        if (this.currentPopupMenu != null && this.currentPopupMenu.isVisible()) {
            CommonUtil.hidePopupMenu(this.currentPopupMenu);
        }
        this.currentPopupMenu = null;
        ToolTipManager.sharedInstance().unregisterComponent(this);
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.drawImage(this.drawingImage, 0, 0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (null == this.container || this.isEndTaskCalled) {
            return;
        }
        if (mouseEvent.getModifiers() == 16 && this.currentPopupMenu != null) {
            JPopupMenu jPopupMenu = this.currentPopupMenu;
            synchronized (jPopupMenu) {
                this.currentPopupMenu.setVisible(false);
                this.isDoubleClick = true;
            }
        }
        this.currentComponent = this.container.matchCurrentComponent(mouseEvent.getX(), mouseEvent.getY());
        if (mouseEvent.getModifiers() == 16 && this.currentComponent != null) {
            if (this.devicePanel.getClickable() == null) {
                return;
            }
            int n = mouseEvent.getClickCount() % 2;
            if (n == 0) {
                this.devicePanel.getClickable().doubleClick(this.currentComponent);
                if (this.devicePanel.getClickable() instanceof ClickableEx) {
                    ((ClickableEx)this.devicePanel.getClickable()).doubleClick(this.currentComponent, mouseEvent);
                }
            } else if (n == 1) {
                this.devicePanel.getClickable().click(this.currentComponent);
                if (this.devicePanel.getClickable() instanceof ClickableEx) {
                    ((ClickableEx)this.devicePanel.getClickable()).click(this.currentComponent, mouseEvent);
                }
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        EnvironmentItem environmentItem;
        if (null == this.container) {
            return;
        }
        this.currentComponent = this.container.matchCurrentComponent(mouseEvent.getX(), mouseEvent.getY());
        if (this.currentComponent == null) {
            return;
        }
        if (!this.currentComponent.isSelectable()) {
            return;
        }
        Graphics2D graphics2D = this.getDrawingGraphics();
        if (this.currentComponent instanceof FansEnvironmentItem && this.selectedComponent == this.currentComponent) {
            environmentItem = (FansEnvironmentItem)this.currentComponent;
            if (!((FansEnvironmentItem)environmentItem).isInArea(mouseEvent.getX(), mouseEvent.getY())) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)environmentItem.getRelatedTreeNode().getParent();
                this.currentComponent = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
                this.selectedComponent.draw(graphics2D);
                this.progressSelectedComponent(graphics2D);
            }
        } else if (this.currentComponent instanceof PowerShelf && this.selectedComponent == this.currentComponent) {
            environmentItem = (PowerShelf)this.currentComponent;
            if (((PowerShelf)environmentItem).isInPower(mouseEvent.getX(), mouseEvent.getY())) {
                ((PowerShelf)environmentItem).setPowerSelected(true);
                ((PowerShelf)environmentItem).selectedShapedDraw(graphics2D);
            } else {
                ((PowerShelf)environmentItem).setPowerSelected(false);
                ((PowerShelf)environmentItem).selectedShapedDraw(graphics2D);
            }
        }
        if (this.selectedComponent != this.currentComponent) {
            if (this.selectedComponent != null) {
                this.selectedComponent.draw(graphics2D);
            }
            if (this.currentComponent instanceof FansEnvironmentItem) {
                environmentItem = (FansEnvironmentItem)this.currentComponent;
                if (((FansEnvironmentItem)environmentItem).isInArea(mouseEvent.getX(), mouseEvent.getY())) {
                    this.progressSelectedComponent(graphics2D);
                } else {
                    defaultMutableTreeNode = (DefaultMutableTreeNode)environmentItem.getRelatedTreeNode().getParent();
                    this.currentComponent = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
                    this.progressSelectedComponent(graphics2D);
                }
            } else if (this.currentComponent instanceof PowerShelf) {
                environmentItem = (PowerShelf)this.currentComponent;
                if (((PowerShelf)environmentItem).isInPower(mouseEvent.getX(), mouseEvent.getY())) {
                    ((PowerShelf)environmentItem).setPowerSelected(true);
                    ((PowerShelf)environmentItem).selectedShapedDraw(graphics2D);
                    this.selectedComponent = this.currentComponent;
                    this.selectedComponent.setIsSelected(true);
                } else {
                    ((PowerShelf)environmentItem).setPowerSelected(false);
                    this.progressSelectedComponent(graphics2D);
                }
            } else {
                this.progressSelectedComponent(graphics2D);
            }
            this.container.draw(graphics2D);
        }
        graphics2D.dispose();
        this.requestFocus();
    }

    protected void progressSelectedComponent(Graphics2D graphics2D) {
        this.selectedComponent = this.currentComponent;
        this.selectedComponent.setIsSelected(true);
        this.selectedComponent.selectedShapedDraw(graphics2D);
    }

    @Override
    public void mouseReleased(final MouseEvent mouseEvent) {
        Object object;
        this.lastReleaseMouseEvent = mouseEvent;
        if (null == this.container) {
            return;
        }
        this.currentComponent = this.container.matchCurrentComponent(mouseEvent.getX(), mouseEvent.getY());
        if (this.currentComponent == null) {
            if (mouseEvent.getSource() == this && SwingUtilities.isRightMouseButton(mouseEvent) && mouseEvent.getClickCount() == 1) {
                this.showDrawingPanelPopupMenu(mouseEvent.getX(), mouseEvent.getY());
            }
            return;
        }
        if (!this.currentComponent.isSelectable()) {
            return;
        }
        Graphics2D graphics2D = this.getDrawingGraphics();
        if (this.selectedComponent != null && this.selectedComponent != this.currentComponent && this.selectedComponent.isInCurrentPage()) {
            this.selectedComponent.draw(graphics2D);
        }
        if (this.currentComponent != null) {
            EnvironmentItem environmentItem;
            if (this.currentComponent instanceof FansEnvironmentItem) {
                environmentItem = (FansEnvironmentItem)this.currentComponent;
                if (((FansEnvironmentItem)environmentItem).isInArea(mouseEvent.getX(), mouseEvent.getY())) {
                    this.progressSelectedComponent(graphics2D);
                } else {
                    object = (DefaultMutableTreeNode)environmentItem.getRelatedTreeNode().getParent();
                    this.currentComponent = (DevicePanelComponent)((DefaultMutableTreeNode)object).getUserObject();
                    if (this.selectedComponent == this.currentComponent) {
                        this.selectedComponent.draw(graphics2D);
                    }
                    this.progressSelectedComponent(graphics2D);
                }
            } else if (this.currentComponent instanceof PowerShelf) {
                environmentItem = (PowerShelf)this.currentComponent;
                if (((PowerShelf)environmentItem).isInPower(mouseEvent.getX(), mouseEvent.getY())) {
                    ((PowerShelf)environmentItem).setPowerSelected(true);
                    ((PowerShelf)environmentItem).selectedShapedDraw(graphics2D);
                    this.selectedComponent = this.currentComponent;
                    this.selectedComponent.setIsSelected(true);
                } else {
                    ((PowerShelf)environmentItem).setPowerSelected(false);
                    this.progressSelectedComponent(graphics2D);
                }
            } else {
                this.progressSelectedComponent(graphics2D);
            }
        }
        graphics2D.dispose();
        this.repaint();
        this.isDoubleClick = false;
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            int n = 0;
            if (this.devicePanel.getClickable() != null && this.devicePanel.getClickable() instanceof ClickableEx) {
                n = ((ClickableEx)this.devicePanel.getClickable()).getDoubleClickTime();
            }
            if (null == this.timer) {
                this.timer = new IviewUtilTimer();
            }
            if (n > 0) {
                object = new IviewTimerTask(){

                    @Override
                    public void run() {
                        if (!DrawingPanel.this.isEndTaskCalled) {
                            DrawingPanel.this.progressRightClick(mouseEvent);
                        }
                    }
                };
                this.timer.schedule((IviewTimerTask)object, n);
            } else {
                this.progressRightClick(mouseEvent);
            }
        }
        if ((SwingUtilities.isRightMouseButton(mouseEvent) || this.isMouseDragged) && this.devicePanel.getClickable() != null && this.selectedComponent != null) {
            this.isMouseDragged = false;
            try {
                if (mouseEvent.getClickCount() == 1) {
                    this.devicePanel.getClickable().click(this.selectedComponent);
                    if (this.devicePanel.getClickable() instanceof ClickableEx) {
                        ((ClickableEx)this.devicePanel.getClickable()).click(this.currentComponent, mouseEvent);
                    }
                } else if (mouseEvent.getClickCount() == 2) {
                    this.isDoubleClick = true;
                    this.devicePanel.getClickable().doubleClick(this.selectedComponent);
                    if (this.devicePanel.getClickable() instanceof ClickableEx) {
                        ((ClickableEx)this.devicePanel.getClickable()).doubleClick(this.currentComponent, mouseEvent);
                    }
                }
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
        }
    }

    protected void progressRightClick(final MouseEvent mouseEvent) {
        if (null == this.container) {
            return;
        }
        DevicePanelComponent devicePanelComponent = this.container.matchCurrentComponent(this.lastReleaseMouseEvent.getX(), this.lastReleaseMouseEvent.getY());
        if (!this.isDoubleClick && SwingUtilities.isRightMouseButton(mouseEvent) && mouseEvent.getClickCount() == 1 && devicePanelComponent.isPopupMenuAllowed(mouseEvent.getX(), mouseEvent.getY())) {
            this.currentPopupMenu = this.isComposeFrame ? this.getComposePopupMenu(this.devicePanel, devicePanelComponent) : this.getNormalPopupMenu(this.devicePanel, devicePanelComponent);
            if (this.currentPopupMenu != null && this.lastReleaseMouseEvent == mouseEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        JPopupMenu jPopupMenu = DrawingPanel.this.currentPopupMenu;
                        synchronized (jPopupMenu) {
                            if (!DrawingPanel.this.isDoubleClick) {
                                if (DrawingPanel.this.hasFocus()) {
                                    DrawingPanel.this.currentPopupMenu.show(DrawingPanel.this, mouseEvent.getX(), mouseEvent.getY());
                                } else {
                                    logger.debug("Drawing panel does not contain focus.");
                                }
                            }
                        }
                    }
                });
            }
        }
    }

    protected void showDrawingPanelPopupMenu(int n, int n2) {
        if (this.devicePanel.getPopupMenu() != null) {
            this.devicePanel.getPopupMenu().show(this, n, n2);
        } else if (this.devicePanelPopupMenu != null) {
            this.devicePanelPopupMenu.show(this, n, n2);
        }
    }

    protected void showPopupMenu(int n, int n2) {
        PopupMenuResponseObjectPair popupMenuResponseObjectPair = this.devicePanel.getModel().getConfigureUtilities().getPopupMenuResponseObjectPair(this.selectedComponent.getPopupMenuReferrenceName());
        if (this.selectedComponent.getPopupMenuReferrenceName() == null) {
            return;
        }
        if (popupMenuResponseObjectPair != null) {
            if (this.devicePanel.getPopupMenuAuthorization() != null) {
                this.currentPopupMenu = this.devicePanel.getPopupMenuAuthorization().authorizePopupMenu(popupMenuResponseObjectPair.getPopupMenu(this.currentComponent), popupMenuResponseObjectPair.getActionListener(), this.selectedComponent);
            }
            if (this.devicePanel.getPopupMenuAuthorization() == null) {
                this.currentPopupMenu = popupMenuResponseObjectPair.getPopupMenu(this.currentComponent);
            }
        } else if (this.devicePanel.getPopupMenuAuthorization() != null) {
            this.currentPopupMenu = this.devicePanel.getPopupMenuAuthorization().authorizePopupMenu(null, null, this.selectedComponent);
        }
        if (this.currentPopupMenu != null) {
            this.currentPopupMenu.show(this, n, n2);
        }
    }

    private JPopupMenu getNormalPopupMenu(DevicePanel devicePanel, DevicePanelComponent devicePanelComponent) {
        JPopupMenu jPopupMenu = null;
        PopupMenuResponseObjectPair popupMenuResponseObjectPair = devicePanel.getModel().getConfigureUtilities().getPopupMenuResponseObjectPair(devicePanelComponent.getPopupMenuReferrenceName());
        if (popupMenuResponseObjectPair != null) {
            jPopupMenu = devicePanel.getPopupMenuAuthorization() != null ? devicePanel.getPopupMenuAuthorization().authorizePopupMenu(popupMenuResponseObjectPair.getPopupMenu(devicePanelComponent), popupMenuResponseObjectPair.getActionListener(), devicePanelComponent) : popupMenuResponseObjectPair.getPopupMenu(devicePanelComponent);
        } else if (devicePanel.getPopupMenuAuthorization() != null) {
            jPopupMenu = devicePanel.getPopupMenuAuthorization().authorizePopupMenu(null, null, devicePanelComponent);
        }
        return jPopupMenu;
    }

    private JPopupMenu getPopupMenuPair(DevicePanel devicePanel, DevicePanelComponent devicePanelComponent, String string, int n, boolean bl) {
        JPopupMenu jPopupMenu = null;
        PopupMenuResponseObjectPair popupMenuResponseObjectPair = ((ComposeFrameModel)devicePanel.getModel()).getConfigureUtilities(devicePanelComponent.subFrameNo, n).getPopupMenuResponseObjectPair(string);
        if (popupMenuResponseObjectPair != null) {
            JPopupMenu jPopupMenu2 = null;
            jPopupMenu2 = bl ? popupMenuResponseObjectPair.getClonePopupMenu(devicePanelComponent, n) : popupMenuResponseObjectPair.getPopupMenu(devicePanelComponent);
            ComposeFrameModel composeFrameModel = (ComposeFrameModel)devicePanel.getModel();
            PopupMenuAuthorization popupMenuAuthorization = composeFrameModel.getPopupMenuAuthorization(devicePanelComponent.subFrameNo, devicePanelComponent.devicePanelIndex);
            jPopupMenu = popupMenuAuthorization != null ? popupMenuAuthorization.authorizePopupMenu(jPopupMenu2, popupMenuResponseObjectPair.getActionListener(), devicePanelComponent) : jPopupMenu2;
        }
        return jPopupMenu;
    }

    private JPopupMenu getComposePopupMenu(DevicePanel devicePanel, DevicePanelComponent devicePanelComponent) {
        JPopupMenu jPopupMenu = null;
        String string = devicePanelComponent.getPopupMenuReferrenceName();
        if (string != null && string.indexOf("+") != -1) {
            JMenu[] jMenuArray;
            jPopupMenu = new JPopupMenu();
            String string2 = "menu1";
            String string3 = "menu2";
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)devicePanelComponent.getRelatedTreeNode().getParent();
            DevicePanelComponent devicePanelComponent2 = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
            if (devicePanelComponent2 instanceof Shelf && (jMenuArray = ((Shelf)devicePanelComponent2).getShelfName()) != null && jMenuArray.indexOf("+") != -1) {
                string2 = jMenuArray.substring(0, jMenuArray.indexOf("+"));
                string3 = jMenuArray.substring(jMenuArray.indexOf("+") + 1);
            }
            jMenuArray = new JMenu[]{new JMenu(string2), new JMenu(string3)};
            StringTokenizer stringTokenizer = new StringTokenizer(string, "+");
            int n = 0;
            JPopupMenu jPopupMenu2 = null;
            if (devicePanelComponent instanceof DoubleCard && ((DoubleCard)devicePanelComponent).getInitFirstCard() != null && ((DoubleCard)devicePanelComponent).getInitSecondCard() != null) {
                JPopupMenu[] jPopupMenuArray = new JPopupMenu[]{this.getPopupMenuPair(devicePanel, ((DoubleCard)devicePanelComponent).getInitFirstCard(), stringTokenizer.nextToken(), 0, true), this.getPopupMenuPair(devicePanel, ((DoubleCard)devicePanelComponent).getInitSecondCard(), stringTokenizer.nextToken(), 1, true)};
                for (int i = 0; i < jPopupMenuArray.length; ++i) {
                    if (jPopupMenuArray[i] == null) continue;
                    Component[] componentArray = jPopupMenuArray[i].getComponents();
                    for (int j = 0; j < componentArray.length; ++j) {
                        jMenuArray[i].add(componentArray[j]);
                    }
                    jPopupMenu.add(jMenuArray[i]);
                }
            } else if (devicePanelComponent instanceof ComposeEnvironmentItem && ((ComposeEnvironmentItem)devicePanelComponent).getInitFirstEnvironmentItem() != null && ((ComposeEnvironmentItem)devicePanelComponent).getInitSecondEnvironmentItem() != null) {
                JPopupMenu[] jPopupMenuArray = new JPopupMenu[]{this.getPopupMenuPair(devicePanel, ((ComposeEnvironmentItem)devicePanelComponent).getInitFirstEnvironmentItem(), stringTokenizer.nextToken(), 0, true), this.getPopupMenuPair(devicePanel, ((ComposeEnvironmentItem)devicePanelComponent).getInitSecondEnvironmentItem(), stringTokenizer.nextToken(), 1, true)};
                for (int i = 0; i < jPopupMenuArray.length; ++i) {
                    if (jPopupMenuArray[i] == null) continue;
                    Component[] componentArray = jPopupMenuArray[i].getComponents();
                    for (int j = 0; j < componentArray.length; ++j) {
                        jMenuArray[i].add(componentArray[j]);
                    }
                    jPopupMenu.add(jMenuArray[i]);
                }
            } else {
                while (stringTokenizer.hasMoreTokens()) {
                    jPopupMenu2 = this.getPopupMenuPair(devicePanel, devicePanelComponent, stringTokenizer.nextToken(), n, true);
                    if (jPopupMenu2 != null) {
                        MenuElement[] menuElementArray = jPopupMenu2.getSubElements();
                        for (int i = 0; i < menuElementArray.length; ++i) {
                            jMenuArray[n].add(menuElementArray[i].getComponent());
                        }
                        jPopupMenu.add(jMenuArray[n]);
                    }
                    ++n;
                }
            }
        } else if (devicePanelComponent.subFrameNo > 0 && !(devicePanelComponent instanceof EmptyShelf)) {
            jPopupMenu = this.getPopupMenuPair(devicePanel, devicePanelComponent, string, devicePanelComponent.devicePanelIndex, false);
        }
        if ((devicePanelComponent instanceof Shelf || devicePanelComponent instanceof EmptyShelf || devicePanelComponent instanceof Frame) && devicePanel.getPopupMenuAuthorization() != null) {
            jPopupMenu = devicePanel.getPopupMenuAuthorization().authorizePopupMenu(jPopupMenu, null, devicePanelComponent);
        }
        return jPopupMenu;
    }

    public void setIsComposeFrame(boolean bl) {
        this.isComposeFrame = bl;
    }

    public boolean getIsComposeFrame() {
        return this.isComposeFrame;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        DevicePanelComponent devicePanelComponent = this.currentComponent;
        if (this.container == null) {
            return;
        }
        this.currentComponent = this.container.matchCurrentComponent(mouseEvent.getX(), mouseEvent.getY());
        if (this.currentComponent == null) {
            this.resetTooltipManager();
            this.setToolTipText(null);
            return;
        }
        if (devicePanelComponent != this.currentComponent) {
            String string = this.currentComponent.getToolTipText();
            if (string != null && !"".equals(string)) {
                String string2 = this.getToolTipText();
                if (ResourceUtil.areEquals(string, string2)) {
                    this.resetTooltipManager();
                }
                this.setToolTipText(string);
            } else {
                this.resetTooltipManager();
                this.setToolTipText(null);
            }
        }
    }

    private void resetTooltipManager() {
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.setEnabled(false);
        toolTipManager.setEnabled(true);
    }

    @Override
    public JToolTip createToolTip() {
        MultiRowToolTip multiRowToolTip = new MultiRowToolTip();
        multiRowToolTip.setComponent(this);
        return multiRowToolTip;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.isMouseDragged = true;
    }

    protected void keepOneSelected() {
    }

    protected void extentFirstToLast() {
        if (this.container == null) {
            return;
        }
        Graphics2D graphics2D = this.getDrawingGraphics();
        if (this.container instanceof Frame && this.selectedComponent == null) {
            this.currentComponent = this.container.getFirstSelectableChild();
        } else if (this.container instanceof Shelf && this.selectedComponent == null) {
            this.currentComponent = this.container;
        } else if (this.selectedComponent instanceof Shelf && DevicePanelComponent.isOpenEmulational) {
            this.currentComponent = this.selectedComponent;
        } else {
            this.currentComponent = this.selectedComponent.getNextSelectableComponent();
            if (this.currentComponent instanceof Frame && this.currentComponent != this.selectedComponent) {
                JScrollPane jScrollPane = this.devicePanel.getScrollDrawingPanel(this.currentComponent);
                JTabbedPane jTabbedPane = (JTabbedPane)jScrollPane.getParent();
                jTabbedPane.setSelectedComponent(jScrollPane);
                this.currentComponent.draw(graphics2D);
                this.currentComponent.setIsSelected(true);
                this.currentComponent.selectedShapedDraw(graphics2D);
                graphics2D.dispose();
                this.keepOneSelected();
                return;
            }
            if (this.currentComponent instanceof TemperatureEnvironmentItem) {
                this.currentComponent = this.currentComponent.getNextSelectableComponent();
            }
            if (this.currentComponent instanceof EmptyComponent) {
                DevicePanelComponent devicePanelComponent = this.currentComponent.getNextSelectableComponent();
                if (!((EmptyComponent)this.currentComponent).isVisibleAllowed()) {
                    this.currentComponent = devicePanelComponent;
                    if (this.currentComponent instanceof EmptyComponent && !((EmptyComponent)this.currentComponent).isVisibleAllowed() || this.currentComponent instanceof TemperatureEnvironmentItem) {
                        int n;
                        DefaultMutableTreeNode defaultMutableTreeNode = this.currentComponent.getRelatedTreeNode();
                        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                        for (n = defaultMutableTreeNode2.getChildCount(); !(n <= 0 || (devicePanelComponent = this.currentComponent.getNextSelectableComponent()) instanceof EmptyComponent && ((EmptyComponent)devicePanelComponent).isVisibleAllowed() || !(devicePanelComponent instanceof EmptyComponent) && !(devicePanelComponent instanceof TemperatureEnvironmentItem)); --n) {
                            this.currentComponent = devicePanelComponent;
                        }
                        if (n == 0) {
                            this.currentComponent = this.selectedComponent;
                            this.keepOneSelected();
                            return;
                        }
                        this.currentComponent = devicePanelComponent;
                    }
                }
                if (devicePanelComponent instanceof Card && ((Card)devicePanelComponent).getOccupiedTwoSlots()) {
                    this.currentComponent = devicePanelComponent;
                }
            }
            this.selectedComponent.draw(graphics2D);
        }
        if (null == this.currentComponent || !this.currentComponent.isSelectable()) {
            return;
        }
        this.selectedComponent = this.currentComponent;
        this.selectedComponent.setIsSelected(true);
        this.selectedComponent.selectedShapedDraw(graphics2D);
        this.container.draw(graphics2D);
        graphics2D.dispose();
        this.keepOneSelected();
    }

    protected void keyReleased() {
        if (null == this.selectedComponent) {
            return;
        }
        Graphics2D graphics2D = this.getDrawingGraphics();
        this.selectedComponent.setIsSelected(true);
        this.selectedComponent.selectedShapedDraw(graphics2D);
        this.repaint();
        graphics2D.dispose();
        if (this.devicePanel.getClickable() != null) {
            this.devicePanel.getClickable().click(this.selectedComponent);
            if (this.devicePanel.getClickable() instanceof ClickableEx) {
                ((ClickableEx)this.devicePanel.getClickable()).click(this.currentComponent, null);
            }
        }
    }

    protected void extentLastToFirst() {
        if (this.container == null) {
            return;
        }
        Graphics2D graphics2D = this.getDrawingGraphics();
        if (this.container instanceof Frame && this.selectedComponent == null) {
            this.currentComponent = this.container.getFirstSelectableChild();
        } else if (this.container instanceof Shelf && this.selectedComponent == null) {
            this.currentComponent = this.container;
        } else if (this.selectedComponent instanceof Shelf && DevicePanelComponent.isOpenEmulational) {
            this.currentComponent = this.selectedComponent;
        } else {
            this.currentComponent = this.selectedComponent.getPreviousSelectableComponent();
            if (this.currentComponent instanceof Frame && this.currentComponent != this.selectedComponent) {
                JScrollPane jScrollPane = this.devicePanel.getScrollDrawingPanel(this.currentComponent);
                JTabbedPane jTabbedPane = (JTabbedPane)jScrollPane.getParent();
                jTabbedPane.setSelectedComponent(jScrollPane);
                this.currentComponent.draw(graphics2D);
                this.currentComponent.setIsSelected(true);
                this.currentComponent.selectedShapedDraw(graphics2D);
                graphics2D.dispose();
                this.keepOneSelected();
                return;
            }
            if (this.currentComponent instanceof TemperatureEnvironmentItem) {
                this.currentComponent = this.currentComponent.getPreviousSelectableComponent();
            }
            if (this.currentComponent instanceof EmptyComponent) {
                DevicePanelComponent devicePanelComponent = this.currentComponent.getPreviousSelectableComponent();
                if (!((EmptyComponent)this.currentComponent).isVisibleAllowed()) {
                    this.currentComponent = devicePanelComponent;
                    if (this.currentComponent instanceof EmptyComponent && !((EmptyComponent)this.currentComponent).isVisibleAllowed() || this.currentComponent instanceof TemperatureEnvironmentItem) {
                        int n;
                        DefaultMutableTreeNode defaultMutableTreeNode = this.currentComponent.getRelatedTreeNode();
                        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                        for (n = defaultMutableTreeNode2.getChildCount(); !(n <= 0 || (devicePanelComponent = this.currentComponent.getPreviousSelectableComponent()) instanceof EmptyComponent && ((EmptyComponent)devicePanelComponent).isVisibleAllowed() || !(devicePanelComponent instanceof EmptyComponent) && !(devicePanelComponent instanceof TemperatureEnvironmentItem)); --n) {
                            this.currentComponent = devicePanelComponent;
                        }
                        if (n == 0) {
                            this.currentComponent = this.selectedComponent;
                            this.keepOneSelected();
                            return;
                        }
                        this.currentComponent = devicePanelComponent;
                    }
                }
            }
            this.selectedComponent.draw(graphics2D);
        }
        if (null == this.currentComponent || !this.currentComponent.isSelectable()) {
            return;
        }
        this.selectedComponent = this.currentComponent;
        this.selectedComponent.setIsSelected(true);
        this.selectedComponent.selectedShapedDraw(graphics2D);
        this.container.draw(graphics2D);
        graphics2D.dispose();
        this.keepOneSelected();
    }

    protected void DepthHightToLower() {
        if (this.container == null) {
            return;
        }
        Graphics2D graphics2D = this.getDrawingGraphics();
        if (this.selectedComponent == null) {
            this.currentComponent = this.container;
            if (!this.currentComponent.isSelectable()) {
                return;
            }
        } else {
            this.currentComponent = this.selectedComponent.getFirstSelectableChild();
            if (null == this.currentComponent) {
                this.currentComponent = this.selectedComponent;
                this.keepOneSelected();
                return;
            }
            if (this.currentComponent instanceof TemperatureEnvironmentItem) {
                this.currentComponent = this.currentComponent.getNextSelectableComponent();
            }
            if (this.currentComponent instanceof EmptyComponent) {
                DevicePanelComponent devicePanelComponent = this.currentComponent.getNextSelectableComponent();
                if (!((EmptyComponent)this.currentComponent).isVisibleAllowed()) {
                    this.currentComponent = devicePanelComponent;
                    if (this.currentComponent instanceof EmptyComponent && !((EmptyComponent)this.currentComponent).isVisibleAllowed()) {
                        int n;
                        DefaultMutableTreeNode defaultMutableTreeNode = this.selectedComponent.getRelatedTreeNode();
                        for (n = defaultMutableTreeNode.getChildCount(); !(n <= 0 || (devicePanelComponent = this.currentComponent.getNextSelectableComponent()) instanceof EmptyComponent && ((EmptyComponent)devicePanelComponent).isVisibleAllowed() || !(devicePanelComponent instanceof EmptyComponent) && !(devicePanelComponent instanceof TemperatureEnvironmentItem)); --n) {
                            this.currentComponent = devicePanelComponent;
                        }
                        if (n == 0) {
                            this.currentComponent = this.selectedComponent;
                            this.keepOneSelected();
                            return;
                        }
                        this.currentComponent = devicePanelComponent;
                    }
                }
                if (devicePanelComponent instanceof Card && ((Card)devicePanelComponent).getOccupiedTwoSlots()) {
                    this.currentComponent = devicePanelComponent;
                }
            }
            this.selectedComponent.draw(graphics2D);
        }
        this.selectedComponent = this.currentComponent;
        this.selectedComponent.setIsSelected(true);
        this.selectedComponent.selectedShapedDraw(graphics2D);
        this.container.draw(graphics2D);
        graphics2D.dispose();
        this.keepOneSelected();
    }

    protected void depthLowerToHight() {
        if (this.container == null) {
            return;
        }
        Graphics2D graphics2D = this.getDrawingGraphics();
        if (this.selectedComponent == null) {
            this.currentComponent = this.container;
            if (!this.currentComponent.isSelectable()) {
                return;
            }
        } else {
            if (this.selectedComponent == this.container) {
                this.keepOneSelected();
                return;
            }
            this.currentComponent = this.selectedComponent.getSelectableParentComponent();
            if (this.currentComponent instanceof TemperatureEnvironmentItem) {
                this.currentComponent = this.currentComponent.getSelectableParentComponent();
            }
            if (this.currentComponent instanceof EmptyComponent) {
                DevicePanelComponent devicePanelComponent = this.currentComponent.getSelectableParentComponent();
                if (!((EmptyComponent)this.currentComponent).isVisibleAllowed()) {
                    this.currentComponent = devicePanelComponent;
                    if (this.currentComponent instanceof EmptyComponent && !((EmptyComponent)this.currentComponent).isVisibleAllowed()) {
                        while (!(devicePanelComponent == null || devicePanelComponent instanceof EmptyComponent && ((EmptyComponent)devicePanelComponent).isVisibleAllowed() || !(devicePanelComponent instanceof EmptyComponent) && !(devicePanelComponent instanceof TemperatureEnvironmentItem))) {
                            devicePanelComponent = this.currentComponent.getSelectableParentComponent();
                        }
                        if (devicePanelComponent == null) {
                            this.currentComponent = this.selectedComponent;
                            this.keepOneSelected();
                            return;
                        }
                        this.currentComponent = devicePanelComponent;
                    }
                }
                if (devicePanelComponent instanceof Card && ((Card)devicePanelComponent).getOccupiedTwoSlots()) {
                    this.currentComponent = devicePanelComponent;
                }
            }
            this.selectedComponent.draw(graphics2D);
        }
        if (null != this.selectedComponent) {
            this.selectedComponent = this.currentComponent;
            this.selectedComponent.setIsSelected(true);
            this.selectedComponent.selectedShapedDraw(graphics2D);
        }
        this.container.draw(graphics2D);
        graphics2D.dispose();
        this.keepOneSelected();
    }

    public void setDevicePanelPopupMenu(JPopupMenu jPopupMenu) {
        this.devicePanelPopupMenu = jPopupMenu;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return 25;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 25;
    }

    protected class DepthLowerToHight
    extends AbstractAction {
        protected DepthLowerToHight() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DrawingPanel.this.depthLowerToHight();
        }
    }

    protected class CallPopupMenu
    extends AbstractAction {
        protected CallPopupMenu() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (DrawingPanel.this.selectedComponent == null) {
                return;
            }
            DrawingPanel.this.currentComponent = DrawingPanel.this.selectedComponent;
            int n = 0;
            int n2 = 0;
            if (DrawingPanel.this.selectedComponent instanceof Shelf || DrawingPanel.this.selectedComponent instanceof Frame || DrawingPanel.this.selectedComponent instanceof EmptyShelf) {
                n = DrawingPanel.this.selectedComponent.bound.x + 5;
                n2 = DrawingPanel.this.selectedComponent.bound.y + DrawingPanel.this.selectedComponent.bound.height / 4;
            } else {
                n = DrawingPanel.this.selectedComponent.bound.x + DrawingPanel.this.selectedComponent.bound.width / 4;
                n2 = DrawingPanel.this.selectedComponent.bound.y + DrawingPanel.this.selectedComponent.bound.height / 4;
            }
            if (DrawingPanel.this.devicePanel.isParentActivated()) {
                if (!DrawingPanel.this.isComposeFrame) {
                    DrawingPanel.this.showPopupMenu(n, n2);
                } else {
                    DevicePanelComponent devicePanelComponent = DrawingPanel.this.container.matchCurrentComponent(n, n2);
                    DrawingPanel.this.currentPopupMenu = DrawingPanel.this.getComposePopupMenu(DrawingPanel.this.devicePanel, devicePanelComponent);
                    DrawingPanel.this.currentPopupMenu.show(DrawingPanel.this, n, n2);
                }
            }
        }
    }

    protected class DepthHightToLower
    extends AbstractAction {
        protected DepthHightToLower() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DrawingPanel.this.DepthHightToLower();
        }
    }

    protected class ExtentLastToFirstAction
    extends AbstractAction {
        protected ExtentLastToFirstAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DrawingPanel.this.extentLastToFirst();
            DrawingPanel.this.keyReleased();
        }
    }

    protected class ReleasedAction
    extends AbstractAction {
        protected ReleasedAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DrawingPanel.this.keyReleased();
        }
    }

    protected class ExtentFirstToLastAction
    extends AbstractAction {
        protected ExtentFirstToLastAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DrawingPanel.this.extentFirstToLast();
            DrawingPanel.this.keyReleased();
        }
    }
}

