/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.devicepanel.view;

import com.swimap.iview.templates.devicepanel.model.DevicePanelTreeModel;
import com.swimap.iview.templates.devicepanel.model.ModelRefreshListener;
import com.swimap.iview.templates.devicepanel.model.component.DevicePanelComponent;
import com.swimap.iview.templates.devicepanel.view.DevicePanel;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.swing.JFrame;
import javax.swing.tree.DefaultMutableTreeNode;

public class DevicePanelEx
extends DevicePanel {
    private transient ModelRefreshListener modelRefreshListener = new ModelRefreshHandler();
    private Dimension panelSize = null;

    public DevicePanelEx(JFrame jFrame, DevicePanelTreeModel devicePanelTreeModel, Dimension dimension) {
        this(jFrame, devicePanelTreeModel, dimension, true);
    }

    public DevicePanelEx(JFrame jFrame, DevicePanelTreeModel devicePanelTreeModel, Dimension dimension, boolean bl) {
        super(jFrame, devicePanelTreeModel, dimension, true, bl);
        this.panelSize = dimension;
        this.devicePanelTreeModel.addModelRefreshListener(this.modelRefreshListener);
    }

    @Override
    public void refreshModel(DevicePanelTreeModel devicePanelTreeModel) {
        if (devicePanelTreeModel == null) {
            throw new IllegalArgumentException("The device panel tree model is null");
        }
        this.devicePanelTreeModel.removeModelChangeListener(this.modelChangeListener);
        devicePanelTreeModel.addModelChangeListener(this.modelChangeListener);
        devicePanelTreeModel.addEmulationalListener(this.emulationalListener);
        this.devicePanelTreeModel = devicePanelTreeModel;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.devicePanelTreeModel.getRoot();
        int n = defaultMutableTreeNode.getChildCount();
        if (n < 1) {
            throw new IllegalArgumentException("Data Error : device panel tree model has no frame");
        }
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            DevicePanelComponent devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode2.getUserObject();
            this.drawingPanels[i].reinit(devicePanelComponent, this.drawingPanels[i].devicePanel);
            Graphics2D graphics2D = this.drawingPanels[i].getDrawingGraphics();
            devicePanelComponent.draw(graphics2D);
            graphics2D.dispose();
            this.drawingPanels[i].repaint();
        }
    }

    private class ModelRefreshHandler
    implements ModelRefreshListener {
        private ModelRefreshHandler() {
        }

        @Override
        public void modelRefresh(DevicePanelTreeModel devicePanelTreeModel) {
            devicePanelTreeModel.getConfigureUtilities().setPanelSize(DevicePanelEx.this.panelSize);
            if (DevicePanelEx.this.legendPanel != null) {
                DevicePanelEx.this.legendPanel.refreshLegendPanel();
            }
            DevicePanelEx.this.refreshModel(devicePanelTreeModel);
        }
    }
}

