/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.devicepanel.view;

import com.swimap.iview.templates.devicepanel.model.DevicePanelTreeModel;
import com.swimap.iview.templates.devicepanel.model.PopupMenuAuthorization;
import com.swimap.iview.templates.devicepanel.model.component.DevicePanelComponent;
import com.swimap.iview.templates.devicepanel.view.Clickable;
import com.swimap.iview.templates.devicepanel.view.DevicePanel;
import com.swimap.iview.templates.devicepanel.view.LegendListener;
import com.swimap.iview.templates.devicepanel.view.ResPropertiesBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class DevicePanelDialog
extends JDialog {
    private static final int DIALOG_EXTERND_WIDTH = 34;
    private static final int DIALOG_EXTERND_HEIGHT = 33;
    private DevicePanel devicePanel = null;
    private transient WindowListener windowListener = new WindowHandler();
    private transient LegendListener legendListener = new LegendHandler();
    private transient ComponentListener componentListener = new ComponentHandler();

    public DevicePanel getDevicePanel() {
        return this.devicePanel;
    }

    public DevicePanelDialog(JFrame jFrame, DevicePanelTreeModel devicePanelTreeModel) {
        super((Frame)jFrame, ResPropertiesBundle.getInstance().getString("DeviceTitle"));
        this.getContentPane().setLayout(new BorderLayout());
        this.devicePanel = new DevicePanel(jFrame, devicePanelTreeModel);
        this.getContentPane().add((Component)this.devicePanel, "Center");
        this.addWindowListener(this.windowListener);
        this.addComponentListener(this.componentListener);
        this.devicePanel.addLegendListener(this.legendListener);
        this.decideSize();
        this.setVisible(true);
    }

    public PopupMenuAuthorization getPopupMenuAuthorization() {
        return this.devicePanel.getPopupMenuAuthorization();
    }

    public void setPopupMenuAuthorization(PopupMenuAuthorization popupMenuAuthorization) {
        this.devicePanel.setPopupMenuAuthorization(popupMenuAuthorization);
    }

    public Clickable getClickable() {
        return this.devicePanel.getClickable();
    }

    public void setClickable(Clickable clickable) {
        this.devicePanel.setClickable(clickable);
    }

    public void refreshModel(DevicePanelTreeModel devicePanelTreeModel) {
        this.devicePanel.refreshModel(devicePanelTreeModel);
    }

    public DevicePanelComponent getCurrentSelectedComponent() {
        return this.devicePanel.getCurrentSelectedComponent();
    }

    public void windowClosing() {
        this.removeWindowListener(this.windowListener);
        this.removeComponentListener(this.componentListener);
        this.devicePanel.removeLegendListener(this.legendListener);
        this.windowListener = null;
        this.componentListener = null;
        this.legendListener = null;
        this.removeAll();
        this.devicePanel.endTask();
        this.dispose();
    }

    private void decideSize() {
        Dimension dimension = this.devicePanel.getModel().getConfigureUtilities().getPanelSize();
        this.setSize(dimension.width + 34, dimension.height + 33);
    }

    private class ComponentHandler
    extends ComponentAdapter {
        private ComponentHandler() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
        }
    }

    private class LegendHandler
    implements LegendListener {
        private LegendHandler() {
        }

        @Override
        public void legendExpanding(int n) {
            ((DevicePanelDialog)DevicePanelDialog.this).devicePanel.legendPanel.setVisible(true);
        }

        @Override
        public void legendClosing(int n) {
            ((DevicePanelDialog)DevicePanelDialog.this).devicePanel.legendPanel.setVisible(false);
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            DevicePanelDialog.this.windowClosing();
        }
    }
}

