/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.devicepanel.view;

import com.swimap.iview.templates.devicepanel.DevicePanelConstants;
import com.swimap.iview.templates.devicepanel.model.DevicePanelTreeModel;
import com.swimap.iview.templates.devicepanel.model.EmulationalListener;
import com.swimap.iview.templates.devicepanel.model.ModelChangeListener;
import com.swimap.iview.templates.devicepanel.model.PopupMenuAuthorization;
import com.swimap.iview.templates.devicepanel.model.PopupMenuResponseObjectPair;
import com.swimap.iview.templates.devicepanel.model.component.BuckledCard;
import com.swimap.iview.templates.devicepanel.model.component.Card;
import com.swimap.iview.templates.devicepanel.model.component.DevicePanelComponent;
import com.swimap.iview.templates.devicepanel.model.component.DevicePanelItem;
import com.swimap.iview.templates.devicepanel.model.component.EmptyComponent;
import com.swimap.iview.templates.devicepanel.model.component.EnvironmentItem;
import com.swimap.iview.templates.devicepanel.model.component.Frame;
import com.swimap.iview.templates.devicepanel.model.component.Port;
import com.swimap.iview.templates.devicepanel.model.component.Shelf;
import com.swimap.iview.templates.devicepanel.model.component.TemperatureEnvironmentItem;
import com.swimap.iview.templates.devicepanel.view.BehindDrawingPanel;
import com.swimap.iview.templates.devicepanel.view.BehindShelfDialog;
import com.swimap.iview.templates.devicepanel.view.Clickable;
import com.swimap.iview.templates.devicepanel.view.DrawingPanel;
import com.swimap.iview.templates.devicepanel.view.EmulationalDevicePanel;
import com.swimap.iview.templates.devicepanel.view.EmulationalShelfDialog;
import com.swimap.iview.templates.devicepanel.view.FacilityDrawingPanel;
import com.swimap.iview.templates.devicepanel.view.FrontDrawingPanel;
import com.swimap.iview.templates.devicepanel.view.LegendDividerPanel;
import com.swimap.iview.templates.devicepanel.view.LegendListener;
import com.swimap.iview.templates.devicepanel.view.LegendPanel;
import com.swimap.iview.templates.devicepanel.view.LmtEmulationalDrawingPanel;
import com.swimap.iview.util.helpmanagement.CSH;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class DevicePanel
extends JPanel
implements DevicePanelConstants {
    private static IviewLogger logger = IviewLogger.getLogger(DevicePanel.class, "IVIEW");
    private static final int TAB_FONT = 12;
    protected DevicePanelTreeModel devicePanelTreeModel = null;
    protected PopupMenuAuthorization popupMenuAuthorization = null;
    protected Clickable clickable = null;
    protected DrawingPanel[] drawingPanels = null;
    protected JScrollPane[] scrollDrawingPanels = null;
    protected transient ModelChangeListener modelChangeListener = new ModelChangeHandler();
    protected transient FocusListener focusListener = new FocusHandler();
    protected transient ChangeListener changeListener = new ChangeHandler();
    protected JTabbedPane drawingComponentTabbedPane = null;
    protected LegendDividerPanel legendDividerPanel = null;
    public LegendPanel legendPanel = null;
    private BehindShelfDialog behindShelfDialog = null;
    private boolean isBehindDialogModal = true;
    private static EmulationalShelfDialog emulationalShelfDialog = null;
    private EmulationalDevicePanel emuPanel = null;
    protected static final int SCROLLBAR_WIDTH = 24;
    protected Hashtable scrollPaneTable = new Hashtable(8);
    protected EmulationalListener emulationalListener = null;
    protected boolean isBehind = false;
    private boolean isComposePanel = false;
    private String legendToolTipOpenApMsg = null;
    private String legendToolTipCloseApMsg = null;
    private boolean parentActivated = true;
    private int temperatureModel = 0;
    private JPopupMenu popupMenu = null;
    private boolean isLegendPanelVisible = true;
    private EventListenerList behidListeners = new EventListenerList();

    public DevicePanel(JFrame jFrame, DevicePanelTreeModel devicePanelTreeModel) {
        this(jFrame, devicePanelTreeModel, true);
    }

    public DevicePanel(JFrame jFrame, DevicePanelTreeModel devicePanelTreeModel, Dimension dimension, boolean bl) {
        this(jFrame, devicePanelTreeModel, dimension, bl, true);
    }

    public DevicePanel(JFrame jFrame, DevicePanelTreeModel devicePanelTreeModel, Dimension dimension, boolean bl, boolean bl2) {
        this.isLegendPanelVisible = bl2;
        if (devicePanelTreeModel == null) {
            throw new IllegalArgumentException("The device panel tree model is null");
        }
        devicePanelTreeModel.getConfigureUtilities().setPanelSize(dimension);
        this.isComposePanel = bl;
        this.jInit(jFrame, devicePanelTreeModel);
    }

    public DevicePanel(JFrame jFrame, DevicePanelTreeModel devicePanelTreeModel, boolean bl) {
        if (devicePanelTreeModel == null) {
            throw new IllegalArgumentException("The device panel tree model is null");
        }
        LegendPanel.isVisibleAllowed = bl;
        this.jInit(jFrame, devicePanelTreeModel);
    }

    private void jInit(JFrame jFrame, DevicePanelTreeModel devicePanelTreeModel) {
        this.devicePanelTreeModel = devicePanelTreeModel;
        this.behindShelfDialog = new BehindShelfDialog(jFrame, this);
        emulationalShelfDialog = EmulationalShelfDialog.getInstance(jFrame);
        this.emuPanel = new EmulationalDevicePanel(this);
        if (this.isLegendPanelVisible) {
            this.legendDividerPanel = new LegendDividerPanel(this);
            this.legendPanel = new LegendPanel(this);
            this.legendPanel.equipFocusListener(this.focusListener);
            this.legendPanel.requestFocusInWindow();
        }
        this.devicePanelTreeModel.addModelChangeListener(this.modelChangeListener);
        this.emulationalListener = devicePanelTreeModel.getEmulationalListener();
        this.equipBox();
        this.setName("Devicepanel");
    }

    public EmulationalListener getEmulationalListener() {
        return this.emulationalListener;
    }

    public MouseWheelHandler getMouseWheelHandler(JScrollPane jScrollPane) {
        return new MouseWheelHandler(jScrollPane);
    }

    public PopupMenuAuthorization getPopupMenuAuthorization() {
        return this.popupMenuAuthorization;
    }

    public void setPopupMenuAuthorization(PopupMenuAuthorization popupMenuAuthorization) {
        this.popupMenuAuthorization = popupMenuAuthorization;
    }

    public Clickable getClickable() {
        return this.clickable;
    }

    public void setClickable(Clickable clickable) {
        this.clickable = clickable;
    }

    public JPopupMenu getPopupMenu(DevicePanelComponent devicePanelComponent) {
        if (devicePanelComponent == null) {
            return null;
        }
        PopupMenuResponseObjectPair popupMenuResponseObjectPair = this.getModel().getConfigureUtilities().getPopupMenuResponseObjectPair(devicePanelComponent.getPopupMenuReferrenceName());
        if (popupMenuResponseObjectPair != null) {
            return popupMenuResponseObjectPair.getPopupMenu(devicePanelComponent);
        }
        return null;
    }

    public void refreshModel(DevicePanelTreeModel devicePanelTreeModel) {
        if (devicePanelTreeModel == null) {
            throw new IllegalArgumentException("The device panel tree model is null");
        }
        this.devicePanelTreeModel.removeModelChangeListener(this.modelChangeListener);
        this.devicePanelTreeModel.removeEmulationalListener(this.emulationalListener);
        devicePanelTreeModel.addModelChangeListener(this.modelChangeListener);
        devicePanelTreeModel.addEmulationalListener(this.emulationalListener);
        if (this.drawingComponentTabbedPane != null) {
            this.drawingComponentTabbedPane.removeFocusListener(this.focusListener);
            this.drawingComponentTabbedPane.removeChangeListener(this.changeListener);
            this.drawingComponentTabbedPane = null;
        }
        if (this.behindShelfDialog.isVisible()) {
            this.behindShelfDialog.setVisible(false);
        }
        if (emulationalShelfDialog.isVisible()) {
            emulationalShelfDialog.setVisible(false);
        }
        for (int i = 0; i < this.drawingPanels.length; ++i) {
            this.scrollDrawingPanels[i].getViewport().setView(null);
            this.drawingPanels[i].endTask();
        }
        this.scrollPaneTable.clear();
        this.setVisible(false);
        this.devicePanelTreeModel.endTask();
        this.devicePanelTreeModel = devicePanelTreeModel;
        this.isBehind = false;
        this.removeAll();
        this.equipBox();
        this.setVisible(true);
    }

    public void locate(String string, int n) {
        if (string == null) {
            throw new IllegalArgumentException("The parentID is null.");
        }
        DefaultMutableTreeNode defaultMutableTreeNode = this.devicePanelTreeModel.findTreeNode(string);
        if (defaultMutableTreeNode == null) {
            throw new IllegalArgumentException("can't find the node of " + string);
        }
        if (n < 0 || n >= defaultMutableTreeNode.getChildCount()) {
            throw new IllegalArgumentException("childIndex isn't in the valid range.");
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
        if (defaultMutableTreeNode2 == null) {
            throw new IllegalArgumentException("The childTreeNode is null");
        }
        this.setTreeNodeSelected(defaultMutableTreeNode2);
    }

    private void setTreeNodeSelected(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode != null) {
            DevicePanelComponent devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
            if (!devicePanelComponent.isSelectable()) {
                logger.debug("Component is not selectable.");
                return;
            }
            DrawingPanel drawingPanel = this.getDrawingPanelEx(devicePanelComponent);
            if (drawingPanel instanceof BehindDrawingPanel && this.getBehidListeners().getListenerCount() > 0) {
                this.fireBehidActionListener((Shelf)drawingPanel.getContainer());
                drawingPanel = this.getDrawingPanelEx(devicePanelComponent);
            }
            this.setTreeNodeSelected(devicePanelComponent, drawingPanel);
        }
    }

    private void setTreeNodeSelected(DevicePanelComponent devicePanelComponent, DrawingPanel drawingPanel) {
        JScrollPane jScrollPane = this.getScrollDrawingPanel(devicePanelComponent);
        if (jScrollPane != null && jScrollPane.getVerticalScrollBar().isEnabled()) {
            jScrollPane.getVerticalScrollBar().setValue(devicePanelComponent.getStartY());
        }
        if (drawingPanel != null) {
            DrawingPanel drawingPanel2;
            Graphics2D graphics2D = drawingPanel.getDrawingGraphics();
            DrawingPanel drawingPanel3 = drawingPanel;
            if (drawingPanel instanceof LmtEmulationalDrawingPanel) {
                drawingPanel2 = (LmtEmulationalDrawingPanel)drawingPanel;
                this.emuPanel.setDrawingPanel((LmtEmulationalDrawingPanel)drawingPanel2);
                drawingPanel3 = this.emuPanel.getDrawingPanel();
            }
            if (drawingPanel instanceof BehindDrawingPanel) {
                if (drawingPanel == this.behindShelfDialog.getDrawingPanel()) {
                    ((Shelf)drawingPanel.getContainer()).setBehindEnabled(true);
                    drawingPanel.getContainer().draw(graphics2D);
                    ((Shelf)drawingPanel.getContainer()).setBehindEnabled(false);
                    if (this.behindShelfDialog.isModal()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DevicePanel.this.behindShelfDialog.setVisible(true);
                            }
                        });
                    } else {
                        this.behindShelfDialog.setVisible(true);
                    }
                } else {
                    drawingPanel2 = (BehindDrawingPanel)drawingPanel;
                    drawingPanel2.setIsComposeFrame(this.isComposePanel);
                    if (((BehindDrawingPanel)drawingPanel2).getFrontDrawingPanel() instanceof FrontDrawingPanel) {
                        this.behindShelfDialog.setFrontDrawingPanel((FrontDrawingPanel)((BehindDrawingPanel)drawingPanel2).getFrontDrawingPanel());
                    }
                    this.behindShelfDialog.setDrawingPanel((BehindDrawingPanel)drawingPanel2);
                }
                drawingPanel3 = ((BehindDrawingPanel)drawingPanel).getFrontDrawingPanel();
            } else {
                drawingPanel.getContainer().draw(graphics2D);
            }
            drawingPanel.keepOneSelected();
            drawingPanel.setSelectedComponent(devicePanelComponent);
            devicePanelComponent.selectedShapedDraw(graphics2D);
            graphics2D.dispose();
            if (this.drawingComponentTabbedPane != null) {
                int n = this.drawingComponentTabbedPane.indexOfComponent((JComponent)this.scrollPaneTable.get(drawingPanel3));
                this.drawingComponentTabbedPane.setSelectedIndex(n);
            }
            drawingPanel.repaint();
            graphics2D.dispose();
        }
    }

    public void locate(String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.devicePanelTreeModel.findTreeNode(string);
        this.setTreeNodeSelected(defaultMutableTreeNode);
    }

    public void updateComponent(String string, boolean bl) {
        if (bl) {
            this.updateDevicePanelComponent(string);
        } else {
            this.updateEmulationalDevicePanelComponent(string);
        }
    }

    private void updateEmulationalDevicePanelComponent(String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        LmtEmulationalDrawingPanel lmtEmulationalDrawingPanel = null;
        try {
            lmtEmulationalDrawingPanel = emulationalShelfDialog.getEmulationalDevicePanel().getDrawingPanel();
            defaultMutableTreeNode = lmtEmulationalDrawingPanel.emuModel.findTreeNode(string);
        }
        catch (Exception exception) {
            return;
        }
        if (defaultMutableTreeNode == null) {
            logger.debug("EmulationalDevicePanel Component " + string + " didn't find, update failed.");
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        DevicePanelComponent devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode2.getUserObject();
        DevicePanelComponent devicePanelComponent2 = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
        Shelf shelf = lmtEmulationalDrawingPanel.shelf;
        Graphics2D graphics2D = lmtEmulationalDrawingPanel.getDrawingGraphics();
        if (lmtEmulationalDrawingPanel.getSelectedComponent() == devicePanelComponent2) {
            devicePanelComponent2.setIsSelected(true);
        }
        if (emulationalShelfDialog != null && shelf == lmtEmulationalDrawingPanel.getOwnerShelf(devicePanelComponent2)) {
            if (!shelf.getBehindEnabled()) {
                if (devicePanelComponent instanceof BuckledCard && devicePanelComponent.getParent().getIndexInNotCompose() < shelf.getFrontChildCount()) {
                    devicePanelComponent2.updateDraw(graphics2D);
                } else if (devicePanelComponent2 instanceof Card && devicePanelComponent2.getIndexInNotCompose() < shelf.getFrontChildCount()) {
                    devicePanelComponent2.updateDraw(graphics2D);
                } else if (devicePanelComponent2 instanceof EmptyComponent && devicePanelComponent2.getIndexInNotCompose() < shelf.getFrontChildCount()) {
                    devicePanelComponent2.updateDraw(graphics2D);
                } else if (devicePanelComponent instanceof Card && devicePanelComponent.getIndexInNotCompose() < shelf.getFrontChildCount()) {
                    devicePanelComponent2.updateDraw(graphics2D);
                } else if (devicePanelComponent2 instanceof Shelf || devicePanelComponent2 instanceof EnvironmentItem) {
                    devicePanelComponent2.updateDraw(graphics2D);
                }
            } else if (shelf.getBehindEnabled()) {
                if (devicePanelComponent instanceof BuckledCard && devicePanelComponent.getParent().getIndexInNotCompose() >= shelf.getFrontChildCount()) {
                    devicePanelComponent2.updateDraw(graphics2D);
                } else if (devicePanelComponent2 instanceof Card && devicePanelComponent2.getIndexInNotCompose() >= shelf.getFrontChildCount()) {
                    devicePanelComponent2.updateDraw(graphics2D);
                } else if (devicePanelComponent2 instanceof EmptyComponent && devicePanelComponent2.getIndexInNotCompose() >= shelf.getFrontChildCount()) {
                    devicePanelComponent2.updateDraw(graphics2D);
                } else if (devicePanelComponent instanceof Card && devicePanelComponent.getIndexInNotCompose() >= shelf.getFrontChildCount()) {
                    devicePanelComponent2.updateDraw(graphics2D);
                } else if (devicePanelComponent2 instanceof Shelf || devicePanelComponent2 instanceof EnvironmentItem) {
                    devicePanelComponent2.updateDraw(graphics2D);
                }
            }
            graphics2D.dispose();
            lmtEmulationalDrawingPanel.repaint();
        }
    }

    private void updateDevicePanelComponent(String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.devicePanelTreeModel.findTreeNode(string);
        if (defaultMutableTreeNode == null) {
            logger.debug("DevicePanel Component " + string + " didn't find, update failed.");
            return;
        }
        DevicePanelComponent devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
        DrawingPanel drawingPanel = this.getDrawingPanel(devicePanelComponent);
        if (null != drawingPanel) {
            if (drawingPanel.getSelectedComponent() == devicePanelComponent) {
                devicePanelComponent.setIsSelected(true);
            }
            Graphics2D graphics2D = drawingPanel.getDrawingGraphics();
            if (drawingPanel.getContainer().getBehindEnabled() == devicePanelComponent.getBehindEnabled()) {
                if ((devicePanelComponent instanceof Port || devicePanelComponent instanceof BuckledCard) && devicePanelComponent.isIsFacility()) {
                    return;
                }
                devicePanelComponent.updateDraw(graphics2D);
            }
            graphics2D.dispose();
            drawingPanel.repaint();
        }
    }

    public JTabbedPane getLegendTabbedPane() {
        return this.legendPanel.getLegendTabbedPane();
    }

    public LegendPanel getLegendPanel() {
        return this.legendPanel;
    }

    public DevicePanelComponent getCurrentSelectedComponent() {
        return null;
    }

    public void addLegendListener(LegendListener legendListener) {
        if (legendListener != null) {
            this.listenerList.add(LegendListener.class, legendListener);
        }
    }

    public void removeLegendListener(LegendListener legendListener) {
        this.listenerList.remove(LegendListener.class, legendListener);
    }

    public int getExtraHeight() {
        int n = 0;
        if (this.drawingComponentTabbedPane != null) {
            AssistantTabbedPaneUI assistantTabbedPaneUI = new AssistantTabbedPaneUI();
            n = assistantTabbedPaneUI.getTabExtraHeight() + 9 + assistantTabbedPaneUI.getRowCount();
        }
        return n;
    }

    public void endTask() {
        if (this.drawingComponentTabbedPane != null) {
            this.drawingComponentTabbedPane.removeFocusListener(this.focusListener);
            this.drawingComponentTabbedPane.removeChangeListener(this.changeListener);
        }
        if (this.legendPanel != null) {
            this.legendPanel.unequipFocusListener(this.focusListener);
            this.legendPanel.clear();
            this.legendPanel = null;
        }
        for (int i = 0; i < this.drawingPanels.length; ++i) {
            this.drawingPanels[i].endTask();
        }
        if (this.legendDividerPanel != null) {
            this.legendDividerPanel.endTask();
            this.legendDividerPanel = null;
        }
        if (this.behindShelfDialog != null) {
            this.behindShelfDialog.endTask();
            this.behindShelfDialog = null;
        }
        if (this.emuPanel != null && this.emuPanel == emulationalShelfDialog.getEmulationalDevicePanel()) {
            if (emulationalShelfDialog.isShowing()) {
                emulationalShelfDialog.dispose();
            }
            this.emuPanel.endTask();
            this.emuPanel = null;
        }
        if (this.devicePanelTreeModel != null) {
            this.devicePanelTreeModel.removeModelChangeListener(this.modelChangeListener);
            this.devicePanelTreeModel.removeEmulationalListener(this.emulationalListener);
            this.devicePanelTreeModel.endTask();
        }
        this.devicePanelTreeModel = null;
        this.modelChangeListener = null;
        this.emulationalListener = null;
        this.clickable = null;
        this.popupMenuAuthorization = null;
        this.focusListener = null;
        this.changeListener = null;
        if (this.isParentActivated()) {
            final KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (keyboardFocusManager.getFocusedWindow() instanceof Dialog) {
                        keyboardFocusManager.getFocusedWindow().requestFocus();
                    }
                }
            });
        }
    }

    public DevicePanelTreeModel getModel() {
        return this.devicePanelTreeModel;
    }

    public BehindShelfDialog getBehindShelfDialog() {
        return this.behindShelfDialog;
    }

    public boolean getIsBehind() {
        return this.isBehind;
    }

    public void setIsBehind(boolean bl) {
        this.isBehind = bl;
    }

    EmulationalDevicePanel getEmulationalDevicePanel() {
        return this.emuPanel;
    }

    void fireLegendExpandingEvent() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != LegendListener.class) continue;
            ((LegendListener)objectArray[i + 1]).legendExpanding(200);
        }
    }

    void fireLegendClosingEvent() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != LegendListener.class) continue;
            ((LegendListener)objectArray[i + 1]).legendClosing(200);
        }
    }

    protected void equipBox() {
        Box box = Box.createHorizontalBox();
        box.setBackground(this.devicePanelTreeModel.getConfigureUtilities().getBackground());
        box.add(this.getDrawingComponent());
        if (this.isLegendPanelVisible) {
            box.add(this.legendDividerPanel);
            Box box2 = Box.createVerticalBox();
            box2.add(this.legendPanel);
            box.add(box2);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)box, "Center");
    }

    public JScrollPane[] getScrollDrawingPanels() {
        return this.scrollDrawingPanels;
    }

    public JComponent getDrawingComponent() {
        int n;
        Object object;
        Cloneable cloneable;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.devicePanelTreeModel.getRoot();
        int n2 = defaultMutableTreeNode.getChildCount();
        if (n2 < 1) {
            throw new IllegalArgumentException("Data Error : device panel tree model has no frame");
        }
        this.drawingPanels = new DrawingPanel[n2];
        this.scrollDrawingPanels = new JScrollPane[n2];
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            cloneable = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            DevicePanelComponent devicePanelComponent = (DevicePanelComponent)cloneable.getUserObject();
            bl = devicePanelComponent.isIsFacility();
            this.drawingPanels[i] = bl ? new FacilityDrawingPanel(devicePanelComponent, this) : new FrontDrawingPanel(devicePanelComponent, this);
            this.drawingPanels[i].setIsComposeFrame(this.isComposePanel);
            if (this.getPopupMenu() != null) {
                this.drawingPanels[i].setDevicePanelPopupMenu(this.getPopupMenu());
            }
            object = this.drawingPanels[i].getDrawingGraphics();
            devicePanelComponent.draw((Graphics2D)object);
            ((Graphics)object).dispose();
        }
        Dimension dimension = this.devicePanelTreeModel.getConfigureUtilities().getPanelSize();
        cloneable = null;
        for (n = 0; n < this.drawingPanels.length; ++n) {
            cloneable = bl ? ((FacilityDrawingPanel)this.drawingPanels[n]).getDimension() : ((FrontDrawingPanel)this.drawingPanels[n]).getDimension();
            object = new Dimension(((Dimension)cloneable).width, ((Dimension)cloneable).height + 10);
            this.drawingPanels[n].setPreferredSize((Dimension)object);
            this.drawingPanels[n].setMaximumSize((Dimension)object);
            this.drawingPanels[n].setMinimumSize((Dimension)object);
            this.scrollDrawingPanels[n] = new JScrollPane(this.drawingPanels[n], 20, 30);
            this.scrollPaneTable.put(this.drawingPanels[n], this.scrollDrawingPanels[n]);
        }
        if (this.drawingPanels.length > 1) {
            this.drawingComponentTabbedPane = new JTabbedPane();
            for (n = 0; n < this.drawingPanels.length; ++n) {
                this.drawingComponentTabbedPane.add(this.drawingPanels[n].getContainer().getType(), this.scrollDrawingPanels[n]);
            }
            this.drawingComponentTabbedPane.addFocusListener(this.focusListener);
            this.drawingComponentTabbedPane.addChangeListener(this.changeListener);
            this.drawingComponentTabbedPane.setFont(new Font("Serif", 0, 12));
            this.drawingComponentTabbedPane.setBorder(null);
            this.drawingComponentTabbedPane.setPreferredSize(new Dimension(dimension.width + 24, dimension.height));
            return this.drawingComponentTabbedPane;
        }
        Dimension dimension2 = new Dimension(dimension.width + 24, dimension.height);
        this.scrollDrawingPanels[0].setPreferredSize(dimension2);
        return this.scrollDrawingPanels[0];
    }

    public JPanel[] getDrawingPanels() {
        JPanel[] jPanelArray = new JPanel[this.drawingPanels.length];
        System.arraycopy(this.drawingPanels, 0, jPanelArray, 0, this.drawingPanels.length);
        return jPanelArray;
    }

    protected boolean isDrawingPanelEnabled(DrawingPanel drawingPanel) {
        if (this.drawingComponentTabbedPane == null) {
            if (drawingPanel == this.behindShelfDialog.getDrawingPanel() && !this.behindShelfDialog.isVisible()) {
                return false;
            }
            return drawingPanel != this.emuPanel.getDrawingPanel() || emulationalShelfDialog.isVisible();
        }
        if (drawingPanel == this.behindShelfDialog.getDrawingPanel() && this.behindShelfDialog.isVisible()) {
            return true;
        }
        if (drawingPanel == this.getCurrentDrawingPanelFromTabPane()) {
            return true;
        }
        return drawingPanel == this.emuPanel.getDrawingPanel() && emulationalShelfDialog.isVisible();
    }

    protected void processStateAlarmChangedEvent(DevicePanelItem[] devicePanelItemArray) {
        Graphics2D graphics2D;
        Object object;
        int n;
        for (n = 0; n < devicePanelItemArray.length; ++n) {
            object = this.getDrawingPanel(devicePanelItemArray[n]);
            if (object == null || !this.isDrawingPanelEnabled((DrawingPanel)object) || !devicePanelItemArray[n].isInCurrentPage()) continue;
            graphics2D = ((DrawingPanel)object).getDrawingGraphics();
            if (devicePanelItemArray[n].isIsFacility()) {
                if (this.isBehind == devicePanelItemArray[n].getBehindEnabled()) {
                    devicePanelItemArray[n].draw(graphics2D);
                }
            } else {
                devicePanelItemArray[n].draw(graphics2D);
            }
            if (devicePanelItemArray[n] instanceof Card) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)devicePanelItemArray[n].getRelatedTreeNode().getParent();
                Shelf shelf = (Shelf)defaultMutableTreeNode.getUserObject();
                int n2 = shelf.bound.x + 20;
                int n3 = shelf.getWidth() - 40;
                int n4 = shelf.bound.y + 5 - 1;
                int n5 = 12;
                if (this.isBehind != devicePanelItemArray[n].getBehindEnabled() && object != this.behindShelfDialog.getDrawingPanel()) {
                    shelf.drawStateBar(graphics2D, n2, n4, n3, n5);
                }
            }
            graphics2D.dispose();
        }
        for (n = 0; n < this.drawingPanels.length; ++n) {
            if (this.drawingPanels[n] == null) continue;
            object = this.drawingPanels[n].getSelectedComponent();
            if (object != null && ((DevicePanelComponent)object).isInCurrentPage() && !(object instanceof Frame) && !(object instanceof Shelf)) {
                graphics2D = this.drawingPanels[n].getDrawingGraphics();
                ((DevicePanelComponent)object).selectedShapedDraw(graphics2D);
                graphics2D.dispose();
            }
            this.drawingPanels[n].repaint();
        }
        if (this.behindShelfDialog != null && this.behindShelfDialog.isVisible()) {
            DevicePanelComponent devicePanelComponent = this.behindShelfDialog.getDrawingPanel().getSelectedComponent();
            if (devicePanelComponent != null && !(devicePanelComponent instanceof Shelf)) {
                object = this.behindShelfDialog.getDrawingPanel().getDrawingGraphics();
                devicePanelComponent.setIsSelected(true);
                devicePanelComponent.selectedShapedDraw((Graphics2D)object);
                ((Graphics)object).dispose();
            }
            this.behindShelfDialog.getDrawingPanel().repaint();
        }
    }

    private void processStateColorChagedEvent(int[] nArray) {
        DrawingPanel drawingPanel2 = null;
        for (DrawingPanel drawingPanel2 : this.drawingPanels) {
            if (null == drawingPanel2) continue;
            for (int i = 0; i < nArray.length; ++i) {
                drawingPanel2.getContainer().updateUtilities(nArray[i]);
            }
            drawingPanel2.getContainer().draw(drawingPanel2.getDrawingGraphics());
            drawingPanel2.repaint();
        }
        this.getLegendPanel().refreshLegendPanel();
    }

    private void processModelChagedEvent(boolean bl) {
        DrawingPanel drawingPanel = null;
        int n = this.drawingPanels.length;
        DevicePanelComponent devicePanelComponent = null;
        Graphics2D graphics2D = null;
        for (int i = 0; i < n; ++i) {
            drawingPanel = this.drawingPanels[i];
            if (null == drawingPanel) continue;
            devicePanelComponent = drawingPanel.getSelectedComponent();
            graphics2D = drawingPanel.getDrawingGraphics();
            drawingPanel.getContainer().draw(graphics2D);
            if (devicePanelComponent != null && devicePanelComponent.isInCurrentPage()) {
                devicePanelComponent.selectedShapedDraw(graphics2D);
            }
            graphics2D.dispose();
            drawingPanel.repaint();
        }
        if (this.behindShelfDialog != null) {
            drawingPanel = this.behindShelfDialog.getDrawingPanel();
            devicePanelComponent = drawingPanel.getSelectedComponent();
            graphics2D = drawingPanel.getDrawingGraphics();
            Shelf shelf = ((BehindDrawingPanel)drawingPanel).getShelf();
            if (null != shelf) {
                shelf.setBehindEnabled(true);
                shelf.draw(graphics2D);
                if (devicePanelComponent != null && devicePanelComponent.isInCurrentPage()) {
                    devicePanelComponent.selectedShapedDraw(graphics2D);
                }
                shelf.setBehindEnabled(false);
            }
            graphics2D.dispose();
            drawingPanel.repaint();
        }
        if (bl) {
            this.getLegendPanel().refreshLegendPanel();
        }
    }

    private void processUserIconUpdated(DevicePanelItem[] devicePanelItemArray) {
        for (int i = 0; i < devicePanelItemArray.length; ++i) {
            DrawingPanel drawingPanel = this.getDrawingPanel(devicePanelItemArray[i]);
            if (null == drawingPanel || !devicePanelItemArray[i].isInCurrentPage()) continue;
            Graphics2D graphics2D = drawingPanel.getDrawingGraphics();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)devicePanelItemArray[i].getRelatedTreeNode().getParent();
            DevicePanelComponent devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
            this.updateDrawingPanel(graphics2D, drawingPanel, devicePanelComponent);
            this.setSelection(drawingPanel);
            this.setBehindDialogSelection();
        }
    }

    private void setBehindDialogSelection() {
        DevicePanelComponent devicePanelComponent = this.behindShelfDialog.getDrawingPanel().getSelectedComponent();
        if (null != devicePanelComponent && !(devicePanelComponent instanceof Shelf)) {
            Graphics2D graphics2D = this.behindShelfDialog.getDrawingPanel().getDrawingGraphics();
            devicePanelComponent.setIsSelected(true);
            devicePanelComponent.selectedShapedDraw(graphics2D);
            graphics2D.dispose();
        }
        this.behindShelfDialog.getDrawingPanel().repaint();
    }

    private void setSelection(DrawingPanel drawingPanel) {
        DevicePanelComponent devicePanelComponent = drawingPanel.getSelectedComponent();
        if (null != devicePanelComponent && devicePanelComponent.isInCurrentPage() && !(devicePanelComponent instanceof Frame) && !(devicePanelComponent instanceof Shelf)) {
            Graphics2D graphics2D = drawingPanel.getDrawingGraphics();
            devicePanelComponent.selectedShapedDraw(graphics2D);
            graphics2D.dispose();
        }
        drawingPanel.repaint();
    }

    private void updateDrawingPanel(Graphics2D graphics2D, DrawingPanel drawingPanel, DevicePanelComponent devicePanelComponent) {
        if (drawingPanel instanceof BehindDrawingPanel) {
            if (devicePanelComponent instanceof Shelf) {
                ((Shelf)devicePanelComponent).setBehindEnabled(true);
                devicePanelComponent.draw(graphics2D);
                ((Shelf)devicePanelComponent).setBehindEnabled(false);
            } else {
                devicePanelComponent.draw(graphics2D);
            }
        } else {
            devicePanelComponent.draw(graphics2D);
        }
    }

    protected void processProgressChangedEvent(DevicePanelItem[] devicePanelItemArray) {
        DrawingPanel drawingPanel = null;
        Graphics2D graphics2D = null;
        for (int i = 0; i < devicePanelItemArray.length; ++i) {
            drawingPanel = this.getDrawingPanel(devicePanelItemArray[i]);
            if (drawingPanel != null && this.isDrawingPanelEnabled(drawingPanel) && devicePanelItemArray[i].isInCurrentPage()) {
                graphics2D = drawingPanel.getDrawingGraphics();
                if (this.isBehind == devicePanelItemArray[i].getBehindEnabled()) {
                    devicePanelItemArray[i].draw(graphics2D);
                }
                graphics2D.dispose();
            }
            drawingPanel.repaint();
        }
        DevicePanelComponent devicePanelComponent = null;
        for (int i = 0; i < this.drawingPanels.length; ++i) {
            if (this.drawingPanels[i] == null) continue;
            devicePanelComponent = this.drawingPanels[i].getSelectedComponent();
            if (devicePanelComponent != null && devicePanelComponent.isInCurrentPage() && !(devicePanelComponent instanceof Frame) && !(devicePanelComponent instanceof Shelf)) {
                graphics2D = this.drawingPanels[i].getDrawingGraphics();
                devicePanelComponent.selectedShapedDraw(graphics2D);
                graphics2D.dispose();
            }
            this.drawingPanels[i].repaint();
        }
        if (this.behindShelfDialog != null && this.behindShelfDialog.isVisible()) {
            devicePanelComponent = this.behindShelfDialog.getDrawingPanel().getSelectedComponent();
            if (devicePanelComponent != null && !(devicePanelComponent instanceof Shelf)) {
                graphics2D = this.behindShelfDialog.getDrawingPanel().getDrawingGraphics();
                devicePanelComponent.setIsSelected(true);
                devicePanelComponent.selectedShapedDraw(graphics2D);
                graphics2D.dispose();
            }
            this.behindShelfDialog.getDrawingPanel().repaint();
        }
    }

    private void processStateTemperatureChangedEvent(DevicePanelItem[] devicePanelItemArray) {
        Object object;
        for (int i = 0; i < devicePanelItemArray.length; ++i) {
            if (devicePanelItemArray[i] instanceof TemperatureEnvironmentItem) {
                ((TemperatureEnvironmentItem)devicePanelItemArray[i]).setTemperatureModel(this.temperatureModel);
            }
            if ((object = this.getDrawingPanel(devicePanelItemArray[i])) == null || !this.isDrawingPanelEnabled((DrawingPanel)object) || !devicePanelItemArray[i].isInCurrentPage()) continue;
            Graphics2D graphics2D = ((DrawingPanel)object).getDrawingGraphics();
            devicePanelItemArray[i].draw(graphics2D);
            graphics2D.dispose();
        }
        if (this.behindShelfDialog.isVisible()) {
            DevicePanelComponent devicePanelComponent = this.behindShelfDialog.getDrawingPanel().getSelectedComponent();
            if (devicePanelComponent != null) {
                object = this.behindShelfDialog.getDrawingPanel().getDrawingGraphics();
                devicePanelComponent.selectedShapedDraw((Graphics2D)object);
                ((Graphics)object).dispose();
            }
            this.behindShelfDialog.getDrawingPanel().repaint();
        }
    }

    protected DrawingPanel processComponentAddedRemovedEvent(DevicePanelComponent devicePanelComponent) {
        DrawingPanel drawingPanel = this.getDrawingPanel(devicePanelComponent);
        if (drawingPanel != null && devicePanelComponent.isInCurrentPage()) {
            Graphics2D graphics2D = drawingPanel.getDrawingGraphics();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)devicePanelComponent.getRelatedTreeNode().getParent();
            DevicePanelComponent devicePanelComponent2 = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
            if (drawingPanel instanceof BehindDrawingPanel) {
                if (devicePanelComponent2 instanceof Shelf) {
                    ((Shelf)devicePanelComponent2).setBehindEnabled(true);
                    devicePanelComponent2.draw(graphics2D);
                    ((Shelf)devicePanelComponent2).setBehindEnabled(false);
                } else {
                    devicePanelComponent2.draw(graphics2D);
                }
            } else {
                devicePanelComponent2.draw(graphics2D);
            }
            graphics2D.dispose();
        }
        return drawingPanel;
    }

    protected JScrollPane getScrollDrawingPanel(DevicePanelComponent devicePanelComponent) {
        DefaultMutableTreeNode defaultMutableTreeNode = devicePanelComponent.getRelatedTreeNode();
        TreeNode[] treeNodeArray = this.devicePanelTreeModel.getPathToRoot(defaultMutableTreeNode);
        if (treeNodeArray == null || treeNodeArray.length < 2) {
            return null;
        }
        int n = treeNodeArray[0].getIndex(treeNodeArray[1]);
        JScrollPane jScrollPane = null;
        try {
            jScrollPane = this.scrollDrawingPanels[n];
        }
        catch (Exception exception) {
            logger.debug("don't get JScrollPane");
        }
        if (jScrollPane != null && (treeNodeArray.length == 3 || treeNodeArray.length == 2)) {
            return jScrollPane;
        }
        return null;
    }

    public DrawingPanel getDrawingPanel(DevicePanelComponent devicePanelComponent) {
        DefaultMutableTreeNode defaultMutableTreeNode = devicePanelComponent.getRelatedTreeNode();
        TreeNode[] treeNodeArray = this.devicePanelTreeModel.getPathToRoot(defaultMutableTreeNode);
        if (treeNodeArray == null || treeNodeArray.length < 2) {
            return null;
        }
        int n = treeNodeArray[0].getIndex(treeNodeArray[1]);
        DrawingPanel drawingPanel = this.drawingPanels[n];
        if (treeNodeArray.length == 3 || treeNodeArray.length == 2) {
            return drawingPanel;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treeNodeArray[2];
        Shelf shelf = (Shelf)defaultMutableTreeNode2.getUserObject();
        if (!this.isBehind && treeNodeArray[2].getIndex(treeNodeArray[3]) < shelf.getFrontChildCount() || this.isBehind && treeNodeArray[2].getIndex(treeNodeArray[3]) >= shelf.getFrontChildCount()) {
            return drawingPanel;
        }
        if (treeNodeArray[2].getIndex(treeNodeArray[3]) < shelf.getRelatedTreeNode().getChildCount() && shelf.isIsFacility()) {
            return drawingPanel;
        }
        if (!this.isBehind && treeNodeArray[2].getIndex(treeNodeArray[3]) >= shelf.getFrontChildCount() || this.isBehind && treeNodeArray[2].getIndex(treeNodeArray[3]) < shelf.getFrontChildCount()) {
            if (((BehindDrawingPanel)this.behindShelfDialog.getDrawingPanel()).getShelf() == shelf) {
                return (BehindDrawingPanel)this.behindShelfDialog.getDrawingPanel();
            }
        } else {
            return null;
        }
        return null;
    }

    protected DrawingPanel getCurrentDrawingPanelFromTabPane() {
        JScrollPane jScrollPane = (JScrollPane)this.drawingComponentTabbedPane.getSelectedComponent();
        DrawingPanel drawingPanel = (DrawingPanel)jScrollPane.getViewport().getView();
        return drawingPanel;
    }

    public int switchFrameDirection(DevicePanelComponent devicePanelComponent) {
        DrawingPanel drawingPanel;
        Object object;
        int n = -1;
        if (devicePanelComponent == null || !(devicePanelComponent instanceof Frame)) {
            return -1;
        }
        boolean bl = false;
        int n2 = devicePanelComponent.getRelatedTreeNode().getChildCount();
        for (int i = 0; i < n2; ++i) {
            Shelf shelf;
            object = (DefaultMutableTreeNode)devicePanelComponent.getRelatedTreeNode().getChildAt(i);
            DevicePanelComponent devicePanelComponent2 = (DevicePanelComponent)((DefaultMutableTreeNode)object).getUserObject();
            if (!(devicePanelComponent2 instanceof Shelf) || (shelf = (Shelf)devicePanelComponent2).getRelatedTreeNode().getChildCount() <= shelf.getFrontChildCount()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return -1;
        }
        boolean bl2 = this.isBehind = !devicePanelComponent.getBehindEnabled();
        if (devicePanelComponent.getBehindEnabled()) {
            devicePanelComponent.setBehindEnabled(false);
            n = 0;
        } else {
            devicePanelComponent.setBehindEnabled(true);
            n = 1;
        }
        if (this.getBehidListeners().getListenerCount() > 0) {
            this.setOnBehindFrame(this.isBehind, (Frame)devicePanelComponent);
        }
        if (null != (drawingPanel = this.getDrawingPanel(devicePanelComponent))) {
            object = drawingPanel.getDrawingGraphics();
            devicePanelComponent.draw((Graphics2D)object);
            drawingPanel.repaint();
            ((Graphics)object).dispose();
        }
        return n;
    }

    public void openEmulationalShelf(DevicePanelComponent devicePanelComponent) {
        if (!(devicePanelComponent instanceof Shelf)) {
            return;
        }
        FacilityDrawingPanel facilityDrawingPanel = (FacilityDrawingPanel)this.getDrawingPanel(devicePanelComponent);
        if (facilityDrawingPanel != null) {
            facilityDrawingPanel.openEmulationShelf(devicePanelComponent);
        }
    }

    public void updateEmulationalDialogTitle() {
        emulationalShelfDialog.updateTitle();
    }

    public void setLegendToolTipOpenApMsg(String string) {
        this.legendToolTipOpenApMsg = string;
    }

    protected String getLegendToolTipOpenApMsg() {
        return this.legendToolTipOpenApMsg;
    }

    public void setLegendToolTipCloseApMsg(String string) {
        this.legendToolTipCloseApMsg = string;
    }

    protected String getLegendToolTipCloseApMsg() {
        return this.legendToolTipCloseApMsg;
    }

    public boolean isParentActivated() {
        return this.parentActivated;
    }

    public void setParentActivated(boolean bl) {
        this.parentActivated = bl;
    }

    public void setEmulationalDialogHelpID(String string) {
        if (string == null) {
            return;
        }
        JRootPane jRootPane = emulationalShelfDialog.getRootPane();
        if (CSH.getHelpIDString(jRootPane) == null) {
            HelpManager.getInstance().enableHelpKey(jRootPane, string);
        } else {
            HelpManager.getInstance().enableHelp(jRootPane, string);
        }
    }

    public EmulationalShelfDialog getEmulationalDialog() {
        return emulationalShelfDialog;
    }

    public void updateEmulationalDialog() {
        emulationalShelfDialog.setEmulationalDevicePanel(this.emuPanel);
        emulationalShelfDialog.setSize(this.emuPanel.getParentDimension());
        emulationalShelfDialog.setTitle(this.emuPanel.getTitleFromTooltip());
        emulationalShelfDialog.validate();
        emulationalShelfDialog.repaint();
    }

    public void setPopupMenu(JPopupMenu jPopupMenu) {
        this.popupMenu = jPopupMenu;
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void setTemperatureModel(int n) {
        this.temperatureModel = n == 0 || n == 1 || n == 2 ? n : 0;
    }

    public int getTemperatureModel() {
        return this.temperatureModel;
    }

    public void setBehindDialogIsModal(boolean bl) {
        this.isBehindDialogModal = bl;
        if (this.behindShelfDialog != null) {
            this.behindShelfDialog.setModal(this.isBehindDialogModal);
        }
    }

    private DrawingPanel getDrawingPanelEx(DevicePanelComponent devicePanelComponent) {
        DefaultMutableTreeNode defaultMutableTreeNode = devicePanelComponent.getRelatedTreeNode();
        TreeNode[] treeNodeArray = this.devicePanelTreeModel.getPathToRoot(defaultMutableTreeNode);
        if (treeNodeArray == null || treeNodeArray.length < 2) {
            return null;
        }
        int n = treeNodeArray[0].getIndex(treeNodeArray[1]);
        DrawingPanel drawingPanel = this.drawingPanels[n];
        if (treeNodeArray.length == 3 || treeNodeArray.length == 2) {
            return drawingPanel;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treeNodeArray[2];
        Shelf shelf = (Shelf)defaultMutableTreeNode2.getUserObject();
        if (this.isBehind && treeNodeArray[2].getIndex(treeNodeArray[3]) >= shelf.getFrontChildCount() || !this.isBehind && treeNodeArray[2].getIndex(treeNodeArray[3]) < shelf.getFrontChildCount()) {
            return drawingPanel;
        }
        if (treeNodeArray[2].getIndex(treeNodeArray[3]) < shelf.getRelatedTreeNode().getChildCount() && shelf.isIsFacility()) {
            return drawingPanel;
        }
        if (!this.isBehind && treeNodeArray[2].getIndex(treeNodeArray[3]) >= shelf.getFrontChildCount() || this.isBehind && treeNodeArray[2].getIndex(treeNodeArray[3]) < shelf.getFrontChildCount()) {
            if (((BehindDrawingPanel)this.behindShelfDialog.getDrawingPanel()).getShelf() == shelf) {
                return (BehindDrawingPanel)this.behindShelfDialog.getDrawingPanel();
            }
            BehindDrawingPanel behindDrawingPanel = new BehindDrawingPanel(shelf, this);
            behindDrawingPanel.setFrontDrawingPanel(drawingPanel);
            return behindDrawingPanel;
        }
        return null;
    }

    public synchronized void addBehidActionListener(ActionListener actionListener) {
        this.behidListeners.add(ActionListener.class, actionListener);
    }

    public synchronized void removeBehidActionListener(ActionListener actionListener) {
        this.behidListeners.remove(ActionListener.class, actionListener);
    }

    final synchronized EventListenerList getBehidListeners() {
        return this.behidListeners;
    }

    private synchronized void setOnBehindFrame(boolean bl, Frame frame) {
        for (int i = 0; i < frame.getRelatedTreeNode().getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)frame.getRelatedTreeNode().getChildAt(i);
            DevicePanelComponent devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
            if (!(devicePanelComponent instanceof Shelf)) continue;
            Shelf shelf = (Shelf)devicePanelComponent;
            shelf.setOnBehindFrame(bl);
        }
    }

    @Override
    public void setName(String string) {
        int n;
        super.setName(string);
        StringBuffer stringBuffer = new StringBuffer(35);
        int n2 = this.drawingPanels.length;
        stringBuffer.append(string).append("_drawingPanels_");
        for (n = 0; n < n2; ++n) {
            if (this.drawingPanels[n] == null) continue;
            this.drawingPanels[n].setName(stringBuffer.toString() + n);
        }
        n2 = this.scrollDrawingPanels.length;
        stringBuffer = new StringBuffer(45);
        stringBuffer.append(string).append("_scrollDrawingPanels_");
        for (n = 0; n < n2; ++n) {
            if (this.scrollDrawingPanels[n] == null) continue;
            this.scrollDrawingPanels[n].setName(stringBuffer.toString() + n);
        }
        if (this.legendDividerPanel != null) {
            this.legendDividerPanel.setName(string + "_legendDividerPanel");
        }
        if (this.legendPanel != null) {
            this.legendPanel.setName(string + "_legendPanel");
        }
        if (this.emuPanel != null) {
            this.emuPanel.setName(string + "_emuPanel");
        }
    }

    private void fireBehidActionListener(Shelf shelf) {
        Object[] objectArray = this.getBehidListeners().getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ActionListener.class) continue;
            ActionEvent actionEvent = new ActionEvent(shelf, 1, "");
            ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent);
        }
    }

    class AssistantTabbedPaneUI
    extends BasicTabbedPaneUI {
        int tabExtraHeight = 0;
        int rowCount = 0;

        AssistantTabbedPaneUI() {
            this.tabPane = DevicePanel.this.drawingComponentTabbedPane;
            this.tabInsets = new Insets(0, 0, 0, 0);
            AssistantTabbedPaneLayout assistantTabbedPaneLayout = new AssistantTabbedPaneLayout();
            assistantTabbedPaneLayout.calculate();
        }

        int getTabExtraHeight() {
            return this.tabExtraHeight;
        }

        int getRowCount() {
            return this.rowCount;
        }

        @Override
        protected Insets getTabAreaInsets(int n) {
            return new Insets(0, 0, 0, 0);
        }

        class AssistantTabbedPaneLayout
        extends BasicTabbedPaneUI.TabbedPaneLayout {
            AssistantTabbedPaneLayout() {
                super(AssistantTabbedPaneUI.this);
            }

            void calculate() {
                int n = 1;
                int n2 = DevicePanel.this.devicePanelTreeModel.getConfigureUtilities().getPanelSize().width;
                FontMetrics fontMetrics = AssistantTabbedPaneUI.this.getFontMetrics();
                int n3 = AssistantTabbedPaneUI.this.tabPane.getTabCount();
                AssistantTabbedPaneUI.this.tabExtraHeight = 0;
                AssistantTabbedPaneUI.this.rowCount = 0;
                if (n3 > 0) {
                    AssistantTabbedPaneUI.this.rowCount = 1;
                    int n4 = 0;
                    int n5 = AssistantTabbedPaneUI.this.calculateMaxTabHeight(n);
                    for (int i = 0; i < n3; ++i) {
                        int n6 = AssistantTabbedPaneUI.this.calculateTabWidth(n, i, fontMetrics);
                        if (n4 != 0 && n4 + n6 > n2) {
                            ++AssistantTabbedPaneUI.this.rowCount;
                            n4 = 0;
                        }
                        n4 += n6;
                    }
                    AssistantTabbedPaneUI.this.tabExtraHeight = AssistantTabbedPaneUI.this.calculateTabAreaHeight(n, AssistantTabbedPaneUI.this.rowCount, n5);
                }
            }
        }
    }

    class ChangeHandler
    implements ChangeListener {
        ChangeHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            DevicePanel.this.behindShelfDialog.setVisible(false);
            emulationalShelfDialog.setVisible(false);
            DevicePanel.this.getCurrentDrawingPanelFromTabPane().repaintAgain();
        }
    }

    class FocusHandler
    extends FocusAdapter {
        FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (DevicePanel.this.drawingComponentTabbedPane != null) {
                DevicePanel.this.getCurrentDrawingPanelFromTabPane().requestFocus();
            } else {
                DevicePanel.this.drawingPanels[0].requestFocus();
            }
        }
    }

    class ModelChangeHandler
    implements ModelChangeListener {
        ModelChangeHandler() {
        }

        @Override
        public void stateChanged(DevicePanelItem[] devicePanelItemArray) {
            DevicePanel.this.processStateAlarmChangedEvent(devicePanelItemArray);
        }

        @Override
        public void progressChanged(DevicePanelItem[] devicePanelItemArray) {
            DevicePanel.this.processProgressChangedEvent(devicePanelItemArray);
        }

        @Override
        public void alarmChanged(DevicePanelItem[] devicePanelItemArray) {
            DevicePanel.this.processStateAlarmChangedEvent(devicePanelItemArray);
        }

        @Override
        public void alarmColorChanged() {
            DevicePanel.this.processModelChagedEvent(true);
        }

        @Override
        public void modelChanged() {
            DevicePanel.this.processModelChagedEvent(false);
        }

        @Override
        public void stateColorChanged(int[] nArray) {
            DevicePanel.this.processStateColorChagedEvent(nArray);
        }

        @Override
        public void userIconsAdded(DevicePanelItem[] devicePanelItemArray) {
            DevicePanel.this.processUserIconUpdated(devicePanelItemArray);
        }

        @Override
        public void userIconsRemoved(DevicePanelItem[] devicePanelItemArray) {
            DevicePanel.this.processUserIconUpdated(devicePanelItemArray);
        }

        @Override
        public void temperatureChanged(DevicePanelItem[] devicePanelItemArray) {
            DevicePanel.this.processStateTemperatureChangedEvent(devicePanelItemArray);
        }

        @Override
        public void componentAdded(DevicePanelComponent devicePanelComponent, EmptyComponent emptyComponent) {
            DrawingPanel drawingPanel = DevicePanel.this.processComponentAddedRemovedEvent(devicePanelComponent);
            if (drawingPanel != null) {
                DevicePanelComponent devicePanelComponent2;
                Graphics2D graphics2D;
                if (drawingPanel.getSelectedComponent() == emptyComponent) {
                    graphics2D = drawingPanel.getDrawingGraphics();
                    if (devicePanelComponent.isSelectable()) {
                        drawingPanel.setSelectedComponent(devicePanelComponent);
                        devicePanelComponent.setIsSelected(true);
                        devicePanelComponent.selectedShapedDraw(graphics2D);
                    } else {
                        devicePanelComponent2 = devicePanelComponent.getSelectableParentComponent();
                        if (devicePanelComponent2 == devicePanelComponent) {
                            drawingPanel.setSelectedComponent(null);
                        } else {
                            drawingPanel.setSelectedComponent(devicePanelComponent2);
                            devicePanelComponent2.setIsSelected(true);
                            if (drawingPanel instanceof BehindDrawingPanel && devicePanelComponent2 instanceof Shelf) {
                                ((Shelf)devicePanelComponent2).setBehindEnabled(true);
                                devicePanelComponent2.selectedShapedDraw(graphics2D);
                                ((Shelf)devicePanelComponent2).setBehindEnabled(false);
                            } else {
                                devicePanelComponent2.selectedShapedDraw(graphics2D);
                            }
                        }
                    }
                    graphics2D.dispose();
                }
                if (drawingPanel.selectedComponent instanceof EmptyComponent) {
                    graphics2D = drawingPanel.getDrawingGraphics();
                    drawingPanel.currentComponent = drawingPanel.selectedComponent.getNextComponent();
                    if (drawingPanel.currentComponent != null && drawingPanel.currentComponent instanceof Card && ((Card)(devicePanelComponent2 = (Card)drawingPanel.currentComponent)).getOccupiedTwoSlots()) {
                        drawingPanel.selectedComponent.draw(graphics2D);
                        drawingPanel.selectedComponent = devicePanelComponent2;
                        drawingPanel.selectedComponent.selectedShapedDraw(graphics2D);
                    }
                    graphics2D.dispose();
                }
                drawingPanel.repaint();
                if (DevicePanel.this.isParentActivated()) {
                    drawingPanel.grabFocus();
                }
            }
        }

        @Override
        public void componentVisibiltyChanged(DevicePanelComponent devicePanelComponent) {
            DrawingPanel drawingPanel = DevicePanel.this.processComponentAddedRemovedEvent(devicePanelComponent);
            if (drawingPanel != null) {
                DevicePanelComponent devicePanelComponent2 = drawingPanel.getSelectedComponent();
                if (null != devicePanelComponent2) {
                    DefaultMutableTreeNode defaultMutableTreeNode = devicePanelComponent2.getRelatedTreeNode();
                    if (defaultMutableTreeNode == null) {
                        drawingPanel.setSelectedComponent(null);
                    } else {
                        devicePanelComponent2.setIsSelected(true);
                        devicePanelComponent2.selectedShapedDraw(drawingPanel.getDrawingGraphics());
                    }
                }
                if (DevicePanel.this.behindShelfDialog.isVisible() && devicePanelComponent instanceof Shelf && DevicePanel.this.behindShelfDialog.getDrawingPanel().getContainer() == devicePanelComponent) {
                    DevicePanel.this.behindShelfDialog.setVisible(false);
                }
                drawingPanel.repaint();
                if (DevicePanel.this.isParentActivated()) {
                    drawingPanel.grabFocus();
                }
            }
        }

        @Override
        public void componentRemoved(DevicePanelComponent devicePanelComponent, EmptyComponent emptyComponent) {
            DrawingPanel drawingPanel = DevicePanel.this.processComponentAddedRemovedEvent(emptyComponent);
            if (drawingPanel != null) {
                Cloneable cloneable;
                Object object;
                if (drawingPanel.getSelectedComponent() == devicePanelComponent) {
                    object = drawingPanel.getDrawingGraphics();
                    if (emptyComponent.isSelectable() && emptyComponent.isVisibleAllowed()) {
                        drawingPanel.setSelectedComponent(emptyComponent);
                        emptyComponent.setIsSelected(true);
                        emptyComponent.selectedShapedDraw((Graphics2D)object);
                    } else {
                        cloneable = emptyComponent.getSelectableParentComponent();
                        if (cloneable == emptyComponent) {
                            drawingPanel.setSelectedComponent(null);
                        } else {
                            drawingPanel.setSelectedComponent((DevicePanelComponent)cloneable);
                            ((DevicePanelComponent)cloneable).setIsSelected(true);
                            if (drawingPanel instanceof BehindDrawingPanel && cloneable instanceof Shelf) {
                                ((Shelf)cloneable).setBehindEnabled(true);
                                ((DevicePanelComponent)cloneable).selectedShapedDraw((Graphics2D)object);
                                ((Shelf)cloneable).setBehindEnabled(false);
                            } else {
                                ((DevicePanelComponent)cloneable).selectedShapedDraw((Graphics2D)object);
                            }
                        }
                    }
                    ((Graphics)object).dispose();
                }
                if (null != (object = drawingPanel.getSelectedComponent())) {
                    cloneable = ((DevicePanelComponent)object).getRelatedTreeNode();
                    if (cloneable == null) {
                        drawingPanel.setSelectedComponent(null);
                    } else {
                        ((DevicePanelComponent)object).setIsSelected(true);
                        ((DevicePanelComponent)object).selectedShapedDraw(drawingPanel.getDrawingGraphics());
                    }
                }
                if (DevicePanel.this.behindShelfDialog.isVisible() && devicePanelComponent instanceof Shelf && DevicePanel.this.behindShelfDialog.getDrawingPanel().getContainer() == devicePanelComponent) {
                    DevicePanel.this.behindShelfDialog.setVisible(false);
                }
                drawingPanel.repaint();
                if (DevicePanel.this.isParentActivated()) {
                    drawingPanel.grabFocus();
                }
            }
        }
    }

    class MouseWheelHandler
    implements MouseWheelListener {
        private JScrollPane scrollPanel = null;

        public MouseWheelHandler(JScrollPane jScrollPane) {
            this.scrollPanel = jScrollPane;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (!this.scrollPanel.isWheelScrollingEnabled() || this.scrollPanel.getViewport().getView().getHeight() <= this.scrollPanel.getViewport().getHeight()) {
                this.scrollPanel.getParent().dispatchEvent(mouseWheelEvent);
            }
        }
    }
}

