/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.devicepanel.view;

import com.swimap.iview.templates.devicepanel.datasource.ComponentData;
import com.swimap.iview.templates.devicepanel.model.component.Shelf;
import com.swimap.iview.templates.devicepanel.view.BehindDrawingPanel;
import com.swimap.iview.templates.devicepanel.view.DevicePanel;
import com.swimap.iview.templates.devicepanel.view.DrawingPanel;
import com.swimap.iview.templates.devicepanel.view.FrontDrawingPanel;
import com.swimap.iview.templates.devicepanel.view.ResPropertiesBundle;
import com.swimap.iview.util.ScreenToolKit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

class BehindShelfDialog
extends JDialog {
    private ResPropertiesBundle res = ResPropertiesBundle.getInstance();
    private BehindDrawingPanel drawingPanel = null;
    private FrontDrawingPanel frontDrawingPanel = null;
    private static final int EXTEND_HEIGHT = 33;
    private static final int EXTEND_WIDTH = 8;
    private final int DEFAULT_WIDTH = 640;
    private final int DEFAULT_HEIGHT = 480;

    FrontDrawingPanel getFrontDrawingPanel() {
        return this.frontDrawingPanel;
    }

    BehindShelfDialog(JFrame jFrame, DevicePanel devicePanel) {
        super((Frame)jFrame, ResPropertiesBundle.getInstance().getString("BehindTitle"));
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.drawingPanel = new BehindDrawingPanel(new Shelf(new ComponentData("", "", "", null), new Rectangle(0, 0, 10, 10)), devicePanel);
        this.setTitle(this.drawingPanel.getTitle() + "-" + this.res.getString("BehindTitle"));
    }

    void setDrawingPanel(BehindDrawingPanel behindDrawingPanel) {
        this.setVisible(false);
        this.getContentPane().removeAll();
        this.drawingPanel.endTask();
        this.drawingPanel = behindDrawingPanel;
        Shelf shelf = (Shelf)this.drawingPanel.getContainer();
        shelf.setBehindEnabled(true);
        Graphics2D graphics2D = this.drawingPanel.getDrawingGraphics();
        shelf.draw(graphics2D);
        graphics2D.dispose();
        shelf.setBehindEnabled(false);
        this.drawingPanel.setPreferredSize(new Dimension(shelf.getWidth(), shelf.getHeight()));
        this.drawingPanel.setMinimumSize(new Dimension(shelf.getWidth(), shelf.getHeight()));
        JScrollPane jScrollPane = new JScrollPane(this.drawingPanel);
        this.getContentPane().add((Component)jScrollPane, "Center");
        int n = Math.min(640, shelf.getWidth() + 8);
        int n2 = Math.min(480, shelf.getHeight() + 33);
        this.setSize(n, n2);
        this.setTitle(this.drawingPanel.getTitle() + "-" + this.res.getString("BehindTitle"));
        ScreenToolKit.centerLocateToScreen(this);
        if (this.isModal()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BehindShelfDialog.this.setVisible(true);
                }
            });
        } else {
            this.setVisible(true);
        }
    }

    void setFrontDrawingPanel(FrontDrawingPanel frontDrawingPanel) {
        this.frontDrawingPanel = frontDrawingPanel;
    }

    DrawingPanel getDrawingPanel() {
        return this.drawingPanel;
    }

    void endTask() {
        if (this.drawingPanel != null) {
            this.drawingPanel.endTask();
        }
        this.frontDrawingPanel = null;
        this.dispose();
    }

    public void windowClosing() {
        ((BehindDrawingPanel)this.getDrawingPanel()).clear();
    }
}

