/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.devicepanel.view;

import com.swimap.iview.templates.devicepanel.model.component.Shelf;
import com.swimap.iview.templates.devicepanel.view.DevicePanel;
import com.swimap.iview.templates.devicepanel.view.DrawingPanel;
import com.swimap.iview.templates.devicepanel.view.FrontDrawingPanel;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;

class BehindDrawingPanel
extends DrawingPanel {
    Shelf shelf = null;
    private DrawingPanel frontDrawingPanel = null;
    private String title = null;

    BehindDrawingPanel(Shelf shelf, DevicePanel devicePanel) {
        super(shelf, devicePanel);
        this.shelf = shelf;
        this.title = this.getParentTitle(devicePanel);
    }

    public String getTitle() {
        return this.title;
    }

    private String getParentTitle(JPanel jPanel) {
        String string = null;
        for (Container container = jPanel.getParent(); container != null; container = container.getParent()) {
            if (container instanceof JInternalFrame) {
                string = ((JInternalFrame)container).getTitle();
                break;
            }
            if (container instanceof JFrame) {
                string = ((JFrame)container).getTitle();
                break;
            }
            if (!(container instanceof JDialog)) continue;
            string = ((JDialog)container).getTitle();
            break;
        }
        return string;
    }

    protected void setFrontDrawingPanel(DrawingPanel drawingPanel) {
        this.frontDrawingPanel = drawingPanel;
    }

    protected DrawingPanel getFrontDrawingPanel() {
        return this.frontDrawingPanel;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.keepOneSelected();
        this.shelf.setBehindEnabled(true);
        super.mousePressed(mouseEvent);
        this.shelf.setBehindEnabled(false);
    }

    @Override
    protected void keepOneSelected() {
        this.shelf.setBehindEnabled(false);
        if (this.devicePanel == null) {
            return;
        }
        if (this.devicePanel.getBehindShelfDialog() == null) {
            return;
        }
        FrontDrawingPanel frontDrawingPanel = this.devicePanel.getBehindShelfDialog().getFrontDrawingPanel();
        if (frontDrawingPanel == null) {
            return;
        }
        if (frontDrawingPanel.selectedComponent != null) {
            Graphics2D graphics2D = frontDrawingPanel.getDrawingGraphics();
            frontDrawingPanel.selectedComponent.draw(graphics2D);
            frontDrawingPanel.selectedComponent = null;
            frontDrawingPanel.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.keepOneSelected();
        this.shelf.setBehindEnabled(true);
        super.mouseReleased(mouseEvent);
        this.shelf.setBehindEnabled(false);
    }

    @Override
    protected void progressRightClick(MouseEvent mouseEvent) {
        this.shelf.setBehindEnabled(true);
        super.progressRightClick(mouseEvent);
        this.shelf.setBehindEnabled(false);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.shelf.setBehindEnabled(true);
        super.mouseClicked(mouseEvent);
        this.shelf.setBehindEnabled(false);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.shelf.setBehindEnabled(true);
        super.mouseMoved(mouseEvent);
        this.shelf.setBehindEnabled(false);
    }

    @Override
    void endTask() {
        super.endTask();
    }

    void clear() {
        this.frontDrawingPanel = null;
        this.shelf = null;
        this.selectedComponent = null;
    }

    public Shelf getShelf() {
        return this.shelf;
    }

    @Override
    protected void extentLastToFirst() {
        if (this.selectedComponent instanceof Shelf) {
            return;
        }
        this.shelf.setBehindEnabled(true);
        super.extentLastToFirst();
        this.shelf.setBehindEnabled(false);
    }

    @Override
    protected void extentFirstToLast() {
        if (this.selectedComponent instanceof Shelf) {
            return;
        }
        this.shelf.setBehindEnabled(true);
        super.extentFirstToLast();
        this.shelf.setBehindEnabled(false);
    }

    @Override
    protected void DepthHightToLower() {
        this.shelf.setBehindEnabled(true);
        super.DepthHightToLower();
        this.shelf.setBehindEnabled(false);
    }

    @Override
    protected void depthLowerToHight() {
        this.shelf.setBehindEnabled(true);
        super.depthLowerToHight();
        this.shelf.setBehindEnabled(false);
    }

    @Override
    protected void keyReleased() {
        this.shelf.setBehindEnabled(true);
        super.keyReleased();
        this.shelf.setBehindEnabled(false);
    }
}

