/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.devicepanel.model.component;

import com.swimap.iview.templates.devicepanel.datasource.ComponentData;
import com.swimap.iview.templates.devicepanel.model.component.EnvironmentItem;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.text.MessageFormat;
import java.text.NumberFormat;

public class TemperatureEnvironmentItem
extends EnvironmentItem {
    private static IviewLogger logger = IviewLogger.getLogger(TemperatureEnvironmentItem.class, "IVIEW");
    private static final int WEIGHT = 20;
    private static final int EMULATE_SIZE = 14;
    private static final int FACILITY_SIZE = 12;
    private static final int BASE_DGREE = 32;
    private static final double UNIT_DGREE = 1.8;
    protected Color rimColor = SHELF_BACKGROUND_COLOR;
    protected Font font = null;
    private int temperature = -1;
    private NumberFormat formatter = NumberFormat.getInstance();
    private int temperatureModel = 0;

    public void setTemperature(int n) {
        this.temperature = n;
    }

    public int getTemperature() {
        return this.temperature;
    }

    private String getFahrenheit() {
        double d = 1.8 * (double)this.getTemperature() + 32.0;
        return this.formatter.format(d);
    }

    public TemperatureEnvironmentItem(String string, String string2, Rectangle rectangle) {
        super(string, string2, rectangle);
        this.isShowSlot = false;
        this.formatter.setMinimumFractionDigits(1);
    }

    public TemperatureEnvironmentItem(ComponentData componentData, Rectangle rectangle) {
        super(componentData, rectangle);
        this.isShowSlot = false;
        this.formatter.setMinimumFractionDigits(1);
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        int n = this.bound.x;
        int n2 = this.bound.y;
        int n3 = this.bound.width;
        int n4 = this.bound.height;
        int n5 = this.isIsFacility() ? 12 : 14;
        Font font = graphics2D.getFont();
        try {
            n5 = this.isIsFacility() ? Integer.parseInt(this.res.getString("TemperatureItem_Facility_FontSize")) : Integer.parseInt(this.res.getString("TemperatureItem_Emulational_FontSize"));
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        if (0 < this.getFontSize()) {
            n5 = this.getFontSize();
        }
        if (n4 < n5) {
            n4 = n5;
        }
        this.font = new Font(this.res.getString("Font"), 0, n5);
        graphics2D.setFont(this.font);
        graphics2D.setPaint(this.rimColor);
        graphics2D.fillRect(n - 10, n2, n3 + 20, n4);
        graphics2D.setPaint(Color.gray);
        graphics2D.drawLine(n - 10, n2, n + n3 + 10, n2);
        graphics2D.setPaint(Color.black);
        graphics2D.drawString(this.getTemperatureDesc(), this.bound.x, this.bound.y + this.bound.height - 3);
        graphics2D.setFont(font);
    }

    private String getTemperatureDesc() {
        StringBuffer stringBuffer = new StringBuffer(this.res.getString("Temperature"));
        if (this.getTemperature() == -1) {
            stringBuffer.append(this.res.getString("Unknown"));
        } else {
            switch (this.temperatureModel) {
                case 0: {
                    stringBuffer.append(MessageFormat.format(this.res.getString("MixTemperture"), String.valueOf(this.getTemperature()), String.valueOf(this.getFahrenheit())));
                    break;
                }
                case 1: {
                    stringBuffer.append(MessageFormat.format(this.res.getString("Celsius"), String.valueOf(this.getTemperature())));
                    break;
                }
                case 2: {
                    stringBuffer.append(MessageFormat.format(this.res.getString("Fahrenheit"), String.valueOf(this.getFahrenheit())));
                    break;
                }
                default: {
                    stringBuffer.append(MessageFormat.format(this.res.getString("MixTemperture"), String.valueOf(this.getTemperature()), String.valueOf(this.getFahrenheit())));
                }
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public void selectedShapedDraw(Graphics2D graphics2D) {
    }

    public void setTemperatureModel(int n) {
        this.temperatureModel = n;
    }
}

