/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.devicepanel.model.component;

import com.swimap.iview.templates.devicepanel.datasource.ComponentData;
import com.swimap.iview.templates.devicepanel.model.ChildPositionType;
import com.swimap.iview.templates.devicepanel.model.component.Card;
import com.swimap.iview.templates.devicepanel.model.component.DevicePanelComponent;
import com.swimap.iview.templates.devicepanel.model.component.EnvironmentItem;
import com.swimap.iview.templates.devicepanel.model.component.Frame;
import com.swimap.iview.templates.devicepanel.model.component.TemperatureEnvironmentItem;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.tree.DefaultMutableTreeNode;

public class Shelf
extends DevicePanelComponent {
    protected String label = null;
    protected int frontChildCount = 0;
    protected boolean isAutoNumber = true;
    protected boolean isShowOpenEmulationalToolTip = true;
    protected String shelfName = null;
    protected ChildPositionType[] childPosition = null;
    protected Font shelfLableFont = null;
    protected Color shelfLableColor = null;
    protected Font slotLableFont = null;
    protected Color slotLableColor = null;
    private boolean environmentItemVisible = true;
    private int environmentItemRowsHight = 0;
    private boolean isOnbehindFrame = false;

    public Shelf(String string, String string2, Rectangle rectangle) {
        super(string, string2, rectangle);
    }

    public Shelf(ComponentData componentData, Rectangle rectangle) {
        super(componentData, rectangle);
        this.isAutoNumber = componentData.getIsAutoSerialNumber();
        this.isShowOpenEmulationalToolTip = componentData.getIsShowOpenEmulationalToolTip();
    }

    @Override
    public void selectedShapedDraw(Graphics2D graphics2D) {
        int n = this.bound.x;
        int n2 = this.bound.y;
        int n3 = this.bound.height;
        int n4 = this.bound.width;
        if (!this.isFacility && (this.behindEnabled && !this.isOnbehindFrame || DevicePanelComponent.isOpenEmulational)) {
            n = 0;
            n2 = 0;
        }
        for (int i = 0; i < 5; ++i) {
            if (i == 0 || i == 4) {
                graphics2D.setPaint(Color.white);
            } else {
                graphics2D.setPaint(SELECTED_COLOR);
            }
            graphics2D.drawRect(n + i, n2 + i, n4 - 2 * i, n3 - 2 * i);
        }
    }

    public int getFrontChildCount() {
        return this.frontChildCount;
    }

    public void setChildPosition(ChildPositionType[] childPositionTypeArray) {
        if (childPositionTypeArray != null) {
            this.childPosition = childPositionTypeArray;
        }
    }

    public ChildPositionType[] getChildPosition() {
        return this.childPosition;
    }

    public void calculateChildPosition(int n, int n2) {
    }

    public int getOccupiedShelfNum() {
        return 1;
    }

    public void setFrontChildCount(int n) {
        this.frontChildCount = n;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public boolean isInArea(int n, int n2) {
        return false;
    }

    public boolean isBehindChildrenDisplayingAllowed(int n, int n2) {
        return this.getRelatedTreeNode().getChildCount() > this.frontChildCount;
    }

    @Override
    public void adjustToAbsaluteCordination(int n, int n2) {
        if (this.isIsFacility()) {
            this.adjustFacilityToAbsaluteCordination();
        } else if (DevicePanelComponent.isOpenEmulational) {
            this.adjustOpenEmuToAbsaluteCordination();
        } else {
            this.adjustEmulationalToAbsaluteCordination();
        }
    }

    private void adjustFacilityToAbsaluteCordination() {
        Cloneable cloneable;
        int n;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.relatedTreeNode.getParent();
        Frame frame = (Frame)defaultMutableTreeNode.getUserObject();
        this.belongingPageIndex = (this.bound.y - frame.getAreaHeight()) / (frame.getHeight() - frame.getAreaHeight() - 5);
        this.bound.x += frame.getStartX();
        this.bound.y = (this.bound.y + 2 - frame.getAreaHeight()) % (frame.getHeight() - frame.getAreaHeight()) + frame.getAreaHeight();
        for (n = 0; n < this.frontChildCount; ++n) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.relatedTreeNode.getChildAt(n);
            cloneable = (DevicePanelComponent)defaultMutableTreeNode2.getUserObject();
            ((DevicePanelComponent)cloneable).setIsFacility(this.isIsFacility());
            ((DevicePanelComponent)cloneable).setBehindEnabled(false);
            ((DevicePanelComponent)cloneable).adjustToAbsaluteCordination(this.bound.x, this.bound.y);
        }
        n = this.relatedTreeNode.getChildCount();
        for (int i = this.frontChildCount; i < n; ++i) {
            cloneable = (DefaultMutableTreeNode)this.relatedTreeNode.getChildAt(i);
            DevicePanelComponent devicePanelComponent = (DevicePanelComponent)((DefaultMutableTreeNode)cloneable).getUserObject();
            devicePanelComponent.setIsFacility(this.isIsFacility());
            devicePanelComponent.setBehindEnabled(true);
            devicePanelComponent.adjustToAbsaluteCordination(this.bound.x, this.bound.y);
        }
        this.setBelongingPageIndex(this.belongingPageIndex);
    }

    private void adjustOpenEmuToAbsaluteCordination() {
        Cloneable cloneable;
        int n;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.relatedTreeNode.getParent();
        Frame frame = (Frame)defaultMutableTreeNode.getUserObject();
        this.belongingPageIndex = (this.bound.y - frame.getAreaHeight()) / (frame.getHeight() - frame.getAreaHeight() - 5);
        this.bound.x = 0;
        this.bound.y = 0;
        for (n = 0; n < this.frontChildCount; ++n) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.relatedTreeNode.getChildAt(n);
            cloneable = (DevicePanelComponent)defaultMutableTreeNode2.getUserObject();
            ((DevicePanelComponent)cloneable).setIsFacility(this.isIsFacility());
            ((DevicePanelComponent)cloneable).setBehindEnabled(false);
            ((DevicePanelComponent)cloneable).adjustToAbsaluteCordination(0, 0);
        }
        n = this.relatedTreeNode.getChildCount();
        for (int i = this.frontChildCount; i < n; ++i) {
            cloneable = (DefaultMutableTreeNode)this.relatedTreeNode.getChildAt(i);
            DevicePanelComponent devicePanelComponent = (DevicePanelComponent)((DefaultMutableTreeNode)cloneable).getUserObject();
            devicePanelComponent.setIsFacility(this.isIsFacility());
            devicePanelComponent.setBehindEnabled(true);
            devicePanelComponent.adjustToAbsaluteCordination(0, 0);
        }
        this.setBelongingPageIndex(this.belongingPageIndex);
    }

    private void adjustEmulationalToAbsaluteCordination() {
        Cloneable cloneable;
        int n;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.relatedTreeNode.getParent();
        Frame frame = (Frame)defaultMutableTreeNode.getUserObject();
        this.belongingPageIndex = (this.bound.y - frame.getAreaHeight()) / (frame.getHeight() - frame.getAreaHeight() - 5);
        this.bound.x += frame.getStartX();
        this.bound.y = (this.bound.y + 2 - frame.getAreaHeight()) % (frame.getHeight() - frame.getAreaHeight()) + frame.getAreaHeight();
        for (n = 0; n < this.frontChildCount; ++n) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.relatedTreeNode.getChildAt(n);
            cloneable = (DevicePanelComponent)defaultMutableTreeNode2.getUserObject();
            ((DevicePanelComponent)cloneable).setIsFacility(this.isIsFacility());
            ((DevicePanelComponent)cloneable).setBehindEnabled(false);
            ((DevicePanelComponent)cloneable).adjustToAbsaluteCordination(this.bound.x, this.bound.y);
        }
        n = this.relatedTreeNode.getChildCount();
        for (int i = this.frontChildCount; i < n; ++i) {
            cloneable = (DefaultMutableTreeNode)this.relatedTreeNode.getChildAt(i);
            DevicePanelComponent devicePanelComponent = (DevicePanelComponent)((DefaultMutableTreeNode)cloneable).getUserObject();
            devicePanelComponent.setIsFacility(this.isIsFacility());
            devicePanelComponent.setBehindEnabled(true);
            devicePanelComponent.adjustToAbsaluteCordination(0, 0);
        }
        this.setBelongingPageIndex(this.belongingPageIndex);
    }

    @Override
    public boolean isPointInArea(int n, int n2) {
        if (this.isIsFacility()) {
            return this.bound.contains(n, n2);
        }
        if (DevicePanelComponent.isOpenEmulational) {
            return n >= 0 && n < this.bound.width && n2 >= 0 && n2 < this.bound.height;
        }
        if (!this.behindEnabled || this.isOnbehindFrame) {
            return this.bound.contains(n, n2);
        }
        return n >= 0 && n < this.bound.width && n2 >= 0 && n2 < this.bound.height;
    }

    public void drawStateBar(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        graphics2D.setPaint(Color.white);
        graphics2D.drawLine(n, n2, n, n2 + n4);
        graphics2D.drawLine(n, n2, n + n3, n2);
        graphics2D.setPaint(Color.gray);
        graphics2D.drawLine(n + n3, n2, n + n3, n2 + n4);
        graphics2D.drawLine(n, n2 + n4, n + n3, n2 + n4);
        graphics2D.setPaint(this.getBackground());
        graphics2D.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
        if (this.isIsFacility()) {
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = this.frontChildCount;
            if (!this.getBehindEnabled()) {
                n7 = this.getFrontChildCount();
                n8 = this.getRelatedTreeNode().getChildCount();
            }
            if (this.frontChildCount == this.getRelatedTreeNode().getChildCount() && this.getBehindEnabled()) {
                n7 = 0;
                n8 = this.getFrontChildCount();
            }
            while (n7 < n8) {
                DevicePanelComponent devicePanelComponent = (DevicePanelComponent)((DefaultMutableTreeNode)this.getRelatedTreeNode().getChildAt(n7)).getUserObject();
                Color color = this.getBackground();
                if (devicePanelComponent != null && devicePanelComponent instanceof Card) {
                    Card card = (Card)devicePanelComponent;
                    n5 = card.bound.width;
                    n6 = card.bound.x;
                    if (card.stateObject != null) {
                        color = card.stateObject.getColor();
                    }
                    int n9 = n6 + n5 / 4;
                    this.drawBarState(graphics2D, n9, n2 + n4 / 4, n5 / 2, n4 / 2, color);
                }
                ++n7;
            }
        }
    }

    protected void drawBarState(Graphics2D graphics2D, int n, int n2, int n3, int n4, Color color) {
        graphics2D.setPaint(color);
        graphics2D.fillRect(n, n2, n3, n4);
        graphics2D.setPaint(Color.black);
        graphics2D.drawLine(n, n2, n, n2 + n4);
        graphics2D.drawLine(n, n2, n + n3, n2);
        graphics2D.setPaint(Color.white);
        graphics2D.drawLine(n + n3, n2 + n4, n + n3, n2);
        graphics2D.drawLine(n + n3, n2 + n4, n, n2 + n4);
    }

    @Override
    public DevicePanelComponent matchCurrentComponent(int n, int n2) {
        if (!this.isPointInArea(n, n2)) {
            return null;
        }
        if (!this.getBehindEnabled()) {
            for (int i = 0; i < this.frontChildCount; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.relatedTreeNode.getChildAt(i);
                DevicePanelComponent devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
                DevicePanelComponent devicePanelComponent2 = devicePanelComponent.matchCurrentComponent(n, n2);
                if (devicePanelComponent2 == null) continue;
                return devicePanelComponent2;
            }
        } else {
            int n3 = this.relatedTreeNode.getChildCount();
            for (int i = this.frontChildCount; i < n3; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.relatedTreeNode.getChildAt(i);
                DevicePanelComponent devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
                DevicePanelComponent devicePanelComponent3 = devicePanelComponent.matchCurrentComponent(n, n2);
                if (devicePanelComponent3 == null) continue;
                return devicePanelComponent3;
            }
        }
        return this;
    }

    @Override
    public void setCurrentPageIndex(int n) {
        this.currentPageIndex = n;
        for (int i = 0; i < this.frontChildCount; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.relatedTreeNode.getChildAt(i);
            DevicePanelComponent devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
            devicePanelComponent.setCurrentPageIndex(n);
        }
    }

    public void setIsAutoNumber(boolean bl) {
        this.isAutoNumber = bl;
    }

    public void setIsShowOpenEmulationalToolTip(boolean bl) {
        this.isShowOpenEmulationalToolTip = bl;
    }

    public boolean getIsShowOpenEmulationalToolTip() {
        return this.isShowOpenEmulationalToolTip;
    }

    public void setShelfName(String string) {
        this.shelfName = string;
    }

    public String getShelfName() {
        return this.shelfName;
    }

    @Override
    public void setBelongingPageIndex(int n) {
        for (int i = 0; i < this.frontChildCount; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.relatedTreeNode.getChildAt(i);
            DevicePanelComponent devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
            devicePanelComponent.setBelongingPageIndex(n);
        }
    }

    @Override
    public DevicePanelComponent getFirstChild() {
        if (!this.getBehindEnabled()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getRelatedTreeNode().getFirstChild();
            DevicePanelComponent devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
            return devicePanelComponent;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getRelatedTreeNode().getChildAt(this.frontChildCount);
        DevicePanelComponent devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
        return devicePanelComponent;
    }

    @Override
    public DevicePanelComponent getFirstSelectableChild() {
        DevicePanelComponent devicePanelComponent = this.getFirstChild();
        if (null == devicePanelComponent) {
            return null;
        }
        DevicePanelComponent devicePanelComponent2 = devicePanelComponent;
        while ((!devicePanelComponent2.isSelectable() || devicePanelComponent2 instanceof TemperatureEnvironmentItem) && (devicePanelComponent2 = devicePanelComponent2.getNextComponent()) != devicePanelComponent) {
        }
        if (!devicePanelComponent2.isSelectable() || devicePanelComponent2 instanceof TemperatureEnvironmentItem) {
            return null;
        }
        return devicePanelComponent2;
    }

    @Override
    public DevicePanelComponent getSelectableParentComponent() {
        DevicePanelComponent devicePanelComponent = this;
        do {
            if (null == (devicePanelComponent = devicePanelComponent.getParentComponent())) {
                return this;
            }
            if (!(devicePanelComponent instanceof Frame) || devicePanelComponent.isSelectable()) continue;
            return this;
        } while (!devicePanelComponent.isSelectable());
        return devicePanelComponent;
    }

    public DevicePanelComponent getLastChild() {
        if (!this.getBehindEnabled()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getRelatedTreeNode().getChildAt(this.frontChildCount - 1);
            DevicePanelComponent devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
            return devicePanelComponent;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getRelatedTreeNode().getLastChild();
        DevicePanelComponent devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
        return devicePanelComponent;
    }

    @Override
    public DevicePanelComponent getLeaf() {
        DevicePanelComponent devicePanelComponent = null;
        devicePanelComponent = this.getFirstChild();
        while (true) {
            if (devicePanelComponent instanceof TemperatureEnvironmentItem) {
                devicePanelComponent = devicePanelComponent.getNextComponent();
            }
            if (devicePanelComponent.getRelatedTreeNode().isLeaf()) break;
            devicePanelComponent = devicePanelComponent.getFirstChild();
        }
        return devicePanelComponent;
    }

    public void setShelfLableFont(Font font) {
        this.shelfLableFont = font;
    }

    public Font getShelfLableFont() {
        return this.shelfLableFont;
    }

    public void setShelfLableColor(Color color) {
        this.shelfLableColor = color;
    }

    public Color getShelfLableColor() {
        return this.shelfLableColor;
    }

    public void setSlotLableFont(Font font) {
        this.slotLableFont = font;
    }

    public Font getSlotLableFont() {
        return this.slotLableFont;
    }

    public void setSlotLableColor(Color color) {
        this.slotLableColor = color;
    }

    public Color getSlotLableColor() {
        return this.slotLableColor;
    }

    public void setEnvironmentItemVisible(boolean bl) {
        this.environmentItemVisible = bl;
    }

    public boolean isEnvironmentItemVisible() {
        return this.environmentItemVisible;
    }

    public int getEnvironmentItemRowsHight() {
        if (this.environmentItemRowsHight == 0) {
            int n = 0;
            int n2 = 0;
            double d = 0.0;
            int n3 = this.relatedTreeNode.getChildCount();
            for (int i = 0; i < n3; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.relatedTreeNode.getChildAt(i);
                DevicePanelComponent devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
                if (!(devicePanelComponent instanceof EnvironmentItem)) continue;
                if (Math.abs(d - devicePanelComponent.bound.getY()) > 2.0) {
                    d = devicePanelComponent.bound.getY();
                    ++n;
                }
                if (devicePanelComponent.bound.height <= n2) continue;
                n2 = devicePanelComponent.bound.height;
            }
            this.environmentItemRowsHight = n2 * n;
        }
        return this.environmentItemRowsHight;
    }

    public void setOnBehindFrame(boolean bl) {
        this.isOnbehindFrame = bl;
        if (this.isFacility) {
            return;
        }
        for (int i = this.frontChildCount; i < this.relatedTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.relatedTreeNode.getChildAt(i);
            DevicePanelComponent devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
            if (this.isOnbehindFrame) {
                devicePanelComponent.adjustLocation(this.bound.x, this.bound.y);
                continue;
            }
            devicePanelComponent.adjustLocation(-this.bound.x, -this.bound.y);
        }
    }

    public boolean isOnBehindFrame() {
        return this.isOnbehindFrame;
    }
}

