/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.devicepanel.model.component;

import com.swimap.iview.templates.devicepanel.DevicePanelConstants;
import com.swimap.iview.templates.devicepanel.DevicePanelUtil;
import com.swimap.iview.templates.devicepanel.datasource.ComponentData;
import com.swimap.iview.templates.devicepanel.model.component.Card;
import com.swimap.iview.templates.devicepanel.model.component.ComposeEnvironmentItem;
import com.swimap.iview.templates.devicepanel.model.component.DevicePanelComponent;
import com.swimap.iview.templates.devicepanel.model.component.EmptyComponent;
import com.swimap.iview.templates.devicepanel.model.component.EnvironmentItem;
import com.swimap.iview.templates.devicepanel.model.component.RegularEnvironmentItem;
import com.swimap.iview.templates.devicepanel.model.component.Shelf;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class RegularShelf
extends Shelf
implements DevicePanelConstants {
    private static IviewLogger logger = IviewLogger.getLogger(RegularShelf.class, "IVIEW");
    private static final int SLOT_POSITION = 15;
    private static final int POSITION_MAX_OFFSET = 30;
    protected boolean slotLabelEnabled = true;
    protected Color rimColor = SHELF_BACKGROUND_COLOR;
    protected int topGirderHeight = 0;
    protected int itemAreaWidth = 0;
    protected int itemAreaHeight = 0;
    protected Font font = null;
    protected ImageIcon nutIcon = new ImageIcon(RegularShelf.class.getResource("nut.gif"));
    private String slotPosition = "bottom";
    private int slotBeginValue = 0;
    private FontMetrics metric = null;
    protected int slotHeight = 16;
    protected int slotDrawPositionSpace = 0;

    public RegularShelf(String string, String string2, Rectangle rectangle) {
        super(string, string2, rectangle);
    }

    public RegularShelf(ComponentData componentData, Rectangle rectangle) {
        super(componentData, rectangle);
        this.reinit();
    }

    public void setSlotBeginValue(int n) {
        this.slotBeginValue = n;
    }

    @Override
    public void reinit() {
        this.topGirderHeight = 15;
        this.itemAreaWidth = this.bound.width - 40 - 20;
        this.itemAreaHeight = this.bound.height - this.topGirderHeight - 25;
        int n = (this.bound.width - 20 - this.itemAreaWidth) / 2;
        n = n < 30 ? n : 30;
        this.font = new Font("Serif", 1, n + 2);
    }

    public void setSlotPosition(String string) {
        if (string != null) {
            this.slotPosition = string;
        }
    }

    public String getSlotPosition() {
        return this.slotPosition;
    }

    public boolean isSlotLabelEnabled() {
        return this.slotLabelEnabled;
    }

    public void setSlotLabelEnabled(boolean bl) {
        this.slotLabelEnabled = bl;
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        if (this.isIsFacility()) {
            this.drawFacility(graphics2D);
        } else {
            this.drawEmulational(graphics2D);
        }
    }

    public void drawFacility(Graphics2D graphics2D) {
        this.topGirderHeight = 20;
        this.itemAreaHeight = this.bound.height - this.topGirderHeight - 25;
        int n = this.bound.width;
        int n2 = this.bound.height;
        int n3 = (n - 20 - this.itemAreaWidth) / 2;
        int n4 = 5;
        int n5 = this.bound.x;
        int n6 = this.bound.y;
        graphics2D.setPaint(this.getBackground());
        graphics2D.fillRect(n5, n6, this.bound.width, this.bound.height);
        graphics2D.setPaint(Color.white);
        graphics2D.draw3DRect(n5, n6, this.bound.width - 1, this.bound.height - 1, true);
        graphics2D.setPaint(this.rimColor);
        graphics2D.fillRect(n5 + n3, n6 + this.topGirderHeight, this.itemAreaWidth + n3, this.itemAreaHeight);
        Font font = graphics2D.getFont();
        graphics2D.setFont(this.font);
        graphics2D.setPaint(Color.black);
        graphics2D.drawLine(n5 + n4, n6 + n2, n5 + n3, n6 + n2);
        graphics2D.drawLine(n5 + n - 1 - n4, n6 + n2, n5 + n - 1 - n3, n6 + n2);
        graphics2D.drawLine(n5 + n3, n6 + n2, n5 + n3, n6 + n2 - 4);
        graphics2D.drawLine(n5 + n3, n6 + n2 - 4, n5 + n - 1 - n3 - 2, n6 + n2 - 4);
        graphics2D.drawLine(n5 + n3, n6 + n2 - 5, n5 + n - 1 - n3 - 2, n6 + n2 - 5);
        graphics2D.drawLine(n5 + n - 1 - n3 - 2, n6 + n2 - 4, n5 + n - 1 - n3 - 2, n6 + n2 - 6);
        graphics2D.setPaint(Color.white);
        graphics2D.drawLine(n5 + n3, n6 + n2 - 6, n5 + n - 1 - n3 - 2, n6 + n2 - 6);
        graphics2D.drawLine(n5 + n - 1 - n3, n6 + n2, n5 + n - 1 - n3, n6 + n2 - 6);
        graphics2D.drawLine(n5 + n - 1 - n3, n6 + this.topGirderHeight + this.itemAreaHeight, n5 + n - 1 - n3, n6 + this.topGirderHeight);
        graphics2D.setPaint(Color.black);
        graphics2D.drawLine(n5 + n3, n6 + n2, n5 + n3, n6 + n2 - 6);
        graphics2D.drawLine(n5 + n3, n6 + this.topGirderHeight + this.itemAreaHeight, n5 + n3, n6 + this.topGirderHeight);
        graphics2D.setPaint(Color.white);
        graphics2D.drawLine(n5 + n3, n6 + this.topGirderHeight + this.itemAreaHeight, n5 + n - 1 - n3, n6 + this.topGirderHeight + this.itemAreaHeight);
        int n7 = this.nutIcon.getIconWidth();
        int n8 = this.nutIcon.getIconHeight();
        int n9 = (n3 - n7) / 2;
        this.nutIcon.paintIcon(null, graphics2D, n5 + n9, n6 + n9);
        this.nutIcon.paintIcon(null, graphics2D, n5 + n9, n6 + n2 - 1 - n9 - n8);
        this.nutIcon.paintIcon(null, graphics2D, n5 + n - 1 - n9 - n7, n6 + n9);
        this.nutIcon.paintIcon(null, graphics2D, n5 + n - 1 - n9 - n7, n6 + n2 - 1 - n9 - n8);
        int n10 = n5 + 20;
        int n11 = n6 + this.topGirderHeight / 4 - 1;
        int n12 = n - 40;
        int n13 = this.topGirderHeight / 5 * 3;
        if (this.getRelatedTreeNode().getChildCount() > this.frontChildCount) {
            this.drawStateBar(graphics2D, n10, n11, n12, n13);
        } else if (this.getBehindEnabled()) {
            this.drawStateBar(graphics2D, n10, n11, n12, n13);
        }
        graphics2D.setPaint(this.rimColor);
        graphics2D.fillRect(n5 + n3, n6 + this.topGirderHeight, 10, this.itemAreaHeight + 1);
        graphics2D.fillRect(n5 + n - 1 - n3 - 10 + 1, n6 + this.topGirderHeight - 1, 10, this.itemAreaHeight + 1);
        graphics2D.drawArc(n5, n6 + n2 - 1 - 2 * n4, 2 * n4, 2 * n4, 180, 90);
        graphics2D.drawArc(n5 + 1, n6 + n2 - 1 - 2 * n4, 2 * n4, 2 * n4, 180, 90);
        graphics2D.drawLine(n5 + n4 - 2, n6 + n2 - 1, n5 + n3 - 1, n6 + n2 - 1);
        graphics2D.drawLine(n5 + n4 - 3, n6 + n2 - 1 - 1, n5 + n3 - 1, n6 + n2 - 1 - 1);
        graphics2D.drawLine(n5 + n3 - 1, n6 + n2 - 1, n5 + n3 - 1, n6 + n2 - 6);
        graphics2D.drawLine(n5 + n3 - 2, n6 + n2 - 2, n5 + n3 - 2, n6 + n2 - 6);
        graphics2D.drawLine(n5 + n3 - 2, n6 + n2 - 6, n5 + n - 1 - n3, n6 + n2 - 6);
        graphics2D.drawLine(n5 + n3 - 1, n6 + n2 - 7, n5 + n - 1 - n3, n6 + n2 - 7);
        graphics2D.setPaint(Color.white);
        graphics2D.drawLine(n5 + n - 1 - n3 + 1, n6 + n2 - 1, n5 + n - 1 - n3 + 1, n6 + n2 - 6);
        graphics2D.drawLine(n5 + n - 1 - n3 + 2, n6 + n2 - 2, n5 + n - 1 - n3 + 2, n6 + n2 - 6);
        graphics2D.setPaint(this.rimColor);
        graphics2D.drawLine(n5 + n - 1 - n3 + 1, n6 + n2 - 1, n5 + n - 1 - n4, n6 + n2 - 1);
        graphics2D.drawLine(n5 + n - 1 - n3 + 2, n6 + n2 - 2, n5 + n - 1 - n4, n6 + n2 - 2);
        graphics2D.drawLine(n5 + n - 1 - 1, n6 + n2 - 4, n5 + n - 1 - 1, n6 + 3);
        graphics2D.drawLine(n5 + n - 1 - 2, n6 + n2 - 3, n5 + n - 1 - 2, n6 + 2);
        graphics2D.drawLine(n5 + n - 1 - 3, n6 + n2 - 2, n5 + n - 1 - 3, n6 + 1);
        graphics2D.drawArc(n5 + n - 1 - 2 * n4, n6 + n2 - 1 - 2 * n4, 2 * n4, 2 * n4, 270, 90);
        graphics2D.drawArc(n5 + n - 1 - 2 * n4 - 1, n6 + n2 - 1 - 2 * n4, 2 * n4, 2 * n4, 270, 90);
        graphics2D.setPaint(Color.white);
        graphics2D.drawLine(n5 + n - 1 - 4, n6 + 1, n5 + n - 1, n6 + 4);
        graphics2D.drawArc(n5 + n - 2 * n4, n6 + 1, 2 * n4 - 1, 2 * n4, 0, 90);
        graphics2D.drawArc(n5 + n - 2 * n4 - 1, n6 + 1, 2 * n4 - 1, 2 * n4, 0, 90);
        graphics2D.drawLine(n5 + 1, n6 + 1 + n4, n5 + 1, n6 + n2 - n4);
        graphics2D.drawLine(n5 + 2, n6 + n4, n5 + 2, n6 + n2 - n4 + 1);
        graphics2D.drawArc(n5, n6 + 1, 2 * n4, 2 * n4, 90, 90);
        graphics2D.drawArc(n5 + 1, n6 + 1, 2 * n4, 2 * n4, 90, 90);
        graphics2D.drawArc(n5 + 2, n6 + 1, 2 * n4, 2 * n4, 90, 90);
        graphics2D.setPaint(this.rimColor);
        graphics2D.drawLine(n5 + n3 - 1, n6 + this.topGirderHeight + this.itemAreaHeight, n5 + n3 - 1, n6 + this.topGirderHeight - 1);
        graphics2D.drawLine(n5 + n3 - 2, n6 + this.topGirderHeight + this.itemAreaHeight + 1, n5 + n3 - 2, n6 + this.topGirderHeight - 2);
        graphics2D.drawLine(n5 + n3 - 1, n6 + this.topGirderHeight - 1, n5 + n - 1 - n3 + 1, n6 + this.topGirderHeight - 1);
        graphics2D.drawLine(n5 + n3 - 2, n6 + this.topGirderHeight - 2, n5 + n - 1 - n3 + 2, n6 + this.topGirderHeight - 2);
        graphics2D.setPaint(Color.black);
        graphics2D.drawLine(n5 + n3 - 1, n6 + this.topGirderHeight - 1, n5 + n3 - 1, n6 + this.topGirderHeight + this.itemAreaHeight);
        graphics2D.drawLine(n5 + n + 1 - n3, n6 + this.topGirderHeight - 1, n5 + n + 1 - n3, n6 + this.topGirderHeight + this.itemAreaHeight - 1);
        graphics2D.setPaint(Color.white);
        graphics2D.drawLine(n5 + n - 1 - n3 + 1, n6 + this.topGirderHeight - 1, n5 + n - 1 - n3 + 1, n6 + this.topGirderHeight + this.itemAreaHeight + 1);
        graphics2D.drawLine(n5 + n - 1 - n3 + 2, n6 + this.topGirderHeight - 2, n5 + n - 1 - n3 + 2, n6 + this.topGirderHeight + this.itemAreaHeight + 1);
        graphics2D.drawLine(n5 + n - 1 - n3 + 1, n6 + this.topGirderHeight + this.itemAreaHeight + 1, n5 + n3 - 1, n6 + this.topGirderHeight + this.itemAreaHeight + 1);
        graphics2D.drawLine(n5 + n3, n6 + this.topGirderHeight + this.itemAreaHeight, n5 + n - n3, n6 + this.topGirderHeight + this.itemAreaHeight);
        graphics2D.setPaint(Color.black);
        graphics2D.drawLine(n5 + n - 1, n6 + 1 + n4, n5 + n - 1, n6 + n2 - 1 - n4);
        graphics2D.drawArc(n5 + n - 1 - 2 * n4, n6 + n2 - 1 - 2 * n4 + 1, 2 * n4, 2 * n4, 270, 90);
        graphics2D.drawArc(n5, n6 + n2 - 1 - 2 * n4 + 1, 2 * n4, 2 * n4, 180, 90);
        graphics2D.drawLine(n5 + n3, n6 + this.topGirderHeight, n5 + n - n3, n6 + this.topGirderHeight);
        if (this.isShowLot()) {
            this.drawShelfLabel(graphics2D, n5, n6, n3);
        }
        graphics2D.setFont(font);
        if (!this.behindEnabled) {
            this.drawFrontCard(graphics2D);
        } else {
            this.drawBehindCard(graphics2D);
        }
    }

    protected void drawBehindCard(Graphics2D graphics2D) {
        Cloneable cloneable;
        int n;
        boolean bl = false;
        int n2 = this.relatedTreeNode.getChildCount();
        for (n = this.frontChildCount; n < n2; ++n) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.relatedTreeNode.getChildAt(n);
            cloneable = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
            if (!(cloneable instanceof RegularEnvironmentItem) && !(cloneable instanceof ComposeEnvironmentItem) || !this.isEnvironmentItemVisible()) continue;
            bl = true;
            break;
        }
        int n3 = this.slotBeginValue;
        for (n = this.frontChildCount; n < n2; ++n) {
            cloneable = (DefaultMutableTreeNode)this.relatedTreeNode.getChildAt(n);
            DevicePanelComponent devicePanelComponent = (DevicePanelComponent)((DefaultMutableTreeNode)cloneable).getUserObject();
            if (devicePanelComponent instanceof EnvironmentItem) {
                if (!this.isEnvironmentItemVisible()) {
                    ((EnvironmentItem)devicePanelComponent).setVisible(false);
                    continue;
                }
                ((EnvironmentItem)devicePanelComponent).setVisible(true);
            }
            if (bl) {
                int n4 = (this.bound.width - 20 - this.itemAreaWidth) / 2;
                this.drawSplit(graphics2D, new Rectangle(this.bound.x + n4, devicePanelComponent.bound.y + devicePanelComponent.bound.height + 1, this.itemAreaWidth + 20, this.slotHeight));
                bl = false;
            }
            if (devicePanelComponent instanceof Card) {
                Card card = (Card)devicePanelComponent;
                if (!card.getOccupiedTwoSlots()) {
                    this.checkAndFixChildBound((DefaultMutableTreeNode)cloneable);
                }
            } else if (devicePanelComponent instanceof EmptyComponent) {
                this.checkAndFixChildBound((DefaultMutableTreeNode)cloneable);
            }
            if (this.slotLabelEnabled && devicePanelComponent.isIsShowSlot()) {
                this.drawSlotLabel(graphics2D, devicePanelComponent, n3++);
            }
            devicePanelComponent.setBehindEnabled(true);
            devicePanelComponent.setIsFacility(this.isIsFacility());
            devicePanelComponent.draw(graphics2D);
        }
    }

    protected void drawFrontCard(Graphics2D graphics2D) {
        Cloneable cloneable;
        int n;
        boolean bl = false;
        for (n = 0; n < this.frontChildCount; ++n) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.relatedTreeNode.getChildAt(n);
            cloneable = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
            if (!(cloneable instanceof RegularEnvironmentItem) && !(cloneable instanceof ComposeEnvironmentItem) || !this.isEnvironmentItemVisible()) continue;
            bl = true;
            break;
        }
        int n2 = this.slotBeginValue;
        for (n = 0; n < this.frontChildCount; ++n) {
            cloneable = (DefaultMutableTreeNode)this.relatedTreeNode.getChildAt(n);
            DevicePanelComponent devicePanelComponent = (DevicePanelComponent)((DefaultMutableTreeNode)cloneable).getUserObject();
            if (devicePanelComponent instanceof EnvironmentItem) {
                if (!this.isEnvironmentItemVisible()) {
                    ((EnvironmentItem)devicePanelComponent).setVisible(false);
                    continue;
                }
                ((EnvironmentItem)devicePanelComponent).setVisible(true);
            }
            if (bl) {
                int n3 = (this.bound.width - 20 - this.itemAreaWidth) / 2;
                this.drawSplit(graphics2D, new Rectangle(this.bound.x + n3, devicePanelComponent.bound.y + devicePanelComponent.bound.height + 1, this.itemAreaWidth + 20, this.slotHeight));
                bl = false;
            }
            if (devicePanelComponent instanceof Card) {
                Card card = (Card)devicePanelComponent;
                if (!card.getOccupiedTwoSlots()) {
                    this.checkAndFixChildBound((DefaultMutableTreeNode)cloneable);
                }
            } else if (devicePanelComponent instanceof EmptyComponent) {
                this.checkAndFixChildBound((DefaultMutableTreeNode)cloneable);
            }
            if (this.slotLabelEnabled && devicePanelComponent.isIsShowSlot()) {
                this.drawSlotLabel(graphics2D, devicePanelComponent, n2++);
            }
            devicePanelComponent.setBehindEnabled(false);
            devicePanelComponent.setIsFacility(this.isIsFacility());
            devicePanelComponent.draw(graphics2D);
        }
    }

    public void drawSplit(Graphics2D graphics2D, Rectangle rectangle) {
        Color color = graphics2D.getColor();
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        graphics2D.setPaint(this.getBackground());
        graphics2D.fillRect(n, n2, n3, n4);
        graphics2D.setPaint(Color.white);
        graphics2D.drawLine(n, n2, n + n3, n2);
        graphics2D.drawLine(n, n2, n, n2 + n4);
        graphics2D.setPaint(Color.black);
        graphics2D.drawLine(n, n2 + n4, n + n3, n2 + n4);
        graphics2D.drawLine(n + n3, n2 + n4, n + n3, n2);
        graphics2D.setPaint(color);
    }

    void checkAndFixChildBound(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (this.getBehindEnabled()) {
            return;
        }
        DevicePanelComponent devicePanelComponent = (DevicePanelComponent)this.relatedTreeNode.getUserObject();
        DevicePanelComponent devicePanelComponent2 = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
        int n = devicePanelComponent.bound.x + devicePanelComponent2.abstractBound.x;
        int n2 = devicePanelComponent2.bound.x - n;
        int n3 = devicePanelComponent.bound.y + devicePanelComponent2.abstractBound.y;
        int n4 = devicePanelComponent2.bound.y - n3;
        if (Math.abs(n2) >= 30) {
            devicePanelComponent2.bound.x = devicePanelComponent.bound.x + devicePanelComponent2.abstractBound.x;
            logger.debug("correct childComponent bound.x " + n + " to " + devicePanelComponent2.bound.x);
        }
        if (Math.abs(n4) >= 30) {
            devicePanelComponent2.bound.y = devicePanelComponent.bound.y + devicePanelComponent2.abstractBound.y;
            logger.debug("correct childComponent bound.y " + n3 + "to" + devicePanelComponent2.bound.y);
        }
    }

    public void drawEmulational(Graphics2D graphics2D) {
        this.topGirderHeight = 15;
        if (DevicePanelComponent.isOpenEmulational) {
            this.topGirderHeight = 20;
        }
        this.itemAreaHeight = this.bound.height - this.topGirderHeight - 25;
        int n = this.bound.width;
        int n2 = this.bound.height;
        int n3 = (n - 20 - this.itemAreaWidth) / 2;
        int n4 = 5;
        int n5 = this.bound.x;
        int n6 = this.bound.y;
        if (this.behindEnabled && !this.isOnBehindFrame() || isOpenEmulational) {
            n5 = 0;
            n6 = 0;
        }
        graphics2D.clearRect(n5, n6, this.bound.width, this.bound.height);
        graphics2D.setPaint(this.getBackground());
        graphics2D.fillRect(n5, n6, this.bound.width, this.bound.height);
        graphics2D.setPaint(Color.white);
        graphics2D.draw3DRect(n5, n6, this.bound.width - 1, this.bound.height - 1, true);
        graphics2D.setPaint(this.rimColor);
        graphics2D.fillRect(n5 + n3, n6 + this.topGirderHeight, this.itemAreaWidth + 20, this.itemAreaHeight);
        Font font = graphics2D.getFont();
        graphics2D.setFont(this.font);
        graphics2D.setPaint(Color.black);
        graphics2D.drawLine(n5 + n4, n6 + n2, n5 + n3, n6 + n2);
        graphics2D.drawLine(n5 + n - 1 - n4, n6 + n2, n5 + n - 1 - n3, n6 + n2);
        graphics2D.drawLine(n5 + n3, n6 + n2, n5 + n3, n6 + n2 - 4);
        graphics2D.drawLine(n5 + n3, n6 + n2 - 4, n5 + n - 1 - n3 - 2, n6 + n2 - 4);
        graphics2D.drawLine(n5 + n3, n6 + n2 - 5, n5 + n - 1 - n3 - 2, n6 + n2 - 5);
        graphics2D.drawLine(n5 + n - 1 - n3 - 2, n6 + n2 - 4, n5 + n - 1 - n3 - 2, n6 + n2 - 6);
        graphics2D.setPaint(Color.white);
        graphics2D.drawLine(n5 + n3, n6 + n2 - 6, n5 + n - 1 - n3 - 2, n6 + n2 - 6);
        graphics2D.drawLine(n5 + n - 1 - n3, n6 + n2, n5 + n - 1 - n3, n6 + n2 - 6);
        graphics2D.drawLine(n5 + n - 1 - n3, n6 + this.topGirderHeight + this.itemAreaHeight, n5 + n - 1 - n3, n6 + this.topGirderHeight);
        graphics2D.setPaint(Color.black);
        graphics2D.drawLine(n5 + n3, n6 + n2, n5 + n3, n6 + n2 - 6);
        graphics2D.drawLine(n5 + n3, n6 + this.topGirderHeight + this.itemAreaHeight, n5 + n3, n6 + this.topGirderHeight);
        graphics2D.setPaint(Color.white);
        graphics2D.drawLine(n5 + n3, n6 + this.topGirderHeight + this.itemAreaHeight, n5 + n - 1 - n3, n6 + this.topGirderHeight + this.itemAreaHeight);
        int n7 = this.nutIcon.getIconWidth();
        int n8 = this.nutIcon.getIconHeight();
        int n9 = (n3 - n7) / 2;
        this.nutIcon.paintIcon(null, graphics2D, n5 + n9, n6 + n9);
        this.nutIcon.paintIcon(null, graphics2D, n5 + n9, n6 + n2 - 1 - n9 - n8);
        this.nutIcon.paintIcon(null, graphics2D, n5 + n - 1 - n9 - n7, n6 + n9);
        this.nutIcon.paintIcon(null, graphics2D, n5 + n - 1 - n9 - n7, n6 + n2 - 1 - n9 - n8);
        int n10 = n5 + n3 + 10;
        int n11 = n6 + this.topGirderHeight / 5 - 1;
        int n12 = this.itemAreaWidth;
        int n13 = this.topGirderHeight / 5 * 3;
        if (this.getRelatedTreeNode().getChildCount() > this.frontChildCount && !this.behindEnabled && !DevicePanelComponent.isOpenEmulational) {
            this.drawStateBar(graphics2D, n10, n11, n12, n13);
        } else if (this.isOnBehindFrame()) {
            this.drawStateBar(graphics2D, n10, n11, n12, n13);
        }
        graphics2D.setPaint(this.rimColor);
        graphics2D.fillRect(n5 + n3, n6 + this.topGirderHeight, 10, this.itemAreaHeight + 1);
        graphics2D.fillRect(n5 + n - 1 - n3 - 10 + 1, n6 + this.topGirderHeight - 1, 10, this.itemAreaHeight + 1);
        graphics2D.drawArc(n5, n6 + n2 - 1 - 2 * n4, 2 * n4, 2 * n4, 180, 90);
        graphics2D.drawArc(n5 + 1, n6 + n2 - 1 - 2 * n4, 2 * n4, 2 * n4, 180, 90);
        graphics2D.drawLine(n5 + n4 - 2, n6 + n2 - 1, n5 + n3 - 1, n6 + n2 - 1);
        graphics2D.drawLine(n5 + n4 - 3, n6 + n2 - 1 - 1, n5 + n3 - 1, n6 + n2 - 1 - 1);
        graphics2D.drawLine(n5 + n3 - 1, n6 + n2 - 1, n5 + n3 - 1, n6 + n2 - 6);
        graphics2D.drawLine(n5 + n3 - 2, n6 + n2 - 2, n5 + n3 - 2, n6 + n2 - 6);
        graphics2D.drawLine(n5 + n3 - 2, n6 + n2 - 6, n5 + n - 1 - n3, n6 + n2 - 6);
        graphics2D.drawLine(n5 + n3 - 1, n6 + n2 - 7, n5 + n - 1 - n3, n6 + n2 - 7);
        graphics2D.setPaint(Color.white);
        graphics2D.drawLine(n5 + n - 1 - n3 + 1, n6 + n2 - 1, n5 + n - 1 - n3 + 1, n6 + n2 - 6);
        graphics2D.drawLine(n5 + n - 1 - n3 + 2, n6 + n2 - 2, n5 + n - 1 - n3 + 2, n6 + n2 - 6);
        graphics2D.setPaint(this.rimColor);
        graphics2D.drawLine(n5 + n - 1 - n3 + 1, n6 + n2 - 1, n5 + n - 1 - n4, n6 + n2 - 1);
        graphics2D.drawLine(n5 + n - 1 - n3 + 2, n6 + n2 - 2, n5 + n - 1 - n4, n6 + n2 - 2);
        graphics2D.drawLine(n5 + n - 1 - 1, n6 + n2 - 4, n5 + n - 1 - 1, n6 + 3);
        graphics2D.drawLine(n5 + n - 1 - 2, n6 + n2 - 3, n5 + n - 1 - 2, n6 + 2);
        graphics2D.drawLine(n5 + n - 1 - 3, n6 + n2 - 2, n5 + n - 1 - 3, n6 + 1);
        graphics2D.drawArc(n5 + n - 1 - 2 * n4, n6 + n2 - 1 - 2 * n4, 2 * n4, 2 * n4, 270, 90);
        graphics2D.drawArc(n5 + n - 1 - 2 * n4 - 1, n6 + n2 - 1 - 2 * n4, 2 * n4, 2 * n4, 270, 90);
        graphics2D.setPaint(Color.white);
        graphics2D.drawLine(n5 + n - 1 - 4, n6 + 1, n5 + n - 1, n6 + 4);
        graphics2D.drawArc(n5 + n - 2 * n4, n6 + 1, 2 * n4 - 1, 2 * n4, 0, 90);
        graphics2D.drawArc(n5 + n - 2 * n4 - 1, n6 + 1, 2 * n4 - 1, 2 * n4, 0, 90);
        graphics2D.drawLine(n5 + 1, n6 + 1 + n4, n5 + 1, n6 + n2 - n4);
        graphics2D.drawLine(n5 + 2, n6 + n4, n5 + 2, n6 + n2 - n4 + 1);
        graphics2D.drawArc(n5, n6 + 1, 2 * n4, 2 * n4, 90, 90);
        graphics2D.drawArc(n5 + 1, n6 + 1, 2 * n4, 2 * n4, 90, 90);
        graphics2D.drawArc(n5 + 2, n6 + 1, 2 * n4, 2 * n4, 90, 90);
        graphics2D.setPaint(this.rimColor);
        graphics2D.drawLine(n5 + n3 - 1, n6 + this.topGirderHeight + this.itemAreaHeight, n5 + n3 - 1, n6 + this.topGirderHeight - 1);
        graphics2D.drawLine(n5 + n3 - 2, n6 + this.topGirderHeight + this.itemAreaHeight + 1, n5 + n3 - 2, n6 + this.topGirderHeight - 2);
        graphics2D.drawLine(n5 + n3 - 1, n6 + this.topGirderHeight - 1, n5 + n - 1 - n3 + 1, n6 + this.topGirderHeight - 1);
        graphics2D.drawLine(n5 + n3 - 2, n6 + this.topGirderHeight - 2, n5 + n - 1 - n3 + 2, n6 + this.topGirderHeight - 2);
        graphics2D.setPaint(Color.black);
        graphics2D.drawLine(n5 + n3 - 1, n6 + this.topGirderHeight - 1, n5 + n3 - 1, n6 + this.topGirderHeight + this.itemAreaHeight);
        graphics2D.drawLine(n5 + n + 1 - n3, n6 + this.topGirderHeight - 1, n5 + n + 1 - n3, n6 + this.topGirderHeight + this.itemAreaHeight - 1);
        graphics2D.setPaint(Color.white);
        graphics2D.drawLine(n5 + n - 1 - n3 + 1, n6 + this.topGirderHeight - 1, n5 + n - 1 - n3 + 1, n6 + this.topGirderHeight + this.itemAreaHeight + 1);
        graphics2D.drawLine(n5 + n - 1 - n3 + 2, n6 + this.topGirderHeight - 2, n5 + n - 1 - n3 + 2, n6 + this.topGirderHeight + this.itemAreaHeight + 1);
        graphics2D.drawLine(n5 + n - 1 - n3 + 1, n6 + this.topGirderHeight + this.itemAreaHeight + 1, n5 + n3 - 1, n6 + this.topGirderHeight + this.itemAreaHeight + 1);
        graphics2D.setPaint(Color.black);
        graphics2D.drawLine(n5 + n - 1, n6 + 1 + n4, n5 + n - 1, n6 + n2 - 1 - n4);
        graphics2D.drawArc(n5 + n - 1 - 2 * n4, n6 + n2 - 1 - 2 * n4 + 1, 2 * n4, 2 * n4, 270, 90);
        graphics2D.drawArc(n5, n6 + n2 - 1 - 2 * n4 + 1, 2 * n4, 2 * n4, 180, 90);
        graphics2D.setFont(font);
        if (this.isShowLot()) {
            this.drawShelfLabel(graphics2D, n5, n6, n3);
        }
        if (!this.behindEnabled) {
            this.drawFrontCard(graphics2D);
        } else {
            this.drawBehindCard(graphics2D);
        }
    }

    private void drawShelfLabel(Graphics2D graphics2D, int n, int n2, int n3) {
        Font font = graphics2D.getFont();
        if (this.label == null || this.isAutoNumber) {
            this.label = this.getDefaultLabel();
        }
        if (this.getShelfLableFont() != null) {
            graphics2D.setFont(this.getShelfLableFont());
        } else {
            graphics2D.setFont(this.font);
        }
        Color color = graphics2D.getColor();
        if (this.getShelfLableColor() != null) {
            graphics2D.setPaint(this.getShelfLableColor());
        } else {
            graphics2D.setPaint(color);
        }
        char[] cArray = this.label.toCharArray();
        int n4 = graphics2D.getFontMetrics(font).getHeight();
        int n5 = n4 * (cArray.length - 1) / 2 - 4;
        for (int i = 0; i < cArray.length; ++i) {
            graphics2D.drawString(new String(cArray, i, 1), n + n3 / 4, n2 + this.bound.height / 2 - n5 + i * 20);
        }
        graphics2D.setFont(font);
        graphics2D.setPaint(color);
    }

    private String getDefaultLabel() {
        TreeNode treeNode = this.relatedTreeNode.getParent();
        int n = treeNode.getIndex(this.relatedTreeNode);
        int n2 = treeNode.getChildCount();
        for (int i = 0; i < n2; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeNode.getChildAt(i);
            if (defaultMutableTreeNode.getUserObject() instanceof EnvironmentItem) continue;
            n -= i;
            break;
        }
        return Integer.toString(n);
    }

    @Override
    public boolean isInArea(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (!this.isIsFacility() && !DevicePanelComponent.isOpenEmulational) {
            this.topGirderHeight = 15;
            int n7 = (this.bound.width - 20 - this.itemAreaWidth) / 2;
            n6 = this.bound.x + n7 + 10;
            n5 = this.bound.y + 4;
            n4 = this.itemAreaWidth;
            n3 = this.topGirderHeight - 8;
        } else {
            this.topGirderHeight = 20;
            n6 = this.bound.x + 20;
            n5 = this.bound.y + this.topGirderHeight / 5 - 1;
            n4 = this.bound.width - 40;
            n3 = this.topGirderHeight / 5 * 3;
        }
        return n > n6 && n < n6 + n4 && n2 > n5 && n2 < n5 + n3;
    }

    protected void drawSlotLabel(Graphics2D graphics2D, DevicePanelComponent devicePanelComponent, int n) {
        Font font = graphics2D.getFont();
        Color color = graphics2D.getColor();
        if (this.getSlotLableFont() != null) {
            graphics2D.setFont(super.getSlotLableFont());
        } else {
            graphics2D.setFont(font);
        }
        if (this.getSlotLableColor() != null) {
            graphics2D.setPaint(this.getSlotLableColor());
        } else {
            graphics2D.setPaint(color);
        }
        String[] stringArray = this.getSlotLabelsFor(devicePanelComponent, n);
        if (null != stringArray && stringArray.length == 1) {
            int n2 = 0;
            if ("bottom".equalsIgnoreCase(this.getSlotPosition())) {
                n2 = devicePanelComponent.getWidth() / 2;
            } else if ("right".equalsIgnoreCase(this.getSlotPosition())) {
                n2 = devicePanelComponent.getHeight() / 2;
            }
            this.drawOneSlotLabel(graphics2D, devicePanelComponent, n2, stringArray[0]);
        } else {
            int n3 = stringArray.length;
            int n4 = 0;
            for (int i = 0; i < n3; ++i) {
                int n5;
                n4 = 0;
                if ("bottom".equalsIgnoreCase(this.getSlotPosition())) {
                    n5 = devicePanelComponent.getWidth() / n3;
                    n4 = n5 * i + n5 / 2;
                } else if ("right".equalsIgnoreCase(this.getSlotPosition())) {
                    n5 = devicePanelComponent.getHeight() / n3;
                    n4 = n5 * i + n5 / 2;
                }
                this.drawOneSlotLabel(graphics2D, devicePanelComponent, n4, stringArray[i]);
            }
        }
        graphics2D.setFont(font);
        graphics2D.setColor(color);
    }

    protected void drawOneSlotLabel(Graphics2D graphics2D, DevicePanelComponent devicePanelComponent, int n, String string) {
        this.metric = graphics2D.getFontMetrics();
        int n2 = this.metric.stringWidth(string);
        int n3 = devicePanelComponent.getHeight();
        if ("bottom".equalsIgnoreCase(this.getSlotPosition())) {
            int n4 = devicePanelComponent.getStartX() + n - n2 / 2;
            int n5 = devicePanelComponent.getStartY() + n3 + this.slotDrawPositionSpace;
            graphics2D.drawString(string, n4, n5 + 15);
        } else if ("right".equalsIgnoreCase(this.getSlotPosition())) {
            int n6 = this.bound.x + this.bound.width - 20;
            int n7 = devicePanelComponent.getStartY() + n + 5 + this.slotDrawPositionSpace;
            graphics2D.drawString(string, n6 + 2, n7);
        } else {
            logger.trace("The slot position you inputed " + this.getSlotPosition() + "is not supported.");
        }
    }

    protected final String[] getSlotLabelsFor(DevicePanelComponent devicePanelComponent, int n) {
        String[] stringArray = null;
        String string = devicePanelComponent.getSlotLabel();
        if (null != string && string.trim().length() > 0) {
            stringArray = string.split("\\s*,\\s*", -1);
        } else {
            String string2 = n < 10 ? "0" + n : n + "";
            stringArray = new String[]{string2};
        }
        return stringArray;
    }

    @Override
    public boolean isPopupMenuAllowed(int n, int n2) {
        return this.getRelatedTreeNode().getChildCount() <= this.frontChildCount || !this.isIsFacility() || !this.isInArea(n, n2);
    }

    @Override
    public void calculateChildPosition(int n, int n2) {
        int n3 = 0;
        if (this.getEnvironmentItemRowsHight() > 0) {
            n3 = this.slotHeight;
        }
        double d = (double)(n - 60 - 1) / (double)this.itemAreaWidth;
        double d2 = 0.0;
        d2 = this.getEnvironmentItemRowsHight() > 0 && !this.isEnvironmentItemVisible() ? (double)(n2 - this.topGirderHeight - 25 - 3 - this.getEnvironmentItemRowsHight() - n3) / (double)this.itemAreaHeight : (double)(n2 - this.topGirderHeight - 25 - 1 - this.getEnvironmentItemRowsHight() - n3) / (double)(this.itemAreaHeight - this.getEnvironmentItemRowsHight() - n3);
        int n4 = this.relatedTreeNode.getChildCount();
        for (int i = 0; i < n4; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.relatedTreeNode.getChildAt(i);
            DevicePanelComponent devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
            Rectangle rectangle = devicePanelComponent.abstractBound;
            devicePanelComponent.realBound = devicePanelComponent instanceof EnvironmentItem ? new Rectangle(DevicePanelUtil.GetInt((double)(rectangle.x - 30) * d + 30.0), DevicePanelUtil.GetInt((double)(rectangle.y - this.topGirderHeight - n3) * d2 + (double)this.topGirderHeight + (double)n3), DevicePanelUtil.GetInt((double)rectangle.width * d), DevicePanelUtil.GetInt(rectangle.height)) : new Rectangle(DevicePanelUtil.GetInt((double)(rectangle.x - 20 - 10) * d + 20.0 + 10.0), DevicePanelUtil.GetInt((double)(rectangle.y - this.topGirderHeight) * d2 + (double)this.topGirderHeight), DevicePanelUtil.GetInt((double)rectangle.width * d), DevicePanelUtil.GetInt((double)rectangle.height * d2));
        }
    }

    @Override
    public int getOccupiedShelfNum() {
        return 1;
    }

    protected void setSlotDrawPositionSpace(int n) {
        this.slotDrawPositionSpace = n;
    }
}

