/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.devicepanel.model.component;

import com.swimap.iview.templates.devicepanel.datasource.ComponentData;
import com.swimap.iview.templates.devicepanel.model.component.DevicePanelComponent;
import com.swimap.iview.templates.devicepanel.model.component.EnvironmentItem;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class RegularEnvironmentItem
extends EnvironmentItem {
    private static IviewLogger logger = IviewLogger.getLogger(RegularEnvironmentItem.class, "IVIEW");
    private static final int STATE_X_SCALE = 12;
    private static final int STATE_WIDTH_SCALE = 20;
    private Color rimColor = SHELF_BACKGROUND_COLOR;
    private Font font = null;
    private Color regularEnvironmentItemColor = this.getBackground();
    private FontMetrics metric = null;
    private String drawName = null;
    private static final int EMULATE_FONT_SIZE = 12;
    private static final int FACILITY_FANOT_SIZE = 11;
    private static final int EMULATE_NAME_X = 16;
    private static final int FACILITY_NAME_X = 12;

    public RegularEnvironmentItem(String string, String string2, Rectangle rectangle) {
        super(string, string2, rectangle);
        this.isShowSlot = false;
    }

    public RegularEnvironmentItem(ComponentData componentData, Rectangle rectangle) {
        super(componentData, rectangle);
        this.isShowSlot = false;
    }

    public Color getRegularEnvironmentItemColor() {
        return this.regularEnvironmentItemColor;
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        if (!this.isVisible) {
            return;
        }
        int n = this.bound.x;
        int n2 = this.bound.y;
        int n3 = this.bound.width;
        int n4 = this.bound.height;
        int n5 = this.isIsFacility() ? 11 : 12;
        try {
            n5 = this.isIsFacility() ? Integer.parseInt(this.res.getString("RegularEnvironmentItem_Facility_FontSize")) : Integer.parseInt(this.res.getString("RegularEnvironmentItem_Emulational_FontSize"));
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        if (0 < this.getFontSize()) {
            n5 = this.getFontSize();
        }
        if (n4 < n5) {
            n4 = n5;
        }
        this.font = new Font(this.res.getString("Font"), 0, n5);
        Font font = graphics2D.getFont();
        graphics2D.setFont(this.font);
        if (this.stateObject != null) {
            this.setRegularEnvironmentItemColor(this.stateObject.getColor());
        }
        graphics2D.setPaint(this.getBackground());
        graphics2D.fillRect(n, n2, n3, n4);
        graphics2D.setPaint(Color.white);
        graphics2D.drawLine(this.bound.x, this.bound.y + this.bound.height - 1, this.bound.x, this.bound.y);
        graphics2D.drawLine(this.bound.x, this.bound.y, this.bound.x + this.bound.width - 1, this.bound.y);
        graphics2D.setPaint(Color.black);
        graphics2D.drawLine(this.bound.x + this.bound.width - 1, this.bound.y, this.bound.x + this.bound.width - 1, this.bound.y + this.bound.height - 1);
        graphics2D.drawLine(this.bound.x + this.bound.width - 1, this.bound.y + this.bound.height - 1, this.bound.x, this.bound.y + this.bound.height - 1);
        int n6 = this.bound.x + this.getStateRectX();
        int n7 = this.bound.y + this.getStateRectY();
        int n8 = this.getStateRectWidth();
        int n9 = this.getStateRectHight();
        graphics2D.setPaint(this.getRegularEnvironmentItemColor());
        graphics2D.fillRect(n6, n7, n8, n9);
        graphics2D.setPaint(Color.black);
        graphics2D.drawLine(n6, n7, n6, n7 + n9);
        graphics2D.drawLine(n6, n7, n6 + n8, n7);
        graphics2D.setPaint(Color.white);
        graphics2D.drawLine(n6 + n8, n7 + n9, n6, n7 + n9);
        graphics2D.drawLine(n6 + n8, n7 + n9, n6 + n8, n7);
        graphics2D.setPaint(Color.black);
        graphics2D.drawString(this.getDrawName(), n6 + n8 + 4, n7 + n9);
        graphics2D.setFont(font);
        this.drawAlarm(graphics2D, false);
    }

    protected void drawSlotLabel(Graphics2D graphics2D, DevicePanelComponent devicePanelComponent, int n) {
        Font font = graphics2D.getFont();
        if (this.getSlotLableFont() != null) {
            graphics2D.setFont(this.getSlotLableFont());
        } else {
            graphics2D.setFont(font);
        }
        Color color = graphics2D.getColor();
        if (this.getSlotLableColor() != null) {
            graphics2D.setPaint(this.getSlotLableColor());
        } else {
            graphics2D.setPaint(color);
        }
        this.metric = graphics2D.getFontMetrics();
        StringBuffer stringBuffer = new StringBuffer(8);
        if (n < 10) {
            stringBuffer.append(0);
            stringBuffer.append(n);
        } else {
            stringBuffer.append(n);
        }
        String string = stringBuffer.toString();
        int n2 = this.metric.stringWidth(string);
        int n3 = devicePanelComponent.getStartX() + devicePanelComponent.getWidth() / 2 - n2 / 2;
        int n4 = this.bound.y;
        if (!this.isIsFacility()) {
            graphics2D.drawString(string, n3, n4 + 16);
        } else {
            graphics2D.drawString(string, n3, n4 + 12);
        }
        graphics2D.setFont(font);
        graphics2D.setColor(color);
    }

    @Override
    public void drawState(Graphics2D graphics2D, boolean bl) {
        if (this.stateObject != null) {
            this.setRegularEnvironmentItemColor(this.stateObject.getColor());
        } else {
            this.setRegularEnvironmentItemColor(this.rimColor);
            logger.debug("FansEnvironmentItem get stateObject fail");
        }
        if (bl) {
            this.selectedShapedDraw(graphics2D);
        } else {
            this.draw(graphics2D);
        }
    }

    @Override
    public void selectedShapedDraw(Graphics2D graphics2D) {
        int n;
        if (!this.isVisible) {
            return;
        }
        Font font = graphics2D.getFont();
        graphics2D.setFont(this.font);
        int n2 = this.bound.x;
        int n3 = this.bound.y;
        int n4 = this.bound.width;
        int n5 = this.bound.height;
        if (n5 < this.font.getSize()) {
            n5 = this.font.getSize();
        }
        graphics2D.clearRect(n2, n3, n4, n5);
        graphics2D.setPaint(this.getBackground());
        graphics2D.fillRect(n2, n3, n4, n5);
        for (n = 0; n < 4; ++n) {
            if (n == 0 || n == 3) {
                graphics2D.setColor(Color.white);
            } else {
                graphics2D.setPaint(SELECTED_COLOR);
            }
            graphics2D.drawRect(n2 + n, n3 + n, n4 - 2 * n, n5 - 2 * n);
        }
        n = this.bound.x + this.getStateRectX() + 1;
        int n6 = this.bound.y + this.getStateRectY() + 1;
        int n7 = this.getStateRectWidth();
        int n8 = this.getStateRectHight();
        graphics2D.setPaint(this.getRegularEnvironmentItemColor());
        graphics2D.fillRect(n, n6, n7, n8);
        graphics2D.setPaint(Color.black);
        graphics2D.drawLine(n, n6, n, n6 + n8);
        graphics2D.drawLine(n, n6, n + n7, n6);
        graphics2D.setPaint(Color.white);
        graphics2D.drawLine(n + n7, n6 + n8, n, n6 + n8);
        graphics2D.drawLine(n + n7, n6 + n8, n + n7, n6);
        graphics2D.setPaint(Color.black);
        graphics2D.drawString(this.getDrawName(), n + n7 + 4, n6 + n8);
        graphics2D.setFont(font);
        this.drawAlarm(graphics2D, true);
    }

    public void setRegularEnvironmentItemColor(Color color) {
        this.regularEnvironmentItemColor = color;
    }

    @Override
    public boolean isPopupMenuAllowed(int n, int n2) {
        return this.isVisible ? super.isPopupMenuAllowed(n, n2) : false;
    }

    @Override
    public boolean isPointInArea(int n, int n2) {
        if (!this.isVisible) {
            return false;
        }
        int n3 = this.bound.x;
        int n4 = this.bound.y;
        int n5 = this.bound.width;
        int n6 = this.bound.height;
        return n > n3 && n < n3 + n5 && n2 > n4 && n2 < n4 + n6;
    }

    public int getStateRectWidth() {
        return this.bound.width / 20;
    }

    public int getStateRectHight() {
        return this.bound.height / 2;
    }

    public int getStateRectX() {
        return (int)(this.bound.getWidth() / 12.0 + 5.0);
    }

    public int getStateRectY() {
        return this.bound.height / 4;
    }

    public void setDrawName(String string) {
        this.drawName = string;
    }

    public String getDrawName() {
        if (this.drawName == null) {
            return this.getType();
        }
        return this.drawName;
    }
}

