/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.devicepanel.model.component;

import com.swimap.iview.templates.devicepanel.datasource.ComponentData;
import com.swimap.iview.templates.devicepanel.model.component.EnvironmentItem;
import com.swimap.iview.templates.devicepanel.model.component.RegularShelf;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.ImageIcon;

public class PowerShelf
extends EnvironmentItem {
    private static IviewLogger logger = IviewLogger.getLogger(PowerShelf.class, "IVIEW");
    private static final int HEIGHTSCALE = 5;
    private static final int WEIGHTSCALE = 25;
    protected ImageIcon nutIcon = new ImageIcon(RegularShelf.class.getResource("nut.gif"));
    protected int topGirderHeight;
    protected int itemAreaWidth;
    protected int itemAreaHeight;
    protected Color rimColor = SHELF_BACKGROUND_COLOR;
    protected String label;
    protected Font font;
    protected Color powerStateColor = this.getBackground();
    private boolean isPowerSeleted = false;
    private static final int EMULATE_FONT_SIZE = 12;
    private static final int FACILITY_FANOT_SIZE = 11;

    public void setPowerStateColor(Color color) {
        this.powerStateColor = color;
    }

    public Color getPowerStateColor() {
        return this.powerStateColor;
    }

    public PowerShelf(String string, String string2, Rectangle rectangle) {
        super(string, string2, rectangle);
        this.topGirderHeight = 0;
        this.itemAreaWidth = 0;
        this.itemAreaHeight = 0;
        this.label = null;
        this.font = null;
    }

    public PowerShelf(ComponentData componentData, Rectangle rectangle) {
        super(componentData, rectangle);
        this.topGirderHeight = 10;
        this.itemAreaWidth = rectangle.width - 40 - 20;
        this.itemAreaHeight = rectangle.height - this.topGirderHeight - 8;
        this.label = null;
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        this.initFontSzie();
        int n = this.bound.width;
        int n2 = this.bound.height;
        int n3 = (n - 20 - this.itemAreaWidth) / 2;
        int n4 = 5;
        int n5 = n4 + n4;
        int n6 = this.bound.x;
        int n7 = this.bound.y;
        int n8 = n6 + n;
        int n9 = n7 + n2;
        int n10 = n6 + n3;
        int n11 = n7 + this.topGirderHeight;
        int n12 = n11 + this.itemAreaHeight;
        int n13 = n8 - n3;
        graphics2D.setPaint(this.getBackground());
        graphics2D.fillRect(n6, n7, n, n2);
        graphics2D.setPaint(Color.white);
        graphics2D.draw3DRect(n6, n7, n - 1, n2 - 1, true);
        graphics2D.setPaint(Color.white);
        graphics2D.drawLine(n6 + 4, n7 + 1, n8 - 5, n7 + 1);
        graphics2D.drawLine(n6 + 3, n7 + 2, n8 - 4, n7 + 2);
        graphics2D.drawLine(n6 + 1, n7 + 4, n6 + 1, n9 - n4);
        graphics2D.drawLine(n6 + 2, n7 + 3, n6 + 2, n9 - n4 + 1);
        graphics2D.drawLine(n6 + 5, n7 + 1, n6 + 1, n7 + 5);
        graphics2D.drawLine(n6 + 4, n7 + 1, n6 + 1, n7 + 4);
        graphics2D.drawLine(n6 + 3, n7 + 1, n6 + 1, n7 + 3);
        graphics2D.drawLine(n8 - 5, n7 + 1, n8 - 2, n7 + 5);
        graphics2D.drawLine(n8 - 6, n7 + 1, n8 - 2, n7 + 6);
        graphics2D.drawLine(n8 - 7, n7 + 1, n8 - 2, n7 + 7);
        graphics2D.setPaint(this.rimColor);
        graphics2D.drawLine(n8 - 2, n9 - 6, n8 - 2, n7 + 7);
        graphics2D.drawLine(n8 - 3, n9 - 5, n8 - 3, n7 + 6);
        graphics2D.drawLine(n8 - 4, n9 - 4, n8 - 4, n7 + 5);
        graphics2D.setPaint(Color.black);
        graphics2D.drawLine(n8 - 1, n7 + 1 + n4, n8 - 1, n9 - 1 - n4);
        graphics2D.setPaint(this.rimColor);
        graphics2D.drawArc(n6, n9 - 1 - n5, n5, n5, 180, 90);
        graphics2D.drawArc(n6 + 1, n9 - 1 - n5, n5, n5, 180, 90);
        graphics2D.drawArc(n8 - 1 - n5, n9 - 1 - n5, n5, n5, 270, 90);
        graphics2D.drawArc(n8 - 1 - n5 - 1, n9 - 1 - n5, n5, n5, 270, 90);
        graphics2D.setPaint(Color.black);
        graphics2D.drawArc(n8 - 1 - n5, n9 - 1 - n5 + 1, n5, n5, 270, 90);
        graphics2D.drawArc(n6, n9 - 1 - n5 + 1, n5, n5, 180, 90);
        graphics2D.drawLine(n10, n9, n10, n9 - 6);
        graphics2D.drawLine(n6 + n4, n9, n10, n9);
        graphics2D.drawLine(n8 - 1 - n4, n9, n13 - 1, n9);
        graphics2D.drawLine(n10, n9, n10, n9 - 4);
        graphics2D.drawLine(n10, n9 - 4, n13 - 1 - 2, n9 - 4);
        graphics2D.drawLine(n10, n9 - 5, n13 - 1 - 2, n9 - 5);
        graphics2D.setPaint(Color.white);
        graphics2D.drawLine(n13, n9 - 1, n13, n9 - 6);
        graphics2D.setPaint(this.rimColor);
        graphics2D.drawLine(n13, n9 - 1, n8 - 2 - n4, n9 - 1);
        graphics2D.drawLine(n13 + 1, n9 - 2, n8 - 2 - n4, n9 - 2);
        graphics2D.drawLine(n6 + n4 - 2, n9 - 1, n10 - 1, n9 - 1);
        graphics2D.drawLine(n6 + n4 - 3, n9 - 2, n10 - 1, n9 - 2);
        graphics2D.drawLine(n10 - 1, n9 - 1, n10 - 1, n9 - 6);
        graphics2D.drawLine(n10 - 2, n9 - 2, n10 - 2, n9 - 6);
        graphics2D.drawLine(n10 - 2, n9 - 6, n13 - 1, n9 - 6);
        graphics2D.drawLine(n10 - 1, n9 - 7, n13 - 1, n9 - 7);
        int n14 = this.nutIcon.getIconWidth();
        int n15 = (n3 - n14) / 2;
        this.nutIcon.paintIcon(null, graphics2D, n6 + n15, n7 + n15);
        this.nutIcon.paintIcon(null, graphics2D, n8 - 1 - n15 - n14, n7 + n15);
        graphics2D.setPaint(Color.white);
        graphics2D.drawLine(n13 - 1, n9, n13 - 1, n9 - 6);
        graphics2D.drawLine(n13 - 1, n12, n13 - 1, n11);
        graphics2D.drawLine(n10, n12, n13 - 1, n12);
        graphics2D.setPaint(Color.black);
        graphics2D.drawLine(n10, n12, n10, n11);
        graphics2D.drawLine(n10, n11, n13 - 1, n11);
        graphics2D.setPaint(this.rimColor);
        graphics2D.fillRect(n10 + 1, n11 + 1, n13 - n10 - 3, n12 - n11 - 2);
        graphics2D.drawLine(n10 - 1, n12, n10 - 1, n11 - 1);
        graphics2D.drawLine(n10 - 2, n12 + 1, n10 - 2, n11 - 2);
        graphics2D.drawLine(n10 - 1, n11 - 1, n13, n11 - 1);
        graphics2D.drawLine(n10 - 2, n11 - 2, n13 + 1, n11 - 2);
        if (this.stateObject != null) {
            this.setPowerStateColor(this.stateObject.getColor());
        }
        int n16 = n10 + 5;
        int n17 = n11 + 2;
        int n18 = n13 - n10 - 10;
        int n19 = n12 - n11 - 4;
        this.drawPower(graphics2D, n16, n17, n18, n19);
    }

    public void drawPower(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        Font font = graphics2D.getFont();
        graphics2D.setFont(this.font);
        graphics2D.setPaint(this.getBackground());
        graphics2D.fillRect(n, n2, n3, n4);
        graphics2D.setPaint(Color.white);
        graphics2D.drawLine(n, n2, n, n2 + n4);
        graphics2D.drawLine(n, n2, n + n3, n2);
        graphics2D.setPaint(Color.black);
        graphics2D.drawLine(n, n2 + n4, n + n3, n2 + n4);
        graphics2D.drawLine(n + n3, n2 + n4, n + n3, n2);
        graphics2D.setPaint(this.getPowerStateColor());
        int n5 = n + n3 / 25;
        int n6 = n2 + n4 / 5 + 1;
        int n7 = n3 / 25;
        int n8 = n4 / 5 * 3;
        graphics2D.fillRect(n5, n6, n7, n8);
        graphics2D.setPaint(Color.black);
        graphics2D.drawLine(n5, n6, n5, n6 + n8);
        graphics2D.drawLine(n5, n6, n5 + n7, n6);
        graphics2D.setPaint(Color.white);
        graphics2D.drawLine(n5 + n7, n6 + n8, n5, n6 + n8);
        graphics2D.drawLine(n5 + n7, n6 + n8, n5 + n7, n6);
        graphics2D.setPaint(Color.black);
        graphics2D.drawString(this.res.getString("Power"), n5 + n7 + 4, n2 + n4 - (n4 - this.font.getSize()) / 2 - 2);
        graphics2D.setFont(font);
    }

    @Override
    public void selectedShapedDraw(Graphics2D graphics2D) {
        this.draw(graphics2D);
        if (this.isPowerSeleted) {
            this.selectedPowerDraw(graphics2D);
            return;
        }
        int n = this.bound.x;
        int n2 = this.bound.y;
        int n3 = this.bound.height;
        int n4 = this.bound.width;
        for (int i = 0; i < 5; ++i) {
            if (i == 0 || i == 4) {
                graphics2D.setColor(Color.white);
            } else {
                graphics2D.setPaint(SELECTED_COLOR);
            }
            graphics2D.drawRect(n + i, n2 + i, n4 - 2 * i, n3 - 2 * i);
        }
    }

    public void selectedPowerDraw(Graphics2D graphics2D) {
        int n;
        this.initFontSzie();
        int n2 = this.bound.width;
        int n3 = (n2 - 20 - this.itemAreaWidth) / 2;
        int n4 = this.bound.x;
        int n5 = this.bound.y;
        int n6 = n4 + n2;
        int n7 = n4 + n3;
        int n8 = n5 + this.topGirderHeight;
        int n9 = n8 + this.itemAreaHeight;
        int n10 = n6 - n3;
        int n11 = n7 + 5;
        int n12 = n8 + 2;
        int n13 = n10 - n7 - 10;
        int n14 = n9 - n8 - 4;
        Font font = graphics2D.getFont();
        graphics2D.setFont(this.font);
        graphics2D.clearRect(n11, n12, n13, n14);
        graphics2D.setPaint(this.getBackground());
        graphics2D.fillRect(n11, n12, n13, n14);
        for (n = -2; n < 2; ++n) {
            if (n == -2 || n == 1) {
                graphics2D.setColor(Color.white);
            } else {
                graphics2D.setPaint(SELECTED_COLOR);
            }
            graphics2D.drawRect(n11 + n, n12 + n, n13 - 2 * n, n14 - 2 * n);
        }
        graphics2D.setPaint(this.getPowerStateColor());
        n = n11 + n13 / 20;
        int n15 = n12 + n14 / 5 + 1;
        int n16 = n13 / 25;
        int n17 = n14 / 5 * 3;
        graphics2D.fillRect(n, n15, n16, n17);
        graphics2D.setPaint(Color.black);
        graphics2D.drawLine(n, n15, n, n15 + n17);
        graphics2D.drawLine(n, n15, n + n16, n15);
        graphics2D.setPaint(Color.white);
        graphics2D.drawLine(n + n16, n15 + n17, n, n15 + n17);
        graphics2D.drawLine(n + n16, n15 + n17, n + n16, n15);
        graphics2D.setPaint(Color.black);
        graphics2D.drawString(this.res.getString("Power"), n + n16 + 4, n15 + n17 + 1);
        graphics2D.setFont(font);
    }

    public boolean isInPower(int n, int n2) {
        int n3 = this.bound.width;
        int n4 = (n3 - 20 - this.itemAreaWidth) / 2;
        int n5 = this.bound.x;
        int n6 = this.bound.y;
        int n7 = n5 + n3;
        int n8 = n5 + n4;
        int n9 = n6 + this.topGirderHeight;
        int n10 = n9 + this.itemAreaHeight;
        int n11 = n7 - n4;
        int n12 = n8;
        int n13 = n9;
        int n14 = n11 - n8;
        int n15 = n10 - n9;
        return n > n12 && n < n12 + n14 && n2 > n13 && n2 < n13 + n15;
    }

    public void setPowerSelected(boolean bl) {
        this.isPowerSeleted = bl;
    }

    private void initFontSzie() {
        if (this.getFontSize() > this.itemAreaHeight) {
            this.itemAreaHeight = this.getFontSize();
        }
        int n = this.isIsFacility() ? 11 : 12;
        try {
            n = this.isIsFacility() ? Integer.parseInt(this.res.getString("PowerItem_Facility_FontSize")) : Integer.parseInt(this.res.getString("PowerItem_Emulational_FontSize"));
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        n = this.getFontSize() > 0 ? this.getFontSize() : n;
        this.font = new Font(this.res.getString("Font"), 0, n);
    }
}

