/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.devicepanel.model.component;

import com.swimap.iview.templates.devicepanel.datasource.ComponentData;
import com.swimap.iview.templates.devicepanel.model.component.DevicePanelComponent;
import com.swimap.iview.templates.devicepanel.model.component.HighShelfEx;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class MultiLineSlotShelf
extends HighShelfEx {
    private static final int SLOT_POSITION = 15;
    private static final int HORIZONTAL_GAP = 3;
    private static final int HORIZONTAL_SPLIT_HEIGHT = 13;
    private static final int VERTICAL_SPLIT_WIDTH = 17;
    private static final int BUFFER_GAP = 10;

    public MultiLineSlotShelf(ComponentData componentData, Rectangle rectangle) {
        super(componentData, rectangle);
    }

    @Override
    protected void drawSplit(Graphics2D graphics2D, DevicePanelComponent devicePanelComponent) {
        if (this.getSlotPosition().equalsIgnoreCase("right")) {
            this.drawVerticalSplit(graphics2D, devicePanelComponent);
        } else {
            this.drawHorizontalSplit(graphics2D, devicePanelComponent);
        }
    }

    private void drawHorizontalSplit(Graphics2D graphics2D, DevicePanelComponent devicePanelComponent) {
        Color color = graphics2D.getColor();
        int n = devicePanelComponent.getStartX();
        int n2 = 13;
        int n3 = devicePanelComponent.getStartY() - n2 - 1;
        int n4 = devicePanelComponent.getWidth();
        graphics2D.setPaint(this.getBackground());
        graphics2D.fillRect(n, n3, n4, n2);
        graphics2D.setPaint(Color.white);
        graphics2D.drawLine(n, n3, n + n4, n3);
        graphics2D.setPaint(Color.black);
        graphics2D.drawLine(n, n3 + n2, n + n4, n3 + n2);
        graphics2D.setColor(color);
    }

    private void drawVerticalSplit(Graphics2D graphics2D, DevicePanelComponent devicePanelComponent) {
        Color color = graphics2D.getColor();
        int n = 17;
        int n2 = devicePanelComponent.getHeight();
        int n3 = devicePanelComponent.getStartX() + devicePanelComponent.bound.width + 2;
        int n4 = devicePanelComponent.getStartY();
        graphics2D.setPaint(this.getBackground());
        graphics2D.fillRect(n3, n4, n, n2);
        graphics2D.setPaint(Color.white);
        graphics2D.drawLine(n3, n4, n3, n4 + n2);
        graphics2D.setPaint(Color.black);
        graphics2D.drawLine(n3 + n, n4, n3 + n, n4 + n2);
        graphics2D.setColor(color);
    }

    @Override
    protected void drawOneSlotLabel(Graphics2D graphics2D, DevicePanelComponent devicePanelComponent, int n, String string) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n2 = fontMetrics.stringWidth(string);
        int n3 = devicePanelComponent.getWidth();
        int n4 = devicePanelComponent.getHeight();
        if (this.getSlotPosition().equalsIgnoreCase("right")) {
            int n5 = devicePanelComponent.getStartX() + n3 + this.slotDrawPositionSpace;
            int n6 = devicePanelComponent.getStartY() + n + fontMetrics.getAscent() / 2;
            graphics2D.drawString(string, n5 + 3, n6);
        } else {
            int n7 = devicePanelComponent.getWidth() / 2;
            if (this.getSlotPosition().equalsIgnoreCase("bottom")) {
                n7 = n;
            }
            if (devicePanelComponent.bound.y + devicePanelComponent.bound.height < this.bound.y + this.bound.height - 25 - 10) {
                int n8 = devicePanelComponent.getStartX() + n7 - n2 / 2;
                int n9 = devicePanelComponent.getStartY() - this.slotDrawPositionSpace - 3;
                graphics2D.drawString(string, n8, n9);
            } else {
                int n10 = devicePanelComponent.getStartX() + n7 - n2 / 2;
                int n11 = devicePanelComponent.getStartY() + n4 + this.slotDrawPositionSpace;
                graphics2D.drawString(string, n10, n11 + 15);
            }
        }
    }

    @Override
    protected boolean isRequiredToDrawSplit(DevicePanelComponent devicePanelComponent, int n, int n2, int n3, int n4) {
        if (this.getSlotPosition().equalsIgnoreCase("right")) {
            return devicePanelComponent.bound.x + devicePanelComponent.bound.width < n + n3 - 20 - 10;
        }
        return devicePanelComponent.bound.y + devicePanelComponent.bound.height < n2 + n4 - 25 - 10;
    }
}

