/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.devicepanel.model.component;

import com.swimap.iview.templates.devicepanel.DevicePanelConstants;
import com.swimap.iview.templates.devicepanel.DevicePanelUtil;
import com.swimap.iview.templates.devicepanel.datasource.ComponentData;
import com.swimap.iview.templates.devicepanel.model.component.DevicePanelComponent;
import com.swimap.iview.templates.devicepanel.model.component.EnvironmentItem;
import com.swimap.iview.templates.devicepanel.model.component.RegularShelf;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class HighShelf
extends RegularShelf
implements DevicePanelConstants {
    private int item1height = 0;
    private int splitY = 0;
    private static final int DEFAULT_SLOTSPACE = -2;

    public HighShelf(String string, String string2, Rectangle rectangle) {
        super(string, string2, rectangle);
        this.slotDrawPositionSpace = -2;
    }

    public HighShelf(ComponentData componentData, Rectangle rectangle) {
        super(componentData, rectangle);
        this.reinit();
        this.slotDrawPositionSpace = -2;
    }

    @Override
    public void reinit() {
        this.topGirderHeight = 15;
        this.itemAreaWidth = this.bound.width - 40;
        this.itemAreaHeight = this.bound.height - this.topGirderHeight - 25;
        this.slotHeight = 16;
        int n = (this.bound.width - 20 - this.itemAreaWidth) / 2;
        this.item1height = (this.itemAreaHeight - this.slotHeight) / 2;
        this.font = new Font("Serif", 1, n + 2 + 10);
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        int n = this.bound.width;
        int n2 = this.bound.height;
        int n3 = (n - this.itemAreaWidth) / 2;
        int n4 = 5;
        int n5 = this.bound.x;
        int n6 = this.bound.y;
        if (this.behindEnabled && !this.isOnBehindFrame() || isOpenEmulational) {
            n5 = 0;
            n6 = 0;
        }
        graphics2D.setPaint(this.getBackground());
        graphics2D.fillRect(n5, n6, this.bound.width, this.bound.height);
        graphics2D.setPaint(Color.white);
        graphics2D.draw3DRect(n5, n6, this.bound.width - 1, this.bound.height - 4, true);
        graphics2D.setPaint(this.rimColor);
        graphics2D.fillRect(n5 + n3, n6 + this.topGirderHeight, n - n3 * 2, this.itemAreaHeight);
        Font font = graphics2D.getFont();
        graphics2D.setFont(this.font);
        graphics2D.setPaint(Color.black);
        graphics2D.drawLine(n5 + n4, n6 + n2, n5 + n3, n6 + n2);
        graphics2D.drawLine(n5 + n - 1 - n4, n6 + n2, n5 + n - 1 - n3, n6 + n2);
        graphics2D.drawLine(n5 + n3, n6 + n2, n5 + n3, n6 + n2 - 4);
        graphics2D.drawLine(n5 + n3, n6 + n2 - 4, n5 + n - 1 - n3 - 2, n6 + n2 - 4);
        graphics2D.drawLine(n5 + n3, n6 + n2 - 5, n5 + n - 1 - n3 - 2, n6 + n2 - 5);
        graphics2D.drawLine(n5 + n - 1 - n3 - 2, n6 + n2 - 4, n5 + n - 1 - n3 - 2, n6 + n2 - 6);
        graphics2D.setPaint(Color.white);
        graphics2D.drawLine(n5 + n3, n6 + n2 - 6, n5 + n - 1 - n3 - 2, n6 + n2 - 6);
        graphics2D.drawLine(n5 + n - 1 - n3, n6 + n2, n5 + n - 1 - n3, n6 + n2 - 6);
        graphics2D.drawLine(n5 + n - 1 - n3, n6 + this.topGirderHeight + this.itemAreaHeight, n5 + n - 1 - n3, n6 + this.topGirderHeight);
        graphics2D.setPaint(Color.black);
        graphics2D.drawLine(n5 + n3, n6 + n2, n5 + n3, n6 + n2 - 6);
        graphics2D.drawLine(n5 + n3, n6 + this.topGirderHeight + this.itemAreaHeight, n5 + n3, n6 + this.topGirderHeight);
        graphics2D.setPaint(Color.white);
        graphics2D.drawLine(n5 + n3, n6 + this.topGirderHeight + this.itemAreaHeight, n5 + n - 1 - n3, n6 + this.topGirderHeight + this.itemAreaHeight);
        int n7 = this.nutIcon.getIconWidth();
        int n8 = this.nutIcon.getIconHeight();
        int n9 = (n3 - n7) / 2;
        this.nutIcon.paintIcon(null, graphics2D, n5 + n9, n6 + n9);
        this.nutIcon.paintIcon(null, graphics2D, n5 + n9, n6 + n2 - 1 - n9 - n8);
        this.nutIcon.paintIcon(null, graphics2D, n5 + n - 1 - n9 - n7, n6 + n9);
        this.nutIcon.paintIcon(null, graphics2D, n5 + n - 1 - n9 - n7, n6 + n2 - 1 - n9 - n8);
        int n10 = n5 + n3 + 10;
        int n11 = n6 + this.topGirderHeight / 5 - 1;
        int n12 = this.itemAreaWidth;
        int n13 = this.topGirderHeight / 5 * 3;
        if (this.getRelatedTreeNode().getChildCount() > this.frontChildCount && !this.behindEnabled) {
            this.drawStateBar(graphics2D, n10, n11, n12, n13);
        } else if (this.isOnBehindFrame()) {
            this.drawStateBar(graphics2D, n10, n11, n12, n13);
        }
        graphics2D.setPaint(this.rimColor);
        graphics2D.fillRect(n5 + n3, n6 + this.topGirderHeight - 1, 10, this.itemAreaHeight + 1);
        graphics2D.fillRect(n5 + n - 1 - n3 - 10 + 1, n6 + this.topGirderHeight - 1, 10, this.itemAreaHeight + 1);
        graphics2D.drawArc(n5, n6 + n2 - 1 - 2 * n4, 2 * n4, 2 * n4, 180, 90);
        graphics2D.drawArc(n5 + 1, n6 + n2 - 1 - 2 * n4, 2 * n4, 2 * n4, 180, 90);
        graphics2D.drawLine(n5 + n4 - 2, n6 + n2 - 1, n5 + n3 - 1, n6 + n2 - 1);
        graphics2D.drawLine(n5 + n4 - 3, n6 + n2 - 1 - 1, n5 + n3 - 1, n6 + n2 - 1 - 1);
        graphics2D.drawLine(n5 + n3 - 1, n6 + n2 - 1, n5 + n3 - 1, n6 + n2 - 6);
        graphics2D.drawLine(n5 + n3 - 2, n6 + n2 - 2, n5 + n3 - 2, n6 + n2 - 6);
        graphics2D.drawLine(n5 + n3 - 2, n6 + n2 - 6, n5 + n - 1 - n3, n6 + n2 - 6);
        graphics2D.drawLine(n5 + n3 - 1, n6 + n2 - 7, n5 + n - 1 - n3, n6 + n2 - 7);
        graphics2D.setPaint(Color.white);
        graphics2D.drawLine(n5 + n - 1 - n3 + 1, n6 + n2 - 1, n5 + n - 1 - n3 + 1, n6 + n2 - 6);
        graphics2D.drawLine(n5 + n - 1 - n3 + 2, n6 + n2 - 2, n5 + n - 1 - n3 + 2, n6 + n2 - 6);
        graphics2D.setPaint(this.rimColor);
        graphics2D.drawLine(n5 + n - 1 - n3 + 1, n6 + n2 - 1, n5 + n - 1 - n4, n6 + n2 - 1);
        graphics2D.drawLine(n5 + n - 1 - n3 + 2, n6 + n2 - 2, n5 + n - 1 - n4, n6 + n2 - 2);
        graphics2D.drawLine(n5 + n - 1 - 1, n6 + n2 - 4, n5 + n - 1 - 1, n6 + 3);
        graphics2D.drawLine(n5 + n - 1 - 2, n6 + n2 - 3, n5 + n - 1 - 2, n6 + 2);
        graphics2D.drawLine(n5 + n - 1 - 3, n6 + n2 - 2, n5 + n - 1 - 3, n6 + 1);
        graphics2D.drawArc(n5 + n - 1 - 2 * n4, n6 + n2 - 1 - 2 * n4, 2 * n4, 2 * n4, 270, 90);
        graphics2D.drawArc(n5 + n - 1 - 2 * n4 - 1, n6 + n2 - 1 - 2 * n4, 2 * n4, 2 * n4, 270, 90);
        graphics2D.setPaint(Color.white);
        graphics2D.drawLine(n5 + n - 1 - 4, n6 + 1, n5 + n - 1, n6 + 4);
        graphics2D.drawArc(n5 + n - 2 * n4, n6 + 1, 2 * n4 - 1, 2 * n4, 0, 90);
        graphics2D.drawArc(n5 + n - 2 * n4 - 1, n6 + 1, 2 * n4 - 1, 2 * n4, 0, 90);
        graphics2D.drawLine(n5 + 1, n6 + 1 + n4, n5 + 1, n6 + n2 - n4);
        graphics2D.drawLine(n5 + 2, n6 + n4, n5 + 2, n6 + n2 - n4 + 1);
        graphics2D.drawArc(n5, n6 + 1, 2 * n4, 2 * n4, 90, 90);
        graphics2D.drawArc(n5 + 1, n6 + 1, 2 * n4, 2 * n4, 90, 90);
        graphics2D.drawArc(n5 + 2, n6 + 1, 2 * n4, 2 * n4, 90, 90);
        graphics2D.setPaint(this.rimColor);
        graphics2D.drawLine(n5 + n3 - 1, n6 + this.topGirderHeight + this.itemAreaHeight, n5 + n3 - 1, n6 + this.topGirderHeight - 1);
        graphics2D.drawLine(n5 + n3 - 2, n6 + this.topGirderHeight + this.itemAreaHeight + 1, n5 + n3 - 2, n6 + this.topGirderHeight - 2);
        graphics2D.drawLine(n5 + n3 - 1, n6 + this.topGirderHeight - 1, n5 + n - 1 - n3 + 1, n6 + this.topGirderHeight - 1);
        graphics2D.drawLine(n5 + n3 - 2, n6 + this.topGirderHeight - 2, n5 + n - 1 - n3 + 2, n6 + this.topGirderHeight - 2);
        graphics2D.setPaint(Color.black);
        graphics2D.drawLine(n5 + n3, n6 + this.topGirderHeight - 1, n5 + n3, n6 + this.topGirderHeight + this.itemAreaHeight);
        graphics2D.drawLine(n5 + n - 1 - n3, n6 + this.topGirderHeight - 1, n5 + n - 1 - n3, n6 + this.topGirderHeight + this.itemAreaHeight - 1);
        graphics2D.setPaint(Color.white);
        graphics2D.drawLine(n5 + n - 1 - n3 + 1, n6 + this.topGirderHeight - 1, n5 + n - 1 - n3 + 1, n6 + this.topGirderHeight + this.itemAreaHeight + 1);
        graphics2D.drawLine(n5 + n - 1 - n3 + 2, n6 + this.topGirderHeight - 2, n5 + n - 1 - n3 + 2, n6 + this.topGirderHeight + this.itemAreaHeight + 1);
        graphics2D.drawLine(n5 + n - 1 - n3 + 1, n6 + this.topGirderHeight + this.itemAreaHeight + 1, n5 + n3 - 1, n6 + this.topGirderHeight + this.itemAreaHeight + 1);
        graphics2D.setPaint(Color.black);
        graphics2D.drawLine(n5 + n - 1, n6 + 1 + n4, n5 + n - 1, n6 + n2 - 1 - n4);
        graphics2D.drawArc(n5 + n - 1 - 2 * n4, n6 + n2 - 1 - 2 * n4 + 1, 2 * n4, 2 * n4, 270, 90);
        graphics2D.drawArc(n5, n6 + n2 - 1 - 2 * n4 + 1, 2 * n4, 2 * n4, 180, 90);
        if (this.isShowLot()) {
            this.drawShelfLabel(graphics2D, n5, n6, n3);
        }
        graphics2D.setFont(font);
        int n14 = 0;
        this.splitY = 0;
        if (!this.behindEnabled) {
            for (int i = 0; i < this.frontChildCount; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.relatedTreeNode.getChildAt(i);
                DevicePanelComponent devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
                if (devicePanelComponent.bound.y - this.splitY > 2 && !(devicePanelComponent instanceof EnvironmentItem)) {
                    this.splitY = devicePanelComponent.bound.y;
                    if (devicePanelComponent.bound.y + devicePanelComponent.bound.height < n6 + n2 - 25) {
                        this.drawSplit(graphics2D, new Rectangle(n5 + n3, devicePanelComponent.bound.y + devicePanelComponent.bound.height, n - n3 * 2, this.slotHeight));
                    }
                }
                if (this.slotLabelEnabled && devicePanelComponent.isShowLot()) {
                    this.drawSlotLabel(graphics2D, devicePanelComponent, n14);
                    ++n14;
                }
                if (devicePanelComponent instanceof EnvironmentItem) {
                    if (!this.isEnvironmentItemVisible()) {
                        ((EnvironmentItem)devicePanelComponent).setVisible(false);
                        continue;
                    }
                    ((EnvironmentItem)devicePanelComponent).setVisible(true);
                }
                devicePanelComponent.draw(graphics2D);
            }
        } else {
            n14 = this.frontChildCount;
            int n15 = this.relatedTreeNode.getChildCount();
            for (int i = this.frontChildCount; i < n15; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.relatedTreeNode.getChildAt(i);
                DevicePanelComponent devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
                if (devicePanelComponent.bound.y - this.splitY > 2 && !(devicePanelComponent instanceof EnvironmentItem)) {
                    this.splitY = devicePanelComponent.bound.y;
                    this.drawSplit(graphics2D, new Rectangle(n5 + n3, devicePanelComponent.bound.y + devicePanelComponent.bound.height, n - n3 * 2, this.slotHeight));
                }
                if (this.slotLabelEnabled && devicePanelComponent.isShowLot()) {
                    this.drawSlotLabel(graphics2D, devicePanelComponent, n14 - this.frontChildCount);
                    ++n14;
                }
                if (devicePanelComponent instanceof EnvironmentItem) {
                    if (!this.isEnvironmentItemVisible()) {
                        ((EnvironmentItem)devicePanelComponent).setVisible(false);
                        continue;
                    }
                    ((EnvironmentItem)devicePanelComponent).setVisible(true);
                }
                devicePanelComponent.draw(graphics2D);
            }
        }
    }

    private void drawShelfLabel(Graphics2D graphics2D, int n, int n2, int n3) {
        if (this.label == null) {
            this.label = this.getDefaultLabel();
        }
        char[] cArray = this.label.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            graphics2D.drawString(new String(cArray, i, 1), n + n3 / 4, n2 + this.bound.height / 2 + i * 20);
        }
    }

    @Override
    public void calculateChildPosition(int n, int n2) {
        int n3 = 0;
        if (this.getEnvironmentItemRowsHight() > 0) {
            n3 = this.slotHeight;
        }
        double d = (double)(n - 40) / (double)this.itemAreaWidth;
        double d2 = 0.0;
        d2 = this.getEnvironmentItemRowsHight() > 0 && !this.isEnvironmentItemVisible() ? (double)(n2 - this.topGirderHeight - 25 - 3 - this.slotHeight - n3 - this.getEnvironmentItemRowsHight()) / ((double)this.itemAreaHeight - (double)this.slotHeight) : (double)(n2 - this.topGirderHeight - 25 - this.slotHeight - n3 - this.getEnvironmentItemRowsHight()) / ((double)this.itemAreaHeight - (double)this.slotHeight - (double)n3 - (double)this.getEnvironmentItemRowsHight());
        int n4 = this.relatedTreeNode.getChildCount();
        for (int i = this.frontChildCount; i < n4; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.relatedTreeNode.getChildAt(i);
            DevicePanelComponent devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
            Rectangle rectangle = devicePanelComponent.abstractBound;
            if (devicePanelComponent.bound.y > this.item1height) {
                if (devicePanelComponent instanceof EnvironmentItem) {
                    devicePanelComponent.realBound = new Rectangle(DevicePanelUtil.GetInt((double)(rectangle.x - 20) * d + 20.0), DevicePanelUtil.GetInt((double)(rectangle.y - this.topGirderHeight - this.slotHeight - n3) * d2 + (double)this.topGirderHeight + (double)this.slotHeight + (double)n3), DevicePanelUtil.GetInt((double)rectangle.width * d), DevicePanelUtil.GetInt(rectangle.height));
                    continue;
                }
                devicePanelComponent.realBound = new Rectangle(DevicePanelUtil.GetInt((double)(rectangle.x - 20) * d + 20.0), DevicePanelUtil.GetInt((double)(rectangle.y - this.topGirderHeight - this.slotHeight) * d2 + (double)this.topGirderHeight + (double)this.slotHeight), DevicePanelUtil.GetInt((double)rectangle.width * d), DevicePanelUtil.GetInt((double)rectangle.height * d2));
                continue;
            }
            devicePanelComponent.realBound = new Rectangle(DevicePanelUtil.GetInt((double)(rectangle.x - 20) * d + 20.0), DevicePanelUtil.GetInt((double)(rectangle.y - this.topGirderHeight) * d2 + (double)this.topGirderHeight), DevicePanelUtil.GetInt((double)rectangle.width * d), DevicePanelUtil.GetInt((double)rectangle.height * d2));
        }
    }

    @Override
    public int getOccupiedShelfNum() {
        return 2;
    }

    private String getDefaultLabel() {
        TreeNode treeNode = this.relatedTreeNode.getParent();
        int n = treeNode.getIndex(this.relatedTreeNode);
        int n2 = treeNode.getChildCount();
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        for (int i = 0; i < n2; ++i) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)treeNode.getChildAt(i);
            if (defaultMutableTreeNode.getUserObject() instanceof EnvironmentItem) continue;
            n -= i;
            break;
        }
        return Integer.toString(n);
    }
}

