/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.devicepanel.model.component;

import com.swimap.iview.templates.devicepanel.datasource.ComponentData;
import com.swimap.iview.templates.devicepanel.model.component.DevicePanelComponent;
import com.swimap.iview.templates.devicepanel.model.component.EnvironmentItem;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.tree.DefaultMutableTreeNode;

public class Frame
extends DevicePanelComponent {
    protected int pageCount = 0;
    protected int areaHeight = 0;
    protected Color rimColor = SHELF_BACKGROUND_COLOR;

    public Frame(String string, String string2, Rectangle rectangle) {
        super(string, string2, rectangle);
    }

    public Frame(ComponentData componentData, Rectangle rectangle) {
        super(componentData, rectangle);
        if (componentData != null) {
            this.setIsFacility(componentData.getIsFacility());
        } else {
            this.setIsFacility(false);
        }
    }

    public int getAreaHeight() {
        return this.areaHeight;
    }

    public void setAreaHeight(int n) {
        this.areaHeight = n;
    }

    @Override
    public void adjustToAbsaluteCordination(int n, int n2) {
        super.adjustToAbsaluteCordination(n, n2);
        int n3 = this.relatedTreeNode.getChildCount();
        for (int i = 0; i < n3; ++i) {
            DevicePanelComponent devicePanelComponent;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.relatedTreeNode.getChildAt(i);
            if (defaultMutableTreeNode.getUserObject() instanceof EnvironmentItem || (devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode.getUserObject()).getBelongingPageIndex() < this.pageCount) continue;
            this.pageCount = devicePanelComponent.getBelongingPageIndex() + 1;
        }
    }

    public boolean downPage() {
        if (this.currentPageIndex <= this.pageCount - 2) {
            ++this.currentPageIndex;
            this.changePage();
            return true;
        }
        return false;
    }

    public boolean upPage() {
        if (this.currentPageIndex >= 1) {
            --this.currentPageIndex;
            this.changePage();
            return true;
        }
        return false;
    }

    protected void changePage() {
        this.setCurrentPageIndex(this.currentPageIndex);
        this.belongingPageIndex = this.currentPageIndex;
        int n = this.relatedTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.relatedTreeNode.getChildAt(i);
            if (!(defaultMutableTreeNode.getUserObject() instanceof EnvironmentItem)) continue;
            EnvironmentItem environmentItem = (EnvironmentItem)defaultMutableTreeNode.getUserObject();
            environmentItem.setBelongingPageIndex(this.belongingPageIndex);
        }
    }

    @Override
    public boolean isPopupMenuAllowed(int n, int n2) {
        return n <= this.bound.x + this.bound.width && n2 <= this.bound.y + 10 + this.bound.height + this.areaHeight;
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        int n = this.bound.x;
        int n2 = this.bound.y;
        int n3 = this.bound.width;
        int n4 = this.bound.height + this.getAreaHeight() + 10;
        graphics2D.setPaint(this.getBackground());
        graphics2D.fillRect(n, n2, n3, n4);
        graphics2D.setPaint(Color.white);
        graphics2D.draw3DRect(n, n2, n3, n4, true);
        graphics2D.setPaint(Color.gray);
        graphics2D.drawLine(n, n2, n, n2 + n4);
        graphics2D.drawLine(n, n2, n + n3, n2);
        graphics2D.drawLine(n + 1, n2, n + 1, n2 + n4);
        graphics2D.drawLine(n, n2 + 1, n + n3, n2 + 1);
        graphics2D.setColor(Color.gray);
        graphics2D.drawLine(n + n3, n2 + n4, n + n3, n2);
        graphics2D.drawLine(n + n3 - 1, n2 + n4, n + n3 - 1, n2);
        graphics2D.drawLine(n, n2 + n4 - 2, n + n3, n2 + n4 - 2);
        graphics2D.drawLine(n, n2 + n4 - 1, n + n3, n2 + n4 - 1);
        int n5 = this.relatedTreeNode.getChildCount();
        for (int i = 0; i < n5; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.relatedTreeNode.getChildAt(i);
            DevicePanelComponent devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
            if (!devicePanelComponent.isInCurrentPage()) continue;
            devicePanelComponent.setIsFacility(this.isIsFacility());
            devicePanelComponent.setBehindEnabled(this.getBehindEnabled());
            devicePanelComponent.draw(graphics2D);
        }
    }

    @Override
    public boolean isPointInArea(int n, int n2) {
        return this.bound.contains(n, n2 - 10 - this.areaHeight) || this.bound.contains(n, n2);
    }

    @Override
    public void selectedShapedDraw(Graphics2D graphics2D) {
        int n;
        int n2 = this.bound.x;
        int n3 = this.bound.y;
        int n4 = this.bound.width;
        int n5 = this.bound.height + this.getAreaHeight() + 10;
        graphics2D.setPaint(this.getBackground());
        graphics2D.fillRect(n2, n3, n4, n5);
        graphics2D.setPaint(Color.white);
        graphics2D.draw3DRect(n2, n3, n4, n5, true);
        for (n = 0; n < 5; ++n) {
            if (n == 0 || n == 4) {
                graphics2D.setColor(Color.white);
            } else {
                graphics2D.setPaint(SELECTED_COLOR);
            }
            graphics2D.drawRect(n2 + n, n3 + n, n4 - 2 * n, n5 - 2 * n);
        }
        for (n = 0; n < this.relatedTreeNode.getChildCount(); ++n) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.relatedTreeNode.getChildAt(n);
            DevicePanelComponent devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
            if (!devicePanelComponent.isInCurrentPage()) continue;
            devicePanelComponent.setIsFacility(this.isIsFacility());
            devicePanelComponent.setBehindEnabled(this.getBehindEnabled());
            devicePanelComponent.draw(graphics2D);
        }
    }
}

