/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.devicepanel.model.component;

import com.swimap.iview.templates.devicepanel.datasource.ComponentData;
import com.swimap.iview.templates.devicepanel.model.component.DevicePanelComponent;
import com.swimap.iview.templates.devicepanel.model.component.EnvironmentItem;
import com.swimap.iview.templates.devicepanel.model.component.RegularShelf;
import com.swimap.iview.templates.devicepanel.model.component.Shelf;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.tree.DefaultMutableTreeNode;

public class FansEnvironmentItem
extends EnvironmentItem {
    private static IviewLogger logger = IviewLogger.getLogger(FansEnvironmentItem.class, "IVIEW");
    private static final int FAN_TOP_EMULATE_SPACE = 16;
    private static final int FAN_TOP_FACILITY_SPACE = 12;
    private static final int HEIGHT_SCALE = 5;
    private static final int WEIGHT_SCALE = 25;
    private static final int EMULATE_FONT_SIZE = 12;
    private static final int FACILITY_FANOT_SIZE = 11;
    private Color rimColor = SHELF_BACKGROUND_COLOR;
    private Font font = null;
    private Color fansColor = this.getBackground();
    private int space = 4;
    private int slotBeginValue = 0;
    private FontMetrics metric = null;

    public Color getFansColor() {
        return this.fansColor;
    }

    public FansEnvironmentItem(String string, String string2, Rectangle rectangle) {
        super(string, string2, rectangle);
        this.isShowSlot = false;
    }

    public FansEnvironmentItem(ComponentData componentData, Rectangle rectangle) {
        super(componentData, rectangle);
        this.isShowSlot = false;
    }

    public void setSlotBeginValue(int n) {
        this.slotBeginValue = n;
    }

    protected boolean isDrawSlot() {
        DevicePanelComponent devicePanelComponent = this.getParent();
        if (!(devicePanelComponent instanceof RegularShelf)) {
            return true;
        }
        RegularShelf regularShelf = (RegularShelf)devicePanelComponent;
        if ("bottom".equalsIgnoreCase(regularShelf.getSlotPosition())) {
            return true;
        }
        return !"right".equalsIgnoreCase(regularShelf.getSlotPosition());
    }

    protected boolean isOnTop() {
        return false;
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        int n = this.bound.x;
        int n2 = this.bound.y;
        int n3 = this.bound.width;
        int n4 = this.bound.height;
        if (this.isIsFacility()) {
            this.space = 2;
        }
        int n5 = n;
        int n6 = n2 + 2 * this.space + (n4 - 3 * this.space) / 2;
        if (this.isOnTop()) {
            n6 = n2 + this.space;
            n2 = n2 + 2 * this.space + (n4 - 3 * this.space) / 2;
        }
        int n7 = n3;
        int n8 = (n4 - 3 * this.space) / 2;
        int n9 = this.isIsFacility() ? 11 : 12;
        try {
            n9 = this.isIsFacility() ? Integer.parseInt(this.res.getString("FanItem_Facility_FontSize")) : Integer.parseInt(this.res.getString("FanItem_Emulational_FontSize"));
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage());
        }
        if (0 < this.getFontSize()) {
            n9 = this.getFontSize();
        }
        if (n8 < n9) {
            n4 += n9 - n8;
            n8 = n9;
        }
        this.font = new Font(this.res.getString("Font"), 0, n9);
        Font font = graphics2D.getFont();
        graphics2D.setFont(this.font);
        if (this.stateObject != null) {
            this.setFansColor(this.stateObject.getColor());
        }
        graphics2D.setPaint(this.rimColor);
        graphics2D.fillRect(n - 10, this.bound.y, n3 + 20, n4 + 1);
        graphics2D.setPaint(this.getBackground());
        graphics2D.fillRect(n - 10, n2 + this.space, n3 + 20, (n4 - 3 * this.space) / 2);
        graphics2D.setPaint(Color.white);
        graphics2D.drawLine(n - 10, n2 + this.space, n + n3 + 10, n2 + this.space);
        graphics2D.drawLine(n - 10, n2 + this.space, n - 10, n2 + this.space + (n4 - 3 * this.space) / 2);
        graphics2D.setPaint(Color.black);
        graphics2D.drawLine(n - 10, n2 + this.space + (n4 - 3 * this.space) / 2, n + n3 + 10, n2 + this.space + (n4 - 3 * this.space) / 2);
        graphics2D.drawLine(n + n3 + 10, n2 + this.space + (n4 - 3 * this.space) / 2, n + n3 + 10, n2 + this.space);
        graphics2D.setPaint(this.getBackground());
        graphics2D.fillRect(n5, n6, n7, n8);
        graphics2D.setPaint(Color.white);
        graphics2D.drawLine(n5, n6, n5, n6 + n8);
        graphics2D.drawLine(n5, n6, n5 + n7, n6);
        graphics2D.setPaint(Color.black);
        graphics2D.drawLine(n5 + n7, n6, n5 + n7, n6 + n8);
        graphics2D.drawLine(n5, n6 + n8, n5 + n7, n6 + n8);
        int n10 = n5 + n7 / 25;
        int n11 = n6 + n8 / 5 + 1;
        int n12 = n7 / 25;
        int n13 = n8 / 5 * 3;
        graphics2D.setPaint(this.getFansColor());
        graphics2D.fillRect(n10, n11, n12, n13);
        graphics2D.setPaint(Color.black);
        graphics2D.drawLine(n10, n11, n10, n11 + n13);
        graphics2D.drawLine(n10, n11, n10 + n12, n11);
        graphics2D.setPaint(Color.white);
        graphics2D.drawLine(n10 + n12, n11 + n13, n10, n11 + n13);
        graphics2D.drawLine(n10 + n12, n11 + n13, n10 + n12, n11);
        graphics2D.setPaint(Color.black);
        graphics2D.drawString(this.res.getString("Fan"), n10 + n12 + 4, n6 - (n8 - n9) / 2 + n8 - 2);
        graphics2D.setFont(font);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getRelatedTreeNode().getParent();
        Shelf shelf = (Shelf)defaultMutableTreeNode.getUserObject();
        if (this.isDrawSlot()) {
            int n14 = this.slotBeginValue;
            for (int i = shelf.behindEnabled ? shelf.frontChildCount : 0; i < (shelf.behindEnabled ? defaultMutableTreeNode.getChildCount() : shelf.frontChildCount); ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                DevicePanelComponent devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode2.getUserObject();
                if (!devicePanelComponent.isIsShowSlot()) continue;
                this.drawSlotLabel(graphics2D, devicePanelComponent, n14);
                ++n14;
            }
        }
    }

    protected void drawSlotLabel(Graphics2D graphics2D, DevicePanelComponent devicePanelComponent, int n) {
        Font font = graphics2D.getFont();
        if (this.getSlotLableFont() != null) {
            graphics2D.setFont(this.getSlotLableFont());
        } else {
            graphics2D.setFont(font);
        }
        Color color = graphics2D.getColor();
        if (this.getSlotLableColor() != null) {
            graphics2D.setPaint(this.getSlotLableColor());
        } else {
            graphics2D.setPaint(color);
        }
        this.metric = graphics2D.getFontMetrics();
        StringBuffer stringBuffer = new StringBuffer(8);
        if (n < 10) {
            stringBuffer.append(0);
            stringBuffer.append(n);
        } else {
            stringBuffer.append(n);
        }
        String string = stringBuffer.toString();
        int n2 = this.metric.stringWidth(string);
        int n3 = devicePanelComponent.getStartX() + devicePanelComponent.getWidth() / 2 - n2 / 2;
        int n4 = this.bound.y;
        if (this.isOnTop()) {
            n4 += this.bound.height - 16;
        }
        if (!this.isIsFacility()) {
            graphics2D.drawString(string, n3, n4 + 16);
        } else {
            graphics2D.drawString(string, n3, n4 + 12);
        }
        graphics2D.setFont(font);
        graphics2D.setColor(color);
    }

    @Override
    public void drawState(Graphics2D graphics2D, boolean bl) {
        if (this.stateObject != null) {
            this.setFansColor(this.stateObject.getColor());
        } else {
            this.setFansColor(this.rimColor);
            logger.debug("FansEnvironmentItem get stateObject fail");
        }
        this.draw(graphics2D);
    }

    @Override
    public void selectedShapedDraw(Graphics2D graphics2D) {
        int n;
        Font font = graphics2D.getFont();
        graphics2D.setFont(this.font);
        int n2 = this.bound.x;
        int n3 = this.bound.y + 2 * this.space + (this.bound.height - 3 * this.space) / 2;
        int n4 = this.bound.width;
        int n5 = (this.bound.height - 3 * this.space) / 2;
        if (this.isOnTop()) {
            n3 = this.bound.y + this.space;
        }
        if (n5 < this.font.getSize()) {
            n5 = this.font.getSize();
        }
        graphics2D.clearRect(n2, n3, n4, n5);
        graphics2D.setPaint(this.getBackground());
        graphics2D.fillRect(n2, n3, n4, n5);
        for (n = -1; n < 3; ++n) {
            if (n == -1 || n == 2) {
                graphics2D.setColor(Color.white);
            } else {
                graphics2D.setPaint(SELECTED_COLOR);
            }
            graphics2D.drawRect(n2 + n, n3 + n, n4 - 2 * n, n5 - 2 * n);
        }
        n = n2 + n4 / 20;
        int n6 = n3 + n5 / 5 + 2;
        int n7 = n4 / 25;
        int n8 = n5 / 5 * 3;
        graphics2D.setPaint(this.getFansColor());
        graphics2D.fillRect(n, n6, n7, n8);
        graphics2D.setPaint(Color.black);
        graphics2D.drawLine(n, n6, n, n6 + n8);
        graphics2D.drawLine(n, n6, n + n7, n6);
        graphics2D.setPaint(Color.white);
        graphics2D.drawLine(n + n7, n6 + n8, n, n6 + n8);
        graphics2D.drawLine(n + n7, n6 + n8, n + n7, n6);
        graphics2D.setPaint(Color.black);
        graphics2D.drawString(this.res.getString("Fan"), n + n7 + 4, n3 + n5 - (n5 - this.font.getSize()) / 2 - 1);
        graphics2D.setFont(font);
    }

    public void setFansColor(Color color) {
        this.fansColor = color;
    }

    public boolean isInArea(int n, int n2) {
        int n3 = this.bound.x;
        int n4 = this.bound.y + 2 * this.space + (this.bound.height - 3 * this.space) / 2;
        int n5 = this.bound.width;
        int n6 = (this.bound.height - 3 * this.space) / 2;
        if (this.isOnTop()) {
            n4 = this.bound.y + this.space;
            int n7 = 12;
            if (0 < this.getFontSize()) {
                n7 = this.getFontSize();
            }
            if (n6 < n7) {
                n6 = n7;
            }
        }
        return n > n3 && n < n3 + n5 && n2 > n4 && n2 < n4 + n6;
    }

    @Override
    public boolean isPointInArea(int n, int n2) {
        return this.isInArea(n, n2);
    }
}

