/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.devicepanel.model.component;

import com.swimap.iview.templates.devicepanel.model.CompareAlarmAndState;
import com.swimap.iview.templates.devicepanel.model.DevicePanelTreeModel;
import com.swimap.iview.templates.devicepanel.model.component.Card;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.ImageIcon;

public class DoubleCard
extends Card {
    private Card frontCard = null;
    private Card backCard = null;
    private String currentCardID = null;
    private Card initFirstCard = null;
    private Card initSecondCard = null;

    public DoubleCard(String string, String string2, Rectangle rectangle, Card card, Card card2) {
        super(string, string2, rectangle);
        this.initFirstCard = card;
        this.initSecondCard = card2;
        if (card == null && card2 == null) {
            return;
        }
        if (card != null && card2 == null) {
            this.frontCard = card;
            this.backCard = null;
            this.initDoubleCard(card);
            return;
        }
        if (card == null && card2 != null) {
            this.initDoubleCard(card2);
            this.frontCard = card2;
            return;
        }
        if (card.getStateObject() != null || card2.getStateObject() != null) {
            this.progressCardsStateAlarm(card, card2);
        } else {
            this.progressCardsAlarm(card, card2);
        }
    }

    public void progressCardsStateAlarm(Card card, Card card2) {
        CompareAlarmAndState compareAlarmAndState = DevicePanelTreeModel.getCompareAlarmAndState();
        if (card.getStateObject() == null && card2.getStateObject() != null) {
            this.frontCard = card2;
            this.backCard = card;
            this.initDoubleCard(card2);
        } else if (card.getStateObject() != null && card2.getStateObject() == null) {
            this.frontCard = card;
            this.backCard = card2;
            this.initDoubleCard(card);
        } else if (card.getStateObject() != null && card2.getStateObject() != null) {
            if (compareAlarmAndState == null) {
                this.frontCard = card;
                this.backCard = card2;
                this.initDoubleCard(card);
                return;
            }
            int n = compareAlarmAndState.compareState(card.getStateObject(), card2.getStateObject());
            if (n > 0) {
                this.frontCard = card2;
                this.backCard = card;
                this.initDoubleCard(card2);
            } else if (n < 0) {
                this.frontCard = card;
                this.backCard = card2;
                this.initDoubleCard(card);
            } else {
                this.progressCardsAlarm(card, card2);
            }
        } else {
            this.progressCardsAlarm(card, card2);
        }
    }

    public void progressCardsAlarm(Card card, Card card2) {
        CompareAlarmAndState compareAlarmAndState = DevicePanelTreeModel.getCompareAlarmAndState();
        if (card.getAlarmObject() == null && card2.getAlarmObject() != null) {
            this.frontCard = card2;
            this.backCard = card;
            this.initDoubleCard(card2);
        } else if (card.getAlarmObject() != null && card2.getAlarmObject() == null) {
            this.frontCard = card;
            this.backCard = card2;
            this.initDoubleCard(card);
        } else if (card.getAlarmObject() != null && card2.getAlarmObject() != null) {
            if (compareAlarmAndState == null) {
                this.frontCard = card;
                this.backCard = card2;
                this.initDoubleCard(card);
                return;
            }
            if (compareAlarmAndState.compareAlarm(card.getAlarmObject(), card2.getAlarmObject()) > 0) {
                this.frontCard = card2;
                this.backCard = card;
                this.initDoubleCard(card2);
            } else {
                this.frontCard = card;
                this.backCard = card2;
                this.initDoubleCard(card);
            }
        } else {
            this.frontCard = card;
            this.backCard = card2;
            this.initDoubleCard(card);
        }
    }

    public void initDoubleCard(Card card) {
        if (card == null) {
            return;
        }
        this.setCurrentCardID(card.getID());
        if (card.getComposeImageIconUtilities() != null) {
            this.setImageIconUtilities(card.getComposeImageIconUtilities());
            this.setLabelVisible(false);
        } else if (card.getLabelVisible() && card.getLabel() != null) {
            this.setLabel(card.getLabel());
            this.setLabelVisible(card.getLabelVisible());
        } else {
            this.setLabel("");
            this.setLabelVisible(false);
        }
        if (card.getStateObject() != null) {
            this.setStateObject(card.getStateObject());
        }
        if (card.getAlarmObject() != null) {
            this.setAlarmObject(card.getAlarmObject());
        }
    }

    public Card getFrontCard() {
        return this.frontCard;
    }

    public Card getBackCard() {
        return this.backCard;
    }

    public String getCurrentCardID() {
        return this.currentCardID;
    }

    public void setCurrentCardID(String string) {
        if (this.frontCard.getID().compareTo(string) == 0 || this.backCard.getID().compareTo(string) == 0) {
            this.currentCardID = string;
        }
    }

    public void swichCurrentCard(String string) {
        if (this.frontCard.getID().compareTo(string) == 0) {
            this.currentCardID = string;
            if (this.frontCard.getComposeImageIconUtilities() != null) {
                this.setImageIconUtilities(this.frontCard.getComposeImageIconUtilities());
                this.setLabelVisible(false);
            } else {
                if (this.frontCard.getLabelVisible() && this.frontCard.getLabel() != null) {
                    this.setLabel(this.frontCard.getLabel());
                    this.setLabelVisible(this.frontCard.getLabelVisible());
                } else {
                    this.setLabel("");
                    this.setLabelVisible(false);
                }
                this.setImageIconUtilities(null);
            }
            this.setStateObject(this.frontCard.getStateObject());
            this.setAlarmObject(this.frontCard.getAlarmObject());
        }
        if (this.backCard.getID().compareTo(string) == 0) {
            this.currentCardID = string;
            if (this.backCard.getComposeImageIconUtilities() != null) {
                this.setImageIconUtilities(this.backCard.getComposeImageIconUtilities());
            } else {
                if (this.backCard.getLabelVisible()) {
                    this.setLabel(this.backCard.getLabel());
                    this.setLabelVisible(true);
                } else {
                    this.setLabel("");
                    this.setLabelVisible(false);
                }
                this.setImageIconUtilities(null);
            }
            this.setStateObject(this.backCard.getStateObject());
            this.setAlarmObject(this.backCard.getAlarmObject());
        }
    }

    @Override
    public void drawWithImage(Graphics2D graphics2D, boolean bl) {
        ImageIcon imageIcon = null;
        int n = this.bound.x;
        int n2 = this.bound.y;
        if (bl) {
            ++n;
            ++n2;
            if (this.stateObject == null) {
                this.imageIconUtilities.update(this.getWidth(), this.getHeight());
                imageIcon = this.imageIconUtilities.getSelectedImageIcon();
            } else {
                this.imageIconUtilities.update(this.getWidth(), this.getHeight());
                imageIcon = this.imageIconUtilities.getSelectedImageIconWithState(this.stateObject);
            }
        } else if (this.stateObject == null) {
            this.imageIconUtilities.update(this.getWidth(), this.getHeight());
            imageIcon = this.imageIconUtilities.getNormalImageIcon();
        } else {
            this.imageIconUtilities.update(this.getWidth(), this.getHeight());
            imageIcon = this.imageIconUtilities.getNormalImageIconWithState(this.stateObject);
        }
        imageIcon.paintIcon(null, graphics2D, n, n2);
        graphics2D.setComposite(composite1);
        this.drawAlarm(graphics2D, bl);
        graphics2D.setComposite(composite2);
    }

    public Card getInitFirstCard() {
        return this.initFirstCard;
    }

    public Card getInitSecondCard() {
        return this.initSecondCard;
    }
}

