/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.devicepanel.model.component;

import com.swimap.iview.templates.devicepanel.DevicePanelUtil;
import com.swimap.iview.templates.devicepanel.datasource.ComponentData;
import com.swimap.iview.templates.devicepanel.model.AlarmObject;
import com.swimap.iview.templates.devicepanel.model.ImageIconUtilities;
import com.swimap.iview.templates.devicepanel.model.StateObject;
import com.swimap.iview.templates.devicepanel.model.component.DevicePanelComponent;
import com.swimap.iview.templates.devicepanel.model.component.EmptyComponent;
import com.swimap.iview.templates.devicepanel.model.component.Frame;
import com.swimap.iview.templates.devicepanel.model.component.Shelf;
import com.swimap.iview.templates.devicepanel.model.component.TemperatureEnvironmentItem;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;

public abstract class DevicePanelItem
extends DevicePanelComponent {
    public static final Composite composite1 = AlphaComposite.getInstance(3, 0.8f);
    public static final Composite composite2 = AlphaComposite.getInstance(3, 1.0f);
    private Rectangle alarmRect = new Rectangle();
    protected ImageIconUtilities imageIconUtilities = null;
    protected ImageIconUtilities composeImageIconUtilities = null;
    protected StateObject stateObject = null;
    protected AlarmObject alarmObject = null;
    protected final int TOP_OR_LEFT = 0;
    protected final int BOTTOM_OR_RIGHT = 1;
    protected double progressValue = -1.0;
    protected Color progressColor = Color.BLUE;
    private static final int ALARM_HEIGHT = 20;
    private ConcurrentHashMap userIconsMap = new ConcurrentHashMap(16);

    public DevicePanelItem(String string, String string2, Rectangle rectangle) {
        super(string, string2, rectangle);
    }

    public DevicePanelItem(ComponentData componentData, Rectangle rectangle) {
        super(componentData, rectangle);
    }

    public void setImageIconUtilities(ImageIconUtilities imageIconUtilities) {
        this.imageIconUtilities = imageIconUtilities;
    }

    public ImageIconUtilities getImageIconUtilities() {
        return this.imageIconUtilities;
    }

    public void setComposeImageIconUtilities(ImageIconUtilities imageIconUtilities) {
        this.composeImageIconUtilities = imageIconUtilities;
    }

    public ImageIconUtilities getComposeImageIconUtilities() {
        return this.composeImageIconUtilities;
    }

    public StateObject getStateObject() {
        return this.stateObject;
    }

    public void setStateObject(StateObject stateObject) {
        this.stateObject = stateObject;
    }

    public void setProgressValue(double d) {
        if (this.isFacility) {
            if (d > 1.0) {
                d = 1.0;
            }
            this.progressValue = d;
        }
    }

    public void setProgressBarColor(Color color) {
        if (color != null) {
            this.progressColor = color;
        }
    }

    public AlarmObject getAlarmObject() {
        return this.alarmObject;
    }

    public void setAlarmObject(AlarmObject alarmObject) {
        this.alarmObject = alarmObject;
    }

    @Override
    public void adjustToAbsaluteCordination(int n, int n2) {
        super.adjustToAbsaluteCordination(n, n2);
        int n3 = this.relatedTreeNode.getChildCount();
        for (int i = 0; i < n3; ++i) {
            EmptyComponent emptyComponent;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.relatedTreeNode.getChildAt(i);
            if (!(defaultMutableTreeNode.getUserObject() instanceof EmptyComponent) || (emptyComponent = (EmptyComponent)defaultMutableTreeNode.getUserObject()).getPopupMenuReferrenceName() != null && !"".equals(emptyComponent.getPopupMenuReferrenceName())) continue;
            emptyComponent.setVisibleAllowed(false);
        }
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        if (this.imageIconUtilities != null) {
            this.drawWithImage(graphics2D, this.isIsSelected());
        } else {
            this.drawWithoutImage(graphics2D, this.isIsSelected());
        }
        graphics2D.setPaint(Color.white);
        graphics2D.drawLine(this.bound.x, this.bound.y + this.bound.height - 1, this.bound.x, this.bound.y);
        graphics2D.drawLine(this.bound.x, this.bound.y, this.bound.x + this.bound.width - 1, this.bound.y);
        graphics2D.setPaint(Color.black);
        graphics2D.drawLine(this.bound.x + this.bound.width - 1, this.bound.y, this.bound.x + this.bound.width - 1, this.bound.y + this.bound.height - 1);
        graphics2D.drawLine(this.bound.x + this.bound.width - 1, this.bound.y + this.bound.height - 1, this.bound.x, this.bound.y + this.bound.height - 1);
        int n = this.relatedTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.relatedTreeNode.getChildAt(i);
            DevicePanelComponent devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
            devicePanelComponent.setBehindEnabled(this.getBehindEnabled());
            devicePanelComponent.setIsFacility(this.isIsFacility());
            devicePanelComponent.setVisibility(true);
            devicePanelComponent.draw(graphics2D);
        }
    }

    public void drawWithImage(Graphics2D graphics2D, boolean bl) {
        ImageIcon imageIcon = null;
        int n = this.bound.x;
        int n2 = this.bound.y;
        if (bl) {
            ++n;
            ++n2;
            imageIcon = this.stateObject == null ? this.imageIconUtilities.getSelectedImageIcon() : this.imageIconUtilities.getSelectedImageIconWithState(this.stateObject);
        } else {
            imageIcon = this.stateObject == null ? this.imageIconUtilities.getNormalImageIcon() : this.imageIconUtilities.getNormalImageIconWithState(this.stateObject);
        }
        imageIcon.paintIcon(null, graphics2D, n, n2);
        this.drawProgress(graphics2D, bl);
        graphics2D.setComposite(composite1);
        this.drawAlarm(graphics2D, bl);
        this.drawUserIcons(graphics2D);
        graphics2D.setComposite(composite2);
        this.setIsSelected(false);
    }

    public void drawWithoutImage(Graphics2D graphics2D, boolean bl) {
        graphics2D.setPaint(this.getBackground());
        graphics2D.fillRect(this.bound.x, this.bound.y, this.bound.width, this.bound.height);
        if (this.isIsSelected()) {
            graphics2D.setPaint(Color.white);
            graphics2D.drawLine(this.bound.x, this.bound.y + this.bound.height - 1, this.bound.x, this.bound.y);
            graphics2D.drawLine(this.bound.x, this.bound.y, this.bound.x + this.bound.width - 1, this.bound.y);
            graphics2D.setPaint(Color.black);
            graphics2D.drawLine(this.bound.x + this.bound.width - 1, this.bound.y, this.bound.x + this.bound.width - 1, this.bound.y + this.bound.height - 1);
            graphics2D.drawLine(this.bound.x + this.bound.width - 1, this.bound.y + this.bound.height - 1, this.bound.x, this.bound.y + this.bound.height - 1);
        }
        this.drawState(graphics2D, bl);
        this.drawProgress(graphics2D, bl);
        graphics2D.setComposite(composite1);
        this.drawAlarm(graphics2D, bl);
        this.drawUserIcons(graphics2D);
        graphics2D.setComposite(composite2);
        this.setIsSelected(false);
    }

    public int getAlarmPosition() {
        return 0;
    }

    public void drawAlarm(Graphics2D graphics2D, boolean bl) {
        if (this.alarmObject != null) {
            int n = this.getComponentDirection();
            ImageIcon imageIcon = this.alarmObject.getImageIcon();
            if (null == imageIcon) {
                return;
            }
            Color color = this.alarmObject.getColor();
            if (null != color) {
                ImageIcon imageIcon2 = this.alarmObject.getCustormIcon(color);
                if (imageIcon2 == null) {
                    imageIcon2 = DevicePanelUtil.getAlarmIconWithColar(imageIcon, color);
                    this.alarmObject.setCustormIcon(color, imageIcon2);
                }
                imageIcon = imageIcon2;
            }
            if (this.bound.width < this.bound.height) {
                this.drawVerticalAlarmImage(graphics2D, imageIcon, bl, n);
            } else {
                this.drawHorizontalAlarmImage(graphics2D, imageIcon, bl, n);
            }
        }
    }

    private void drawVerticalAlarmImage(Graphics2D graphics2D, ImageIcon imageIcon, boolean bl, int n) {
        int n2 = 0;
        int n3 = 0;
        if (bl) {
            n2 = this.bound.x + (this.bound.width - imageIcon.getIconWidth()) / 2 + 1;
            n3 = this.getAlarmPosition() == 0 ? (n == 2 ? this.bound.y + this.bound.height - imageIcon.getIconHeight() - 5 - 1 : this.bound.y + 5 + 1) : (n == 2 ? this.bound.y + 20 + 1 : this.bound.y + this.bound.height - 20 - 1);
            imageIcon.paintIcon(null, graphics2D, n2, n3);
        } else {
            n2 = this.bound.x + (this.bound.width - imageIcon.getIconWidth()) / 2;
            n3 = this.getAlarmPosition() == 0 ? (n == 2 ? this.bound.y + this.bound.height - imageIcon.getIconHeight() - 5 : this.bound.y + 5) : (n == 2 ? this.bound.y + 20 : this.bound.y + this.bound.height - 20);
            if (this.isIsFacility()) {
                n3 = n == 2 ? this.bound.y + this.bound.height - imageIcon.getIconHeight() - 2 : this.bound.y + 2;
            }
            imageIcon.paintIcon(null, graphics2D, n2, n3);
        }
    }

    private void drawHorizontalAlarmImage(Graphics2D graphics2D, ImageIcon imageIcon, boolean bl, int n) {
        int n2 = 0;
        int n3 = 0;
        if (bl) {
            n2 = this.getAlarmPosition() == 0 ? (n == 4 ? this.bound.x + this.bound.width - imageIcon.getIconWidth() - 5 - 1 : this.bound.x + 5 + 1) : (n == 4 ? this.bound.x + 20 + 1 : this.bound.x + this.bound.width - 20 - 1);
            n3 = this.bound.y + (this.bound.height - imageIcon.getIconHeight()) / 2 + 1;
            imageIcon.paintIcon(null, graphics2D, n2, n3);
        } else {
            n2 = this.getAlarmPosition() == 0 ? (n == 4 ? this.bound.x + this.bound.width - imageIcon.getIconWidth() - 5 : this.bound.x + 5) : (n == 4 ? this.bound.x + 20 : this.bound.x + this.bound.width - 20);
            n3 = this.bound.y + (this.bound.height - imageIcon.getIconHeight()) / 2;
            imageIcon.paintIcon(null, graphics2D, n2, n3);
        }
    }

    public void drawState(Graphics2D graphics2D, boolean bl) {
        if (this.stateObject != null) {
            graphics2D.setPaint(this.stateObject.getColor());
            if (this.bound.width < this.bound.height) {
                if (bl) {
                    this.alarmRect.setLocation(this.bound.x + 1, this.bound.y + 1);
                    this.alarmRect.setSize(this.bound.width - 3, this.bound.height - 2);
                } else {
                    this.alarmRect.setLocation(this.bound.x, this.bound.y);
                    this.alarmRect.setSize(this.bound.width, this.bound.height);
                }
                graphics2D.fill3DRect(this.alarmRect.x, this.alarmRect.y, this.alarmRect.width, this.alarmRect.height, true);
            } else {
                if (bl) {
                    this.alarmRect.setLocation(this.bound.x + 1, this.bound.y + 1);
                    this.alarmRect.setSize(this.bound.width - 2, this.bound.height - 3);
                } else {
                    this.alarmRect.setLocation(this.bound.x, this.bound.y);
                    this.alarmRect.setSize(this.bound.width, this.bound.height);
                }
                graphics2D.fill3DRect(this.alarmRect.x, this.alarmRect.y, this.alarmRect.width, this.alarmRect.height, true);
            }
        }
    }

    public void drawStateWithImage(Graphics2D graphics2D, boolean bl) {
        this.drawState(graphics2D, bl);
    }

    @Override
    public void selectedShapedDraw(Graphics2D graphics2D) {
        int n;
        if (this.imageIconUtilities != null && !this.isIsFacility()) {
            this.drawWithImage(graphics2D, this.isIsSelected());
        } else {
            this.drawWithoutImage(graphics2D, this.isIsSelected());
        }
        int n2 = this.bound.x;
        int n3 = this.bound.y;
        int n4 = this.bound.height;
        int n5 = this.bound.width;
        Color color = graphics2D.getColor();
        for (n = 0; n < 4; ++n) {
            if (n == 0 || n == 3) {
                graphics2D.setColor(Color.white);
            } else {
                graphics2D.setPaint(SELECTED_COLOR);
            }
            graphics2D.drawRect(n2 + n, n3 + n, n5 - 2 * n, n4 - 2 * n);
        }
        graphics2D.setColor(color);
        if (!this.isIsFacility()) {
            n = this.relatedTreeNode.getChildCount();
            for (int i = 0; i < n; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.relatedTreeNode.getChildAt(i);
                DevicePanelComponent devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
                devicePanelComponent.draw(graphics2D);
            }
        }
    }

    public void drawProgress(Graphics2D graphics2D, boolean bl) {
        if (this.progressValue < 0.0 || !this.isIsFacility()) {
            return;
        }
        int n = 20;
        int n2 = 20;
        if (this.alarmObject != null && this.alarmObject.getImageIcon() != null) {
            n = this.alarmObject.getImageIcon().getIconWidth();
            n2 = this.alarmObject.getImageIcon().getIconHeight();
            if (n < 20) {
                n = 20;
            }
            if (n2 < 20) {
                n2 = 20;
            }
        }
        int n3 = 5;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        if (this.bound.width < this.bound.height) {
            if (bl) {
                n4 = this.bound.x + (int)((double)this.bound.width * 0.2);
                n5 = this.getAlarmPosition() == 0 ? this.bound.y + n2 + 1 : this.bound.y + n3 + 1;
            } else {
                n4 = this.bound.x + (int)((double)this.bound.width * 0.2);
                n5 = this.getAlarmPosition() == 0 ? this.bound.y + n2 : this.bound.y + n3;
            }
            n7 = this.bound.height - n2 - n3;
            n6 = this.bound.width - (int)((double)this.bound.width * 0.2) * 2 - 1;
            n8 = (int)((double)n7 * this.progressValue);
            if (n8 > 0) {
                graphics2D.setPaint(this.progressColor);
                graphics2D.fill3DRect(n4 + 1, n5 + n7 - n8, n6 - 1, n8, true);
            }
        } else {
            if (bl) {
                n4 = this.getAlarmPosition() == 0 ? this.bound.x + n + n3 + 1 : this.bound.x + n3 + 1;
                n5 = this.bound.y + (int)((double)this.bound.height * 0.2) + 1;
            } else {
                n4 = this.getAlarmPosition() == 0 ? this.bound.x + n + n3 : this.bound.x + n3;
                n5 = this.bound.y + (int)((double)this.bound.height * 0.2);
            }
            n6 = this.bound.width - n - n3 * 2;
            n7 = this.bound.height - (int)((double)this.bound.height * 0.4);
            n8 = (int)((double)n6 * this.progressValue);
            if (n8 > 0) {
                graphics2D.setPaint(this.progressColor);
                graphics2D.fill3DRect(n4, n5, n8, n7, false);
            }
        }
        graphics2D.setPaint(Color.BLACK);
        graphics2D.drawLine(n4, n5, n4 + n6, n5);
        graphics2D.drawLine(n4, n5, n4, n5 + n7);
        graphics2D.setPaint(Color.WHITE);
        graphics2D.drawLine(n4 + n6, n5, n4 + n6, n5 + n7);
        graphics2D.drawLine(n4, n5 + n7, n4 + n6, n5 + n7);
    }

    @Override
    public DevicePanelComponent getFirstComponent() {
        DevicePanelComponent devicePanelComponent = null;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getRelatedTreeNode().getParent();
        DevicePanelComponent devicePanelComponent2 = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
        if (!(devicePanelComponent2 instanceof Shelf)) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getFirstChild();
            devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode2.getUserObject();
        } else {
            Shelf shelf = (Shelf)devicePanelComponent2;
            if (!shelf.getBehindEnabled()) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getFirstChild();
                devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode3.getUserObject();
            } else if (shelf.getBehindEnabled()) {
                DefaultMutableTreeNode defaultMutableTreeNode4 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(shelf.frontChildCount);
                devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode4.getUserObject();
            }
        }
        return this.getRelatedVisibleItem(devicePanelComponent);
    }

    @Override
    public DevicePanelComponent getNextComponent() {
        DevicePanelComponent devicePanelComponent = null;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getRelatedTreeNode().getParent();
        int n = defaultMutableTreeNode.getIndex(this.getRelatedTreeNode());
        DevicePanelComponent devicePanelComponent2 = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
        if (!(devicePanelComponent2 instanceof Shelf)) {
            if (!(devicePanelComponent2 instanceof Shelf)) {
                if (n == defaultMutableTreeNode.getChildCount() - 1) {
                    devicePanelComponent = this.getFirstComponent();
                } else {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = this.getRelatedTreeNode().getNextSibling();
                    devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode2.getUserObject();
                    devicePanelComponent = this.getRelatedVisibleItem(devicePanelComponent);
                }
            }
        } else {
            Shelf shelf = (Shelf)devicePanelComponent2;
            if (!shelf.getBehindEnabled() && n == shelf.frontChildCount - 1 || shelf.getBehindEnabled() && n == defaultMutableTreeNode.getChildCount() - 1) {
                devicePanelComponent = this.getFirstComponent();
            } else {
                DefaultMutableTreeNode defaultMutableTreeNode3 = this.getRelatedTreeNode().getNextSibling();
                devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode3.getUserObject();
                devicePanelComponent = this.getRelatedVisibleItem(devicePanelComponent);
            }
        }
        return devicePanelComponent;
    }

    @Override
    public DevicePanelComponent getPreviousComponent() {
        DevicePanelComponent devicePanelComponent = null;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getRelatedTreeNode().getParent();
        int n = defaultMutableTreeNode.getIndex(this.getRelatedTreeNode());
        DevicePanelComponent devicePanelComponent2 = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
        if (!(devicePanelComponent2 instanceof Shelf)) {
            if (n == 0) {
                return this.getLastComponent();
            }
            DefaultMutableTreeNode defaultMutableTreeNode2 = this.getRelatedTreeNode().getPreviousSibling();
            devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode2.getUserObject();
            return this.getRelatedVisibleItem(devicePanelComponent);
        }
        Shelf shelf = (Shelf)devicePanelComponent2;
        if (!shelf.getBehindEnabled() && n == 0 || shelf.getBehindEnabled() && n == shelf.getFrontChildCount()) {
            return this.getLastComponent();
        }
        DefaultMutableTreeNode defaultMutableTreeNode3 = this.getRelatedTreeNode().getPreviousSibling();
        if (defaultMutableTreeNode3 != null) {
            devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode3.getUserObject();
            devicePanelComponent = this.getRelatedVisibleItem(devicePanelComponent);
        }
        return devicePanelComponent;
    }

    @Override
    public DevicePanelComponent getLastComponent() {
        DevicePanelComponent devicePanelComponent = null;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getRelatedTreeNode().getParent();
        DevicePanelComponent devicePanelComponent2 = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
        if (devicePanelComponent2 instanceof Shelf) {
            Shelf shelf = (Shelf)devicePanelComponent2;
            if (!shelf.getBehindEnabled()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(shelf.frontChildCount - 1);
                devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode2.getUserObject();
            } else {
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getLastChild();
                devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode3.getUserObject();
            }
        } else {
            DefaultMutableTreeNode defaultMutableTreeNode4 = (DefaultMutableTreeNode)defaultMutableTreeNode.getLastChild();
            devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode4.getUserObject();
        }
        return this.getRelatedVisibleItem(devicePanelComponent);
    }

    @Override
    public DevicePanelComponent getSelectableParentComponent() {
        DevicePanelComponent devicePanelComponent = this;
        do {
            if (null == (devicePanelComponent = devicePanelComponent.getParentComponent())) {
                return this;
            }
            if ((this.getBehindEnabled() || isOpenEmulational) && devicePanelComponent instanceof Shelf && !devicePanelComponent.isSelectable()) {
                return this;
            }
            if (!(devicePanelComponent instanceof Frame) || devicePanelComponent.isSelectable()) continue;
            return this;
        } while (!devicePanelComponent.isSelectable());
        return devicePanelComponent;
    }

    @Override
    public DevicePanelComponent getNextSelectableComponent() {
        DevicePanelComponent devicePanelComponent = this.getNextComponent();
        while (!((this == devicePanelComponent || devicePanelComponent.isSelectable()) && !(devicePanelComponent instanceof TemperatureEnvironmentItem) || (devicePanelComponent = devicePanelComponent.getNextComponent()) instanceof TemperatureEnvironmentItem && this == devicePanelComponent)) {
        }
        return devicePanelComponent;
    }

    @Override
    public DevicePanelComponent getPreviousSelectableComponent() {
        DevicePanelComponent devicePanelComponent = this.getPreviousComponent();
        while (!((this == devicePanelComponent || devicePanelComponent.isSelectable()) && !(devicePanelComponent instanceof TemperatureEnvironmentItem) || (devicePanelComponent = devicePanelComponent.getPreviousComponent()) instanceof TemperatureEnvironmentItem && this == devicePanelComponent)) {
        }
        return devicePanelComponent;
    }

    private void drawUserIcons(Graphics2D graphics2D) {
        Iterator iterator = this.userIconsMap.entrySet().iterator();
        boolean bl = this.getWidth() < this.getHeight();
        int n = this.getComponentDirection();
        Map.Entry entry = null;
        Icon icon = null;
        Point point = null;
        boolean bl2 = iterator.hasNext();
        while (bl2) {
            entry = iterator.next();
            icon = (Icon)entry.getValue();
            if (null == icon) {
                bl2 = iterator.hasNext();
                continue;
            }
            point = (Point)entry.getKey();
            if (null != point) {
                if (bl) {
                    this.drawVerticalUserIcon(graphics2D, icon, point, n);
                } else {
                    this.drawHorizontalUserIcon(graphics2D, icon, point, n);
                }
            }
            bl2 = iterator.hasNext();
        }
    }

    private void drawVerticalUserIcon(Graphics2D graphics2D, Icon icon, Point point, int n) {
        if (n == 2) {
            icon.paintIcon(null, graphics2D, this.bound.x + this.bound.width - point.x - icon.getIconWidth(), this.bound.y + this.bound.height - point.y - icon.getIconHeight());
        } else {
            icon.paintIcon(null, graphics2D, this.bound.x + point.x, this.bound.y + point.y);
        }
    }

    private void drawHorizontalUserIcon(Graphics2D graphics2D, Icon icon, Point point, int n) {
        if (n == 4) {
            icon.paintIcon(null, graphics2D, this.bound.x + this.bound.width - point.y - icon.getIconWidth(), this.bound.y + point.x);
        } else if (n == 3) {
            icon.paintIcon(null, graphics2D, this.bound.x + point.y, this.bound.y + this.bound.height - point.x - icon.getIconHeight());
        } else {
            icon.paintIcon(null, graphics2D, this.bound.x + point.x, this.bound.y + point.y);
        }
    }

    public void addUserImageIcon(Icon icon, Point point) {
        if (null != point && null != icon) {
            this.userIconsMap.put(point, icon);
        }
    }

    public void removeUserImageIcon(Icon icon) {
        for (Map.Entry entry : this.userIconsMap.entrySet()) {
            Icon icon2 = (Icon)entry.getValue();
            if (!icon2.equals(icon)) continue;
            this.userIconsMap.remove(entry.getKey());
        }
    }

    private DevicePanelComponent getRelatedVisibleItem(DevicePanelComponent devicePanelComponent) {
        if (devicePanelComponent != null && !devicePanelComponent.isVisible()) {
            DevicePanelComponent devicePanelComponent2 = devicePanelComponent.getRelattedEmptyItem();
            if (null == devicePanelComponent2) {
                return devicePanelComponent;
            }
            devicePanelComponent = devicePanelComponent2;
        }
        return devicePanelComponent;
    }

    @Override
    public void updateUtilities(int n) {
        if (null != this.imageIconUtilities) {
            this.imageIconUtilities.removeEntry(n);
        }
        if (null != this.composeImageIconUtilities) {
            this.composeImageIconUtilities.removeEntry(n);
        }
        super.updateUtilities(n);
    }
}

