/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.devicepanel.model.component;

import com.swimap.iview.templates.devicepanel.model.CompareAlarmAndState;
import com.swimap.iview.templates.devicepanel.model.DevicePanelTreeModel;
import com.swimap.iview.templates.devicepanel.model.component.EnvironmentItem;
import com.swimap.iview.templates.devicepanel.model.component.RegularEnvironmentItem;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class ComposeEnvironmentItem
extends EnvironmentItem {
    private static IviewLogger logger = IviewLogger.getLogger(ComposeEnvironmentItem.class, "IVIEW");
    private static final int STATE_X_SCALE = 12;
    private static final int STATE_WIDTH_SCALE = 20;
    private EnvironmentItem frontEnvironmentItem = null;
    private EnvironmentItem backEnvironmentItem = null;
    private EnvironmentItem initFirstEnvironmentItem = null;
    private EnvironmentItem initSecondEnvironmentItem = null;
    private String environmentItemID = null;
    private Color stateColor = this.getBackground();
    private Font font = null;
    private static final int FACILITY_FANOT_SIZE = 11;

    public ComposeEnvironmentItem(String string, String string2, Rectangle rectangle, EnvironmentItem environmentItem, EnvironmentItem environmentItem2) {
        super(string, string2, rectangle);
        this.initFirstEnvironmentItem = environmentItem;
        this.initSecondEnvironmentItem = environmentItem2;
        this.isShowSlot = false;
        if (environmentItem == null && environmentItem2 == null) {
            return;
        }
        if (environmentItem != null && environmentItem2 == null) {
            this.frontEnvironmentItem = environmentItem;
            this.backEnvironmentItem = null;
            this.initComposeEnvironmentItem(environmentItem);
            return;
        }
        if (environmentItem == null && environmentItem2 != null) {
            this.initComposeEnvironmentItem(environmentItem2);
            this.frontEnvironmentItem = environmentItem2;
            return;
        }
        if (environmentItem.getStateObject() != null || environmentItem2.getStateObject() != null) {
            this.progressItemsStateAlarm(environmentItem, environmentItem2);
        } else {
            this.progressItemsAlarm(environmentItem, environmentItem2);
        }
    }

    public void progressItemsStateAlarm(EnvironmentItem environmentItem, EnvironmentItem environmentItem2) {
        CompareAlarmAndState compareAlarmAndState = DevicePanelTreeModel.getCompareAlarmAndState();
        if (environmentItem.getStateObject() == null && environmentItem2.getStateObject() != null) {
            this.frontEnvironmentItem = environmentItem2;
            this.backEnvironmentItem = environmentItem;
            this.initComposeEnvironmentItem(environmentItem2);
        } else if (environmentItem.getStateObject() != null && environmentItem2.getStateObject() == null) {
            this.frontEnvironmentItem = environmentItem;
            this.backEnvironmentItem = environmentItem2;
            this.initComposeEnvironmentItem(environmentItem);
        } else if (environmentItem.getStateObject() != null && environmentItem2.getStateObject() != null) {
            if (compareAlarmAndState == null) {
                this.frontEnvironmentItem = environmentItem;
                this.backEnvironmentItem = environmentItem2;
                this.initComposeEnvironmentItem(environmentItem);
                return;
            }
            int n = compareAlarmAndState.compareState(environmentItem.getStateObject(), environmentItem2.getStateObject());
            if (n > 0) {
                this.frontEnvironmentItem = environmentItem2;
                this.backEnvironmentItem = environmentItem;
                this.initComposeEnvironmentItem(environmentItem2);
            } else if (n < 0) {
                this.frontEnvironmentItem = environmentItem;
                this.backEnvironmentItem = environmentItem2;
                this.initComposeEnvironmentItem(environmentItem);
            } else {
                this.progressItemsAlarm(environmentItem, environmentItem2);
            }
        } else {
            this.progressItemsAlarm(environmentItem, environmentItem2);
        }
    }

    public void progressItemsAlarm(EnvironmentItem environmentItem, EnvironmentItem environmentItem2) {
        CompareAlarmAndState compareAlarmAndState = DevicePanelTreeModel.getCompareAlarmAndState();
        if (environmentItem.getAlarmObject() == null && environmentItem2.getAlarmObject() != null) {
            this.frontEnvironmentItem = environmentItem2;
            this.backEnvironmentItem = environmentItem;
            this.initComposeEnvironmentItem(environmentItem2);
        } else if (environmentItem.getAlarmObject() != null && environmentItem2.getAlarmObject() == null) {
            this.frontEnvironmentItem = environmentItem;
            this.backEnvironmentItem = environmentItem2;
            this.initComposeEnvironmentItem(environmentItem);
        } else if (environmentItem.getAlarmObject() != null && environmentItem2.getAlarmObject() != null) {
            if (compareAlarmAndState == null) {
                this.frontEnvironmentItem = environmentItem;
                this.backEnvironmentItem = environmentItem2;
                this.initComposeEnvironmentItem(environmentItem);
                return;
            }
            if (compareAlarmAndState.compareAlarm(environmentItem.getAlarmObject(), environmentItem2.getAlarmObject()) > 0) {
                this.frontEnvironmentItem = environmentItem2;
                this.backEnvironmentItem = environmentItem;
                this.initComposeEnvironmentItem(environmentItem2);
            } else {
                this.frontEnvironmentItem = environmentItem;
                this.backEnvironmentItem = environmentItem2;
                this.initComposeEnvironmentItem(environmentItem);
            }
        } else {
            this.frontEnvironmentItem = environmentItem;
            this.backEnvironmentItem = environmentItem2;
            this.initComposeEnvironmentItem(environmentItem);
        }
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        int n = this.bound.x;
        int n2 = this.bound.y;
        int n3 = this.bound.width;
        int n4 = this.bound.height;
        int n5 = this.getFontSize();
        this.font = new Font(this.res.getString("Font"), 0, n5);
        if (n5 > n4) {
            n4 = n5;
        }
        Font font = graphics2D.getFont();
        graphics2D.setFont(this.font);
        graphics2D.setPaint(this.getBackground());
        graphics2D.fillRect(n, n2, n3, n4);
        graphics2D.setPaint(Color.white);
        graphics2D.drawLine(this.bound.x, this.bound.y + this.bound.height - 1, this.bound.x, this.bound.y);
        graphics2D.drawLine(this.bound.x, this.bound.y, this.bound.x + this.bound.width - 1, this.bound.y);
        graphics2D.setPaint(Color.black);
        graphics2D.drawLine(this.bound.x + this.bound.width - 1, this.bound.y, this.bound.x + this.bound.width - 1, this.bound.y + this.bound.height - 1);
        graphics2D.drawLine(this.bound.x + this.bound.width - 1, this.bound.y + this.bound.height - 1, this.bound.x, this.bound.y + this.bound.height - 1);
        int n6 = this.bound.x + this.getStateRectX();
        int n7 = this.bound.y + this.getStateRectY();
        int n8 = this.getStateRectWidth();
        int n9 = this.getStateRectHight();
        if (this.stateObject != null) {
            this.stateColor = this.stateObject.getColor();
        }
        graphics2D.setPaint(this.stateColor);
        graphics2D.fillRect(n6, n7, n8, n9);
        graphics2D.setPaint(Color.black);
        graphics2D.drawLine(n6, n7, n6, n7 + n9);
        graphics2D.drawLine(n6, n7, n6 + n8, n7);
        graphics2D.setPaint(Color.white);
        graphics2D.drawLine(n6 + n8, n7 + n9, n6, n7 + n9);
        graphics2D.drawLine(n6 + n8, n7 + n9, n6 + n8, n7);
        graphics2D.setPaint(Color.black);
        graphics2D.drawString(this.type, n6 + n8 + 4, n7 + n9);
        graphics2D.setFont(font);
        this.drawAlarm(graphics2D, false);
    }

    @Override
    public void selectedShapedDraw(Graphics2D graphics2D) {
        int n;
        Font font = graphics2D.getFont();
        graphics2D.setFont(this.font);
        int n2 = this.bound.x;
        int n3 = this.bound.y;
        int n4 = this.bound.width;
        int n5 = this.bound.height;
        if (this.font.getSize() > n5) {
            n5 = this.font.getSize();
        }
        graphics2D.clearRect(n2, n3, n4, n5);
        graphics2D.setPaint(this.getBackground());
        graphics2D.fillRect(n2, n3, n4, n5);
        for (n = 0; n < 4; ++n) {
            if (n == 0 || n == 3) {
                graphics2D.setColor(Color.white);
            } else {
                graphics2D.setPaint(SELECTED_COLOR);
            }
            graphics2D.drawRect(n2 + n, n3 + n, n4 - 2 * n, n5 - 2 * n);
        }
        n = this.bound.x + this.getStateRectX() + 1;
        int n6 = this.bound.y + this.getStateRectY() + 1;
        int n7 = this.getStateRectWidth();
        int n8 = this.getStateRectHight();
        graphics2D.setPaint(this.stateColor);
        graphics2D.fillRect(n, n6, n7, n8);
        graphics2D.setPaint(Color.black);
        graphics2D.drawLine(n, n6, n, n6 + n8);
        graphics2D.drawLine(n, n6, n + n7, n6);
        graphics2D.setPaint(Color.white);
        graphics2D.drawLine(n + n7, n6 + n8, n, n6 + n8);
        graphics2D.drawLine(n + n7, n6 + n8, n + n7, n6);
        graphics2D.setPaint(Color.black);
        graphics2D.drawString(this.getType(), n + n7 + 4, n6 + n8);
        graphics2D.setFont(font);
        this.drawAlarm(graphics2D, true);
    }

    private int getStateRectHight() {
        if (this.frontEnvironmentItem instanceof RegularEnvironmentItem) {
            return ((RegularEnvironmentItem)this.frontEnvironmentItem).getStateRectHight();
        }
        return this.bound.height / 2;
    }

    private int getStateRectWidth() {
        if (this.frontEnvironmentItem instanceof RegularEnvironmentItem) {
            return ((RegularEnvironmentItem)this.frontEnvironmentItem).getStateRectWidth();
        }
        return this.bound.width / 20;
    }

    private int getStateRectY() {
        if (this.frontEnvironmentItem instanceof RegularEnvironmentItem) {
            return ((RegularEnvironmentItem)this.frontEnvironmentItem).getStateRectY();
        }
        return this.bound.height / 4;
    }

    private int getStateRectX() {
        if (this.frontEnvironmentItem instanceof RegularEnvironmentItem) {
            return ((RegularEnvironmentItem)this.frontEnvironmentItem).getStateRectX();
        }
        return (int)(this.bound.getWidth() / 12.0 + 5.0);
    }

    private void initComposeEnvironmentItem(EnvironmentItem environmentItem) {
        if (environmentItem == null) {
            return;
        }
        this.setCurrentItemID(environmentItem.getID());
        int n = this.isIsFacility() ? 11 : 12;
        try {
            n = this.isIsFacility() ? Integer.parseInt(this.res.getString("ComposeEnvironmentItem_Facility_FontSize")) : Integer.parseInt(this.res.getString("ComposeEnvironmentItem_Emulational_FontSize"));
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        if (0 < environmentItem.getFontSize()) {
            n = environmentItem.getFontSize();
        }
        this.setFontSize(n);
        if (environmentItem.getStateObject() != null) {
            this.setStateObject(environmentItem.getStateObject());
        }
        if (environmentItem.getAlarmObject() != null) {
            this.setAlarmObject(environmentItem.getAlarmObject());
        }
        this.type = environmentItem instanceof RegularEnvironmentItem ? ((RegularEnvironmentItem)environmentItem).getDrawName() : (environmentItem.type != null ? environmentItem.type : "ComposeEnvironmentItem");
        if (this.frontEnvironmentItem != null && this.backEnvironmentItem != null) {
            this.setPopupMenuReferrenceName(this.frontEnvironmentItem.getPopupMenuReferrenceName() + '+' + this.backEnvironmentItem.getPopupMenuReferrenceName());
        }
    }

    public EnvironmentItem getFrontEnvironmentItem() {
        return this.frontEnvironmentItem;
    }

    public EnvironmentItem getBackEnvironmentItem() {
        return this.backEnvironmentItem;
    }

    public String getCurrentEnvironmentItemID() {
        return this.environmentItemID;
    }

    public void setCurrentItemID(String string) {
        if (this.frontEnvironmentItem.getID().compareTo(string) == 0 || this.backEnvironmentItem.getID().compareTo(string) == 0) {
            this.environmentItemID = string;
        }
    }

    public void swichCurrentItem(String string) {
        if (this.frontEnvironmentItem.getID().compareTo(string) == 0) {
            this.environmentItemID = string;
            this.setStateObject(this.frontEnvironmentItem.getStateObject());
            this.setAlarmObject(this.frontEnvironmentItem.getAlarmObject());
            this.type = this.frontEnvironmentItem instanceof RegularEnvironmentItem ? ((RegularEnvironmentItem)this.frontEnvironmentItem).getDrawName() : (this.frontEnvironmentItem.type != null ? this.frontEnvironmentItem.type : "ComposeEnvironmentItem");
        }
        if (this.backEnvironmentItem.getID().compareTo(string) == 0) {
            this.environmentItemID = string;
            this.setStateObject(this.backEnvironmentItem.getStateObject());
            this.setAlarmObject(this.backEnvironmentItem.getAlarmObject());
            this.type = this.backEnvironmentItem instanceof RegularEnvironmentItem ? ((RegularEnvironmentItem)this.backEnvironmentItem).getDrawName() : (this.backEnvironmentItem.type != null ? this.backEnvironmentItem.type : "ComposeEnvironmentItem");
        }
    }

    public EnvironmentItem getInitFirstEnvironmentItem() {
        return this.initFirstEnvironmentItem;
    }

    public EnvironmentItem getInitSecondEnvironmentItem() {
        return this.initSecondEnvironmentItem;
    }
}

