/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.devicepanel.model.component;

import com.swimap.iview.templates.devicepanel.datasource.ComponentData;
import com.swimap.iview.templates.devicepanel.model.ChildPositionType;
import com.swimap.iview.templates.devicepanel.model.ModelFactory;
import com.swimap.iview.templates.devicepanel.model.component.DevicePanelComponent;
import com.swimap.iview.templates.devicepanel.model.component.DevicePanelItem;
import com.swimap.iview.templates.devicepanel.model.component.EmptyComponent;
import com.swimap.iview.templates.devicepanel.model.component.Shelf;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.tree.DefaultMutableTreeNode;

public class Card
extends DevicePanelItem {
    private static IviewLogger logger = IviewLogger.getLogger(Card.class, "IVIEW");
    protected boolean occupiedTwoSlots = false;
    protected String labelText = null;
    private boolean isComposeCard = false;
    private boolean isLabelVisible = true;
    private Font oldFont = null;
    private int labelOffset = 10;
    private Font lableFont = new Font("Monospaced", 0, 14);
    protected int lableFontSpace = 0;
    private Color lableFontColor = Color.BLACK;
    private EmptyComponent emptyComponent = null;
    private int labelDirection = -1;
    protected Integer labelX = null;
    protected Integer labelY = null;
    private boolean isDrawLabelOnImageText = false;

    public Card(String string, String string2, Rectangle rectangle) {
        super(string, string2, rectangle);
    }

    public Card(ComponentData componentData, Rectangle rectangle) {
        super(componentData, rectangle);
    }

    @Override
    public int getWidth() {
        int n = super.getWidth();
        if (this.occupiedTwoSlots && n < super.getHeight()) {
            n /= 2;
        }
        return n;
    }

    @Override
    public int getHeight() {
        int n = super.getHeight();
        if (this.occupiedTwoSlots && n < super.getWidth()) {
            n /= 2;
        }
        return n;
    }

    public void setLableFont(Font font) {
        this.lableFont = font;
    }

    public Font getLableFont() {
        return this.lableFont;
    }

    public void setLabelDirection(String string) {
        try {
            if (null != string) {
                this.labelDirection = Integer.parseInt(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            logger.trace("Please set direction either 0 or 1 : " + numberFormatException);
        }
    }

    public void setLabelX(String string) {
        try {
            if (null != string) {
                this.labelX = Integer.parseInt(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            logger.trace("Point X is not valid : ", numberFormatException);
        }
    }

    public void setLabelY(String string) {
        try {
            if (null != string) {
                this.labelY = Integer.parseInt(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            logger.trace("Point Y is not valid : ", numberFormatException);
        }
    }

    public void setLableFontColor(Color color) {
        this.lableFontColor = color;
    }

    public Color getLableFontColor() {
        return this.lableFontColor;
    }

    public void setLableFontSpace(int n) {
        this.lableFontSpace = n;
    }

    @Override
    public int getStartX() {
        int n = super.getStartX();
        if (this.occupiedTwoSlots && super.getWidth() < super.getHeight()) {
            n += this.getWidth();
        }
        return n;
    }

    @Override
    public int getStartY() {
        int n = super.getStartY();
        if (this.occupiedTwoSlots && super.getHeight() < super.getWidth()) {
            n += this.getHeight();
        }
        return n;
    }

    @Override
    public void adjustToAbsaluteCordination(int n, int n2) {
        if (this.occupiedTwoSlots) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.relatedTreeNode.getParent();
            Shelf shelf = (Shelf)defaultMutableTreeNode.getUserObject();
            int n3 = defaultMutableTreeNode.getIndex(this.relatedTreeNode);
            if (n3 >= 1 && n3 <= shelf.getFrontChildCount() - 1 || n3 >= shelf.getFrontChildCount() + 1 && n3 <= defaultMutableTreeNode.getChildCount() - 1) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n3 - 1);
                if (defaultMutableTreeNode2.getUserObject() instanceof EmptyComponent || this.getComposeCard()) {
                    if (this.getComposeCard()) {
                        DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n3 - 2);
                        DevicePanelItem devicePanelItem = (DevicePanelItem)defaultMutableTreeNode3.getUserObject();
                        if (this.getHeight() > this.getWidth()) {
                            this.bound.x = devicePanelItem.getStartX();
                            this.bound.width += devicePanelItem.getWidth();
                        } else {
                            this.bound.y = devicePanelItem.getStartY();
                            this.bound.height += devicePanelItem.getHeight();
                        }
                    } else {
                        EmptyComponent emptyComponent = (EmptyComponent)defaultMutableTreeNode2.getUserObject();
                        emptyComponent.setVisibleAllowed(false);
                        if (this.getHeight() > this.getWidth()) {
                            this.bound.x = emptyComponent.getStartX() - n;
                            this.bound.width += emptyComponent.getWidth();
                        } else {
                            this.bound.y = emptyComponent.getStartY() - n2;
                            this.bound.height += emptyComponent.getHeight();
                        }
                    }
                    if (this.imageIconUtilities != null) {
                        this.imageIconUtilities.update(this.bound.width, this.bound.height);
                    }
                } else {
                    this.occupiedTwoSlots = false;
                }
            }
        }
        super.adjustToAbsaluteCordination(n, n2);
    }

    public void setOccupiedTwoSlots(boolean bl) {
        this.occupiedTwoSlots = bl;
    }

    public boolean getOccupiedTwoSlots() {
        return this.occupiedTwoSlots;
    }

    public boolean getLabelVisible() {
        return this.isLabelVisible;
    }

    public void setLabelVisible(boolean bl) {
        this.isLabelVisible = bl;
    }

    public void setLabel(String string) {
        this.labelText = string;
    }

    public String getLabel() {
        if (this.labelText == null || "".equals(this.labelText)) {
            this.labelText = this.getLabelVisible() ? this.type : "";
        } else if (this.labelText != null && !this.getLabelVisible()) {
            this.labelText = "";
        }
        return this.labelText;
    }

    @Override
    public void drawWithoutImage(Graphics2D graphics2D, boolean bl) {
        this.oldFont = graphics2D.getFont();
        graphics2D.setFont(this.lableFont);
        super.drawWithoutImage(graphics2D, bl);
        if (!bl) {
            this.drawLabel(graphics2D);
        } else {
            this.drawSelectedLabel(graphics2D);
        }
        graphics2D.setFont(this.oldFont);
    }

    protected int getLabelOffset() {
        return this.labelOffset;
    }

    protected void setLabelOffset(int n) {
        logger.trace("DevicePanel.Card: set label offset is = " + n);
        this.labelOffset = n;
    }

    protected void drawLabel(Graphics2D graphics2D) {
        Color color = graphics2D.getColor();
        graphics2D.setPaint(this.lableFontColor);
        if (this.progressValue >= 0.0) {
            graphics2D.setPaint(Color.WHITE);
        }
        if (this.labelDirection != 0 && this.labelDirection != 1) {
            if (this.bound.width < this.bound.height) {
                this.drawVerticalString(graphics2D);
            } else {
                this.drawHorizontalString(graphics2D);
            }
        } else {
            int n = this.getComponentDirection();
            if (this.labelDirection == 0) {
                if (n == 2) {
                    this.drawRotatedVerticalString(graphics2D);
                } else if (n == 1) {
                    this.drawVerticalString(graphics2D);
                } else if (n == 3) {
                    this.drawRotatedAntiVerticalString(graphics2D);
                } else if (n == 4) {
                    this.drawRotatedClockVerticalString(graphics2D);
                }
            } else if (this.labelDirection == 1) {
                if (n == 1) {
                    this.drawHorizontalString(graphics2D);
                } else if (n == 2) {
                    this.drawRotatedHorizontalString(graphics2D);
                } else if (n == 3) {
                    this.drawRotatedAntiHorizontalString(graphics2D);
                } else if (n == 4) {
                    this.drawRotatedClockHorizontalString(graphics2D);
                }
            }
        }
        graphics2D.setColor(color);
    }

    private boolean validateLableChar(char c, String string) {
        if (!Character.isDefined(c)) {
            logger.warn(new StringBuffer("illegal char ").append(c).append(" found in lable ").append(string).toString());
            return false;
        }
        return true;
    }

    public void drawSelectedLabel(Graphics2D graphics2D) {
        Color color = graphics2D.getColor();
        graphics2D.setPaint(this.lableFontColor);
        if (this.progressValue >= 0.0) {
            graphics2D.setPaint(Color.WHITE);
        }
        if (this.labelDirection != 0 && this.labelDirection != 1) {
            if (this.bound.width < this.bound.height) {
                this.drawSelectedVerticalString(graphics2D);
            } else {
                this.drawSelectedHorizontalString(graphics2D);
            }
        } else {
            int n = this.getComponentDirection();
            if (this.labelDirection == 0) {
                if (n == 2) {
                    this.drawRotatedVerticalString(graphics2D);
                } else if (n == 1) {
                    this.drawVerticalString(graphics2D);
                } else if (n == 3) {
                    this.drawRotatedAntiVerticalString(graphics2D);
                } else if (n == 4) {
                    this.drawRotatedClockVerticalString(graphics2D);
                }
            } else if (this.labelDirection == 1) {
                if (n == 1) {
                    this.drawHorizontalString(graphics2D);
                } else if (n == 2) {
                    this.drawRotatedHorizontalString(graphics2D);
                } else if (n == 3) {
                    this.drawRotatedAntiHorizontalString(graphics2D);
                } else if (n == 4) {
                    this.drawRotatedClockHorizontalString(graphics2D);
                }
            }
        }
        graphics2D.setColor(color);
    }

    public void setComposeCard(boolean bl) {
        this.isComposeCard = bl;
    }

    public boolean getComposeCard() {
        return this.isComposeCard;
    }

    @Override
    public int getComponentDirection() {
        ChildPositionType[] childPositionTypeArray;
        int n = this.getIndexInNotCompose();
        DevicePanelComponent devicePanelComponent = this.getParent();
        if (n > -1 && devicePanelComponent instanceof Shelf && null != (childPositionTypeArray = ((Shelf)devicePanelComponent).getChildPosition())) {
            boolean bl;
            ChildPositionType childPositionType = childPositionTypeArray[n];
            String string = childPositionType.getDirection();
            boolean bl2 = bl = this.getWidth() < this.getHeight();
            if ("2".equals(string) && bl) {
                return 2;
            }
            if ("1".equals(string) && !bl) {
                return 3;
            }
            if ("2".equals(string) && !bl) {
                return 4;
            }
        }
        return 1;
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        if (this.isVisible()) {
            super.draw(graphics2D);
        } else {
            this.emptyComponent = this.createEmptyComponent();
            if (null == this.emptyComponent) {
                super.draw(graphics2D);
                return;
            }
            this.emptyComponent.draw(graphics2D);
            int n = this.relatedTreeNode.getChildCount();
            DefaultMutableTreeNode defaultMutableTreeNode = null;
            DevicePanelComponent devicePanelComponent = null;
            for (int i = 0; i < n; ++i) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)this.relatedTreeNode.getChildAt(i);
                devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
                devicePanelComponent.setBehindEnabled(this.getBehindEnabled());
                devicePanelComponent.setIsFacility(this.isIsFacility());
                devicePanelComponent.setVisibility(false);
                devicePanelComponent.draw(graphics2D);
            }
        }
    }

    @Override
    public void selectedShapedDraw(Graphics2D graphics2D) {
        if (this.isVisible()) {
            super.selectedShapedDraw(graphics2D);
        } else {
            this.emptyComponent.selectedShapedDraw(graphics2D);
        }
    }

    private EmptyComponent createEmptyComponent() {
        EmptyComponent emptyComponent = ModelFactory.createEmptyComponent(this.bound);
        if (null == emptyComponent) {
            return null;
        }
        emptyComponent.setRelatedTreeNode(this.getRelatedTreeNode());
        emptyComponent.setBelongingPageIndex(this.getBelongingPageIndex());
        emptyComponent.setCurrentPageIndex(this.getCurrentPageIndex());
        return emptyComponent;
    }

    @Override
    public DevicePanelComponent getRelattedEmptyItem() {
        return this.emptyComponent;
    }

    protected void drawHorizontalString(Graphics2D graphics2D) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getLabel();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        n = this.labelX == null ? (this.alarmObject != null && this.alarmObject.getImageIcon().getIconWidth() > 20 ? this.bound.x + this.alarmObject.getImageIcon().getIconWidth() + this.labelOffset : this.bound.x + this.labelOffset + 20) : this.bound.x + this.labelX;
        n3 = this.labelY == null ? this.bound.y + this.bound.height / 2 + 5 : this.bound.y + this.labelY + graphics2D.getFontMetrics(this.lableFont).getHeight() / 2;
        int n4 = string.length();
        for (int i = 0; i < n4 && (n2 = n + i * (this.lableFont.getSize() + this.lableFontSpace)) + this.lableFont.getSize() < this.bound.x + this.bound.width; ++i) {
            if (!this.validateLableChar(string.charAt(i), string)) continue;
            stringBuffer.setLength(0);
            stringBuffer.append(string.charAt(i));
            graphics2D.drawString(stringBuffer.toString(), n2, n3);
        }
    }

    protected void drawVerticalString(Graphics2D graphics2D) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        String string = this.getLabel();
        n = this.labelY == null ? (this.alarmObject != null && this.alarmObject.getImageIcon().getIconHeight() > 20 ? this.bound.y + this.alarmObject.getImageIcon().getIconHeight() + this.labelOffset : this.bound.y + this.labelOffset + 20) : this.bound.y + this.labelY + graphics2D.getFontMetrics(this.lableFont).getHeight() / 2;
        n2 = this.labelX == null ? this.bound.x + this.bound.width / 2 - 4 : this.bound.x + this.labelX;
        if (string != null) {
            int n3 = 0;
            int n4 = string.length();
            for (int i = 0; i < n4 && (n3 = n + i * (this.lableFont.getSize() + this.lableFontSpace)) < this.bound.y + this.bound.height; ++i) {
                if (!this.validateLableChar(string.charAt(i), string)) continue;
                stringBuffer.setLength(0);
                stringBuffer.append(string.charAt(i));
                graphics2D.drawString(stringBuffer.toString(), n2, n3);
            }
        }
    }

    protected void drawSelectedHorizontalString(Graphics2D graphics2D) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string = this.getLabel();
        n = null == this.labelX ? (this.alarmObject != null && this.alarmObject.getImageIcon().getIconWidth() > 20 ? this.bound.x + this.alarmObject.getImageIcon().getIconWidth() + this.labelOffset + 1 : this.bound.x + this.labelOffset + 20 + 1) : this.bound.x + this.labelX + 3;
        n3 = null == this.labelY ? this.bound.y + this.bound.height / 2 + 6 : this.bound.y + this.labelY + graphics2D.getFontMetrics(this.lableFont).getHeight() / 2 + 3;
        int n4 = string.length();
        for (int i = 0; i < n4 && (n2 = n + i * (this.lableFont.getSize() + this.lableFontSpace)) + this.lableFont.getSize() < this.bound.x + this.bound.width; ++i) {
            if (!this.validateLableChar(string.charAt(i), string)) continue;
            stringBuffer.setLength(0);
            stringBuffer.append(string.charAt(i));
            graphics2D.drawString(stringBuffer.toString(), n2, n3);
        }
    }

    private void drawSelectedVerticalString(Graphics2D graphics2D) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        n = null == this.labelY ? (this.alarmObject != null && this.alarmObject.getImageIcon().getIconHeight() > 20 ? this.bound.y + this.alarmObject.getImageIcon().getIconHeight() + this.labelOffset + 1 : this.bound.y + this.labelOffset + 20 + 1) : this.bound.y + this.labelY + graphics2D.getFontMetrics(this.lableFont).getHeight() / 2 + 3;
        n2 = null == this.labelX ? this.bound.x + this.bound.width / 2 : this.bound.x + this.labelX;
        String string = this.getLabel();
        if (string != null) {
            int n3 = 0;
            int n4 = string.length();
            for (int i = 0; i < n4 && (n3 = n + i * (this.lableFont.getSize() + this.lableFontSpace)) < this.bound.y + this.bound.height; ++i) {
                if (!this.validateLableChar(string.charAt(i), string)) continue;
                stringBuffer.setLength(0);
                stringBuffer.append(string.charAt(i));
                graphics2D.drawString(stringBuffer.toString(), n2, n3);
            }
        }
    }

    public void setDrawLabelOnImageText(String string) {
        this.isDrawLabelOnImageText = Boolean.parseBoolean(string);
    }

    @Override
    public void drawWithImage(Graphics2D graphics2D, boolean bl) {
        super.drawWithImage(graphics2D, bl);
        if (this.isDrawLabelOnImageText) {
            this.oldFont = graphics2D.getFont();
            graphics2D.setFont(this.lableFont);
            this.drawLabel(graphics2D);
            graphics2D.setFont(this.oldFont);
        }
    }

    protected void drawRotatedAntiHorizontalString(Graphics2D graphics2D) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (this.labelY == null) {
            if (this.alarmObject != null && this.alarmObject.getImageIcon().getIconHeight() > 20) {
                n = this.alarmObject.getImageIcon().getIconHeight();
                n2 = this.bound.y + n + this.labelOffset;
                n4 = n;
            } else {
                n2 = this.bound.y + this.labelOffset + 20;
                n4 = 20;
            }
        } else {
            n2 = this.bound.y + this.labelY;
        }
        if (this.labelX == null) {
            n3 = this.bound.x + this.bound.width / 2 - 4;
            n5 = graphics2D.getFontMetrics(this.lableFont).getHeight() / 2 + 4;
        } else {
            n3 = this.bound.x + this.labelX;
        }
        n = n2;
        n2 = this.bound.y + this.bound.height - (n3 - this.bound.x) + n4;
        n3 = this.bound.x + (n - this.bound.y) + graphics2D.getFontMetrics(this.lableFont).getHeight() / 2 + n5;
        this.drawRotatedLabel(graphics2D, n2, n3, true);
    }

    protected void drawRotatedVerticalString(Graphics2D graphics2D) {
        int n = 0;
        int n2 = 0;
        n = this.labelY == null ? (this.alarmObject != null && this.alarmObject.getImageIcon().getIconHeight() > 20 ? this.bound.y + this.alarmObject.getImageIcon().getIconHeight() + this.labelOffset : this.bound.y + this.labelOffset + 20) : this.bound.y + this.labelY + graphics2D.getFontMetrics(this.lableFont).getHeight() / 2;
        n = this.bound.y + this.bound.height - (n - this.bound.y);
        n2 = this.labelX == null ? this.bound.x + this.bound.width / 2 - 4 : this.bound.x + this.labelX;
        n2 = this.bound.x + this.bound.width - (n2 - this.bound.x);
        this.drawRotatedLabel(graphics2D, n, n2, false);
    }

    protected void drawRotatedClockHorizontalString(Graphics2D graphics2D) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (this.labelY == null) {
            if (this.alarmObject != null && this.alarmObject.getImageIcon().getIconHeight() > 20) {
                n = this.bound.y + this.alarmObject.getImageIcon().getIconHeight() + this.labelOffset;
                n3 = this.alarmObject.getImageIcon().getIconHeight();
            } else {
                n = this.bound.y + this.labelOffset + 20;
                n3 = 20;
            }
        } else {
            n = this.bound.y + this.labelY + graphics2D.getFontMetrics(this.lableFont).getHeight() / 2;
        }
        if (this.labelX == null) {
            n2 = this.bound.x + this.bound.width / 2 - 4;
            n4 = graphics2D.getFontMetrics(this.lableFont).getHeight() / 2 + 4;
        } else {
            n2 = this.bound.x + this.labelX;
        }
        int n5 = n;
        n = this.bound.y + (n2 - this.bound.x) - n4;
        n2 = this.bound.x + this.bound.width - (n5 - this.bound.y) - n3;
        String string = this.getLabel();
        if (string != null) {
            int n6 = 0;
            int n7 = string.length();
            for (int i = 0; i < n7 && (n6 = n + i * (this.lableFont.getSize() + this.lableFontSpace)) < this.bound.y + this.bound.height; ++i) {
                if (!this.validateLableChar(string.charAt(i), string)) continue;
                stringBuffer.setLength(0);
                stringBuffer.append(string.charAt(i));
                graphics2D.translate(n2, n6);
                graphics2D.rotate(1.5707963267948966);
                graphics2D.drawString(stringBuffer.toString(), 0, 0);
                graphics2D.rotate(4.71238898038469);
                graphics2D.translate(-n2, -n6);
            }
        }
    }

    protected void drawRotatedAntiVerticalString(Graphics2D graphics2D) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        n = this.labelX == null ? (this.alarmObject != null && this.alarmObject.getImageIcon().getIconWidth() > 20 ? this.bound.x + this.alarmObject.getImageIcon().getIconWidth() + this.labelOffset : this.bound.x + this.labelOffset + 20 - graphics2D.getFontMetrics(this.lableFont).getHeight() / 2) : this.bound.x + this.labelX;
        n3 = this.labelY == null ? this.bound.y + this.bound.height / 2 + 5 : this.bound.y + this.labelY + graphics2D.getFontMetrics(this.lableFont).getHeight() / 2;
        int n4 = n3;
        n3 = this.bound.y + this.bound.height - (n - this.bound.x);
        n = this.bound.x + (n4 - this.bound.y);
        String string = this.getLabel();
        if (null != string) {
            int n5 = string.length();
            for (int i = 0; i < n5 && (n2 = n + i * (this.lableFont.getSize() + this.lableFontSpace)) + this.lableFont.getSize() < this.bound.x + this.bound.width; ++i) {
                if (!this.validateLableChar(string.charAt(i), string)) continue;
                stringBuffer.setLength(0);
                stringBuffer.append(string.charAt(i));
                graphics2D.translate(n2, n3);
                graphics2D.rotate(-1.5707963267948966);
                graphics2D.drawString(stringBuffer.toString(), 0, 0);
                graphics2D.rotate(-4.71238898038469);
                graphics2D.translate(-n2, -n3);
            }
        }
    }

    protected void drawRotatedHorizontalString(Graphics2D graphics2D) {
        int n = 0;
        int n2 = 0;
        n = this.labelX == null ? (this.alarmObject != null && this.alarmObject.getImageIcon().getIconWidth() > 20 ? this.bound.x + this.alarmObject.getImageIcon().getIconWidth() + this.labelOffset : this.bound.x + this.labelOffset + 20) : this.bound.x + this.labelX;
        n = this.bound.x + this.bound.width - (n - this.bound.x);
        n2 = this.labelY == null ? this.bound.y + this.bound.height / 2 + 5 : this.bound.y + this.labelY + graphics2D.getFontMetrics(this.lableFont).getHeight() / 2;
        n2 = this.bound.y + this.bound.height - (n2 - this.bound.y);
        this.drawClockRotatedLabel(graphics2D, n2, n, true);
    }

    protected void drawRotatedClockVerticalString(Graphics2D graphics2D) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (this.labelX == null) {
            if (this.alarmObject != null && this.alarmObject.getImageIcon().getIconWidth() > 20) {
                n = this.bound.x + this.alarmObject.getImageIcon().getIconWidth() + this.labelOffset;
                n3 = this.labelOffset;
            } else {
                n = this.bound.x + this.labelOffset + 20;
                n3 = this.labelOffset;
            }
        } else {
            n = this.bound.x + this.labelX;
        }
        n2 = this.labelY == null ? this.bound.y + this.bound.height / 2 + 5 : this.bound.y + this.labelY + graphics2D.getFontMetrics(this.lableFont).getHeight() / 2;
        int n4 = n2;
        n2 = this.bound.y + (n - this.bound.x) - n3;
        n = this.bound.x + this.bound.width - (n4 - this.bound.y);
        this.drawClockRotatedLabel(graphics2D, n2, n, false);
    }

    private void drawClockRotatedLabel(Graphics2D graphics2D, int n, int n2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getLabel();
        if (null != string) {
            int n3 = string.length();
            int n4 = 0;
            for (int i = 0; i < n3 && (n4 = n2 - i * (this.lableFont.getSize() + this.lableFontSpace)) - this.lableFont.getSize() > this.bound.x; ++i) {
                if (!this.validateLableChar(string.charAt(i), string)) continue;
                stringBuffer.setLength(0);
                stringBuffer.append(string.charAt(i));
                graphics2D.translate(n4, n);
                if (bl) {
                    graphics2D.rotate(Math.PI);
                } else {
                    graphics2D.rotate(1.5707963267948966);
                }
                graphics2D.drawString(stringBuffer.toString(), 0, 0);
                if (bl) {
                    graphics2D.rotate(Math.PI);
                } else {
                    graphics2D.rotate(4.71238898038469);
                }
                graphics2D.translate(-n4, -n);
            }
        }
    }

    private void drawRotatedLabel(Graphics2D graphics2D, int n, int n2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getLabel();
        if (string != null) {
            int n3 = 0;
            int n4 = string.length();
            for (int i = 0; i < n4 && (n3 = n - i * (this.lableFont.getSize() + this.lableFontSpace)) > this.bound.y; ++i) {
                if (!this.validateLableChar(string.charAt(i), string)) continue;
                stringBuffer.setLength(0);
                stringBuffer.append(string.charAt(i));
                graphics2D.translate(n2, n3);
                if (bl) {
                    graphics2D.rotate(-1.5707963267948966);
                } else {
                    graphics2D.rotate(Math.PI);
                }
                graphics2D.drawString(stringBuffer.toString(), 0, 0);
                if (bl) {
                    graphics2D.rotate(-4.71238898038469);
                } else {
                    graphics2D.rotate(Math.PI);
                }
                graphics2D.translate(-n2, -n3);
            }
        }
    }
}

