/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.devicepanel.model;

import com.swimap.iview.templates.devicepanel.DevicePanelConstants;
import com.swimap.iview.templates.devicepanel.datasource.SourceChangeListener;
import com.swimap.iview.templates.devicepanel.model.CardType;
import com.swimap.iview.templates.devicepanel.model.ComponentFactory;
import com.swimap.iview.templates.devicepanel.model.ConfigureUtilities;
import com.swimap.iview.templates.devicepanel.model.DataNotValidException;
import com.swimap.iview.templates.devicepanel.model.DevicePanelTreeModel;
import com.swimap.iview.templates.devicepanel.model.ImageIconUtilities;
import com.swimap.iview.templates.devicepanel.model.ModelFactory;
import com.swimap.iview.templates.devicepanel.model.PopupMenuAuthorization;
import com.swimap.iview.templates.devicepanel.model.component.Card;
import com.swimap.iview.templates.devicepanel.model.component.ComposeEnvironmentItem;
import com.swimap.iview.templates.devicepanel.model.component.DevicePanelComponent;
import com.swimap.iview.templates.devicepanel.model.component.DevicePanelItem;
import com.swimap.iview.templates.devicepanel.model.component.DoubleCard;
import com.swimap.iview.templates.devicepanel.model.component.EmptyComponent;
import com.swimap.iview.templates.devicepanel.model.component.EmptyShelf;
import com.swimap.iview.templates.devicepanel.model.component.EnvironmentItem;
import com.swimap.iview.templates.devicepanel.model.component.Shelf;
import com.swimap.iview.templates.devicepanel.view.DevicePanel;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.tree.DefaultMutableTreeNode;

public class SubFrameData {
    private static IviewLogger logger = IviewLogger.getLogger(SubFrameData.class, "IVIEW");
    private DevicePanel[] panels = null;
    private DevicePanelTreeModel[] models = null;
    private int subFrameNo;
    private String label = null;
    private Rectangle subFrameBound = null;
    private int curEmptyShelfHeight = 0;

    public SubFrameData(DevicePanel[] devicePanelArray, int n) {
        this.panels = devicePanelArray;
        this.getModels();
        this.subFrameNo = n;
    }

    public DevicePanel[] getDevicePanels() {
        return this.panels;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getLabel() {
        return this.label;
    }

    public DevicePanelTreeModel[] getModels() {
        if (this.models == null && this.panels != null) {
            this.models = new DevicePanelTreeModel[this.panels.length];
            for (int i = 0; i < this.panels.length; ++i) {
                if (this.panels[i] == null) continue;
                this.models[i] = this.panels[i].getModel();
            }
        }
        return this.models;
    }

    public boolean isEmptySubFrame() {
        if (this.models == null || this.models.length == 0) {
            return true;
        }
        for (int i = 0; i < this.models.length; ++i) {
            if (this.models[i] == null) continue;
            return false;
        }
        return true;
    }

    public int getPanelsCount() {
        if (this.panels != null) {
            return this.panels.length;
        }
        return 0;
    }

    public Dimension getSubFrameSize() {
        if (this.models == null || this.models.length < 1) {
            return null;
        }
        for (int i = 0; i < this.models.length; ++i) {
            if (this.models[i] == null) continue;
            return this.models[i].getFirstShelfRealSize();
        }
        return null;
    }

    public void setSubFrameBound(Rectangle rectangle) {
        this.subFrameBound = rectangle;
    }

    public void isValid() throws DataNotValidException {
        if (this.isEmptySubFrame()) {
            return;
        }
        if (this.models.length == 2) {
            if (this.models[0] != null && this.models[1] != null) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.models[0].getRoot();
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.models[1].getRoot();
                defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0).getChildAt(0);
                defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(0).getChildAt(0);
                if (defaultMutableTreeNode.getChildCount() != defaultMutableTreeNode2.getChildCount()) {
                    throw new DataNotValidException("the child count is not equal!", 2);
                }
            }
        } else if (this.models.length > 2) {
            throw new DataNotValidException("the devicepanel's count is not correct!", 3);
        }
    }

    public void createSubFrameNode(DefaultMutableTreeNode defaultMutableTreeNode) throws DataNotValidException {
        if (this.isEmptySubFrame()) {
            EmptyComponent emptyComponent = ComponentFactory.createEmptyComponent(EmptyShelf.class, this.subFrameBound);
            emptyComponent.setBackground(((DevicePanelComponent)defaultMutableTreeNode.getUserObject()).getBackground());
            emptyComponent.subFrameNo = this.subFrameNo;
            if (this.subFrameBound.getHeight() == 0.0) {
                emptyComponent.setVisibleAllowed(false);
            } else if (emptyComponent instanceof EmptyShelf) {
                ((EmptyShelf)emptyComponent).setLabel(this.label);
            }
            ModelFactory.createTreeNode(defaultMutableTreeNode, emptyComponent, defaultMutableTreeNode.getChildCount());
            return;
        }
        if (this.models.length == 1) {
            this.createSingleShelfNode(defaultMutableTreeNode, 0);
        } else if (this.models.length == 2) {
            if (this.models[0] != null && this.models[1] != null) {
                this.createComposeShelfNode(defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
            } else if (this.models[0] != null) {
                this.createSingleShelfNode(defaultMutableTreeNode, 0);
            } else {
                this.createSingleShelfNode(defaultMutableTreeNode, 1);
            }
        } else {
            throw new DataNotValidException("the devicepanel's count is not correct!", 3);
        }
    }

    public boolean isHighShelf() {
        if (this.models == null) {
            return false;
        }
        try {
            for (int i = 0; i < this.models.length; ++i) {
                if (this.models[i] == null) continue;
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.models[i].getRoot();
                if ((defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0).getChildAt(0)).getUserObject() instanceof EmptyComponent) {
                    return false;
                }
                Shelf shelf = (Shelf)defaultMutableTreeNode.getUserObject();
                if (shelf.getOccupiedShelfNum() <= 1) continue;
                return true;
            }
        }
        catch (Exception exception) {
            logger.trace("Exception in isHighShelf(), the EXCEPTION is:");
            logger.trace(exception.getMessage(), exception);
        }
        return false;
    }

    public PopupMenuAuthorization getPopupMenuAuthorization(int n) {
        DevicePanel devicePanel = this.panels[n];
        if (devicePanel == null) {
            return null;
        }
        return devicePanel.getPopupMenuAuthorization();
    }

    public ConfigureUtilities getConfigureUtilities(int n) {
        if (this.models == null || this.models.length < 1 || n >= this.models.length) {
            return null;
        }
        DevicePanelTreeModel devicePanelTreeModel = this.models[n];
        if (devicePanelTreeModel == null) {
            return null;
        }
        return devicePanelTreeModel.getConfigureUtilities();
    }

    private void createSingleShelfNode(DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.models[n].getRoot();
        defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(0).getChildAt(0);
        Object object = defaultMutableTreeNode2.getUserObject();
        Dimension dimension = this.models[n].getFirstShelfRealSize();
        if (object instanceof EmptyShelf) {
            ((EmptyShelf)object).setLabel(this.label);
            return;
        }
        ((Shelf)object).calculateChildPosition(dimension.width, dimension.height);
        Shelf shelf = (Shelf)((Shelf)object).clone();
        shelf.setBound(this.subFrameBound);
        shelf.setEnvironmentItemVisible(true);
        shelf.reinit();
        shelf.setLabel(this.label);
        shelf.subFrameNo = this.subFrameNo;
        shelf.devicePanelIndex = n;
        ModelFactory.createTreeNode(defaultMutableTreeNode, shelf, defaultMutableTreeNode.getChildCount());
        DefaultMutableTreeNode defaultMutableTreeNode3 = shelf.getRelatedTreeNode();
        for (int i = 0; i < defaultMutableTreeNode2.getChildCount(); ++i) {
            this.createComponentNode(defaultMutableTreeNode3, (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(i), n);
        }
    }

    private void createComponentNode(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2, int n) {
        DevicePanelItem devicePanelItem = (DevicePanelItem)defaultMutableTreeNode2.getUserObject();
        DevicePanelItem devicePanelItem2 = (DevicePanelItem)devicePanelItem.clone();
        devicePanelItem2.setBound(devicePanelItem2.realBound);
        devicePanelItem2.subFrameNo = this.subFrameNo;
        devicePanelItem2.devicePanelIndex = n;
        ModelFactory.createTreeNode(defaultMutableTreeNode, devicePanelItem2, defaultMutableTreeNode.getChildCount());
        if (devicePanelItem2 instanceof EmptyComponent) {
            return;
        }
        if (devicePanelItem2 instanceof Card) {
            CardType cardType = (CardType)this.getConfigureUtilities(n).getComponentType(devicePanelItem2.getType());
            ImageIconUtilities imageIconUtilities = cardType.getComposeImageIconUtilities(this.getConfigureUtilities(n), devicePanelItem2.getWidth(), devicePanelItem2.getHeight());
            if (imageIconUtilities != null) {
                devicePanelItem2.setImageIconUtilities(imageIconUtilities);
            } else {
                devicePanelItem2.setImageIconUtilities(null);
            }
        } else {
            devicePanelItem2.setImageIconUtilities(null);
        }
    }

    public void createComposeShelfNode(DefaultMutableTreeNode defaultMutableTreeNode, int n) throws DataNotValidException {
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.models[0].getRoot();
        DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)this.models[1].getRoot();
        defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(0).getChildAt(0);
        defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode3.getChildAt(0).getChildAt(0);
        Shelf shelf = (Shelf)defaultMutableTreeNode2.getUserObject();
        Shelf shelf2 = (Shelf)defaultMutableTreeNode3.getUserObject();
        if (defaultMutableTreeNode2.getChildCount() != defaultMutableTreeNode3.getChildCount()) {
            throw new DataNotValidException("the child count is not equal!", 2);
        }
        Dimension dimension = this.models[0].getFirstShelfRealSize();
        shelf.calculateChildPosition(dimension.width, dimension.height);
        shelf2.calculateChildPosition(dimension.width, dimension.height);
        Shelf shelf3 = (Shelf)shelf.clone();
        shelf3.setBound(this.subFrameBound);
        shelf3.setEnvironmentItemVisible(true);
        shelf3.reinit();
        shelf3.setLabel(this.label);
        shelf3.setID(shelf.getID() + '+' + shelf2.getID());
        shelf3.setShelfName(shelf.getShelfName() + '+' + shelf2.getShelfName());
        shelf3.subFrameNo = this.subFrameNo;
        shelf3.devicePanelIndex = 0;
        ModelFactory.createTreeNode(defaultMutableTreeNode, shelf3, n);
        DefaultMutableTreeNode defaultMutableTreeNode4 = shelf3.getRelatedTreeNode();
        int n2 = shelf3.getFrontChildCount();
        for (int i = 0; i < defaultMutableTreeNode2.getChildCount(); ++i) {
            this.createComposeCardNode(defaultMutableTreeNode4, (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(i), (DefaultMutableTreeNode)defaultMutableTreeNode3.getChildAt(i), i < n2);
        }
    }

    private void createComposeCardNode(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2, DefaultMutableTreeNode defaultMutableTreeNode3, boolean bl) {
        Object object = defaultMutableTreeNode2.getUserObject();
        Object object2 = defaultMutableTreeNode3.getUserObject();
        if (object instanceof Card && object2 instanceof Card) {
            Object object3;
            DevicePanelConstants devicePanelConstants;
            Card card = (Card)((Card)object).clone();
            CardType cardType = (CardType)this.getConfigureUtilities(defaultMutableTreeNode2.getChildCount()).getComponentType(card.getType());
            card.subFrameNo = this.subFrameNo;
            card.devicePanelIndex = 0;
            try {
                devicePanelConstants = cardType.getComposeImageIconUtilities(this.models[0].getConfigureUtilities(), card.getWidth(), card.getHeight());
                if (devicePanelConstants != null) {
                    card.setImageIconUtilities((ImageIconUtilities)devicePanelConstants);
                } else {
                    card.setImageIconUtilities(null);
                }
            }
            catch (Exception exception) {
                card.setImageIconUtilities(null);
            }
            devicePanelConstants = (Card)((Card)object2).clone();
            ((Card)devicePanelConstants).subFrameNo = this.subFrameNo;
            ((Card)devicePanelConstants).devicePanelIndex = 1;
            try {
                object3 = cardType.getComposeImageIconUtilities(this.models[1].getConfigureUtilities(), ((Card)devicePanelConstants).getWidth(), ((Card)devicePanelConstants).getHeight());
                if (object3 != null) {
                    ((DevicePanelItem)devicePanelConstants).setImageIconUtilities((ImageIconUtilities)object3);
                } else {
                    ((DevicePanelItem)devicePanelConstants).setImageIconUtilities(null);
                }
            }
            catch (Exception exception) {
                ((DevicePanelItem)devicePanelConstants).setImageIconUtilities(null);
            }
            object3 = card.getID() + '+' + ((DevicePanelComponent)devicePanelConstants).getID();
            String string = "DoubleCard";
            String string2 = card.getPopupMenuReferrenceName() + '+' + ((DevicePanelComponent)devicePanelConstants).getPopupMenuReferrenceName();
            DoubleCard doubleCard = new DoubleCard((String)object3, string, card.realBound, card, (Card)devicePanelConstants);
            doubleCard.setPopupMenuReferrenceName(string2);
            if (doubleCard == null) {
                logger.trace("DoubleCard create file!");
            } else {
                doubleCard.subFrameNo = this.subFrameNo;
                doubleCard.devicePanelIndex = 1;
                ModelFactory.createTreeNode(defaultMutableTreeNode, doubleCard, defaultMutableTreeNode.getChildCount());
            }
        } else if (object instanceof EnvironmentItem && object2 instanceof EnvironmentItem) {
            EnvironmentItem environmentItem = (EnvironmentItem)((EnvironmentItem)object).clone();
            environmentItem.subFrameNo = this.subFrameNo;
            environmentItem.devicePanelIndex = 0;
            EnvironmentItem environmentItem2 = (EnvironmentItem)((EnvironmentItem)object2).clone();
            environmentItem2.subFrameNo = this.subFrameNo;
            environmentItem2.devicePanelIndex = 1;
            String string = environmentItem.getID() + '+' + environmentItem2.getID();
            String string3 = "DoubleCard";
            ComposeEnvironmentItem composeEnvironmentItem = new ComposeEnvironmentItem(string, string3, environmentItem.realBound, environmentItem, environmentItem2);
            composeEnvironmentItem.subFrameNo = this.subFrameNo;
            composeEnvironmentItem.devicePanelIndex = 1;
            ModelFactory.createTreeNode(defaultMutableTreeNode, composeEnvironmentItem, defaultMutableTreeNode.getChildCount());
        } else if (object instanceof Card || object instanceof EnvironmentItem) {
            this.createComponentNode(defaultMutableTreeNode, defaultMutableTreeNode2, 0);
        } else if (object2 instanceof Card || object2 instanceof EnvironmentItem) {
            ((Card)object2).realBound = (Rectangle)((DevicePanelComponent)object).realBound.clone();
            this.createComponentNode(defaultMutableTreeNode, defaultMutableTreeNode3, 1);
        } else {
            DevicePanelItem devicePanelItem = (DevicePanelItem)((DevicePanelItem)object).clone();
            DevicePanelItem devicePanelItem2 = (DevicePanelItem)object2;
            devicePanelItem.setBound(devicePanelItem.realBound);
            devicePanelItem.subFrameNo = this.subFrameNo;
            devicePanelItem.devicePanelIndex = 1;
            devicePanelItem.setComposeFlg(true);
            devicePanelItem.setIndexInNotCompose(((DevicePanelItem)object).getIndexInNotCompose());
            devicePanelItem.setPopupMenuReferrenceName(devicePanelItem.getPopupMenuReferrenceName() + '+' + devicePanelItem2.getPopupMenuReferrenceName());
            ModelFactory.createTreeNode(defaultMutableTreeNode, devicePanelItem, defaultMutableTreeNode.getChildCount());
        }
    }

    public void addDataSourceChangeListner(SourceChangeListener sourceChangeListener) {
        if (this.isEmptySubFrame()) {
            return;
        }
        for (int i = 0; i < this.models.length; ++i) {
            if (this.models[i] == null) continue;
            this.models[i].dataSource.addSourceChangeListener(sourceChangeListener);
        }
    }

    public void removeDataSourceChangeListener(SourceChangeListener sourceChangeListener) {
        if (this.isEmptySubFrame()) {
            return;
        }
        for (int i = 0; i < this.models.length; ++i) {
            if (this.models[i] == null) continue;
            this.models[i].dataSource.removeSourceChangeListener(sourceChangeListener);
        }
    }

    public void setEmptyShelfHeight(int n) {
        this.curEmptyShelfHeight = n;
    }

    public int getEmptyShelfHeight() {
        return this.curEmptyShelfHeight >= 70 ? this.curEmptyShelfHeight : 70;
    }
}

