/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.devicepanel.model;

import com.swimap.iview.templates.devicepanel.datasource.ResponseObject;
import com.swimap.iview.templates.devicepanel.model.component.DevicePanelComponent;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.tree.DefaultMutableTreeNode;

public class PopupMenuResponseObjectPair {
    private static IviewLogger logger = IviewLogger.getLogger(PopupMenuResponseObjectPair.class, "IVIEW");
    public static final String RESPONSE_OBJECT_PROPERTY = "ResponseObject";
    public static final String ID_FLAG = "idFlag";
    private JPopupMenu popupMenu = null;
    private ResponseObject responseObject = null;
    private ActionHandler actionListener = null;

    public PopupMenuResponseObjectPair(JPopupMenu jPopupMenu, ResponseObject responseObject, boolean bl) {
        this.popupMenu = jPopupMenu;
        this.responseObject = responseObject;
        this.actionListener = bl ? new ActionHandlerEx() : new ActionHandler();
    }

    public PopupMenuResponseObjectPair(JPopupMenu jPopupMenu, ResponseObject responseObject) {
        this(jPopupMenu, responseObject, false);
    }

    public JPopupMenu getPopupMenu(DevicePanelComponent devicePanelComponent) {
        this.actionListener.setDevicePanelComponent(devicePanelComponent);
        return this.popupMenu;
    }

    public JPopupMenu getPopupMenu(Component component) {
        if (this.actionListener instanceof ActionHandlerEx) {
            ((ActionHandlerEx)this.actionListener).setActionComponent(component);
            return this.popupMenu;
        }
        return null;
    }

    public JPopupMenu getClonePopupMenu(DevicePanelComponent devicePanelComponent, int n) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.actionListener.setDevicePanelComponent(devicePanelComponent);
        Component[] componentArray = this.popupMenu.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            JMenuItem jMenuItem;
            JMenuItem jMenuItem2;
            if (componentArray[i] instanceof JMenu) {
                jMenuItem2 = (JMenu)componentArray[i];
                jMenuItem = new JMenu(jMenuItem2.getText());
                jMenuItem.setName(jMenuItem2.getName());
                jMenuItem.setMnemonic(jMenuItem2.getMnemonic());
                this.cloneMenu((JMenu)jMenuItem2, (JMenu)jMenuItem);
                jPopupMenu.add(jMenuItem);
                continue;
            }
            if (componentArray[i] instanceof JMenuItem) {
                jMenuItem2 = (JMenuItem)componentArray[i];
                jMenuItem = new JMenuItem(jMenuItem2.getText());
                jMenuItem.setName(jMenuItem2.getName());
                jMenuItem.setMnemonic(jMenuItem2.getMnemonic());
                jMenuItem.setAccelerator(jMenuItem2.getAccelerator());
                jMenuItem.setActionCommand(jMenuItem2.getActionCommand());
                jMenuItem.putClientProperty(RESPONSE_OBJECT_PROPERTY, jMenuItem2.getClientProperty(RESPONSE_OBJECT_PROPERTY));
                jMenuItem.putClientProperty(ID_FLAG, n);
                jMenuItem.addActionListener(this.actionListener);
                jMenuItem.setEnabled(jMenuItem2.isEnabled());
                jPopupMenu.add(jMenuItem);
                continue;
            }
            if (!(componentArray[i] instanceof JPopupMenu.Separator)) continue;
            jPopupMenu.addSeparator();
        }
        return jPopupMenu;
    }

    private void cloneMenu(JMenu jMenu, JMenu jMenu2) {
        for (int i = 0; i < jMenu.getMenuComponentCount(); ++i) {
            JMenuItem jMenuItem;
            JMenuItem jMenuItem2;
            if (jMenu.getMenuComponent(i) instanceof JMenu) {
                jMenuItem2 = (JMenu)jMenu.getMenuComponent(i);
                jMenuItem = new JMenu(jMenuItem2.getText());
                jMenuItem.setName(jMenuItem2.getName());
                jMenuItem.setMnemonic(jMenuItem2.getMnemonic());
                this.cloneMenu((JMenu)jMenuItem2, (JMenu)jMenuItem);
                jMenu2.add(jMenuItem);
                continue;
            }
            if (jMenu.getMenuComponent(i) instanceof JMenuItem) {
                jMenuItem2 = (JMenuItem)jMenu.getMenuComponent(i);
                jMenuItem = new JMenuItem(jMenuItem2.getText());
                jMenuItem.setName(jMenuItem2.getName());
                jMenuItem.setMnemonic(jMenuItem2.getMnemonic());
                jMenuItem.setAccelerator(jMenuItem2.getAccelerator());
                jMenuItem.setActionCommand(jMenuItem2.getActionCommand());
                jMenuItem.putClientProperty(RESPONSE_OBJECT_PROPERTY, jMenuItem2.getClientProperty(RESPONSE_OBJECT_PROPERTY));
                jMenuItem.addActionListener(this.actionListener);
                jMenuItem.setEnabled(jMenuItem2.isEnabled());
                jMenu2.add(jMenuItem);
                continue;
            }
            if (!(jMenu.getMenuComponent(i) instanceof JPopupMenu.Separator)) continue;
            jMenu2.addSeparator();
        }
    }

    public ActionListener getActionListener() {
        return this.actionListener;
    }

    public void endTask() {
        if (this.actionListener != null) {
            this.actionListener.removeFromAll();
            this.actionListener = null;
        }
        this.popupMenu = null;
        this.responseObject = null;
    }

    private final class ActionHandlerEx
    extends ActionHandler {
        private Component actionComponent;
        private Class[] parameterTypes;
        private Object[] parameters;

        ActionHandlerEx() {
            this.actionComponent = null;
            this.parameterTypes = new Class[2];
            this.parameters = new Object[2];
            this.parameterTypes[0] = ActionEvent.class;
            this.parameterTypes[1] = Component.class;
            MenuElement[] menuElementArray = PopupMenuResponseObjectPair.this.popupMenu.getSubElements();
            for (int i = 0; i < menuElementArray.length; ++i) {
                JMenuItem jMenuItem;
                if (menuElementArray[i].getComponent() instanceof JMenu) {
                    jMenuItem = (JMenu)menuElementArray[i].getComponent();
                    this.equipMenu((JMenu)jMenuItem);
                    continue;
                }
                if (!(menuElementArray[i].getComponent() instanceof JMenuItem)) continue;
                jMenuItem = (JMenuItem)menuElementArray[i].getComponent();
                jMenuItem.removeActionListener(this);
                jMenuItem.addActionListener(this);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getActionCommand();
            ResponseObject responseObject = null;
            this.parameters[0] = actionEvent;
            this.parameters[1] = this.actionComponent;
            try {
                responseObject = PopupMenuResponseObjectPair.this.responseObject;
                if (jMenuItem.getClientProperty(PopupMenuResponseObjectPair.RESPONSE_OBJECT_PROPERTY) != null) {
                    responseObject = (ResponseObject)jMenuItem.getClientProperty(PopupMenuResponseObjectPair.RESPONSE_OBJECT_PROPERTY);
                }
                Method method = responseObject.getClass().getMethod(string, this.parameterTypes);
                method.invoke((Object)responseObject, this.parameters);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                StringBuffer stringBuffer = new StringBuffer("The class of '");
                stringBuffer.append(responseObject.getClass().getName());
                stringBuffer.append("' has no method : '");
                stringBuffer.append(string);
                stringBuffer.append("', which contains two parameter types of ActionEvent.class and DevicePanelComponent.class");
                logger.debug(stringBuffer.toString());
            }
            catch (Exception exception) {
                logger.debug(exception.toString());
            }
        }

        void setActionComponent(Component component) {
            this.actionComponent = component;
        }

        @Override
        protected void equipMenu(JMenu jMenu) {
            for (int i = 0; i < jMenu.getMenuComponentCount(); ++i) {
                JMenuItem jMenuItem;
                if (jMenu.getMenuComponent(i) instanceof JMenu) {
                    jMenuItem = (JMenu)jMenu.getMenuComponent(i);
                    this.equipMenu((JMenu)jMenuItem);
                    continue;
                }
                if (!(jMenu.getMenuComponent(i) instanceof JMenuItem)) continue;
                jMenuItem = (JMenuItem)jMenu.getMenuComponent(i);
                jMenuItem.removeActionListener(this);
                jMenuItem.addActionListener(this);
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        private DevicePanelComponent component = null;
        private Class[] parameterTypes = new Class[2];
        private Object[] parameters = new Object[2];

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getActionCommand();
            ResponseObject responseObject = null;
            this.parameters[0] = actionEvent;
            this.parameters[1] = this.component;
            try {
                responseObject = PopupMenuResponseObjectPair.this.responseObject;
                if (jMenuItem.getClientProperty(PopupMenuResponseObjectPair.RESPONSE_OBJECT_PROPERTY) != null) {
                    responseObject = (ResponseObject)jMenuItem.getClientProperty(PopupMenuResponseObjectPair.RESPONSE_OBJECT_PROPERTY);
                }
                if (jMenuItem.getClientProperty(PopupMenuResponseObjectPair.ID_FLAG) != null) {
                    int n = (Integer)jMenuItem.getClientProperty(PopupMenuResponseObjectPair.ID_FLAG);
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.component.getRelatedTreeNode().getParent();
                    DevicePanelComponent devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
                    String string2 = devicePanelComponent.getID();
                    if (string2 != null && string2.indexOf("+") != -1) {
                        if (n == 0) {
                            this.component.setParentID(string2.substring(0, string2.indexOf("+")));
                        } else if (n == 1) {
                            this.component.setParentID(string2.substring(string2.indexOf("+") + 1));
                        }
                    }
                }
                Method method = responseObject.getClass().getMethod(string, this.parameterTypes);
                method.invoke((Object)responseObject, this.parameters);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                StringBuffer stringBuffer = new StringBuffer("The class of '");
                stringBuffer.append(responseObject.getClass().getName());
                stringBuffer.append("' has no method : '");
                stringBuffer.append(string);
                stringBuffer.append("', which contains two parameter types of ActionEvent.class and DevicePanelComponent.class");
                logger.debug(stringBuffer.toString());
            }
            catch (Exception exception) {
                logger.debug(exception.toString());
            }
        }

        ActionHandler() {
            MenuElement[] menuElementArray = PopupMenuResponseObjectPair.this.popupMenu.getSubElements();
            for (int i = 0; i < menuElementArray.length; ++i) {
                JMenuItem jMenuItem;
                if (menuElementArray[i].getComponent() instanceof JMenu) {
                    jMenuItem = (JMenu)menuElementArray[i].getComponent();
                    this.equipMenu((JMenu)jMenuItem);
                    continue;
                }
                if (!(menuElementArray[i].getComponent() instanceof JMenuItem)) continue;
                jMenuItem = (JMenuItem)menuElementArray[i].getComponent();
                jMenuItem.addActionListener(this);
            }
            this.parameterTypes[0] = ActionEvent.class;
            this.parameterTypes[1] = DevicePanelComponent.class;
        }

        void setDevicePanelComponent(DevicePanelComponent devicePanelComponent) {
            this.component = devicePanelComponent;
        }

        void removeFromAll() {
            MenuElement[] menuElementArray = PopupMenuResponseObjectPair.this.popupMenu.getSubElements();
            for (int i = 0; i < menuElementArray.length; ++i) {
                JMenuItem jMenuItem;
                if (menuElementArray[i].getComponent() instanceof JMenu) {
                    jMenuItem = (JMenu)menuElementArray[i].getComponent();
                    this.removeFromMenu((JMenu)jMenuItem);
                    continue;
                }
                if (!(menuElementArray[i].getComponent() instanceof JMenuItem)) continue;
                jMenuItem = (JMenuItem)menuElementArray[i].getComponent();
                jMenuItem.removeActionListener(this);
            }
        }

        protected void equipMenu(JMenu jMenu) {
            int n = jMenu.getMenuComponentCount();
            for (int i = 0; i < n; ++i) {
                JMenuItem jMenuItem;
                if (jMenu.getMenuComponent(i) instanceof JMenu) {
                    jMenuItem = (JMenu)jMenu.getMenuComponent(i);
                    this.equipMenu((JMenu)jMenuItem);
                    continue;
                }
                if (!(jMenu.getMenuComponent(i) instanceof JMenuItem)) continue;
                jMenuItem = (JMenuItem)jMenu.getMenuComponent(i);
                jMenuItem.addActionListener(this);
            }
        }

        protected void removeFromMenu(JMenu jMenu) {
            for (int i = 0; i < jMenu.getMenuComponentCount(); ++i) {
                JMenuItem jMenuItem;
                if (jMenu.getMenuComponent(i) instanceof JMenu) {
                    jMenuItem = (JMenu)jMenu.getMenuComponent(i);
                    this.removeFromMenu((JMenu)jMenuItem);
                    continue;
                }
                if (!(jMenu.getMenuComponent(i) instanceof JMenuItem)) continue;
                jMenuItem = (JMenuItem)jMenu.getMenuComponent(i);
                jMenuItem.removeActionListener(this);
            }
        }
    }
}

