/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.devicepanel.model;

import com.swimap.iview.templates.devicepanel.datasource.ComponentData;
import com.swimap.iview.templates.devicepanel.datasource.DataSource;
import com.swimap.iview.templates.devicepanel.model.BuckledCardType;
import com.swimap.iview.templates.devicepanel.model.CardType;
import com.swimap.iview.templates.devicepanel.model.ChildPositionType;
import com.swimap.iview.templates.devicepanel.model.ComponentFactory;
import com.swimap.iview.templates.devicepanel.model.ComponentType;
import com.swimap.iview.templates.devicepanel.model.ComposeFrameModel;
import com.swimap.iview.templates.devicepanel.model.ConfigureUtilities;
import com.swimap.iview.templates.devicepanel.model.DataNotValidException;
import com.swimap.iview.templates.devicepanel.model.DevicePanelTreeModel;
import com.swimap.iview.templates.devicepanel.model.EnvItemType;
import com.swimap.iview.templates.devicepanel.model.FrameType;
import com.swimap.iview.templates.devicepanel.model.ImageIconUtilities;
import com.swimap.iview.templates.devicepanel.model.PortType;
import com.swimap.iview.templates.devicepanel.model.ShelfType;
import com.swimap.iview.templates.devicepanel.model.SubFrameData;
import com.swimap.iview.templates.devicepanel.model.component.BuckledCard;
import com.swimap.iview.templates.devicepanel.model.component.Card;
import com.swimap.iview.templates.devicepanel.model.component.DevicePanelComponent;
import com.swimap.iview.templates.devicepanel.model.component.EmptyComponent;
import com.swimap.iview.templates.devicepanel.model.component.EnvironmentItem;
import com.swimap.iview.templates.devicepanel.model.component.FansEnvironmentItem;
import com.swimap.iview.templates.devicepanel.model.component.Frame;
import com.swimap.iview.templates.devicepanel.model.component.Port;
import com.swimap.iview.templates.devicepanel.model.component.RegularEnvironmentItem;
import com.swimap.iview.templates.devicepanel.model.component.RegularShelf;
import com.swimap.iview.templates.devicepanel.model.component.Shelf;
import com.swimap.iview.templates.devicepanel.model.xml.Color;
import com.swimap.iview.templates.devicepanel.model.xml.Font;
import com.swimap.iview.templates.devicepanel.model.xml.LabelFont;
import com.swimap.iview.templates.devicepanel.model.xml.LabelPoint;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Rectangle;
import javax.swing.tree.DefaultMutableTreeNode;

public class ModelFactory {
    private static IviewLogger logger = IviewLogger.getLogger(ModelFactory.class, "IVIEW");

    private ModelFactory() {
    }

    public static DevicePanelTreeModel createComposeModel(SubFrameData[] subFrameDataArray, ComponentData componentData, int n) throws DataNotValidException {
        if (subFrameDataArray == null || subFrameDataArray.length == 0) {
            throw new DataNotValidException("subFrame data is null", 1);
        }
        int n2 = 0;
        for (n2 = 0; n2 < subFrameDataArray.length && subFrameDataArray[n2] == null; ++n2) {
        }
        if (n2 == subFrameDataArray.length) {
            throw new DataNotValidException("subFrame data is null", 1);
        }
        RootComponent rootComponent = new RootComponent();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(rootComponent);
        rootComponent.setRelatedTreeNode(defaultMutableTreeNode);
        return new ComposeFrameModel(defaultMutableTreeNode, subFrameDataArray, componentData, n);
    }

    public static DevicePanelTreeModel createDevicePanelTreeModel(DataSource dataSource, ConfigureUtilities configureUtilities) throws DataNotValidException {
        if (dataSource == null) {
            throw new NullPointerException("null pointer...");
        }
        DefaultMutableTreeNode defaultMutableTreeNode = ModelFactory.getRootTreeNode(dataSource, configureUtilities);
        DevicePanelTreeModel devicePanelTreeModel = new DevicePanelTreeModel(defaultMutableTreeNode, dataSource, configureUtilities);
        return devicePanelTreeModel;
    }

    private static DefaultMutableTreeNode getRootTreeNode(DataSource dataSource, ConfigureUtilities configureUtilities) throws DataNotValidException {
        RootComponent rootComponent = new RootComponent();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(rootComponent);
        rootComponent.setRelatedTreeNode(defaultMutableTreeNode);
        ComponentData[] componentDataArray = dataSource.getComponentDatas();
        if (componentDataArray == null) {
            throw new DataNotValidException("The component datas from data source is null");
        }
        for (int i = 0; i < componentDataArray.length; ++i) {
            ModelFactory.establishFrame(defaultMutableTreeNode, componentDataArray[i], configureUtilities);
        }
        return defaultMutableTreeNode;
    }

    private static void establishFrame(DefaultMutableTreeNode defaultMutableTreeNode, ComponentData componentData, ConfigureUtilities configureUtilities) throws DataNotValidException {
        ComponentType componentType;
        if (componentData == null) {
            throw new DataNotValidException("The frame data can not be null");
        }
        ComponentType componentType2 = configureUtilities.getComponentType(componentData.type);
        if (componentType2 == null) {
            StringBuffer stringBuffer = new StringBuffer("Can not find a frame node in XML file with the component data: '").append(componentData.toString()).append("'");
            throw new DataNotValidException(stringBuffer.toString());
        }
        if (!(componentType2 instanceof FrameType)) {
            StringBuffer stringBuffer = new StringBuffer("The component data of '").append(componentData.toString()).append("' can not match a frame type in XML file");
            throw new DataNotValidException(stringBuffer.toString());
        }
        FrameType frameType = (FrameType)componentType2;
        String string = configureUtilities.getCompatabilityType(componentData.type);
        FrameType frameType2 = null;
        if (string != null && null != (componentType = configureUtilities.getComponentType(string)) && componentType instanceof FrameType) {
            frameType2 = (FrameType)componentType;
        }
        boolean bl = frameType2 != null && frameType.getChildPositionTypes().length == 0;
        int n = bl ? frameType2.getFrameHeight() : frameType.getFrameHeight();
        int n2 = bl ? frameType2.getFrameWidth() : frameType.getFrameWidth();
        Rectangle rectangle = new Rectangle(0, 0, n2, n);
        Class clazz = frameType2 != null && frameType.getComponentClassText() == null ? frameType2.getComponentClass() : frameType.getComponentClass();
        Frame frame = (Frame)ComponentFactory.createDevicePanelComponent(clazz, componentData, rectangle);
        frame.setToolTipText(componentData.info);
        frame.setUserObject(componentData.userObject);
        frame.setBackground(configureUtilities.getBackground());
        String string2 = frameType.getPopupMenuRef();
        if (string2.length() == 0 && null != frameType2) {
            string2 = frameType2.getPopupMenuRef();
        }
        frame.setPopupMenuReferrenceName(string2);
        frame.setAreaHeight(frameType.getAreaHeight());
        ModelFactory.createTreeNode(defaultMutableTreeNode, frame, defaultMutableTreeNode.getChildCount());
        ChildPositionType[] childPositionTypeArray = frameType.getChildPositionTypes();
        if (componentData.children == null || componentData.children.length != childPositionTypeArray.length) {
            StringBuffer stringBuffer = new StringBuffer("The frame data of '").append(componentData.toString()).append("' does not accord with the frame node in XML file, ").append("because their children length are not the same");
            throw new DataNotValidException(stringBuffer.toString());
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = frame.getRelatedTreeNode();
        for (int i = 0; i < componentData.children.length; ++i) {
            ModelFactory.establishEnvironmentItemAndShelf(defaultMutableTreeNode2, componentData.children[i], childPositionTypeArray[i], defaultMutableTreeNode2.getChildCount(), configureUtilities);
        }
    }

    static void establishEnvironmentItemAndShelf(DefaultMutableTreeNode defaultMutableTreeNode, ComponentData componentData, ChildPositionType childPositionType, int n, ConfigureUtilities configureUtilities) throws DataNotValidException {
        int n2;
        Object object;
        Object object2;
        Object object3;
        if (componentData == null) {
            ModelFactory.createEmptyComponent(defaultMutableTreeNode, childPositionType, n, configureUtilities);
            return;
        }
        ComponentType componentType = configureUtilities.getComponentType(componentData.type);
        if (componentType == null) {
            StringBuffer stringBuffer = new StringBuffer("Can not find a env-item or shelf node in XML file with the component data of '").append(componentData.toString()).append("'");
            throw new DataNotValidException(stringBuffer.toString());
        }
        if (componentType instanceof EnvItemType) {
            EnvItemType envItemType = (EnvItemType)componentType;
            EnvironmentItem environmentItem = (EnvironmentItem)ComponentFactory.createDevicePanelComponent(envItemType.getComponentClass(), componentData, childPositionType.getBound());
            environmentItem.setToolTipText(componentData.info);
            environmentItem.setUserObject(componentData.userObject);
            environmentItem.setBackground(configureUtilities.getBackground());
            environmentItem.setImageIconUtilities(envItemType.getImageIconUtilities(configureUtilities, environmentItem.getWidth(), environmentItem.getHeight()));
            environmentItem.setPopupMenuReferrenceName(envItemType.getPopupMenuRef());
            environmentItem.setFontSize(envItemType.getFontSize());
            ModelFactory.createTreeNode(defaultMutableTreeNode, environmentItem, n);
            return;
        }
        if (!(componentType instanceof ShelfType)) {
            StringBuffer stringBuffer = new StringBuffer("The component data of '").append(componentData.toString()).append("' can not match a env-item or shelf type in XML file");
            throw new DataNotValidException(stringBuffer.toString());
        }
        ShelfType shelfType = (ShelfType)componentType;
        String string = configureUtilities.getCompatabilityType(componentData.type);
        ComponentType componentType2 = null;
        if (string != null && null != (object3 = configureUtilities.getComponentType(string)) && object3 instanceof ShelfType) {
            componentType2 = (ShelfType)object3;
        }
        object3 = componentType2 != null && shelfType.getComponentClassText() == null ? componentType2.getComponentClass() : shelfType.getComponentClass();
        Shelf shelf = (Shelf)ComponentFactory.createDevicePanelComponent((Class)object3, componentData, childPositionType.getBound());
        shelf.setToolTipText(componentData.info);
        shelf.setUserObject(componentData.userObject);
        if (shelf instanceof RegularShelf) {
            String string2;
            object2 = (RegularShelf)shelf;
            ((RegularShelf)object2).setSlotBeginValue(componentData.getSlotBeginValue());
            String string3 = string2 = componentType2 != null && shelfType.getSlotPosition() == null ? ((ShelfType)componentType2).getSlotPosition() : shelfType.getSlotPosition();
            if (null != string2) {
                ((RegularShelf)object2).setSlotPosition(string2);
            } else {
                ((RegularShelf)object2).setSlotPosition(componentData.getSlotPosition());
            }
            ((DevicePanelComponent)object2).setShowLot(childPositionType.isSlotVisible());
        }
        shelf.setSizeInCompositeFrame(componentData.getSizeInCompositeFrame());
        if (!componentData.getIsAutoSerialNumber()) {
            shelf.setIsAutoNumber(componentData.getIsAutoSerialNumber());
            shelf.setLabel(String.valueOf(componentData.getShelfNumber()));
        }
        shelf.setBackground(configureUtilities.getBackground());
        if (!((DevicePanelComponent)defaultMutableTreeNode.getUserObject()).isIsFacility()) {
            shelf.setShelfLableColor(configureUtilities.getEmulationalShelfLableColor());
            shelf.setShelfLableFont(configureUtilities.getEmulationalShelfLableFont());
            shelf.setSlotLableColor(configureUtilities.getEmulationalSlotLableColor());
            shelf.setSlotLableFont(configureUtilities.getEmulationalSlotLableFont());
        } else {
            shelf.setShelfLableColor(configureUtilities.getShelfLableColor());
            shelf.setShelfLableFont(configureUtilities.getShelfLableFont());
            shelf.setSlotLableColor(configureUtilities.getSlotLableColor());
            shelf.setSlotLableFont(configureUtilities.getSlotLableFont());
        }
        object2 = shelfType.getPopupMenuRef();
        if (((String)object2).length() == 0 && null != componentType2) {
            object2 = componentType2.getPopupMenuRef();
        }
        shelf.setPopupMenuReferrenceName((String)object2);
        shelf.setFrontChildCount(shelfType.getFrontChildCount());
        boolean bl = componentType2 != null && shelfType.getEnvironmentItemVisibleText() == null ? ((ShelfType)componentType2).isEnvironmentItemVisible() : shelfType.isEnvironmentItemVisible();
        shelf.setEnvironmentItemVisible(bl);
        shelf.setShelfName(componentData.getShelfName());
        ModelFactory.createTreeNode(defaultMutableTreeNode, shelf, n);
        ChildPositionType[] childPositionTypeArray = shelfType.getChildPositionTypes();
        if (componentType2 != null) {
            boolean bl2;
            object = componentType2.getChildPositionTypes();
            n2 = ((ChildPositionType[])object).length - ((ShelfType)componentType2).getFrontChildCount();
            int n3 = childPositionTypeArray.length - shelfType.getFrontChildCount();
            boolean bl3 = bl2 = n2 > 0 && n3 == 0 && componentData.children.length - shelfType.getFrontChildCount() == n2;
            if (bl2) {
                childPositionTypeArray = new ChildPositionType[shelfType.getFrontChildCount() + n2];
                System.arraycopy(shelfType.getChildPositionTypes(), 0, childPositionTypeArray, 0, shelfType.getChildPositionTypes().length);
                for (int i = 0; i < n2; ++i) {
                    childPositionTypeArray[i + shelfType.getFrontChildCount()] = object[i + ((ShelfType)componentType2).getFrontChildCount()];
                }
            }
        }
        shelf.setChildPosition(childPositionTypeArray);
        if (componentData.children == null || componentData.children.length != childPositionTypeArray.length) {
            object = new StringBuffer("The shelf data of '").append(componentData.toString()).append("' does not accord with the shelf node in XML file, ").append("because their children length are not the same");
            throw new DataNotValidException(((StringBuffer)object).toString());
        }
        object = shelf.getRelatedTreeNode();
        for (n2 = 0; n2 < componentData.children.length; ++n2) {
            ModelFactory.establishCardAndPort((DefaultMutableTreeNode)object, componentData.children[n2], childPositionTypeArray[n2], ((DefaultMutableTreeNode)object).getChildCount(), configureUtilities);
        }
    }

    static void establishCardAndPort(DefaultMutableTreeNode defaultMutableTreeNode, ComponentData componentData, ChildPositionType childPositionType, int n, ConfigureUtilities configureUtilities) throws DataNotValidException {
        ChildPositionType[] childPositionTypeArray;
        Object object;
        Object object2;
        LabelFont labelFont;
        LabelPoint labelPoint;
        boolean bl;
        Object object3;
        if (componentData == null) {
            ModelFactory.createEmptyComponent(defaultMutableTreeNode, childPositionType, n);
            return;
        }
        ComponentType componentType = configureUtilities.getComponentType(componentData.type);
        if (componentType == null) {
            StringBuffer stringBuffer = new StringBuffer("Can not find a card, port or  EnvironmentItem type node in XML file with the component data of '").append(componentData.toString()).append("'");
            throw new DataNotValidException(stringBuffer.toString());
        }
        if (componentType instanceof EnvItemType) {
            EnvItemType envItemType = (EnvItemType)componentType;
            EnvironmentItem environmentItem = (EnvironmentItem)ComponentFactory.createDevicePanelComponent(envItemType.getComponentClass(), componentData, childPositionType.getBound());
            environmentItem.setToolTipText(componentData.info);
            environmentItem.setUserObject(componentData.userObject);
            if (environmentItem instanceof RegularEnvironmentItem) {
                ((RegularEnvironmentItem)environmentItem).setDrawName(configureUtilities.getLabelText(environmentItem.getType()));
            }
            environmentItem.setBackground(configureUtilities.getBackground());
            environmentItem.setImageIconUtilities(envItemType.getImageIconUtilities(configureUtilities, environmentItem.getWidth(), environmentItem.getHeight()));
            environmentItem.setPopupMenuReferrenceName(envItemType.getPopupMenuRef());
            environmentItem.setFontSize(envItemType.getFontSize());
            ModelFactory.createTreeNode(defaultMutableTreeNode, environmentItem, n);
            if (environmentItem instanceof FansEnvironmentItem) {
                ((FansEnvironmentItem)environmentItem).setSlotBeginValue(componentData.getSlotBeginValue());
                DevicePanelComponent devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
                if (devicePanelComponent instanceof Shelf) {
                    Shelf shelf = (Shelf)devicePanelComponent;
                    environmentItem.setSlotLableColor(shelf.getSlotLableColor());
                    environmentItem.setSlotLableFont(shelf.getSlotLableFont());
                }
            }
            return;
        }
        if (componentType instanceof PortType) {
            Rectangle rectangle = ModelFactory.getReversedBound(childPositionType, defaultMutableTreeNode);
            ModelFactory.createPort(defaultMutableTreeNode, componentData, (PortType)componentType, rectangle, n, configureUtilities, childPositionType);
            return;
        }
        if (!(componentType instanceof CardType)) {
            StringBuffer stringBuffer = new StringBuffer("The component data of '").append(componentData.toString()).append("' can not match a  card or port type in XML file");
            throw new DataNotValidException(stringBuffer.toString());
        }
        CardType cardType = (CardType)componentType;
        String string = configureUtilities.getCompatabilityType(componentData.type);
        ComponentType componentType2 = null;
        if (string != null && null != (object3 = configureUtilities.getComponentType(string)) && object3 instanceof CardType) {
            componentType2 = (CardType)object3;
        }
        object3 = componentType2 != null && cardType.getComponentClassText() == null ? componentType2.getComponentClass() : cardType.getComponentClass();
        Card card = (Card)ComponentFactory.createDevicePanelComponent((Class)object3, componentData, childPositionType.getBound());
        card.setToolTipText(componentData.info);
        card.setUserObject(componentData.userObject);
        card.setBackground(configureUtilities.getBackground());
        int n2 = 1;
        if (card.getHeight() > card.getWidth() && "2".equals(childPositionType.getDirection())) {
            n2 = 2;
        } else if (card.getHeight() < card.getWidth() && "1".equals(childPositionType.getDirection())) {
            n2 = 3;
        } else if (card.getHeight() < card.getWidth() && "2".equals(childPositionType.getDirection())) {
            n2 = 4;
        }
        boolean bl2 = bl = componentType2 != null && cardType.getIconRender() == null;
        if (bl) {
            card.setImageIconUtilities(componentType2.getImageIconUtilities(configureUtilities, card.getWidth(), card.getHeight(), n2));
        } else {
            card.setImageIconUtilities(cardType.getImageIconUtilities(configureUtilities, card.getWidth(), card.getHeight(), n2));
        }
        String string2 = cardType.getPopupMenuRef();
        if (string2.length() == 0 && null != componentType2) {
            string2 = componentType2.getPopupMenuRef();
        }
        card.setPopupMenuReferrenceName(string2);
        card.setShowLot(childPositionType.isSlotVisible());
        card.setSlotLabel(childPositionType.getSlotLabel());
        boolean bl3 = componentType2 != null && cardType.getOccupiedSlotText() == null ? ((CardType)componentType2).isOccupiedTwoSlots() : cardType.isOccupiedTwoSlots();
        card.setOccupiedTwoSlots(bl3);
        String string3 = componentType2 != null && cardType.getDrawLabelOnImageText() == null ? ((CardType)componentType2).getDrawLabelOnImageText() : cardType.getDrawLabelOnImageText();
        card.setDrawLabelOnImageText(string3);
        String string4 = componentType2 != null && cardType.getLabelDirection() == null ? ((CardType)componentType2).getLabelDirection() : cardType.getLabelDirection();
        card.setLabelDirection(string4);
        LabelPoint labelPoint2 = labelPoint = componentType2 != null && cardType.getLabelPoint() == null ? ((CardType)componentType2).getLabelPoint() : cardType.getLabelPoint();
        if (null != labelPoint) {
            card.setLabelX(labelPoint.getXText());
            card.setLabelY(labelPoint.getYText());
        }
        LabelFont labelFont2 = labelFont = componentType2 != null && cardType.getLabelFont() == null ? ((CardType)componentType2).getLabelFont() : cardType.getLabelFont();
        if (null != labelFont) {
            Font font = labelFont.getFont();
            if (null != font) {
                try {
                    object2 = configureUtilities.xmlFont2Font(font);
                    card.setLableFont((java.awt.Font)object2);
                }
                catch (NumberFormatException numberFormatException) {
                    logger.trace("Exception while converting to font.", numberFormatException);
                }
            }
            if (null != (object2 = labelFont.getColor())) {
                try {
                    java.awt.Color color = new java.awt.Color(Integer.parseInt(((Color)object2).getRText()), Integer.parseInt(((Color)object2).getGText()), Integer.parseInt(((Color)object2).getBText()));
                    card.setLableFontColor(color);
                }
                catch (NumberFormatException numberFormatException) {
                    logger.trace("Exception while creating the color.", numberFormatException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    logger.trace("Exception while creating the color.", illegalArgumentException);
                }
            }
        }
        boolean bl4 = componentType2 != null && cardType.getComposeIcon() == null;
        object2 = null;
        object2 = bl4 ? componentType2.getComposeImageIconUtilities(configureUtilities, card.getWidth() - 1, card.getHeight() - 1) : cardType.getComposeImageIconUtilities(configureUtilities, card.getWidth() - 1, card.getHeight() - 1);
        if (object2 != null) {
            card.setComposeImageIconUtilities((ImageIconUtilities)object2);
            card.setLabelVisible(false);
            card.setLabel("");
        } else {
            boolean bl5;
            boolean bl6 = bl5 = componentType2 != null && cardType.getLabelVisibleText() == null ? ((CardType)componentType2).isLabelVisible() : cardType.isLabelVisible();
            if (bl5) {
                object = componentType2 != null && cardType.getLabelText() == null ? componentType2.getLabelText() : cardType.getLabelText();
                card.setLabel((String)object);
                card.setLabelVisible(true);
            } else {
                card.setLabel("");
                card.setLabelVisible(false);
            }
        }
        ModelFactory.createTreeNode(defaultMutableTreeNode, card, n);
        ChildPositionType[] childPositionTypeArray2 = childPositionTypeArray = componentType2 != null && cardType.getChildPositionTypes().length == 0 ? componentType2.getChildPositionTypes() : cardType.getChildPositionTypes();
        if (childPositionTypeArray.length == 0) {
            return;
        }
        if (componentData.children == null || componentData.children.length != childPositionTypeArray.length) {
            object = new StringBuffer("The card data of '").append(componentData.toString()).append("' does not accord with the card node in XML file, ").append("because their children length are not the same");
            throw new DataNotValidException(((StringBuffer)object).toString());
        }
        object = card.getRelatedTreeNode();
        for (int i = 0; i < componentData.children.length; ++i) {
            ModelFactory.establishBuckledCardAndPort((DefaultMutableTreeNode)object, componentData.children[i], childPositionTypeArray[i], ((DefaultMutableTreeNode)object).getChildCount(), configureUtilities);
        }
    }

    static void establishBuckledCardAndPort(DefaultMutableTreeNode defaultMutableTreeNode, ComponentData componentData, ChildPositionType childPositionType, int n, ConfigureUtilities configureUtilities) throws DataNotValidException {
        ChildPositionType[] childPositionTypeArray;
        boolean bl;
        Object object;
        if (componentData == null) {
            ModelFactory.createEmptyComponent(defaultMutableTreeNode, childPositionType, n);
            return;
        }
        ComponentType componentType = configureUtilities.getComponentType(componentData.type);
        if (componentType == null) {
            StringBuffer stringBuffer = new StringBuffer("The component data of '").append(componentData.toString()).append("' can not match a buckled-card or port type in XML file");
            throw new DataNotValidException(stringBuffer.toString());
        }
        if (componentType instanceof PortType) {
            Rectangle rectangle = ModelFactory.getReversedBound(childPositionType, defaultMutableTreeNode);
            ModelFactory.createPort(defaultMutableTreeNode, componentData, (PortType)componentType, rectangle, n, configureUtilities, childPositionType);
            return;
        }
        if (!(componentType instanceof BuckledCardType)) {
            StringBuffer stringBuffer = new StringBuffer("The component data of '").append(componentData.toString()).append("' can not match a buckled-card or port type in XML file");
            throw new DataNotValidException(stringBuffer.toString());
        }
        BuckledCardType buckledCardType = (BuckledCardType)componentType;
        String string = configureUtilities.getCompatabilityType(componentData.type);
        ComponentType componentType2 = null;
        if (string != null && null != (object = configureUtilities.getComponentType(string)) && object instanceof BuckledCardType) {
            componentType2 = (BuckledCardType)object;
        }
        object = ModelFactory.getReversedBound(childPositionType, defaultMutableTreeNode);
        Class clazz = componentType2 != null && buckledCardType.getComponentClassText() == null ? componentType2.getComponentClass() : buckledCardType.getComponentClass();
        BuckledCard buckledCard = (BuckledCard)ComponentFactory.createDevicePanelComponent(clazz, componentData, (Rectangle)object);
        buckledCard.setToolTipText(componentData.info);
        buckledCard.setUserObject(componentData.userObject);
        buckledCard.setBackground(configureUtilities.getBackground());
        boolean bl2 = componentType2 != null && buckledCardType.getOccupiedSlotText() == null ? ((BuckledCardType)componentType2).isOccupiedTwoSlots() : buckledCardType.isOccupiedTwoSlots();
        buckledCard.setOccupiedTwoSlots(bl2);
        buckledCard.setBuckleWidth(buckledCardType.getBuckleWidth());
        buckledCard.setBuckleHeight(buckledCardType.getBuckleHeight());
        buckledCard.setExtendsDirection(buckledCardType.getExtendsDirectionText());
        int n2 = 1;
        if (childPositionType.getBound().width < childPositionType.getBound().height && "2".equals(childPositionType.getDirection())) {
            n2 = 2;
        } else if (childPositionType.getBound().width > childPositionType.getBound().height && "1".equals(childPositionType.getDirection())) {
            n2 = 3;
        } else if (childPositionType.getBound().width > childPositionType.getBound().height && "2".equals(childPositionType.getDirection())) {
            n2 = 4;
        }
        boolean bl3 = bl = componentType2 != null && buckledCardType.getIconFileName() == null;
        if (bl) {
            buckledCard.setImageIconUtilities(componentType2.getImageIconUtilities(configureUtilities, buckledCard.getWidth(), buckledCard.getHeight(), n2));
        } else {
            buckledCard.setImageIconUtilities(buckledCardType.getImageIconUtilities(configureUtilities, buckledCard.getWidth(), buckledCard.getHeight(), n2));
        }
        String string2 = buckledCardType.getPopupMenuRef();
        if (string2.length() == 0 && null != componentType2) {
            string2 = componentType2.getPopupMenuRef();
        }
        buckledCard.setPopupMenuReferrenceName(string2);
        boolean bl4 = componentType2 != null && buckledCardType.getVisibleAllowedText() == null ? ((BuckledCardType)componentType2).isVisibleAllowed() : buckledCardType.isVisibleAllowed();
        buckledCard.setVisibleAllowed(bl4);
        ModelFactory.createTreeNode(defaultMutableTreeNode, buckledCard, n);
        ChildPositionType[] childPositionTypeArray2 = childPositionTypeArray = componentType2 != null && buckledCardType.getChildPositionTypes().length == 0 ? componentType2.getChildPositionTypes() : buckledCardType.getChildPositionTypes();
        if (childPositionTypeArray.length == 0) {
            return;
        }
        if (componentData.children == null || componentData.children.length != childPositionTypeArray.length) {
            StringBuffer stringBuffer = new StringBuffer("The buckled-card data of '").append(componentData.toString()).append("' does not accord with the card node in XML file, ").append("because their children length are not the same");
            throw new DataNotValidException(stringBuffer.toString());
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = buckledCard.getRelatedTreeNode();
        for (int i = 0; i < componentData.children.length; ++i) {
            ModelFactory.establishPort(defaultMutableTreeNode2, componentData.children[i], childPositionTypeArray[i], defaultMutableTreeNode2.getChildCount(), configureUtilities);
        }
    }

    static void establishPort(DefaultMutableTreeNode defaultMutableTreeNode, ComponentData componentData, ChildPositionType childPositionType, int n, ConfigureUtilities configureUtilities) throws DataNotValidException {
        if (componentData == null) {
            ModelFactory.createEmptyComponent(defaultMutableTreeNode, childPositionType, n);
            return;
        }
        ComponentType componentType = configureUtilities.getComponentType(componentData.type);
        if (componentType == null) {
            StringBuffer stringBuffer = new StringBuffer("The component data of '").append(componentData.toString()).append("' can not match a port type in XML file");
            throw new DataNotValidException(stringBuffer.toString());
        }
        if (!(componentType instanceof PortType)) {
            StringBuffer stringBuffer = new StringBuffer("The component data of '").append(componentData.toString()).append("' can not match a port type in XML file");
            throw new DataNotValidException(stringBuffer.toString());
        }
        PortType portType = (PortType)componentType;
        Rectangle rectangle = ModelFactory.getReversedBuckleBound(childPositionType, defaultMutableTreeNode);
        ModelFactory.createPort(defaultMutableTreeNode, componentData, portType, rectangle, n, configureUtilities, childPositionType);
    }

    private static void createPort(DefaultMutableTreeNode defaultMutableTreeNode, ComponentData componentData, PortType portType, Rectangle rectangle, int n, ConfigureUtilities configureUtilities, ChildPositionType childPositionType) {
        boolean bl;
        Object object;
        LabelFont labelFont;
        boolean bl2;
        Object object2;
        String string = configureUtilities.getCompatabilityType(componentData.type);
        ComponentType componentType = null;
        if (string != null && null != (object2 = configureUtilities.getComponentType(string)) && object2 instanceof PortType) {
            componentType = (PortType)object2;
        }
        object2 = componentType != null && portType.getComponentClassText() == null ? componentType.getComponentClass() : portType.getComponentClass();
        Port port = (Port)ComponentFactory.createDevicePanelComponent((Class)object2, componentData, rectangle);
        port.setToolTipText(componentData.info);
        port.setUserObject(componentData.userObject);
        port.setBackground(configureUtilities.getBackground());
        port.setSlotLabel(childPositionType.getSlotLabel());
        port.setSlotLabelPosition(childPositionType.getSlotPosition());
        boolean bl3 = bl2 = componentType != null && portType.getIconFileName() == null;
        if (bl2) {
            port.setImageIconUtilities(componentType.getImageIconUtilities(configureUtilities, port.getWidth(), port.getHeight(), ((DevicePanelComponent)defaultMutableTreeNode.getUserObject()).getComponentDirection()));
        } else {
            port.setImageIconUtilities(portType.getImageIconUtilities(configureUtilities, port.getWidth(), port.getHeight(), ((DevicePanelComponent)defaultMutableTreeNode.getUserObject()).getComponentDirection()));
        }
        LabelFont labelFont2 = labelFont = componentType != null && portType.getPortSlotFont() == null ? ((PortType)componentType).getPortSlotFont() : portType.getPortSlotFont();
        if (null != labelFont) {
            Font font = labelFont.getFont();
            if (null != font) {
                try {
                    object = configureUtilities.xmlFont2Font(font);
                    port.setSlotLabelFont((java.awt.Font)object);
                }
                catch (NumberFormatException numberFormatException) {
                    logger.trace("Exception while converting to font.", numberFormatException);
                }
            }
            if (null != (object = labelFont.getColor())) {
                try {
                    java.awt.Color color = new java.awt.Color(Integer.parseInt(((Color)object).getRText()), Integer.parseInt(((Color)object).getGText()), Integer.parseInt(((Color)object).getBText()));
                    port.setSlotLabelFontColor(color);
                }
                catch (NumberFormatException numberFormatException) {
                    logger.trace("Exception while creating the port color.", numberFormatException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    logger.trace("Exception while creating the color.", illegalArgumentException);
                }
            }
        }
        boolean bl4 = bl = componentType != null && portType.getIconBaseColor() == null;
        if (bl) {
            port.getImageIconUtilities().setRendedColorOffset(((PortType)componentType).getColorOffset());
            port.getImageIconUtilities().setRendedColor(((PortType)componentType).getIconBaseColor());
            port.getImageIconUtilities().setFilteDegree(((PortType)componentType).getFilteDegree());
        } else {
            port.getImageIconUtilities().setRendedColorOffset(portType.getColorOffset());
            port.getImageIconUtilities().setRendedColor(portType.getIconBaseColor());
            port.getImageIconUtilities().setFilteDegree(portType.getFilteDegree());
        }
        object = portType.getPopupMenuRef();
        if (((String)object).length() == 0 && null != componentType) {
            object = componentType.getPopupMenuRef();
        }
        port.setPopupMenuReferrenceName((String)object);
        ModelFactory.createTreeNode(defaultMutableTreeNode, port, n);
    }

    static void createEmptyComponent(DefaultMutableTreeNode defaultMutableTreeNode, ChildPositionType childPositionType, int n) {
        ModelFactory.createEmptyComponent(defaultMutableTreeNode, childPositionType, n, null);
    }

    static void createEmptyComponent(DefaultMutableTreeNode defaultMutableTreeNode, ChildPositionType childPositionType, int n, ConfigureUtilities configureUtilities) {
        Class clazz = null;
        clazz = childPositionType.getEmptyComponentClass();
        Rectangle rectangle = ModelFactory.getReversedBuckleBound(childPositionType, defaultMutableTreeNode);
        EmptyComponent emptyComponent = ComponentFactory.createEmptyComponent(clazz, rectangle);
        if (defaultMutableTreeNode.getUserObject() instanceof Frame && configureUtilities != null) {
            emptyComponent.setBackground(configureUtilities.getBackground());
        }
        emptyComponent.setPopupMenuReferrenceName(childPositionType.getEmptyPopupMenuRef());
        emptyComponent.setShowLot(childPositionType.isSlotVisible());
        emptyComponent.setSlotLabel(childPositionType.getSlotLabel());
        ModelFactory.createTreeNode(defaultMutableTreeNode, emptyComponent, n);
    }

    static void createTreeNode(DefaultMutableTreeNode defaultMutableTreeNode, DevicePanelComponent devicePanelComponent, int n) {
        if (defaultMutableTreeNode.getChildCount() <= n) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(devicePanelComponent);
            devicePanelComponent.setRelatedTreeNode(defaultMutableTreeNode2);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        } else {
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
            defaultMutableTreeNode3.setUserObject(devicePanelComponent);
            devicePanelComponent.setRelatedTreeNode(defaultMutableTreeNode3);
        }
    }

    private static Rectangle getReversedBound(ChildPositionType childPositionType, DefaultMutableTreeNode defaultMutableTreeNode) {
        Card card;
        Rectangle rectangle = childPositionType.getBound();
        if (defaultMutableTreeNode.getUserObject() instanceof Card && (card = (Card)defaultMutableTreeNode.getUserObject()) != null) {
            int n = card.getComponentDirection();
            if (n == 2) {
                rectangle.y = card.getHeight() - rectangle.y - rectangle.height;
                rectangle.x = card.getWidth() - rectangle.x - rectangle.width;
            } else if (n == 3) {
                int n2 = rectangle.y;
                rectangle.y = card.getHeight() - rectangle.x - rectangle.width;
                rectangle.x = n2;
                int n3 = rectangle.width;
                rectangle.width = rectangle.height;
                rectangle.height = n3;
            } else if (n == 4) {
                int n4 = rectangle.x;
                rectangle.x = card.getWidth() - rectangle.y - rectangle.height;
                rectangle.y = n4;
                int n5 = rectangle.width;
                rectangle.width = rectangle.height;
                rectangle.height = n5;
            }
        }
        return rectangle;
    }

    private static Rectangle getReversedBuckleBound(ChildPositionType childPositionType, DefaultMutableTreeNode defaultMutableTreeNode) {
        Rectangle rectangle = childPositionType.getBound();
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof BuckledCard) {
            BuckledCard buckledCard = (BuckledCard)object;
            int n = buckledCard.getComponentDirection();
            if (n == 2) {
                rectangle.y = buckledCard.getHeight() - rectangle.y - rectangle.height;
                rectangle.x = buckledCard.getWidth() - rectangle.x - rectangle.width;
            } else if (n == 3) {
                int n2 = rectangle.y;
                rectangle.y = buckledCard.getHeight() - rectangle.x - rectangle.width;
                rectangle.x = n2;
                int n3 = rectangle.width;
                rectangle.width = rectangle.height;
                rectangle.height = n3;
            } else if (n == 4) {
                int n4 = rectangle.x;
                rectangle.x = buckledCard.getWidth() - rectangle.y - rectangle.height;
                rectangle.y = n4;
                int n5 = rectangle.width;
                rectangle.width = rectangle.height;
                rectangle.height = n5;
            }
        } else if (object instanceof Card) {
            return ModelFactory.getReversedBound(childPositionType, defaultMutableTreeNode);
        }
        return rectangle;
    }

    public static EmptyComponent createEmptyComponent(Rectangle rectangle) {
        return ComponentFactory.createEmptyComponent(EmptyComponent.class, rectangle);
    }

    private static class RootComponent
    extends DevicePanelComponent {
        RootComponent() {
            super(new ComponentData("", "", "", null), new Rectangle(0, 0, 0, 0));
        }
    }
}

