/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.devicepanel.model;

import com.swimap.iview.templates.devicepanel.DevicePanelConstants;
import com.swimap.iview.templates.devicepanel.model.StateObject;
import com.swimap.iview.templates.utils.ColorFilter;
import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;

public class ImageIconUtilities
implements DevicePanelConstants {
    private static final LoadingImageIcon LOADING_IMAGE_ICON = new LoadingImageIcon();
    private static final int TRANSPARENCE = 15;
    private ImageIcon sourceImageIcon = null;
    private ImageIcon normalImageIcon = null;
    private Map normalImageIconWithStateHashMap = Collections.synchronizedMap(new HashMap(20));
    private int direction = 1;
    private int rendererLength = 0;
    private Color rendedColor = null;
    private int rendedColorOffset = 0;
    private int filteDegree = 40;

    public ImageIconUtilities(ImageIcon imageIcon, int n, int n2) {
        this.sourceImageIcon = imageIcon;
        this.update(n, n2);
    }

    public ImageIconUtilities(ImageIcon imageIcon, int n, int n2, int n3, int n4) {
        this(imageIcon, n, n2);
        this.direction = n3;
        this.rendererLength = n4;
    }

    public void update(int n, int n2) {
        this.normalImageIcon = Math.abs(this.sourceImageIcon.getIconWidth() - n) <= 2 && Math.abs(this.sourceImageIcon.getIconHeight() - n2) <= 2 ? this.sourceImageIcon : this.createImageIcon(this.sourceImageIcon, n, n2);
    }

    public ImageIcon getNormalImageIcon() {
        return this.normalImageIcon;
    }

    public ImageIcon getSelectedImageIcon() {
        return this.getNormalImageIcon();
    }

    public ImageIcon getNormalImageIconWithState(StateObject stateObject) {
        if (stateObject == null) {
            return null;
        }
        ImageIcon imageIcon = (ImageIcon)this.normalImageIconWithStateHashMap.get(stateObject);
        if (imageIcon == null) {
            Color color = stateObject.getColor();
            imageIcon = this.createImageIconWithState(this.normalImageIcon, color);
            this.normalImageIconWithStateHashMap.put(stateObject, imageIcon);
        }
        return imageIcon;
    }

    public ImageIcon getSelectedImageIconWithState(StateObject stateObject) {
        return this.getNormalImageIconWithState(stateObject);
    }

    public Color getRendedColor() {
        return this.rendedColor;
    }

    public void setRendedColor(Color color) {
        this.rendedColor = color;
    }

    public void setRendedColorOffset(int n) {
        this.rendedColorOffset = n;
    }

    public void setFilteDegree(int n) {
        this.filteDegree = n;
    }

    private ImageIcon createImageIcon(ImageIcon imageIcon, int n, int n2) {
        Image image = imageIcon.getImage().getScaledInstance(n, n2, 4);
        LOADING_IMAGE_ICON.loadImage(image);
        return new ImageIcon(image);
    }

    private ImageIcon createImageIconWithState(ImageIcon imageIcon, Color color) {
        int n = imageIcon.getIconWidth();
        int n2 = imageIcon.getIconHeight();
        ColorFilter colorFilter = new ColorFilter(true, this.filteDegree, 15.0, color, n, n2, this.direction, this.rendererLength, this.rendedColor, this.rendedColorOffset);
        FilteredImageSource filteredImageSource = new FilteredImageSource(imageIcon.getImage().getSource(), colorFilter);
        Image image = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
        LOADING_IMAGE_ICON.loadImage(image);
        return new ImageIcon(image);
    }

    public void removeEntry(int n) {
        this.normalImageIconWithStateHashMap.remove(new StateObject(n, null, null));
    }

    private static class LoadingImageIcon
    extends ImageIcon {
        private LoadingImageIcon() {
        }

        @Override
        public void loadImage(Image image) {
            super.loadImage(image);
        }
    }
}

