/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.devicepanel.model;

import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.templates.devicepanel.DevicePanelConstants;
import com.swimap.iview.templates.devicepanel.datasource.ComponentData;
import com.swimap.iview.templates.devicepanel.datasource.DataSource;
import com.swimap.iview.templates.devicepanel.datasource.SourceChangeListener;
import com.swimap.iview.templates.devicepanel.model.AlarmObject;
import com.swimap.iview.templates.devicepanel.model.ChildPositionType;
import com.swimap.iview.templates.devicepanel.model.CompareAlarmAndState;
import com.swimap.iview.templates.devicepanel.model.ComponentType;
import com.swimap.iview.templates.devicepanel.model.ConfigureUtilities;
import com.swimap.iview.templates.devicepanel.model.DataNotValidException;
import com.swimap.iview.templates.devicepanel.model.EmulationalListener;
import com.swimap.iview.templates.devicepanel.model.ModelChangeListener;
import com.swimap.iview.templates.devicepanel.model.ModelFactory;
import com.swimap.iview.templates.devicepanel.model.ModelRefreshListener;
import com.swimap.iview.templates.devicepanel.model.StateObject;
import com.swimap.iview.templates.devicepanel.model.component.BuckledCard;
import com.swimap.iview.templates.devicepanel.model.component.Card;
import com.swimap.iview.templates.devicepanel.model.component.ComposeEnvironmentItem;
import com.swimap.iview.templates.devicepanel.model.component.DevicePanelComponent;
import com.swimap.iview.templates.devicepanel.model.component.DevicePanelItem;
import com.swimap.iview.templates.devicepanel.model.component.DoubleCard;
import com.swimap.iview.templates.devicepanel.model.component.EmptyComponent;
import com.swimap.iview.templates.devicepanel.model.component.EmptyShelf;
import com.swimap.iview.templates.devicepanel.model.component.EnvironmentItem;
import com.swimap.iview.templates.devicepanel.model.component.Frame;
import com.swimap.iview.templates.devicepanel.model.component.Shelf;
import com.swimap.iview.templates.devicepanel.model.component.TemperatureEnvironmentItem;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class DevicePanelTreeModel
extends DefaultTreeModel
implements DevicePanelConstants {
    private static IviewLogger logger = IviewLogger.getLogger(DevicePanelTreeModel.class, "IVIEW");
    protected DataSource dataSource = null;
    protected transient SourceChangeListener sourceChangeListener = new SourceChangeHandler();
    protected ConfigureUtilities configureUtilities = null;
    protected static CompareAlarmAndState alarmAndStateCompare;
    private EmulationalListener emulationalListener = null;

    public DevicePanelTreeModel(DefaultMutableTreeNode defaultMutableTreeNode) {
        super(defaultMutableTreeNode);
    }

    public DevicePanelTreeModel(DefaultMutableTreeNode defaultMutableTreeNode, DataSource dataSource, ConfigureUtilities configureUtilities) {
        super(defaultMutableTreeNode);
        this.dataSource = dataSource;
        this.configureUtilities = configureUtilities;
        dataSource.addSourceChangeListener(this.sourceChangeListener);
        boolean bl = false;
        if (configureUtilities.getIsFacility()) {
            bl = true;
        }
        DevicePanelComponent devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
        ComponentData[] componentDataArray = dataSource.getComponentDatas();
        for (int i = 0; i < componentDataArray.length; ++i) {
            devicePanelComponent.setIsFacility(componentDataArray[i].getIsFacility() || bl);
        }
        devicePanelComponent.adjustToAbsaluteCordination(0, 0);
    }

    public static void setCompareAlarmAndState(CompareAlarmAndState compareAlarmAndState) {
        alarmAndStateCompare = compareAlarmAndState;
    }

    public static CompareAlarmAndState getCompareAlarmAndState() {
        return alarmAndStateCompare;
    }

    public Dimension getFirstShelfSize() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getRoot();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0);
        if (defaultMutableTreeNode2 != null) {
            DevicePanelComponent devicePanelComponent = (DevicePanelComponent)((DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(0)).getUserObject();
            return new Dimension(devicePanelComponent.getWidth(), devicePanelComponent.getHeight());
        }
        return null;
    }

    public Dimension getFirstShelfRealSize() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getRoot();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0);
        if (defaultMutableTreeNode2 != null) {
            DevicePanelComponent devicePanelComponent = (DevicePanelComponent)((DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(0)).getUserObject();
            if (devicePanelComponent instanceof Shelf || devicePanelComponent instanceof EmptyShelf) {
                return devicePanelComponent.getSizeInCompositeFrame();
            }
            logger.debug("The first child of frame in compose devicepanel is not shelf retrun null.");
            return null;
        }
        return null;
    }

    public ConfigureUtilities getConfigureUtilities() {
        return this.configureUtilities;
    }

    public void addModelChangeListener(ModelChangeListener modelChangeListener) {
        if (modelChangeListener != null) {
            this.listenerList.add(ModelChangeListener.class, modelChangeListener);
        }
    }

    public void addEmulationalListener(EmulationalListener emulationalListener) {
        if (emulationalListener != null) {
            this.listenerList.add(EmulationalListener.class, emulationalListener);
        }
    }

    public void removeEmulationalListener(EmulationalListener emulationalListener) {
        this.listenerList.remove(EmulationalListener.class, emulationalListener);
    }

    public void removeModelChangeListener(ModelChangeListener modelChangeListener) {
        this.listenerList.remove(ModelChangeListener.class, modelChangeListener);
    }

    public void addModelRefreshListener(ModelRefreshListener modelRefreshListener) {
        if (modelRefreshListener != null) {
            this.listenerList.add(ModelRefreshListener.class, modelRefreshListener);
        }
    }

    public void removeModelRefreshListener(ModelRefreshListener modelRefreshListener) {
        this.listenerList.remove(ModelRefreshListener.class, modelRefreshListener);
    }

    public DefaultMutableTreeNode findTreeNode(String string) {
        if (string == null || "".equals(string)) {
            return null;
        }
        Comparator comparator = new Comparator();
        comparator.setID(string);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getRoot();
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.searchTreeNode(defaultMutableTreeNode, comparator);
        return defaultMutableTreeNode2;
    }

    public void endTask() {
        if (this.dataSource != null) {
            this.dataSource.removeSourceChangeListener(this.sourceChangeListener);
        }
        this.sourceChangeListener = null;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getRoot();
        this.destroyTreeNode(defaultMutableTreeNode);
    }

    protected void fireItemStateChangedEvent(DevicePanelItem[] devicePanelItemArray) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ModelChangeListener.class) continue;
            ((ModelChangeListener)objectArray[i + 1]).stateChanged(devicePanelItemArray);
        }
    }

    private void fireItemProgressChangedEvent(DevicePanelItem[] devicePanelItemArray) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ModelChangeListener.class) continue;
            ((ModelChangeListener)objectArray[i + 1]).progressChanged(devicePanelItemArray);
        }
    }

    protected void fireItemTemperatureChangedEvent(DevicePanelItem[] devicePanelItemArray) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ModelChangeListener.class) continue;
            ((ModelChangeListener)objectArray[i + 1]).temperatureChanged(devicePanelItemArray);
        }
    }

    protected void fireItemAlarmChangedEvent(DevicePanelItem[] devicePanelItemArray) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ModelChangeListener.class) continue;
            ((ModelChangeListener)objectArray[i + 1]).alarmChanged(devicePanelItemArray);
        }
    }

    protected void fireStateColorChanged(int[] nArray) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ModelChangeListener.class) continue;
            ((ModelChangeListener)objectArray[i + 1]).stateColorChanged(nArray);
        }
    }

    protected void fireAlarmColorChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ModelChangeListener.class) continue;
            ((ModelChangeListener)objectArray[i + 1]).alarmColorChanged();
        }
    }

    protected void fireModelChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ModelChangeListener.class) continue;
            ((ModelChangeListener)objectArray[i + 1]).modelChanged();
        }
    }

    protected void fireModelRefreshEvent() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ModelRefreshListener.class) continue;
            ((ModelRefreshListener)objectArray[i + 1]).modelRefresh(this);
        }
    }

    public EmulationalListener getEmulationalListener() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != EmulationalListener.class) continue;
            this.emulationalListener = (EmulationalListener)objectArray[i + 1];
        }
        return this.emulationalListener;
    }

    protected void fireComponentAddedEvent(DevicePanelComponent devicePanelComponent, EmptyComponent emptyComponent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ModelChangeListener.class) continue;
            ((ModelChangeListener)objectArray[i + 1]).componentAdded(devicePanelComponent, emptyComponent);
        }
    }

    protected void fireComponentRemovedEvent(DevicePanelComponent devicePanelComponent, EmptyComponent emptyComponent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ModelChangeListener.class) continue;
            ((ModelChangeListener)objectArray[i + 1]).componentRemoved(devicePanelComponent, emptyComponent);
        }
    }

    protected void fireComponentVisiblityEvent(DevicePanelComponent devicePanelComponent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ModelChangeListener.class) continue;
            ((ModelChangeListener)objectArray[i + 1]).componentVisibiltyChanged(devicePanelComponent);
        }
    }

    protected void destroyTreeNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode == null) {
            return;
        }
        ((DevicePanelComponent)defaultMutableTreeNode.getUserObject()).setRelatedTreeNode(null);
        defaultMutableTreeNode.setUserObject(null);
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            this.destroyTreeNode((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i));
        }
        defaultMutableTreeNode.removeAllChildren();
    }

    private DefaultMutableTreeNode searchTreeNode(DefaultMutableTreeNode defaultMutableTreeNode, Comparable comparable) {
        if (defaultMutableTreeNode == null || comparable == null) {
            return null;
        }
        if (comparable.compareTo(defaultMutableTreeNode.getUserObject()) == 0) {
            return defaultMutableTreeNode;
        }
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                DefaultMutableTreeNode defaultMutableTreeNode3 = this.searchTreeNode(defaultMutableTreeNode2, comparable);
                if (defaultMutableTreeNode3 == null) continue;
                return defaultMutableTreeNode3;
            }
            return null;
        }
        return null;
    }

    private synchronized void processProgressChange(String[] stringArray, double[] dArray, Color color) {
        if (stringArray.length != dArray.length) {
            logger.debug("itemIDs.length != progressValue.length, itemIDs.len = " + stringArray.length + " values.len = " + dArray.length);
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        Card card = null;
        LinkedList<Card> linkedList = new LinkedList<Card>();
        for (int i = 0; i < stringArray.length; ++i) {
            defaultMutableTreeNode = this.findTreeNode(stringArray[i]);
            if (defaultMutableTreeNode != null && defaultMutableTreeNode.getUserObject() instanceof Card) {
                card = (Card)defaultMutableTreeNode.getUserObject();
                linkedList.add(card);
                card.setProgressValue(dArray[i]);
                card.setProgressBarColor(color);
                continue;
            }
            logger.debug(stringArray[i] + " 'card is not found. itemTreeNode = " + defaultMutableTreeNode);
        }
        if (linkedList.size() == 0) {
            logger.debug("itemLinkedList.size () == 0, returned");
            return;
        }
        DevicePanelItem[] devicePanelItemArray = new DevicePanelItem[linkedList.size()];
        linkedList.toArray(devicePanelItemArray);
        this.fireItemProgressChangedEvent(devicePanelItemArray);
    }

    protected synchronized void processStateAlarmValues(String[] stringArray, int[] nArray, boolean bl) {
        if (stringArray.length != nArray.length) {
            logger.debug("itemID.length != values.length, itemIDs.len = " + stringArray.length + "values.len = " + nArray.length);
            return;
        }
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (int i = 0; i < stringArray.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = this.findTreeNode(stringArray[i]);
            if (defaultMutableTreeNode != null && defaultMutableTreeNode.getUserObject() instanceof DevicePanelItem) {
                Object object;
                DevicePanelItem devicePanelItem = (DevicePanelItem)defaultMutableTreeNode.getUserObject();
                if (devicePanelItem == null) {
                    logger.debug("nullitem");
                    continue;
                }
                linkedList.add(devicePanelItem);
                if (bl) {
                    object = this.configureUtilities.getStateObject(nArray[i]);
                    if (object != null) {
                        if (devicePanelItem instanceof DoubleCard) {
                            if (((DoubleCard)devicePanelItem).getBackCard() != null && ((DoubleCard)devicePanelItem).getBackCard().getID().compareTo(stringArray[i]) == 0) {
                                ((DoubleCard)devicePanelItem).getBackCard().setStateObject((StateObject)object);
                            } else if (((DoubleCard)devicePanelItem).getFrontCard() != null && ((DoubleCard)devicePanelItem).getFrontCard().getID().compareTo(stringArray[i]) == 0) {
                                ((DoubleCard)devicePanelItem).getFrontCard().setStateObject((StateObject)object);
                            }
                            this.processDoubleCardStateValues(devicePanelItem, stringArray[i]);
                            continue;
                        }
                        if (devicePanelItem instanceof ComposeEnvironmentItem) {
                            if (((ComposeEnvironmentItem)devicePanelItem).getBackEnvironmentItem() != null && ((ComposeEnvironmentItem)devicePanelItem).getBackEnvironmentItem().getID().compareTo(stringArray[i]) == 0) {
                                ((ComposeEnvironmentItem)devicePanelItem).getBackEnvironmentItem().setStateObject((StateObject)object);
                            } else if (((ComposeEnvironmentItem)devicePanelItem).getFrontEnvironmentItem() != null && ((ComposeEnvironmentItem)devicePanelItem).getFrontEnvironmentItem().getID().compareTo(stringArray[i]) == 0) {
                                ((ComposeEnvironmentItem)devicePanelItem).getFrontEnvironmentItem().setStateObject((StateObject)object);
                            }
                            this.processComposeEIStateValues(devicePanelItem, stringArray[i]);
                            continue;
                        }
                        devicePanelItem.setStateObject((StateObject)object);
                        continue;
                    }
                    logger.debug("state value can not found and ignored. pos : 1, returned");
                    continue;
                }
                if (this.isWithOutAlarm(nArray[i])) {
                    devicePanelItem.setAlarmObject(null);
                    continue;
                }
                object = this.configureUtilities.getAlarmObject(nArray[i]);
                if (object != null) {
                    if (devicePanelItem instanceof DoubleCard) {
                        if (((DoubleCard)devicePanelItem).getBackCard() != null && ((DoubleCard)devicePanelItem).getBackCard().getID().compareTo(stringArray[i]) == 0) {
                            ((DoubleCard)devicePanelItem).getBackCard().setAlarmObject((AlarmObject)object);
                        } else if (((DoubleCard)devicePanelItem).getFrontCard() != null && ((DoubleCard)devicePanelItem).getFrontCard().getID().compareTo(stringArray[i]) == 0) {
                            ((DoubleCard)devicePanelItem).getFrontCard().setAlarmObject((AlarmObject)object);
                        }
                        this.processDoubleCardStateValues(devicePanelItem, stringArray[i]);
                        continue;
                    }
                    if (devicePanelItem instanceof ComposeEnvironmentItem) {
                        if (((ComposeEnvironmentItem)devicePanelItem).getBackEnvironmentItem() != null && ((ComposeEnvironmentItem)devicePanelItem).getBackEnvironmentItem().getID().compareTo(stringArray[i]) == 0) {
                            ((ComposeEnvironmentItem)devicePanelItem).getBackEnvironmentItem().setAlarmObject((AlarmObject)object);
                        } else if (((ComposeEnvironmentItem)devicePanelItem).getFrontEnvironmentItem() != null && ((ComposeEnvironmentItem)devicePanelItem).getFrontEnvironmentItem().getID().compareTo(stringArray[i]) == 0) {
                            ((ComposeEnvironmentItem)devicePanelItem).getFrontEnvironmentItem().setAlarmObject((AlarmObject)object);
                        }
                        this.processComposeEIAlarmValues(devicePanelItem, stringArray[i]);
                        continue;
                    }
                    devicePanelItem.setAlarmObject((AlarmObject)object);
                    continue;
                }
                logger.debug("state value can not found and ignored. pos : 2, returned");
                continue;
            }
            if (defaultMutableTreeNode != null) continue;
            logger.debug(stringArray[i] + "not find.");
        }
        if (linkedList.size() == 0) {
            logger.debug("itemLinkedList.size () == 0, returned");
            return;
        }
        DevicePanelItem[] devicePanelItemArray = new DevicePanelItem[linkedList.size()];
        int n = 0;
        for (Object object : linkedList) {
            devicePanelItemArray[n] = object;
            ++n;
        }
        if (bl) {
            this.fireItemStateChangedEvent(devicePanelItemArray);
        } else {
            this.fireItemAlarmChangedEvent(devicePanelItemArray);
        }
    }

    private void processAlarmColorChanged(int[] nArray, Color[] colorArray) {
        if (nArray.length != colorArray.length) {
            logger.trace("alarmValues.length != alarmColors.length, itemIDs.len = " + nArray.length + "values.len = " + colorArray.length);
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            AlarmObject alarmObject = this.configureUtilities.getAlarmObject(nArray[i]);
            if (null == alarmObject) continue;
            alarmObject.setColor(colorArray[i]);
        }
        this.fireAlarmColorChanged();
    }

    private void processStateColorChanged(int[] nArray, Color[] colorArray) {
        if (nArray.length != colorArray.length) {
            logger.trace("stateValues.length != stateColors.length, itemIDs.len = " + nArray.length + "values.len = " + colorArray.length);
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            StateObject stateObject = this.configureUtilities.getStateObject(nArray[i]);
            if (null == stateObject) continue;
            stateObject.setColor(colorArray[i]);
        }
        this.fireStateColorChanged(nArray);
    }

    private void processTemperatureValues(String[] stringArray, int[] nArray) {
        if (stringArray.length != nArray.length) {
            return;
        }
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (int i = 0; i < stringArray.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = this.findTreeNode(stringArray[i]);
            if (defaultMutableTreeNode == null || !(defaultMutableTreeNode.getUserObject() instanceof TemperatureEnvironmentItem)) continue;
            TemperatureEnvironmentItem temperatureEnvironmentItem = (TemperatureEnvironmentItem)defaultMutableTreeNode.getUserObject();
            temperatureEnvironmentItem.setTemperature(nArray[i]);
            linkedList.add(temperatureEnvironmentItem);
        }
        if (linkedList.size() == 0) {
            return;
        }
        DevicePanelItem[] devicePanelItemArray = new TemperatureEnvironmentItem[linkedList.size()];
        int n = 0;
        for (TemperatureEnvironmentItem temperatureEnvironmentItem : linkedList) {
            devicePanelItemArray[n] = temperatureEnvironmentItem;
            ++n;
        }
        if (devicePanelItemArray.length != 0) {
            this.fireItemTemperatureChangedEvent(devicePanelItemArray);
        }
    }

    protected synchronized void processDoubleCardStateValues(DevicePanelItem devicePanelItem, String string) {
        if (devicePanelItem instanceof DoubleCard) {
            DoubleCard doubleCard = (DoubleCard)devicePanelItem;
            Card card = doubleCard.getFrontCard();
            Card card2 = doubleCard.getBackCard();
            if (alarmAndStateCompare != null) {
                if (card != null && card2 != null) {
                    if (card.getStateObject() != null && card2.getStateObject() != null) {
                        int n = alarmAndStateCompare.compareState(card.getStateObject(), card2.getStateObject());
                        if (n > 0) {
                            doubleCard.swichCurrentCard(card2.getID());
                        } else if (n == 0) {
                            this.processDoubleCardAlarmValues(devicePanelItem, string);
                        } else {
                            doubleCard.swichCurrentCard(card.getID());
                        }
                    } else if (card.getStateObject() != null && card2.getStateObject() == null) {
                        doubleCard.swichCurrentCard(card.getID());
                    } else if (card.getStateObject() == null && card2.getStateObject() != null) {
                        doubleCard.swichCurrentCard(card2.getID());
                    } else {
                        this.processDoubleCardAlarmValues(devicePanelItem, string);
                    }
                } else if (card != null) {
                    doubleCard.swichCurrentCard(card.getID());
                } else if (card2 != null) {
                    doubleCard.swichCurrentCard(card2.getID());
                }
            } else if (card != null && card2 != null) {
                if (card.getStateObject() != null && card2.getStateObject() != null) {
                    if ((card.getID().compareTo(string) == 0 || card2.getID().compareTo(string) == 0) && doubleCard.getCurrentCardID().compareTo(string) != 0) {
                        doubleCard.swichCurrentCard(string);
                    }
                } else if (card.getStateObject() != null && card2.getStateObject() == null) {
                    doubleCard.swichCurrentCard(card.getID());
                } else if (card.getStateObject() == null && card2.getStateObject() != null) {
                    doubleCard.swichCurrentCard(card2.getID());
                } else {
                    this.processDoubleCardAlarmValues(devicePanelItem, string);
                }
            } else if (card != null) {
                doubleCard.swichCurrentCard(card.getID());
            } else if (card2 != null) {
                doubleCard.swichCurrentCard(card2.getID());
            }
        }
    }

    protected synchronized void processDoubleCardAlarmValues(DevicePanelItem devicePanelItem, String string) {
        if (devicePanelItem instanceof DoubleCard) {
            DoubleCard doubleCard = (DoubleCard)devicePanelItem;
            Card card = doubleCard.getFrontCard();
            Card card2 = doubleCard.getBackCard();
            if (alarmAndStateCompare != null) {
                if (card != null && card2 != null) {
                    if (card.getAlarmObject() != null && card2.getAlarmObject() != null) {
                        if (alarmAndStateCompare.compareAlarm(card.getAlarmObject(), card2.getAlarmObject()) > 0) {
                            doubleCard.swichCurrentCard(card2.getID());
                        } else {
                            doubleCard.swichCurrentCard(card.getID());
                        }
                    } else if (card.getAlarmObject() != null && card2.getAlarmObject() == null) {
                        doubleCard.swichCurrentCard(card.getID());
                    } else if (card.getAlarmObject() == null && card2.getAlarmObject() != null) {
                        doubleCard.swichCurrentCard(card2.getID());
                    } else if ((card.getID().compareTo(string) == 0 || card2.getID().compareTo(string) == 0) && doubleCard.getCurrentCardID().compareTo(string) != 0) {
                        doubleCard.swichCurrentCard(string);
                    }
                } else if (card != null) {
                    doubleCard.swichCurrentCard(card.getID());
                } else if (card2 != null) {
                    doubleCard.swichCurrentCard(card2.getID());
                }
            } else if (card != null && card2 != null) {
                if (card.getAlarmObject() != null && card2.getAlarmObject() != null) {
                    if ((card.getID().compareTo(string) == 0 || card2.getID().compareTo(string) == 0) && doubleCard.getCurrentCardID().compareTo(string) != 0) {
                        doubleCard.swichCurrentCard(string);
                    }
                } else if (card.getAlarmObject() != null && card2.getAlarmObject() == null) {
                    doubleCard.swichCurrentCard(card.getID());
                } else if (card.getAlarmObject() == null && card2.getAlarmObject() != null) {
                    doubleCard.swichCurrentCard(card2.getID());
                } else if ((card.getID().compareTo(string) == 0 || card2.getID().compareTo(string) == 0) && doubleCard.getCurrentCardID().compareTo(string) != 0) {
                    doubleCard.swichCurrentCard(string);
                }
            } else if (card != null) {
                doubleCard.swichCurrentCard(card.getID());
            } else if (card2 != null) {
                doubleCard.swichCurrentCard(card2.getID());
            }
        }
    }

    protected synchronized void processComposeEIStateValues(DevicePanelItem devicePanelItem, String string) {
        if (devicePanelItem instanceof ComposeEnvironmentItem) {
            ComposeEnvironmentItem composeEnvironmentItem = (ComposeEnvironmentItem)devicePanelItem;
            EnvironmentItem environmentItem = composeEnvironmentItem.getFrontEnvironmentItem();
            EnvironmentItem environmentItem2 = composeEnvironmentItem.getBackEnvironmentItem();
            if (alarmAndStateCompare != null) {
                if (environmentItem != null && environmentItem2 != null) {
                    if (environmentItem.getStateObject() != null && environmentItem2.getStateObject() != null) {
                        int n = alarmAndStateCompare.compareState(environmentItem.getStateObject(), environmentItem2.getStateObject());
                        if (n > 0) {
                            composeEnvironmentItem.swichCurrentItem(environmentItem2.getID());
                        } else if (n == 0) {
                            this.processComposeEIAlarmValues(devicePanelItem, string);
                        } else {
                            composeEnvironmentItem.swichCurrentItem(environmentItem.getID());
                        }
                    } else if (environmentItem.getStateObject() != null && environmentItem2.getStateObject() == null) {
                        composeEnvironmentItem.swichCurrentItem(environmentItem.getID());
                    } else if (environmentItem.getStateObject() == null && environmentItem2.getStateObject() != null) {
                        composeEnvironmentItem.swichCurrentItem(environmentItem2.getID());
                    } else {
                        this.processComposeEIAlarmValues(devicePanelItem, string);
                    }
                } else if (environmentItem != null) {
                    composeEnvironmentItem.swichCurrentItem(environmentItem.getID());
                } else if (environmentItem2 != null) {
                    composeEnvironmentItem.swichCurrentItem(environmentItem2.getID());
                }
            } else if (environmentItem != null && environmentItem2 != null) {
                if (environmentItem.getStateObject() != null && environmentItem2.getStateObject() != null) {
                    if ((environmentItem.getID().compareTo(string) == 0 || environmentItem2.getID().compareTo(string) == 0) && composeEnvironmentItem.getCurrentEnvironmentItemID().compareTo(string) != 0) {
                        composeEnvironmentItem.swichCurrentItem(string);
                    }
                } else if (environmentItem.getStateObject() != null && environmentItem2.getStateObject() == null) {
                    composeEnvironmentItem.swichCurrentItem(environmentItem.getID());
                } else if (environmentItem.getStateObject() == null && environmentItem2.getStateObject() != null) {
                    composeEnvironmentItem.swichCurrentItem(environmentItem2.getID());
                } else {
                    this.processComposeEIAlarmValues(devicePanelItem, string);
                }
            } else if (environmentItem != null) {
                composeEnvironmentItem.swichCurrentItem(environmentItem.getID());
            } else if (environmentItem2 != null) {
                composeEnvironmentItem.swichCurrentItem(environmentItem2.getID());
            }
        }
    }

    protected synchronized void processComposeEIAlarmValues(DevicePanelItem devicePanelItem, String string) {
        if (devicePanelItem instanceof ComposeEnvironmentItem) {
            ComposeEnvironmentItem composeEnvironmentItem = (ComposeEnvironmentItem)devicePanelItem;
            EnvironmentItem environmentItem = composeEnvironmentItem.getFrontEnvironmentItem();
            EnvironmentItem environmentItem2 = composeEnvironmentItem.getBackEnvironmentItem();
            if (alarmAndStateCompare != null) {
                if (environmentItem != null && environmentItem2 != null) {
                    if (environmentItem.getAlarmObject() != null && environmentItem2.getAlarmObject() != null) {
                        if (alarmAndStateCompare.compareAlarm(environmentItem.getAlarmObject(), environmentItem2.getAlarmObject()) > 0) {
                            composeEnvironmentItem.swichCurrentItem(environmentItem2.getID());
                        } else {
                            composeEnvironmentItem.swichCurrentItem(environmentItem.getID());
                        }
                    } else if (environmentItem.getAlarmObject() != null && environmentItem2.getAlarmObject() == null) {
                        composeEnvironmentItem.swichCurrentItem(environmentItem.getID());
                    } else if (environmentItem.getAlarmObject() == null && environmentItem2.getAlarmObject() != null) {
                        composeEnvironmentItem.swichCurrentItem(environmentItem2.getID());
                    } else if ((environmentItem.getID().compareTo(string) == 0 || environmentItem2.getID().compareTo(string) == 0) && composeEnvironmentItem.getCurrentEnvironmentItemID().compareTo(string) != 0) {
                        composeEnvironmentItem.swichCurrentItem(string);
                    }
                } else if (environmentItem != null) {
                    composeEnvironmentItem.swichCurrentItem(environmentItem.getID());
                } else if (environmentItem2 != null) {
                    composeEnvironmentItem.swichCurrentItem(environmentItem2.getID());
                }
            } else if (environmentItem != null && environmentItem2 != null) {
                if (environmentItem.getAlarmObject() != null && environmentItem2.getAlarmObject() != null) {
                    if ((environmentItem.getID().compareTo(string) == 0 || environmentItem2.getID().compareTo(string) == 0) && composeEnvironmentItem.getCurrentEnvironmentItemID().compareTo(string) != 0) {
                        composeEnvironmentItem.swichCurrentItem(string);
                    }
                } else if (environmentItem.getAlarmObject() != null && environmentItem2.getAlarmObject() == null) {
                    composeEnvironmentItem.swichCurrentItem(environmentItem.getID());
                } else if (environmentItem.getAlarmObject() == null && environmentItem2.getAlarmObject() != null) {
                    composeEnvironmentItem.swichCurrentItem(environmentItem2.getID());
                } else if ((environmentItem.getID().compareTo(string) == 0 || environmentItem2.getID().compareTo(string) == 0) && composeEnvironmentItem.getCurrentEnvironmentItemID().compareTo(string) != 0) {
                    composeEnvironmentItem.swichCurrentItem(string);
                }
            } else if (environmentItem != null) {
                composeEnvironmentItem.swichCurrentItem(environmentItem.getID());
            } else if (environmentItem2 != null) {
                composeEnvironmentItem.swichCurrentItem(environmentItem2.getID());
            }
        }
    }

    protected void addComponent(String string, ComponentData componentData, int n) {
        DevicePanelComponent[] devicePanelComponentArray = this.addComponentToModel(string, componentData, n);
        if (null != devicePanelComponentArray) {
            this.fireComponentAddedEvent(devicePanelComponentArray[0], (EmptyComponent)devicePanelComponentArray[1]);
        }
    }

    protected void removeComponet(DefaultMutableTreeNode defaultMutableTreeNode, DevicePanelComponent devicePanelComponent) throws DataNotValidException {
        DevicePanelComponent devicePanelComponent2;
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        DevicePanelComponent devicePanelComponent3 = (DevicePanelComponent)defaultMutableTreeNode2.getUserObject();
        int n = defaultMutableTreeNode2.getIndex(defaultMutableTreeNode);
        ComponentType componentType = this.configureUtilities.getComponentType(devicePanelComponent3.getType());
        ChildPositionType[] childPositionTypeArray = componentType.getChildPositionTypes();
        this.destroyTreeNode(defaultMutableTreeNode);
        if (!devicePanelComponent.isIsFacility() && devicePanelComponent instanceof Shelf) {
            devicePanelComponent.setRelatedTreeNode(defaultMutableTreeNode);
        }
        ModelFactory.createEmptyComponent(defaultMutableTreeNode2, childPositionTypeArray[n], n, this.configureUtilities);
        EmptyComponent emptyComponent = (EmptyComponent)defaultMutableTreeNode.getUserObject();
        int n2 = devicePanelComponent3.getStartX();
        int n3 = devicePanelComponent3.getStartY();
        int n4 = 0;
        if (devicePanelComponent3 instanceof Shelf) {
            devicePanelComponent2 = (Shelf)devicePanelComponent3;
            n4 = ((Shelf)devicePanelComponent2).getFrontChildCount();
            if (n >= ((Shelf)devicePanelComponent2).getFrontChildCount() && !devicePanelComponent2.isIsFacility() && !((Shelf)devicePanelComponent2).isOnBehindFrame()) {
                n2 = 0;
                n3 = 0;
            }
        }
        if (devicePanelComponent instanceof Card && ((Card)(devicePanelComponent2 = (Card)devicePanelComponent)).getOccupiedTwoSlots() && n != 0 && n != n4) {
            ModelFactory.createEmptyComponent(defaultMutableTreeNode2, childPositionTypeArray[--n], n);
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(n);
            EmptyComponent emptyComponent2 = (EmptyComponent)defaultMutableTreeNode3.getUserObject();
            emptyComponent2.adjustToAbsaluteCordination(n2, n3);
            emptyComponent2.setBelongingPageIndex(devicePanelComponent.getBelongingPageIndex());
            emptyComponent2.setCurrentPageIndex(devicePanelComponent.getCurrentPageIndex());
        }
        if (devicePanelComponent3 instanceof Card && ((Card)(devicePanelComponent2 = (Card)devicePanelComponent3)).getOccupiedTwoSlots()) {
            if (((Card)devicePanelComponent2).getHeight() > ((Card)devicePanelComponent2).getWidth()) {
                n2 -= devicePanelComponent3.getWidth();
            } else {
                n3 -= devicePanelComponent3.getHeight();
            }
        }
        emptyComponent.adjustToAbsaluteCordination(n2, n3);
        emptyComponent.setBelongingPageIndex(devicePanelComponent.getBelongingPageIndex());
        emptyComponent.setCurrentPageIndex(devicePanelComponent.getCurrentPageIndex());
        this.fireComponentRemovedEvent(devicePanelComponent, emptyComponent);
    }

    public void testProcessDoubleCardAlarmValues(DevicePanelItem devicePanelItem, String string) {
        this.processDoubleCardAlarmValues(devicePanelItem, string);
    }

    public void testProcessDoubleCardStateAlarmValues(DevicePanelItem devicePanelItem, String string) {
        this.processDoubleCardStateValues(devicePanelItem, string);
    }

    private static void traceMessage(String string, String string2) {
        logger.debug(string2);
    }

    private boolean isWithOutAlarm(int n) {
        if (this.configureUtilities == null || this.configureUtilities.getWithoutAlarmValues() == null) {
            return false;
        }
        return this.configureUtilities.getWithoutAlarmValues().contains(n);
    }

    protected void fireUserIconsAdded(DevicePanelItem[] devicePanelItemArray) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ModelChangeListener.class) continue;
            ((ModelChangeListener)objectArray[i + 1]).userIconsAdded(devicePanelItemArray);
        }
    }

    protected void fireUserIconsRemoved(DevicePanelItem[] devicePanelItemArray) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ModelChangeListener.class) continue;
            ((ModelChangeListener)objectArray[i + 1]).userIconsRemoved(devicePanelItemArray);
        }
    }

    private void processUserIconsAdded(String[] stringArray, Icon[] iconArray, Point[] pointArray) {
        if (stringArray.length != iconArray.length || stringArray.length != pointArray.length) {
            logger.trace("itemIDs.length != progressValue.length, itemIDs.len = " + stringArray.length + " values.len = " + iconArray.length);
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        LinkedList<DevicePanelItem> linkedList = new LinkedList<DevicePanelItem>();
        for (int i = 0; i < stringArray.length; ++i) {
            defaultMutableTreeNode = this.findTreeNode(stringArray[i]);
            if (defaultMutableTreeNode != null && defaultMutableTreeNode.getUserObject() instanceof DevicePanelItem) {
                DevicePanelItem devicePanelItem = (DevicePanelItem)defaultMutableTreeNode.getUserObject();
                if (devicePanelItem == null) {
                    logger.trace("null item");
                    continue;
                }
                devicePanelItem.addUserImageIcon(iconArray[i], pointArray[i]);
                linkedList.add(devicePanelItem);
                continue;
            }
            logger.trace(stringArray[i] + " 'card is not found. itemTreeNode = " + defaultMutableTreeNode);
        }
        if (linkedList.size() == 0) {
            logger.trace("itemLinkedList.size () == 0, returned");
            return;
        }
        DevicePanelItem[] devicePanelItemArray = new DevicePanelItem[linkedList.size()];
        linkedList.toArray(devicePanelItemArray);
        if (devicePanelItemArray.length > 0) {
            this.fireUserIconsAdded(devicePanelItemArray);
        }
    }

    private void processUserIconsRemoved(String[] stringArray, Icon[] iconArray) {
        LinkedList<DevicePanelItem> linkedList = new LinkedList<DevicePanelItem>();
        for (int i = 0; i < stringArray.length; ++i) {
            DevicePanelTreeModel.traceMessage("SourceChangeHandler:UserIconsRemoved()", "start removing, componentID=" + stringArray[i]);
            DefaultMutableTreeNode defaultMutableTreeNode = this.findTreeNode(stringArray[i]);
            if (defaultMutableTreeNode == null || defaultMutableTreeNode == this.getRoot()) {
                DevicePanelTreeModel.traceMessage("SourceChangeHandler:UserIconsRemoved()", "Can not find parentTreeNode with id of " + stringArray[i]);
                return;
            }
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof EmptyComponent) {
                DevicePanelTreeModel.traceMessage("SourceChangeHandler:UserIconsRemoved()", "Already is empty component.");
                return;
            }
            DevicePanelComponent devicePanelComponent = (DevicePanelComponent)object;
            if (devicePanelComponent instanceof Frame) {
                DevicePanelTreeModel.traceMessage("SourceChangeHandler:UserIconsRemoved()", "Frame can not be removed. ");
                return;
            }
            if (!(object instanceof DevicePanelItem)) continue;
            DevicePanelItem devicePanelItem = (DevicePanelItem)object;
            devicePanelItem.removeUserImageIcon(iconArray[i]);
            linkedList.add(devicePanelItem);
        }
        if (linkedList.size() == 0) {
            logger.trace("itemLinkedList.size () == 0, returned");
            return;
        }
        DevicePanelItem[] devicePanelItemArray = new DevicePanelItem[linkedList.size()];
        linkedList.toArray(devicePanelItemArray);
        if (devicePanelItemArray.length > 0) {
            this.fireUserIconsRemoved(devicePanelItemArray);
        }
    }

    private void processComponentVisibilty(String[] stringArray, boolean bl) {
        LinkedList<DevicePanelItem> linkedList = new LinkedList<DevicePanelItem>();
        for (int i = 0; i < stringArray.length; ++i) {
            DevicePanelTreeModel.traceMessage("SourceChangeHandler:processChangeComponentVisibilty()", "change visibility, componentID=" + stringArray[i]);
            DefaultMutableTreeNode defaultMutableTreeNode = this.findTreeNode(stringArray[i]);
            if (null == defaultMutableTreeNode) {
                DevicePanelTreeModel.traceMessage("ProcessChangeComponentVisibilty()", "Can not find TreeNode with id of " + stringArray[i]);
                continue;
            }
            Object object = defaultMutableTreeNode.getUserObject();
            if (!(object instanceof Card)) {
                DevicePanelTreeModel.traceMessage("ProcessChangeComponentVisibilty", "Component type is not CARD.");
                continue;
            }
            DevicePanelItem devicePanelItem = (DevicePanelItem)object;
            if (bl == devicePanelItem.isVisible()) continue;
            linkedList.add(devicePanelItem);
        }
        if (linkedList.size() == 0) {
            logger.trace("itemLinkedList.size () == 0, returned");
            return;
        }
        DevicePanelItem[] devicePanelItemArray = new DevicePanelItem[linkedList.size()];
        linkedList.toArray(devicePanelItemArray);
        if (devicePanelItemArray.length > 0) {
            for (int i = 0; i < devicePanelItemArray.length; ++i) {
                devicePanelItemArray[i].setVisibility(bl);
                this.fireComponentVisiblityEvent(devicePanelItemArray[i]);
            }
        }
    }

    protected void hideAddedItem(String string, ComponentData componentData, int n) {
        DevicePanelComponent[] devicePanelComponentArray = this.addComponentToModel(string, componentData, n);
        if (devicePanelComponentArray != null) {
            devicePanelComponentArray[0].setVisibility(false);
            this.fireComponentAddedEvent(devicePanelComponentArray[0], (EmptyComponent)devicePanelComponentArray[1]);
        }
    }

    private DevicePanelComponent[] addComponentToModel(String string, ComponentData componentData, int n) {
        DevicePanelTreeModel.traceMessage("SourceChangeHandler:addComponentToModel()", "start adding.. parentID=" + string + ", index=" + n);
        DefaultMutableTreeNode defaultMutableTreeNode = this.findTreeNode(string);
        if (defaultMutableTreeNode == null || defaultMutableTreeNode == this.getRoot()) {
            DevicePanelTreeModel.traceMessage("SourceChangeHandler:addComponentToModel()", "Can not find parentTreeNode with id of " + string);
            return null;
        }
        if (n < 0 || n >= defaultMutableTreeNode.getChildCount()) {
            DevicePanelTreeModel.traceMessage("SourceChangeHandler:addComponentToModel()", "The child index of '" + n + "' is out of bounds");
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
        if (!(defaultMutableTreeNode2.getUserObject() instanceof EmptyComponent)) {
            DevicePanelTreeModel.traceMessage("SourceChangeHandler:addComponentToModel()", "The position is not empty and can not add a new component");
            return null;
        }
        EmptyComponent emptyComponent = (EmptyComponent)defaultMutableTreeNode2.getUserObject();
        DevicePanelComponent devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
        ComponentType componentType = this.configureUtilities.getComponentType(devicePanelComponent.getType());
        ChildPositionType[] childPositionTypeArray = componentType.getChildPositionTypes();
        try {
            DevicePanelComponent devicePanelComponent2;
            if (devicePanelComponent instanceof Frame) {
                ModelFactory.establishEnvironmentItemAndShelf(defaultMutableTreeNode, componentData, childPositionTypeArray[n], n, this.configureUtilities);
            } else if (devicePanelComponent instanceof Shelf) {
                ModelFactory.establishCardAndPort(defaultMutableTreeNode, componentData, childPositionTypeArray[n], n, this.configureUtilities);
            } else if (devicePanelComponent instanceof Card) {
                ModelFactory.establishBuckledCardAndPort(defaultMutableTreeNode, componentData, childPositionTypeArray[n], n, this.configureUtilities);
            } else if (devicePanelComponent instanceof BuckledCard) {
                ModelFactory.establishPort(defaultMutableTreeNode, componentData, childPositionTypeArray[n], n, this.configureUtilities);
            } else {
                logger.trace("IVDevicePanel: Add component returned: component is " + devicePanelComponent);
                return null;
            }
            DevicePanelComponent devicePanelComponent3 = (DevicePanelComponent)defaultMutableTreeNode2.getUserObject();
            devicePanelComponent3.setBehindEnabled(devicePanelComponent.getBehindEnabled());
            devicePanelComponent3.setIsFacility(devicePanelComponent.isIsFacility());
            int n2 = devicePanelComponent.getStartX();
            int n3 = devicePanelComponent.getStartY();
            if (devicePanelComponent instanceof Shelf) {
                devicePanelComponent2 = (Shelf)devicePanelComponent;
                devicePanelComponent3.setBehindEnabled(n >= ((Shelf)devicePanelComponent2).getFrontChildCount());
                if (n >= ((Shelf)devicePanelComponent2).getFrontChildCount() && !devicePanelComponent2.isIsFacility() && !((Shelf)devicePanelComponent2).isOnBehindFrame()) {
                    n2 = 0;
                    n3 = 0;
                }
            }
            if (devicePanelComponent instanceof Card && ((Card)(devicePanelComponent2 = (Card)devicePanelComponent)).getOccupiedTwoSlots()) {
                if (((Card)devicePanelComponent2).getHeight() > ((Card)devicePanelComponent2).getWidth()) {
                    n2 -= devicePanelComponent.getWidth();
                } else {
                    n3 -= devicePanelComponent.getHeight();
                }
            }
            devicePanelComponent3.adjustToAbsaluteCordination(n2, n3);
            devicePanelComponent3.setBelongingPageIndex(emptyComponent.getBelongingPageIndex());
            devicePanelComponent3.setCurrentPageIndex(emptyComponent.getCurrentPageIndex());
            return new DevicePanelComponent[]{devicePanelComponent3, emptyComponent};
        }
        catch (DataNotValidException dataNotValidException) {
            this.destroyTreeNode(defaultMutableTreeNode2);
            defaultMutableTreeNode2.setUserObject(emptyComponent);
            logger.trace(dataNotValidException.getMessage(), dataNotValidException);
            return null;
        }
    }

    private void processLabelChanged(String[] stringArray, String[] stringArray2) {
        int n = 0;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        Object object = null;
        DevicePanelComponent devicePanelComponent = null;
        Card card = null;
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            DevicePanelTreeModel.traceMessage("SourceChangeHandler:LabelChanged()", "start label change, componentID=" + stringArray[i]);
            defaultMutableTreeNode = this.findTreeNode(stringArray[i]);
            if (defaultMutableTreeNode == null || defaultMutableTreeNode == this.getRoot()) {
                DevicePanelTreeModel.traceMessage("SourceChangeHandler:labelChanged()", "Can not find parentTreeNode with id of " + stringArray[i]);
                continue;
            }
            object = defaultMutableTreeNode.getUserObject();
            if (object instanceof EmptyComponent) {
                DevicePanelTreeModel.traceMessage("SourceChangeHandler:labelChanged()", "Already is empty component.");
                continue;
            }
            devicePanelComponent = (DevicePanelComponent)object;
            if (!(devicePanelComponent instanceof Card)) {
                DevicePanelTreeModel.traceMessage("SourceChangeHandler:labelChanged()", "Label can be changed only for cards.");
                continue;
            }
            card = (Card)object;
            string = stringArray2 == null ? null : (stringArray2.length < i ? null : stringArray2[i]);
            card.setLabel(string == null ? null : string.trim());
            ++n;
        }
        if (n > 0) {
            this.fireModelChanged();
        }
    }

    private static class Comparator
    implements Comparable {
        private String id = null;

        private Comparator() {
        }

        public void setID(String string) {
            this.id = string;
        }

        public int compareTo(Object object) {
            DevicePanelComponent devicePanelComponent = (DevicePanelComponent)object;
            if (devicePanelComponent != null && this.compareID(devicePanelComponent.getID())) {
                return 0;
            }
            return -1;
        }

        private boolean compareID(String string) {
            int n = this.id.indexOf("+");
            int n2 = string.indexOf("+");
            if (n == -1 && n2 == -1 || n != -1 && n2 != -1) {
                return ResourceUtil.areEquals(string, this.id);
            }
            if (n2 != -1) {
                String string2 = string.substring(0, n2);
                String string3 = string.substring(n2 + 1);
                return ResourceUtil.areEquals(string2, this.id) || ResourceUtil.areEquals(string3, this.id);
            }
            String string4 = this.id.substring(0, n);
            String string5 = this.id.substring(n + 1);
            return string.equals(string4) || string.equals(string5);
        }
    }

    private class SourceChangeHandler
    implements SourceChangeListener {
        private SourceChangeHandler() {
        }

        @Override
        public void stateChanged(String[] stringArray, int[] nArray) {
            boolean bl = true;
            DevicePanelTreeModel.this.processStateAlarmValues(stringArray, nArray, bl);
        }

        @Override
        public void progressChanged(String[] stringArray, double[] dArray, Color color) {
            DevicePanelTreeModel.this.processProgressChange(stringArray, dArray, color);
        }

        @Override
        public void alarmChanged(String[] stringArray, int[] nArray) {
            boolean bl = false;
            DevicePanelTreeModel.this.processStateAlarmValues(stringArray, nArray, bl);
        }

        @Override
        public void alarmColorChanged(int[] nArray, Color[] colorArray) {
            DevicePanelTreeModel.this.processAlarmColorChanged(nArray, colorArray);
        }

        @Override
        public void stateColorChanged(int[] nArray, Color[] colorArray) {
            DevicePanelTreeModel.this.processStateColorChanged(nArray, colorArray);
        }

        @Override
        public void componentAdded(String string, ComponentData componentData, int n) {
            DevicePanelTreeModel.this.addComponent(string, componentData, n);
        }

        @Override
        public void hideAddedComponent(String string, ComponentData componentData, int n) {
            DevicePanelTreeModel.this.hideAddedItem(string, componentData, n);
        }

        @Override
        public void temperatureChanged(String[] stringArray, int[] nArray) {
            DevicePanelTreeModel.this.processTemperatureValues(stringArray, nArray);
        }

        @Override
        public void componentRemoved(String string) {
            DevicePanelTreeModel.traceMessage("SourceChangeHandler:componentRemoved()", "start removing, componentID=" + string);
            DefaultMutableTreeNode defaultMutableTreeNode = DevicePanelTreeModel.this.findTreeNode(string);
            if (defaultMutableTreeNode == null || defaultMutableTreeNode == DevicePanelTreeModel.this.getRoot()) {
                DevicePanelTreeModel.traceMessage("SourceChangeHandler:componentRemoved()", "Can not find parentTreeNode with id of " + string);
                return;
            }
            if (defaultMutableTreeNode.getUserObject() instanceof EmptyComponent) {
                DevicePanelTreeModel.traceMessage("SourceChangeHandler:componentRemoved()", "Already is empty component.");
                return;
            }
            DevicePanelComponent devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
            if (devicePanelComponent instanceof Frame) {
                DevicePanelTreeModel.traceMessage("SourceChangeHandler:componentRemoved()", "Frame can not be removed. ");
                return;
            }
            try {
                DevicePanelTreeModel.this.removeComponet(defaultMutableTreeNode, devicePanelComponent);
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
        }

        @Override
        public void userIconsAdded(String[] stringArray, Icon[] iconArray, Point[] pointArray) {
            DevicePanelTreeModel.this.processUserIconsAdded(stringArray, iconArray, pointArray);
        }

        @Override
        public void userIconsRemoved(String[] stringArray, Icon[] iconArray) {
            DevicePanelTreeModel.this.processUserIconsRemoved(stringArray, iconArray);
        }

        @Override
        public void changeComponentVisibilty(String[] stringArray, boolean bl) {
            DevicePanelTreeModel.this.processComponentVisibilty(stringArray, bl);
        }

        @Override
        public void labelChanged(String[] stringArray, String[] stringArray2) {
            DevicePanelTreeModel.this.processLabelChanged(stringArray, stringArray2);
        }
    }
}

