/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.devicepanel.model;

import com.swimap.iview.templates.devicepanel.datasource.ComponentData;
import com.swimap.iview.templates.devicepanel.datasource.SourceChangeListener;
import com.swimap.iview.templates.devicepanel.model.ComponentFactory;
import com.swimap.iview.templates.devicepanel.model.ConfigureUtilities;
import com.swimap.iview.templates.devicepanel.model.ConfigureUtilitiesEx;
import com.swimap.iview.templates.devicepanel.model.DataNotValidException;
import com.swimap.iview.templates.devicepanel.model.DevicePanelTreeModel;
import com.swimap.iview.templates.devicepanel.model.ModelFactory;
import com.swimap.iview.templates.devicepanel.model.PopupMenuAuthorization;
import com.swimap.iview.templates.devicepanel.model.SubFrameData;
import com.swimap.iview.templates.devicepanel.model.component.DevicePanelComponent;
import com.swimap.iview.templates.devicepanel.model.component.Frame;
import com.swimap.iview.templates.devicepanel.model.component.Shelf;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

public class ComposeFrameModel
extends DevicePanelTreeModel {
    private static IviewLogger logger = IviewLogger.getLogger(ComposeFrameModel.class, "IVIEW");
    private SubFrameData[] subFrameData = null;
    private Rectangle frameRectangle = null;
    private ComponentData frameData = null;
    private int numberRuler = 1;
    private static final int FRAMEARE_EXTEND_WIDTH = 12;
    private static final int FRAMEARE_EXTEND_HIGHT = 14;

    public ComposeFrameModel(DefaultMutableTreeNode defaultMutableTreeNode, SubFrameData[] subFrameDataArray, ComponentData componentData, int n) throws DataNotValidException {
        super(defaultMutableTreeNode);
        this.subFrameData = subFrameDataArray;
        this.frameData = componentData;
        this.numberRuler = n;
        try {
            this.initializeModel(defaultMutableTreeNode);
        }
        catch (DataNotValidException dataNotValidException) {
            throw dataNotValidException;
        }
        catch (Exception exception) {
            logger.error("initializeModel error the detail exception is:");
            logger.trace(exception.getMessage(), exception);
            throw new DataNotValidException(exception);
        }
    }

    private void initializeModel(DefaultMutableTreeNode defaultMutableTreeNode) throws DataNotValidException {
        this.installListenerForSubFrame(this.subFrameData, this.sourceChangeListener);
        this.calculateSubFrameLabel(this.subFrameData, this.numberRuler);
        this.configureUtilities = this.createConfigureUtilities(this.subFrameData);
        this.calculateSubFrameBound(this.subFrameData);
        this.createFrameNode(defaultMutableTreeNode, this.subFrameData, this.frameData);
        DevicePanelComponent devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
        devicePanelComponent.adjustToAbsaluteCordination(0, 0);
    }

    private void installListenerForSubFrame(SubFrameData[] subFrameDataArray, SourceChangeListener sourceChangeListener) {
        if (subFrameDataArray == null || subFrameDataArray.length == 0) {
            return;
        }
        for (int i = 0; i < subFrameDataArray.length; ++i) {
            if (subFrameDataArray[i] == null) continue;
            subFrameDataArray[i].addDataSourceChangeListner(sourceChangeListener);
        }
    }

    public PopupMenuAuthorization getPopupMenuAuthorization(int n, int n2) {
        SubFrameData subFrameData = this.subFrameData[n - 1];
        if (subFrameData == null) {
            return null;
        }
        return subFrameData.getPopupMenuAuthorization(n2);
    }

    public ConfigureUtilities getConfigureUtilities(int n, int n2) {
        SubFrameData subFrameData = this.subFrameData[n - 1];
        if (subFrameData == null) {
            return null;
        }
        return subFrameData.getConfigureUtilities(n2);
    }

    private void unInstallListenerForSubFrame(SubFrameData[] subFrameDataArray, SourceChangeListener sourceChangeListener) {
        if (subFrameDataArray == null || subFrameDataArray.length == 0) {
            return;
        }
        for (int i = 0; i < subFrameDataArray.length; ++i) {
            if (subFrameDataArray[i] == null) continue;
            subFrameDataArray[i].removeDataSourceChangeListener(sourceChangeListener);
        }
    }

    private void calculateSubFrameLabel(SubFrameData[] subFrameDataArray, int n) {
        int n2 = 0;
        if (n == 1) {
            for (int i = 0; i < subFrameDataArray.length; ++i) {
                if (subFrameDataArray[i] == null) continue;
                subFrameDataArray[i].setLabel(String.valueOf(n2));
                ++n2;
            }
        } else {
            for (int i = subFrameDataArray.length - 1; i >= 0; --i) {
                if (subFrameDataArray[i] == null) continue;
                subFrameDataArray[i].setLabel(String.valueOf(n2));
                ++n2;
            }
        }
    }

    private ConfigureUtilities createConfigureUtilities(SubFrameData[] subFrameDataArray) {
        return new ConfigureUtilitiesEx(this.getSubConfigureUtilities(subFrameDataArray));
    }

    public boolean changeData(SubFrameData[] subFrameDataArray) {
        if (subFrameDataArray == null || subFrameDataArray.length == 0) {
            return false;
        }
        int n = 0;
        for (n = 0; n < subFrameDataArray.length && subFrameDataArray[n] == null; ++n) {
        }
        if (n == subFrameDataArray.length) {
            return false;
        }
        try {
            this.unInstallListenerForSubFrame(this.subFrameData, this.sourceChangeListener);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getRoot();
            int n2 = defaultMutableTreeNode.getChildCount();
            for (int i = 0; i < n2; ++i) {
                this.destroyTreeNode((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i));
            }
            defaultMutableTreeNode.removeAllChildren();
            this.subFrameData = subFrameDataArray;
            this.initializeModel(defaultMutableTreeNode);
            this.fireModelRefreshEvent();
        }
        catch (Exception exception) {
            logger.error("initializeModel error the detail exception is:");
            logger.trace(exception.getMessage(), exception);
            return false;
        }
        return true;
    }

    private void calculateSubFrameBound(SubFrameData[] subFrameDataArray) {
        int n;
        int[] nArray = new int[subFrameDataArray.length];
        int[] nArray2 = new int[subFrameDataArray.length];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < subFrameDataArray.length; ++i) {
            Dimension dimension = subFrameDataArray[i].getSubFrameSize();
            if (dimension != null) {
                nArray[i] = (int)dimension.getWidth();
                nArray2[i] = (int)dimension.getHeight();
                n3 += nArray2[i];
                if (n4 >= nArray[i] + 1) continue;
                n4 = nArray[i] + 1;
                continue;
            }
            nArray[i] = 0;
            nArray2[i] = subFrameDataArray[i].getEmptyShelfHeight();
            if (i > 0 && subFrameDataArray[i - 1].isHighShelf()) {
                nArray2[i] = 0;
            }
            n3 += nArray2[i];
            ++n2;
        }
        double d = this.frameData.getSizeInCompositeFrame().getHeight();
        double d2 = this.frameData.getSizeInCompositeFrame().getWidth();
        if ((double)n3 > d) {
            d = n3;
        }
        if (n4 < (int)d2) {
            n4 = (int)d2;
        }
        if (n2 > 0) {
            for (n = 0; n < subFrameDataArray.length; ++n) {
                if (nArray[n] != 0) continue;
                nArray[n] = n4;
            }
        }
        this.frameRectangle = new Rectangle(n4 + 24, (int)d + 14);
        n = 10;
        for (int i = 0; i < subFrameDataArray.length; ++i) {
            subFrameDataArray[i].setSubFrameBound(new Rectangle(12, n, nArray[i], nArray2[i]));
            n += nArray2[i];
        }
    }

    private ConfigureUtilities[] getSubConfigureUtilities(SubFrameData[] subFrameDataArray) {
        if (subFrameDataArray == null) {
            return null;
        }
        Vector<ConfigureUtilities> vector = new Vector<ConfigureUtilities>(subFrameDataArray.length);
        DevicePanelTreeModel[] devicePanelTreeModelArray = null;
        for (int i = 0; i < subFrameDataArray.length; ++i) {
            if (subFrameDataArray[i] == null || (devicePanelTreeModelArray = subFrameDataArray[i].getModels()) == null) continue;
            for (int j = 0; j < devicePanelTreeModelArray.length; ++j) {
                if (devicePanelTreeModelArray[j] == null) continue;
                vector.add(devicePanelTreeModelArray[j].configureUtilities);
            }
        }
        ConfigureUtilities[] configureUtilitiesArray = new ConfigureUtilities[vector.size()];
        vector.toArray(configureUtilitiesArray);
        return configureUtilitiesArray;
    }

    private void createFrameNode(DefaultMutableTreeNode defaultMutableTreeNode, SubFrameData[] subFrameDataArray, ComponentData componentData) throws DataNotValidException {
        Frame frame = (Frame)ComponentFactory.createDevicePanelComponent(Frame.class, componentData, this.frameRectangle);
        frame.setToolTipText(componentData.info);
        frame.setBackground(this.configureUtilities.getBackground());
        ModelFactory.createTreeNode(defaultMutableTreeNode, frame, defaultMutableTreeNode.getChildCount());
        DefaultMutableTreeNode defaultMutableTreeNode2 = frame.getRelatedTreeNode();
        for (int i = 0; i < subFrameDataArray.length; ++i) {
            if (subFrameDataArray[i] == null) continue;
            subFrameDataArray[i].createSubFrameNode(defaultMutableTreeNode2);
        }
    }

    @Override
    public void endTask() {
        this.unInstallListenerForSubFrame(this.subFrameData, this.sourceChangeListener);
        this.sourceChangeListener = null;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getRoot();
        this.destroyTreeNode(defaultMutableTreeNode);
    }

    @Override
    protected void addComponent(String string, ComponentData componentData, int n) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.findTreeNode(string);
        if (defaultMutableTreeNode == null || defaultMutableTreeNode == this.getRoot()) {
            logger.error("Can not find parentTreeNode with id of " + string);
            return;
        }
        if (n < 0 || n >= defaultMutableTreeNode.getChildCount()) {
            logger.error("The child index of '" + n + "' is out of bounds");
            return;
        }
        DevicePanelComponent devicePanelComponent = (DevicePanelComponent)defaultMutableTreeNode.getUserObject();
        if (devicePanelComponent instanceof Frame) {
            logger.trace("The parentComponent is " + devicePanelComponent);
            return;
        }
        if (devicePanelComponent instanceof Shelf) {
            if (componentData == null) {
                return;
            }
            this.changeData(this.subFrameData);
        } else {
            logger.trace("The parentComponent is " + devicePanelComponent);
        }
    }

    @Override
    protected void removeComponet(DefaultMutableTreeNode defaultMutableTreeNode, DevicePanelComponent devicePanelComponent) throws DataNotValidException {
        this.changeData(this.subFrameData);
    }
}

