/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.devicepanel.model;

import com.swimap.iview.templates.devicepanel.model.ComponentType;
import com.swimap.iview.templates.devicepanel.model.XMLFileNotValidException;
import com.swimap.iview.templates.devicepanel.model.component.EmptyComponent;
import com.swimap.iview.templates.devicepanel.model.xml.ChildPosition;
import com.swimap.iview.templates.devicepanel.model.xml.Direction;
import java.awt.Rectangle;

public class ChildPositionType
extends ComponentType {
    private Rectangle bound = null;
    private Class emptyComponentClass = EmptyComponent.class;
    private String emptyPopupMenuRef = null;
    private boolean slotVisible = true;
    private String slotLabel = null;
    private String slotPosition = null;
    ClassLoader classLoader = null;
    private Direction direction = null;

    ChildPositionType(ChildPosition childPosition) throws XMLFileNotValidException {
        this(childPosition, null);
    }

    ChildPositionType(ChildPosition childPosition, ClassLoader classLoader) throws XMLFileNotValidException {
        super("", "", null);
        int n = this.textToInt(childPosition.getBound().getXText(), ChildPositionType.class.getName(), "ChildPositionType");
        int n2 = this.textToInt(childPosition.getBound().getYText(), ChildPositionType.class.getName(), "ChildPositionType");
        int n3 = this.textToInt(childPosition.getBound().getWText(), ChildPositionType.class.getName(), "ChildPositionType");
        int n4 = this.textToInt(childPosition.getBound().getHText(), ChildPositionType.class.getName(), "ChildPositionType");
        this.bound = new Rectangle(n, n2, n3, n4);
        this.classLoader = classLoader;
        if (childPosition.getEmptyConfig() != null) {
            this.emptyPopupMenuRef = childPosition.getEmptyConfig().getPopupmenuRefText();
            this.createEmptyComponentClass(childPosition.getEmptyConfig().getClassNameText());
        }
        if (childPosition.getSlotVisibleText() != null && "false".equalsIgnoreCase(childPosition.getSlotVisibleText())) {
            this.slotVisible = false;
        }
        if (childPosition.getDirection() != null) {
            this.direction = childPosition.getDirection();
        }
        this.slotLabel = childPosition.getSlotLabelText();
        this.slotPosition = childPosition.getSlotPositionText();
    }

    public Rectangle getBound() {
        return new Rectangle(this.bound);
    }

    Class getEmptyComponentClass() {
        return this.emptyComponentClass;
    }

    String getEmptyPopupMenuRef() {
        return this.emptyPopupMenuRef;
    }

    public boolean isSlotVisible() {
        return this.slotVisible;
    }

    public String getSlotLabel() {
        return this.slotLabel;
    }

    public String getSlotPosition() {
        return this.slotPosition;
    }

    private void createEmptyComponentClass(String string) throws XMLFileNotValidException {
        Class<EmptyComponent> clazz = EmptyComponent.class;
        if (string == null || "".equals(string)) {
            this.emptyComponentClass = clazz;
        } else {
            try {
                this.emptyComponentClass = Class.forName(string);
            }
            catch (Exception exception) {
                StringBuffer stringBuffer = new StringBuffer("The empty-config in xml file contains a invalid class name of '");
                stringBuffer.append(string);
                stringBuffer.append("', because the class can not be found");
                if (this.classLoader != null) {
                    try {
                        this.componentClass = this.classLoader.loadClass(string);
                    }
                    catch (Exception exception2) {
                        stringBuffer.append("and classLoader load class faile");
                        throw new XMLFileNotValidException(stringBuffer.toString());
                    }
                    if (this.componentClass == null) {
                        stringBuffer.append("and classLoader load a null class ");
                        throw new XMLFileNotValidException(stringBuffer.toString());
                    }
                }
                throw new XMLFileNotValidException(stringBuffer.toString());
            }
            if (!clazz.isAssignableFrom(this.emptyComponentClass)) {
                StringBuffer stringBuffer = new StringBuffer("The empty-config in xml file contains a invalid class name of '");
                stringBuffer.append(string);
                stringBuffer.append("', because the class is not subclass of EmptyComponent class");
                throw new XMLFileNotValidException(stringBuffer.toString());
            }
        }
    }

    public String getDirection() {
        if (null != this.direction) {
            return this.direction.getText();
        }
        return null;
    }
}

