/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.devicepanel.model;

import com.swimap.iview.templates.devicepanel.model.ChildPositionType;
import com.swimap.iview.templates.devicepanel.model.ComponentType;
import com.swimap.iview.templates.devicepanel.model.ImageIconUtilities;
import com.swimap.iview.templates.devicepanel.model.XMLFileNotValidException;
import com.swimap.iview.templates.devicepanel.model.xml.Card;
import com.swimap.iview.templates.devicepanel.model.xml.ComposeIcon;
import com.swimap.iview.templates.devicepanel.model.xml.IconRenderer;
import com.swimap.iview.templates.devicepanel.model.xml.LabelFont;
import com.swimap.iview.templates.devicepanel.model.xml.LabelPoint;
import javax.swing.ImageIcon;

class CardType
extends ComponentType {
    private boolean occupiedSlots = false;
    private int direction = 1;
    private int rendererLength = 0;
    private boolean labelVisible = true;
    private ComposeIcon composeIr = null;
    private int composeDirection = 1;
    private IconRenderer iconRender = null;
    private String occupiedSlotText = null;
    private String labelVisibleText = null;
    private LabelFont labelFont = null;
    private String labelDirection = null;
    private LabelPoint labelPoint = null;
    private String drawLabelOnImageText = null;

    CardType(Card card) throws XMLFileNotValidException {
        this(card, null);
    }

    CardType(Card card, ClassLoader classLoader) throws XMLFileNotValidException {
        super(card.getTypeText(), card.getPopupmenuRefText(), null);
        this.label = card.getLabelText();
        this.iconRender = card.getIconRenderer();
        if (this.iconRender != null) {
            this.iconFileName = this.iconRender.getIconText();
            if (this.iconRender.getDirectionText() != null && !"".equals(this.iconRender.getDirectionText())) {
                this.direction = this.textToInt(this.iconRender.getDirectionText(), CardType.class.getName(), "CardType");
                if (this.direction != 1 && this.direction != 2 && this.direction != 3 && this.direction != 4) {
                    this.direction = 1;
                }
            }
            if (this.iconRender.getRendererLengthText() != null && !"".equals(this.iconRender.getRendererLengthText())) {
                this.rendererLength = this.textToInt(this.iconRender.getRendererLengthText(), CardType.class.getName(), "CardType");
            }
        }
        this.composeIr = card.getComposeIcon();
        if (this.composeIr != null) {
            this.composeIconFileName = this.composeIr.getIconText();
            if (this.composeIr.getDirectionText() != null && !"".equals(this.composeIr.getDirectionText())) {
                this.composeDirection = this.textToInt(this.composeIr.getDirectionText(), CardType.class.getName(), "CardType");
                if (this.composeDirection != 1 && this.composeDirection != 2 && this.composeDirection != 3 && this.composeDirection != 4) {
                    this.composeDirection = 1;
                }
            }
        }
        Class<com.swimap.iview.templates.devicepanel.model.component.Card> clazz = com.swimap.iview.templates.devicepanel.model.component.Card.class;
        this.componentClassText = card.getClassNameText();
        if (this.componentClassText == null || "".equals(this.componentClassText)) {
            this.componentClass = clazz;
        } else {
            try {
                this.componentClass = Class.forName(this.componentClassText);
            }
            catch (Exception exception) {
                StringBuffer stringBuffer = new StringBuffer("The card with the type of '").append(this.type).append("' in xml file configures with a invalid class name : '").append(this.componentClassText).append("', because can not found the class");
                if (classLoader != null) {
                    try {
                        this.componentClass = classLoader.loadClass(card.getClassNameText());
                    }
                    catch (Exception exception2) {
                        stringBuffer.append("and classLoader load class faile").append(exception2.getStackTrace());
                        throw new XMLFileNotValidException(stringBuffer.toString());
                    }
                    if (this.componentClass == null) {
                        stringBuffer.append("and classLoader load a null class ");
                        throw new XMLFileNotValidException(stringBuffer.toString());
                    }
                }
                throw new XMLFileNotValidException(stringBuffer.toString());
            }
            if (!clazz.isAssignableFrom(this.componentClass)) {
                StringBuffer stringBuffer = new StringBuffer("The card with the type of '");
                stringBuffer.append(this.type);
                stringBuffer.append("' in xml file configures with a invalid class name : '");
                stringBuffer.append(this.componentClassText);
                stringBuffer.append("', because the class is not subclass of Card class");
                throw new XMLFileNotValidException(stringBuffer.toString());
            }
        }
        this.occupiedSlotText = card.getOccupiedTwoSlotsText();
        this.occupiedSlots = this.occupiedSlotText != null && "true".equalsIgnoreCase(this.occupiedSlotText);
        this.labelVisibleText = card.getLabelVisibleText();
        this.labelVisible = this.labelVisibleText == null || !"false".equalsIgnoreCase(this.labelVisibleText);
        this.childPositionTypes = new ChildPositionType[card.getChildPositionCount()];
        for (int i = 0; i < this.childPositionTypes.length; ++i) {
            this.childPositionTypes[i] = new ChildPositionType(card.getChildPosition(i), classLoader);
        }
        this.comapatabiltity = card.getCompatibilityText();
        this.labelFont = card.getLabelFont();
        this.labelDirection = card.getLabelDirectionText();
        this.labelPoint = card.getLabelPoint();
        this.drawLabelOnImageText = card.getDrawLabelOnImageText();
    }

    LabelPoint getLabelPoint() {
        return this.labelPoint;
    }

    LabelFont getLabelFont() {
        return this.labelFont;
    }

    String getLabelDirection() {
        return this.labelDirection;
    }

    boolean isOccupiedTwoSlots() {
        return this.occupiedSlots;
    }

    String getOccupiedSlotText() {
        return this.occupiedSlotText;
    }

    String getLabelVisibleText() {
        return this.labelVisibleText;
    }

    String getDrawLabelOnImageText() {
        return this.drawLabelOnImageText;
    }

    ComposeIcon getComposeIcon() {
        return this.composeIr;
    }

    IconRenderer getIconRender() {
        return this.iconRender;
    }

    boolean isLabelVisible() {
        return this.labelVisible;
    }

    @Override
    ImageIconUtilities createImageIconUtilities(ImageIcon imageIcon, int n, int n2) {
        return new ImageIconUtilities(imageIcon, n, n2, this.direction, this.rendererLength);
    }
}

