/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.devicepanel.datasource;

import com.swimap.iview.templates.devicepanel.datasource.ComponentData;
import com.swimap.iview.templates.devicepanel.datasource.SourceChangeListener;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import java.awt.Point;
import javax.swing.Icon;
import javax.swing.event.EventListenerList;

public class DataSource {
    private static IviewLogger logger = IviewLogger.getLogger(DataSource.class, "IVIEW");
    private ComponentData[] frameDatas = null;
    private EventListenerList listeners = new EventListenerList();

    public DataSource(ComponentData[] componentDataArray) {
        this.frameDatas = componentDataArray;
    }

    public void notifyStateChanged(String[] stringArray, int[] nArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            logger.debug(new StringBuffer("ID:").append(stringArray[i]).append("\tstateValues:").append(nArray[i]).toString());
        }
        Object[] objectArray = this.listeners.getListenerList();
        SourceChangeListener sourceChangeListener = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (!objectArray[i].equals(SourceChangeListener.class)) continue;
            sourceChangeListener = (SourceChangeListener)objectArray[i + 1];
            sourceChangeListener.stateChanged(stringArray, nArray);
        }
    }

    public void notifyStateColorChanged(int[] nArray, Color[] colorArray) {
        if (null == nArray || null == colorArray) {
            throw new IllegalArgumentException("stateValues or stateColors cannot be null.");
        }
        Object[] objectArray = this.listeners.getListenerList();
        SourceChangeListener sourceChangeListener = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (!objectArray[i].equals(SourceChangeListener.class)) continue;
            sourceChangeListener = (SourceChangeListener)objectArray[i + 1];
            sourceChangeListener.stateColorChanged(nArray, colorArray);
        }
    }

    public void notifyProgressChanged(String[] stringArray, double[] dArray, Color color) {
        Object[] objectArray = this.listeners.getListenerList();
        SourceChangeListener sourceChangeListener = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (!objectArray[i].equals(SourceChangeListener.class)) continue;
            sourceChangeListener = (SourceChangeListener)objectArray[i + 1];
            sourceChangeListener.progressChanged(stringArray, dArray, color);
        }
    }

    public void notifyAlarmChanged(String[] stringArray, int[] nArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            logger.debug(new StringBuffer("ID:").append(stringArray[i]).append("\talarmValues:").append(nArray[i]).toString());
        }
        Object[] objectArray = this.listeners.getListenerList();
        SourceChangeListener sourceChangeListener = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (!objectArray[i].equals(SourceChangeListener.class)) continue;
            sourceChangeListener = (SourceChangeListener)objectArray[i + 1];
            sourceChangeListener.alarmChanged(stringArray, nArray);
        }
    }

    public void notifyAlarmColorChanged(int[] nArray, Color[] colorArray) {
        if (null == nArray || null == colorArray) {
            throw new IllegalArgumentException("alarmValues or alarmColors cannot be null.");
        }
        Object[] objectArray = this.listeners.getListenerList();
        SourceChangeListener sourceChangeListener = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (!objectArray[i].equals(SourceChangeListener.class)) continue;
            sourceChangeListener = (SourceChangeListener)objectArray[i + 1];
            sourceChangeListener.alarmColorChanged(nArray, colorArray);
        }
    }

    public void notifyTemperatureChanged(String[] stringArray, int[] nArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            logger.debug(new StringBuffer("ID:").append(stringArray[i]).append("\temperatureValues:").append(nArray[i]).toString());
        }
        Object[] objectArray = this.listeners.getListenerList();
        SourceChangeListener sourceChangeListener = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (!objectArray[i].equals(SourceChangeListener.class)) continue;
            sourceChangeListener = (SourceChangeListener)objectArray[i + 1];
            sourceChangeListener.temperatureChanged(stringArray, nArray);
        }
    }

    public void notifyComponentAdded(String string, ComponentData componentData, int n) {
        logger.debug(new StringBuffer("parentID:").append(string).append("\tchildIndex:").append(n).append("\tcomponentData:").append(componentData).toString());
        Object[] objectArray = this.listeners.getListenerList();
        SourceChangeListener sourceChangeListener = null;
        for (int i = 0; i < objectArray.length; i += 2) {
            if (!objectArray[i].equals(SourceChangeListener.class)) continue;
            sourceChangeListener = (SourceChangeListener)objectArray[i + 1];
            sourceChangeListener.componentAdded(string, componentData, n);
        }
    }

    public void notifyComponentRemoved(String string) {
        logger.debug(new StringBuffer("componentID:").append(string).toString());
        Object[] objectArray = this.listeners.getListenerList();
        SourceChangeListener sourceChangeListener = null;
        for (int i = 0; i < objectArray.length; i += 2) {
            if (!objectArray[i].equals(SourceChangeListener.class)) continue;
            sourceChangeListener = (SourceChangeListener)objectArray[i + 1];
            sourceChangeListener.componentRemoved(string);
        }
    }

    public void addSourceChangeListener(SourceChangeListener sourceChangeListener) {
        this.listeners.add(SourceChangeListener.class, sourceChangeListener);
    }

    public void removeSourceChangeListener(SourceChangeListener sourceChangeListener) {
        this.listeners.remove(SourceChangeListener.class, sourceChangeListener);
    }

    public ComponentData[] getComponentDatas() {
        return this.frameDatas;
    }

    public void notifyUserIconAdded(String[] stringArray, Icon[] iconArray, Point[] pointArray) {
        if (null == stringArray || null == iconArray || null == pointArray) {
            throw new IllegalArgumentException("parameters cannot be null.");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            logger.trace("\tpositions: " + pointArray[i].toString());
        }
        Object[] objectArray = this.listeners.getListenerList();
        SourceChangeListener sourceChangeListener = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (!objectArray[i].equals(SourceChangeListener.class)) continue;
            sourceChangeListener = (SourceChangeListener)objectArray[i + 1];
            sourceChangeListener.userIconsAdded(stringArray, iconArray, pointArray);
        }
    }

    public void notifyUserIconRemoved(String[] stringArray, Icon[] iconArray) {
        if (null == stringArray || null == iconArray) {
            throw new IllegalArgumentException("parameters cannot be null.");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            logger.trace("componentID: " + stringArray[i].toString());
        }
        Object[] objectArray = this.listeners.getListenerList();
        SourceChangeListener sourceChangeListener = null;
        for (int i = 0; i < objectArray.length; i += 2) {
            if (!objectArray[i].equals(SourceChangeListener.class)) continue;
            sourceChangeListener = (SourceChangeListener)objectArray[i + 1];
            sourceChangeListener.userIconsRemoved(stringArray, iconArray);
        }
    }

    public void notifyLabelChanged(String[] stringArray, String[] stringArray2) {
        if (null == stringArray) {
            throw new IllegalArgumentException("item IDs cannot be null.");
        }
        Object[] objectArray = this.listeners.getListenerList();
        SourceChangeListener sourceChangeListener = null;
        for (int i = 0; i < objectArray.length; i += 2) {
            if (!objectArray[i].equals(SourceChangeListener.class)) continue;
            sourceChangeListener = (SourceChangeListener)objectArray[i + 1];
            sourceChangeListener.labelChanged(stringArray, stringArray2);
        }
    }

    public void notifyComponentVisibility(String[] stringArray, boolean bl) {
        if (null == stringArray || stringArray.length < 1) {
            throw new IllegalArgumentException("Parameters cannot be null.");
        }
        logger.trace("NotifyComponentVisibility : Show/Hide = " + bl);
        for (int i = 0; i < stringArray.length; ++i) {
            logger.trace("ComponentID: " + stringArray[i].toString());
        }
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (!objectArray[i].equals(SourceChangeListener.class)) continue;
            SourceChangeListener sourceChangeListener = (SourceChangeListener)objectArray[i + 1];
            sourceChangeListener.changeComponentVisibilty(stringArray, bl);
        }
    }

    public void notifyHideAddedComponent(String string, ComponentData componentData, int n) {
        logger.debug(new StringBuffer("parentID:").append(string).append("\tchildIndex:").append(n).append("\tcomponentData:").append(componentData).toString());
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (!objectArray[i].equals(SourceChangeListener.class)) continue;
            SourceChangeListener sourceChangeListener = (SourceChangeListener)objectArray[i + 1];
            sourceChangeListener.hideAddedComponent(string, componentData, n);
        }
    }
}

