/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.datechooser;

import com.swimap.imap12.util.dateChooser.InmDateChooser;
import com.swimap.imap12.util.dateChooser.InmDateDocument;
import com.swimap.imap12.util.dateChooser.InmFormatDocument;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.ReflectionUtilities;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.adapter.FrameworkHelper;
import com.swimap.iview.util.format.FormatException;
import com.swimap.iview.util.format.TimeDateFormatUtil;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class DateChooser
extends InmDateChooser {
    private static IviewLogger logger = IviewLogger.getLogger(DateChooser.class, "IVIEW");
    private JCheckBox dstCheck = null;
    private Vector listenerList = new Vector(10);
    private ChangeEvent changeEvt = new ChangeEvent(this);
    private static final double DOUBLE_WIDTH = 0.1;
    private static final int MINUTE = 60000;
    private boolean isUserEnabled = false;
    private boolean isCalendarDST = false;
    private Calendar locCalendar = null;
    private boolean isResetStart = false;
    private boolean isRemoval = false;
    private boolean isDuplicateTime = false;
    private transient DocumentListener documentListener = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            DateChooser.this.doEmptyTimeValidation(documentEvent);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            DateChooser.this.doEmptyTimeValidation(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            if (InmFormatDocument.zFlag) {
                DateChooser.this.isRemoval = false;
            } else {
                DateChooser.this.isRemoval = true;
            }
            DateChooser.this.doEmptyTimeValidation(documentEvent);
            DateChooser.this.isRemoval = false;
        }
    };

    public DateChooser() {
        this.jbInit(null);
    }

    public DateChooser(byte by) {
        super(by, new GregorianCalendar());
        this.jbInit(null);
    }

    public DateChooser(byte by, TimeZone timeZone) {
        this(by, new GregorianCalendar(timeZone));
    }

    public DateChooser(TimeZone timeZone) {
        this(3, new GregorianCalendar(timeZone));
    }

    public DateChooser(byte by, Calendar calendar) {
        super(by, calendar);
        this.jbInit(calendar);
    }

    @Override
    public void setCalendar(Calendar calendar) {
        this.isRemoval = true;
        this.locCalendar = calendar;
        if (calendar != null) {
            logger.trace("The currentZone information is:" + calendar.getTimeZone());
            this.isCalendarDST = calendar.get(16) > 0;
        }
        super.setCalendar(calendar);
        this.isRemoval = false;
    }

    private void jbInit(Calendar calendar) {
        this.locCalendar = calendar;
        int n = this.getCompIndex();
        this.dstCheck = new JCheckBox(res.getString("DST"));
        this.dstCheck.setName("DateChooser_DSTCheck");
        this.dstCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DateChooser.this.isUserEnabled = true;
                DateChooser.this.fireChageEvent();
                DateChooser.this.isUserEnabled = false;
            }
        });
        this.dstCheck.setPreferredSize(new Dimension(this.dstCheck.getPreferredSize().width, 21));
        this.add((Component)this.dstCheck, new GridBagConstraints(n, 0, 1, 2, 0.0, 0.1, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.dstCheck.setEnabled(false);
        this.isDuplicateTime = false;
        this.isCalendarDST = false;
        if (calendar != null) {
            logger.trace("The currentZone info is:" + calendar.getTimeZone());
            this.isCalendarDST = calendar.get(16) > 0;
        }
        this.dstCheck.setVisible(Boolean.valueOf(System.getProperty("iview.datechooser.dstvisible", "true")));
        this.addDocumentListener(this.documentListener);
        this.fireValueChanged(this.changeEvt);
    }

    private void doEmptyTimeValidation(final DocumentEvent documentEvent) {
        Calendar calendar;
        Calendar calendar2;
        boolean bl;
        if (this.isResetStart) {
            return;
        }
        this.fireValueChanged(this.changeEvt);
        if (null != this.oldValue && !this.isDuplicateTime && !this.dstCheck.isSelected() && !this.isRemoval && (bl = this.isJumpingTime(calendar2 = (Calendar)(calendar = this.getCalendar(true)).clone()))) {
            String string = null;
            TimeZone timeZone = calendar.getTimeZone();
            if (timeZone instanceof SimpleTimeZone) {
                int n = (Integer)ReflectionUtilities.getFieldByObject((SimpleTimeZone)timeZone, "startTime");
                Calendar calendar3 = (Calendar)calendar.clone();
                calendar3.set(10, 0);
                calendar3.set(12, 0);
                calendar3.set(13, 0);
                calendar3.set(14, 0);
                if (n == 0) {
                    calendar3.set(11, 2);
                } else {
                    calendar3.set(11, 0);
                }
                calendar3.setTimeInMillis(calendar3.getTimeInMillis() + (long)n - 1L);
                String string2 = TimeDateFormatUtil.getFormatDate(calendar3);
                Calendar calendar4 = (Calendar)calendar.clone();
                calendar4.set(10, 0);
                calendar4.set(12, 0);
                calendar4.set(13, 0);
                calendar4.set(14, 0);
                if (n == 0) {
                    calendar4.set(11, 1);
                } else {
                    calendar4.set(11, 0);
                }
                int n2 = n + timeZone.getDSTSavings() - 1;
                calendar4.setTimeInMillis(calendar4.getTimeInMillis() + (long)n2);
                String string3 = TimeDateFormatUtil.getFormatDate(calendar4);
                String string4 = " (" + string2 + ' ' + this.getFormatedTime(n) + '~' + string3 + ' ' + this.getFormatedTime(n2) + ") ";
                string = res.getString("Emptystart") + string4 + res.getString("Emptyend");
                this.timeTextField.setToolTipText(res.getString("Emptytip") + string4);
            } else {
                string = res.getString("Empty");
            }
            Window window = ScreenToolKit.getContainingWindow(this);
            if (null == window) {
                window = FrameworkHelper.getMainFrame();
            }
            OptionPane.showMessageDialog(window, string);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Document document = documentEvent.getDocument();
                    if (document instanceof InmDateDocument) {
                        DateChooser.this.isResetStart = true;
                        ((InmDateDocument)document).getTextComponent().setText(DateChooser.this.oldValue);
                        ((InmDateDocument)document).getTextComponent().setCaretPosition(DateChooser.this.oldCaretPosition);
                        DateChooser.this.isResetStart = false;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DateChooser.this.fireValueChanged(DateChooser.this.changeEvt);
                            }
                        });
                    }
                }
            }).start();
        }
    }

    private void fireValueChanged(ChangeEvent changeEvent) {
        if (!this.isUserEnabled) {
            this.setDstState();
        }
        int n = this.listenerList.size();
        for (int i = 0; i < n; ++i) {
            ((ChangeListener)this.listenerList.elementAt(i)).stateChanged(changeEvent);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (null != changeListener && !this.listenerList.contains(changeListener)) {
            this.listenerList.add(changeListener);
        }
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(changeListener);
    }

    private boolean isDuplicateTime(Calendar calendar, TimeZone timeZone) {
        Calendar calendar2 = (Calendar)calendar.clone();
        boolean bl = !timeZone.inDaylightTime(calendar.getTime());
        calendar2.add(12, -timeZone.getDSTSavings() / 60000);
        return timeZone.inDaylightTime(calendar2.getTime()) && bl;
    }

    private boolean isJumpingTime(Calendar calendar) {
        if (null != calendar) {
            TimeZone timeZone = calendar.getTimeZone();
            String string = this.get(10);
            if (timeZone.useDaylightTime() && null != string) {
                int n = Integer.parseInt(string);
                boolean bl = this.is12_HourLock();
                int n2 = 0;
                if (bl) {
                    n2 = calendar.get(10);
                    if (n == 12 && n2 == 0) {
                        n = 0;
                    }
                } else {
                    n2 = calendar.get(11);
                }
                return n2 != n;
            }
        }
        return false;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (!bl) {
            this.dstCheck.setEnabled(bl);
        } else {
            this.setDstState();
        }
    }

    private void setDstState() {
        if (this.isResetStart) {
            return;
        }
        Calendar calendar = super.getCalendar(true);
        if (null == calendar) {
            return;
        }
        TimeZone timeZone = calendar.getTimeZone();
        if (timeZone.useDaylightTime()) {
            String string;
            boolean bl;
            boolean bl2 = false;
            bl2 = timeZone.inDaylightTime(calendar.getTime());
            this.isDuplicateTime = bl = this.isDuplicateTime(calendar, timeZone);
            if (this.isEnabled()) {
                this.dstCheck.setEnabled(bl);
            }
            if (bl) {
                bl2 = this.locCalendar != null ? this.isCalendarDST : bl;
            }
            if ((string = this.getTextField().getText()) != null && string.charAt(0) == ' ') {
                bl2 = false;
            }
            this.dstCheck.setSelected(bl2);
        }
    }

    @Override
    public Calendar getCalendar() {
        Calendar calendar = super.getCalendar();
        return this.setDSTOffset(calendar);
    }

    @Override
    public Calendar getCalendar(boolean bl) {
        Calendar calendar = super.getCalendar(bl);
        return this.setDSTOffset(calendar);
    }

    private Calendar setDSTOffset(Calendar calendar) {
        if (this.isDuplicateTime) {
            if (this.dstCheck.isSelected()) {
                calendar.set(16, calendar.getTimeZone().getDSTSavings());
            } else {
                calendar.set(16, 0);
            }
        }
        return calendar;
    }

    public void setDSTVisible(boolean bl) {
        String string = System.getProperty("iview.datechooser.dstvisible", "true");
        this.dstCheck.setVisible(bl && Boolean.valueOf(string) != false);
    }

    public boolean isDSTVisible() {
        return this.dstCheck.isVisible();
    }

    private String getFormatedTime(int n) {
        String string = Integer.toString((n /= 1000) % 60);
        String string2 = Integer.toString(n % 3600 / 60);
        String string3 = Integer.toString(n / 3600 % 24);
        if (string.length() < 2) {
            string = '0' + string;
        }
        if (string2.length() < 2) {
            string2 = '0' + string2;
        }
        if (string3.length() < 2) {
            string3 = '0' + string3;
        }
        try {
            return TimeDateFormatUtil.getFormatTime(Integer.parseInt(string3), Integer.parseInt(string2), Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            logger.trace("Exception while formatting " + string3 + ':' + string2 + ':' + string, numberFormatException);
        }
        catch (FormatException formatException) {
            logger.trace("Exception while formatting " + string3 + ':' + string2 + ':' + string, formatException);
        }
        return null;
    }
}

