/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.colorchooser.picker;

import com.swimap.iview.commstyle.commini.BorderlessButton;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.templates.colorchooser.ColorChooser;
import com.swimap.iview.templates.colorchooser.picker.ColorButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JPanel;

final class ColorPanel
extends JPanel {
    private static final Color[] defaultColorList = new Color[]{new Color(0, 0, 0), new Color(153, 51, 0), new Color(51, 51, 0), new Color(0, 51, 51), new Color(0, 51, 102), new Color(0, 0, 128), new Color(51, 51, 153), new Color(51, 51, 51), new Color(128, 0, 0), new Color(255, 102, 102), new Color(128, 128, 0), new Color(0, 128, 0), new Color(0, 128, 128), new Color(0, 0, 255), new Color(102, 102, 153), new Color(128, 128, 128), new Color(255, 0, 0), new Color(255, 153, 0), new Color(153, 204, 0), new Color(51, 153, 204), new Color(51, 204, 204), new Color(51, 102, 255), new Color(128, 0, 128), new Color(153, 153, 153), new Color(255, 0, 255), new Color(255, 204, 0), new Color(255, 255, 0), new Color(0, 255, 0), new Color(0, 255, 255), new Color(0, 204, 255), new Color(153, 51, 102), new Color(192, 192, 192), new Color(255, 153, 204), new Color(255, 204, 153), new Color(255, 255, 153), new Color(204, 255, 204), new Color(204, 255, 255), new Color(153, 204, 255), new Color(204, 153, 253), new Color(255, 255, 255)};
    private HashMap buttons = new HashMap(40);
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/templates/colorchooser/Res");
    private Color selectedColor = null;
    private ColorButton selectedButton = null;
    private JPanel centerPanel = new JPanel();
    private JPanel southPanel = new JPanel();
    private JPanel totalPanel = new JPanel();
    private Component component = null;
    private Color initialColor = null;
    private JDialog colorChooserDialog = null;
    private ColorChooser chooserPane = null;

    ColorPanel(Component component) {
        this.component = component;
        this.init();
    }

    private void init() {
        this.centerPanel.setLayout(new GridLayout(5, 8, 0, 0));
        this.initCenterPanel(this.centerPanel, defaultColorList);
        this.initSouthPanel(this.southPanel);
        this.totalPanel.setLayout(new BorderLayout(0, 4));
        this.setLayout(new FlowLayout(1, 3, 3));
        this.totalPanel.add((Component)this.centerPanel, "Center");
        this.totalPanel.add((Component)this.southPanel, "South");
        this.add(this.totalPanel);
    }

    private void initCenterPanel(JPanel jPanel, Color[] colorArray) {
        ColorButton colorButton = null;
        for (int i = 0; i < colorArray.length; ++i) {
            colorButton = new ColorButton(colorArray[i]);
            colorButton.addActionListener(new ColorButtonActionListener(colorButton.getSelectedColor()));
            this.buttons.put(colorArray[i], colorButton);
            jPanel.add(colorButton);
        }
    }

    private void initSouthPanel(JPanel jPanel) {
        jPanel.setLayout(new BorderLayout());
        BorderlessButton borderlessButton = new BorderlessButton(res.getString("OtherColor"));
        borderlessButton.setPreferredSize(new Dimension(0, 21));
        borderlessButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColorPanel.this.showColorChooser(ColorPanel.this.component, ColorPanel.this.initialColor);
            }
        });
        jPanel.add(borderlessButton);
    }

    final void setColor(Color color) {
        Color color2 = this.selectedColor;
        this.selectedColor = color;
        if (color2 == null && null == this.selectedColor) {
            color2 = Color.white;
        } else if (color2 != null && color2.equals(this.selectedColor)) {
            color2 = null;
        }
        this.initialColor = color;
        this.checkInTheButtons(this.selectedColor, this.buttons);
        this.firePropertyChange("COLOR_CHANGE", color2, this.selectedColor);
    }

    private void checkInTheButtons(Color color, HashMap hashMap) {
        if (this.selectedButton != null) {
            if (this.selectedButton.getSelectedColor().equals(color)) {
                return;
            }
            this.selectedButton.setButtonSelected(false);
            this.selectedButton = null;
        }
        if (hashMap.containsKey(color)) {
            this.selectedButton = (ColorButton)hashMap.get(color);
            this.selectedButton.setButtonSelected(true);
        }
    }

    private void showColorChooser(Component component, Color color) {
        if (this.colorChooserDialog == null || this.chooserPane == null) {
            this.chooserPane = new ColorChooser(color);
            this.colorChooserDialog = ColorChooser.createDialog(component, null, true, this.chooserPane, new ChooserOKListener(), null);
        } else {
            this.chooserPane.setColor(color);
        }
        this.colorChooserDialog.setVisible(true);
    }

    private final class ColorButtonActionListener
    implements ActionListener {
        private Color color = null;

        ColorButtonActionListener(Color color) {
            this.color = color;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColorPanel.this.setColor(this.color);
        }
    }

    private final class ChooserOKListener
    extends AbstractAction {
        private ChooserOKListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColorPanel.this.setColor(ColorPanel.this.chooserPane.getColor());
        }
    }
}

