/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.colorchooser.picker;

import com.swimap.iview.templates.colorchooser.picker.ColorComboBox;
import com.swimap.iview.templates.colorchooser.picker.ColorPanel;
import com.swimap.iview.util.CommonUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.plaf.basic.ComboPopup;

final class ColorComboBoxPopup
extends JPopupMenu
implements ComboPopup {
    private JList list = new JList();
    private ColorPanel panel;
    private ColorComboBox comboBox = null;
    private static final int DEFAULT_POPUP_WIDTH = 150;
    private static final int DEFAULT_POPUP_HEIGHT = 121;
    private transient MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (ColorComboBoxPopup.this.isVisible() || !ColorComboBoxPopup.this.comboBox.isEnabled()) {
                ColorComboBoxPopup.this.setVisible(false);
            } else {
                ColorComboBoxPopup.this.show();
            }
        }
    };

    @Override
    public void show() {
        this.panel.setColor(this.comboBox.getForeground());
        this.show(this.comboBox, this.comboBox.getWidth() - (int)this.getPreferredSize().getWidth(), this.comboBox.getHeight());
    }

    ColorComboBoxPopup(ColorComboBox colorComboBox) {
        this.comboBox = colorComboBox;
        this.panel = new ColorPanel(this.comboBox.getColorChooserParent());
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setLayout(new BorderLayout());
        this.add((Component)this.panel, "Center");
        this.setPreferredSize(new Dimension(150, 121));
        this.panel.addPropertyChangeListener("COLOR_CHANGE", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ColorComboBoxPopup.this.hide();
                if (propertyChangeEvent.getNewValue() != null) {
                    ColorComboBoxPopup.this.comboBox.setForeground((Color)propertyChangeEvent.getNewValue());
                }
                if (null != propertyChangeEvent.getOldValue() && propertyChangeEvent.getNewValue() != propertyChangeEvent.getOldValue()) {
                    ColorComboBoxPopup.this.comboBox.fireActionListener();
                }
            }
        });
    }

    @Override
    public void hide() {
        CommonUtil.hidePopupMenu(this);
    }

    @Override
    public void uninstallingUI() {
    }

    @Override
    public MouseListener getMouseListener() {
        return this.mouseListener;
    }

    @Override
    public MouseMotionListener getMouseMotionListener() {
        return null;
    }

    @Override
    public KeyListener getKeyListener() {
        return null;
    }

    public JList getList() {
        return this.list;
    }
}

